/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.enterprise.gc.g1;

import com.oracle.svm.core.NeverInline;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.c.NonmovableArray;
import com.oracle.svm.core.c.NonmovableArrays;
import com.oracle.svm.core.c.function.CEntryPointOptions;
import com.oracle.svm.core.code.CodeInfo;
import com.oracle.svm.core.code.CodeInfoAccess;
import com.oracle.svm.core.deopt.DeoptimizedFrame;
import com.oracle.svm.core.graal.RuntimeCompilation;
import com.oracle.svm.core.graal.nodes.WriteCurrentVMThreadNode;
import com.oracle.svm.core.graal.snippets.CEntryPointSnippets;
import com.oracle.svm.core.heap.StoredContinuation;
import com.oracle.svm.core.heap.StoredContinuationAccess;
import com.oracle.svm.core.memory.NullableNativeMemory;
import com.oracle.svm.core.nmt.NmtCategory;
import com.oracle.svm.core.snippets.KnownIntrinsics;
import com.oracle.svm.core.stack.JavaStackWalker;
import com.oracle.svm.core.stack.ParameterizedStackFrameVisitor;
import com.oracle.svm.core.thread.ContinuationSupport;
import com.oracle.svm.core.thread.VMOperation;
import com.oracle.svm.core.thread.VMThreads;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.enterprise.gc.g1.bv;
import com.oracle.svm.enterprise.gc.g1.bw;
import com.oracle.svm.enterprise.gc.g1.nativelib.SharedGCStructs;
import java.util.function.BooleanSupplier;
import org.graalvm.nativeimage.CurrentIsolate;
import org.graalvm.nativeimage.IsolateThread;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.StackValue;
import org.graalvm.nativeimage.c.function.CEntryPoint;
import org.graalvm.nativeimage.c.function.CEntryPointLiteral;
import org.graalvm.nativeimage.c.function.CFunctionPointer;
import org.graalvm.nativeimage.c.function.CodePointer;
import org.graalvm.nativeimage.c.struct.RawField;
import org.graalvm.nativeimage.c.struct.RawStructure;
import org.graalvm.nativeimage.c.struct.SizeOf;
import org.graalvm.nativeimage.c.type.CCharPointer;
import org.graalvm.word.Pointer;
import org.graalvm.word.PointerBase;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordFactory;

public final class G1StackWalker {
    private static final e oe = new e();
    private static final c of = new c();
    private static final a og = new a();
    public final CEntryPointLiteral<CFunctionPointer> oh = CEntryPointLiteral.create(G1StackWalker.class, (String)"fetchThreadStackFrames", (Class[])new Class[]{PointerBase.class, IsolateThread.class});
    public final CEntryPointLiteral<CFunctionPointer> oi = CEntryPointLiteral.create(G1StackWalker.class, (String)"freeThreadStackFrames", (Class[])new Class[]{PointerBase.class, IsolateThread.class, SharedGCStructs.StackFramesPerThread.class});
    public final CEntryPointLiteral<CFunctionPointer> oj = ContinuationSupport.isSupported() ? CEntryPointLiteral.create(G1StackWalker.class, (String)"fetchContinuationStackFrames", (Class[])new Class[]{PointerBase.class, Pointer.class}) : null;
    public final CEntryPointLiteral<CFunctionPointer> ok = ContinuationSupport.isSupported() ? CEntryPointLiteral.create(G1StackWalker.class, (String)"freeContinuationStackFrames", (Class[])new Class[]{PointerBase.class, SharedGCStructs.StackFrames.class}) : null;
    public final CEntryPointLiteral<CFunctionPointer> ol = RuntimeCompilation.isEnabled() ? CEntryPointLiteral.create(G1StackWalker.class, (String)"fetchCodeInfos", (Class[])new Class[]{PointerBase.class, IsolateThread.class}) : null;
    public final CEntryPointLiteral<CFunctionPointer> om = RuntimeCompilation.isEnabled() ? CEntryPointLiteral.create(G1StackWalker.class, (String)"freeCodeInfos", (Class[])new Class[]{PointerBase.class, IsolateThread.class, SharedGCStructs.CodeInfosPerThread.class}) : null;

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public G1StackWalker() {
    }

    @Uninterruptible(reason="G1 may only call uninterruptible code.")
    @CEntryPoint(include=bw.class, publishAs=CEntryPoint.Publish.NotPublished)
    @CEntryPointOptions(prologue=bv.class, epilogue=CEntryPointOptions.NoEpilogue.class)
    public static SharedGCStructs.StackFramesPerThread fetchThreadStackFrames(PointerBase pointerBase, IsolateThread isolateThread) {
        return G1StackWalker.a(oe);
    }

    @Uninterruptible(reason="G1 may only call uninterruptible code.")
    @CEntryPoint(include=bw.class, publishAs=CEntryPoint.Publish.NotPublished)
    @CEntryPointOptions(prologue=bv.class, epilogue=CEntryPointOptions.NoEpilogue.class)
    public static void freeThreadStackFrames(PointerBase pointerBase, IsolateThread isolateThread, SharedGCStructs.StackFramesPerThread stackFramesPerThread) {
        int n2 = 0;
        while ((long)n2 < stackFramesPerThread.count()) {
            NullableNativeMemory.free((PointerBase)stackFramesPerThread.threads().i(n2).dV());
            ++n2;
        }
        NullableNativeMemory.free((PointerBase)stackFramesPerThread);
    }

    @Uninterruptible(reason="G1 may only call uninterruptible code.")
    @CEntryPoint(include=f.class, publishAs=CEntryPoint.Publish.NotPublished)
    @CEntryPointOptions(prologue=d.class, epilogue=CEntryPointOptions.NoEpilogue.class)
    public static SharedGCStructs.StackFrames fetchContinuationStackFrames(PointerBase pointerBase, Pointer pointer) {
        StoredContinuation storedContinuation = (StoredContinuation)pointer.toObject();
        ContinuationStackFrameCollectorData continuationStackFrameCollectorData = (ContinuationStackFrameCollectorData)StackValue.get(ContinuationStackFrameCollectorData.class);
        c.a(continuationStackFrameCollectorData);
        StoredContinuationAccess.walkFrames((StoredContinuation)storedContinuation, (StoredContinuationAccess.ContinuationStackFrameVisitor)of, (StoredContinuationAccess.ContinuationStackFrameVisitorData)continuationStackFrameCollectorData);
        return continuationStackFrameCollectorData.getStack();
    }

    @Uninterruptible(reason="May be called by a non-Java thread (at or outside a safepoint).")
    @CEntryPoint(include=f.class, publishAs=CEntryPoint.Publish.NotPublished)
    @CEntryPointOptions(prologue=d.class, epilogue=CEntryPointOptions.NoEpilogue.class)
    public static void freeContinuationStackFrames(PointerBase pointerBase, SharedGCStructs.StackFrames stackFrames) {
        NullableNativeMemory.free((PointerBase)stackFrames);
    }

    @Uninterruptible(reason="G1 may only call uninterruptible code.")
    @CEntryPoint(include=bw.class, publishAs=CEntryPoint.Publish.NotPublished)
    @CEntryPointOptions(prologue=bv.class, epilogue=CEntryPointOptions.NoEpilogue.class)
    public static SharedGCStructs.CodeInfosPerThread fetchCodeInfos(PointerBase pointerBase, IsolateThread isolateThread) {
        return G1StackWalker.a(og);
    }

    @Uninterruptible(reason="G1 may only call uninterruptible code.")
    @CEntryPoint(include=bw.class, publishAs=CEntryPoint.Publish.NotPublished)
    @CEntryPointOptions(prologue=bv.class, epilogue=CEntryPointOptions.NoEpilogue.class)
    public static void freeCodeInfos(PointerBase pointerBase, IsolateThread isolateThread, SharedGCStructs.CodeInfosPerThread codeInfosPerThread) {
        int n2 = 0;
        while ((long)n2 < codeInfosPerThread.count()) {
            NullableNativeMemory.free((PointerBase)codeInfosPerThread.threads().f(n2).dU());
            ++n2;
        }
        NullableNativeMemory.free((PointerBase)codeInfosPerThread);
    }

    @NeverInline(value="Stack walking.")
    @Uninterruptible(reason="G1 may only call uninterruptible code.")
    private static <T extends PointerBase, U extends PointerBase> T a(b<T, U> b2) {
        VMOperation.guaranteeInProgressAtSafepoint((String)"Doing a stack walk for every thread is only possible when we are at a safepoint.");
        b2.dz();
        b2.dA();
        JavaStackWalker.walkCurrentThread((Pointer)KnownIntrinsics.readCallerStackPointer(), b2, null);
        b2.dB();
        IsolateThread isolateThread = VMThreads.firstThread();
        while (isolateThread.isNonNull()) {
            if (isolateThread != CurrentIsolate.getCurrentThread()) {
                b2.dA();
                JavaStackWalker.walkThread((IsolateThread)isolateThread, b2, null);
                b2.dB();
            }
            isolateThread = VMThreads.nextThread((IsolateThread)isolateThread);
        }
        return b2.dE();
    }

    @Uninterruptible(reason="G1 may only call uninterruptible code.")
    private static <V extends PointerBase> V e(UnsignedWord unsignedWord) {
        PointerBase pointerBase = NullableNativeMemory.malloc((UnsignedWord)unsignedWord, (NmtCategory)NmtCategory.GC);
        if (pointerBase.isNull()) {
            throw VMError.shouldNotReachHere((String)"malloc returned null.");
        }
        return (V)pointerBase;
    }

    @Uninterruptible(reason="G1 may only call uninterruptible code.")
    private static <V extends PointerBase> V a(V v2, UnsignedWord unsignedWord) {
        PointerBase pointerBase = NullableNativeMemory.realloc(v2, (UnsignedWord)unsignedWord, (NmtCategory)NmtCategory.GC);
        if (pointerBase.isNull()) {
            throw VMError.shouldNotReachHere((String)"realloc returned null.");
        }
        return (V)pointerBase;
    }

    private static class e
    extends b<SharedGCStructs.StackFramesPerThread, SharedGCStructs.StackFrames> {
        @Platforms(value={Platform.HOSTED_ONLY.class})
        e() {
        }

        @Override
        @Uninterruptible(reason="G1 may only call uninterruptible code.")
        public void dz() {
            assert (((SharedGCStructs.StackFramesPerThread)this.op).isNull() && this.oq == 0 && ((SharedGCStructs.StackFrames)this.or).isNull() && this.os == 0);
            this.oq = 5;
            this.op = G1StackWalker.e(this.dF());
            ((SharedGCStructs.StackFramesPerThread)this.op).setCount(0L);
        }

        @Override
        @Uninterruptible(reason="G1 may only call uninterruptible code.")
        public void dA() {
            assert (((SharedGCStructs.StackFrames)this.or).isNull() && this.os == 0);
            this.os = 10;
            this.or = G1StackWalker.e(this.dG());
            ((SharedGCStructs.StackFrames)this.or).setCount(0L);
        }

        @Override
        @Uninterruptible(reason="G1 may only call uninterruptible code.")
        public void dB() {
            long l2 = ((SharedGCStructs.StackFramesPerThread)this.op).count();
            if (l2 == (long)this.oq) {
                this.oq *= 2;
                this.op = G1StackWalker.a((SharedGCStructs.StackFramesPerThread)this.op, this.dF());
            }
            ((SharedGCStructs.StackFramesPerThread)this.op).threads().i(l2).a((SharedGCStructs.StackFrames)this.or);
            ((SharedGCStructs.StackFramesPerThread)this.op).setCount(l2 + 1L);
            this.or = WordFactory.nullPointer();
            this.os = 0;
        }

        @Uninterruptible(reason="G1 may only call uninterruptible code.")
        public boolean visitRegularFrame(Pointer pointer, CodePointer codePointer, CodeInfo codeInfo, Object object) {
            NonmovableArray nonmovableArray = CodeInfoAccess.getStackReferenceMapEncoding((CodeInfo)codeInfo);
            long l2 = CodeInfoAccess.lookupStackReferenceMapIndex((CodeInfo)codeInfo, (long)CodeInfoAccess.relativeIP((CodeInfo)codeInfo, (CodePointer)codePointer));
            this.a(pointer, (NonmovableArray<Byte>)nonmovableArray, l2);
            return true;
        }

        @Uninterruptible(reason="G1 may only call uninterruptible code.")
        protected boolean visitDeoptimizedFrame(Pointer pointer, CodePointer codePointer, DeoptimizedFrame deoptimizedFrame, Object object) {
            return true;
        }

        @Uninterruptible(reason="G1 may only call uninterruptible code.")
        private void a(Pointer pointer, NonmovableArray<Byte> nonmovableArray, long l2) {
            long l3 = ((SharedGCStructs.StackFrames)this.or).count();
            if (l3 == (long)this.os) {
                this.os *= 2;
                this.or = G1StackWalker.a((SharedGCStructs.StackFrames)this.or, this.dG());
            }
            SharedGCStructs.StackFrame stackFrame = ((SharedGCStructs.StackFrames)this.or).frames().h(l3);
            stackFrame.setStackPointer(pointer);
            stackFrame.setEncodedReferenceMap((CCharPointer)NonmovableArrays.getArrayBase(nonmovableArray));
            stackFrame.setReferenceMapIndex(l2);
            ((SharedGCStructs.StackFrames)this.or).setCount(l3 + 1L);
        }

        @Uninterruptible(reason="G1 may only call uninterruptible code.")
        private UnsignedWord dF() {
            return SizeOf.unsigned(SharedGCStructs.StackFramesPerThread.class).add(SizeOf.unsigned(SharedGCStructs.StackFrames.class).multiply(this.oq));
        }

        @Uninterruptible(reason="G1 may only call uninterruptible code.")
        private UnsignedWord dG() {
            return SizeOf.unsigned(SharedGCStructs.StackFrames.class).add(SizeOf.unsigned(SharedGCStructs.StackFrame.class).multiply(this.os));
        }
    }

    private static abstract class b<T extends PointerBase, U extends PointerBase>
    extends ParameterizedStackFrameVisitor {
        protected static final int on = 5;
        protected static final int oo = 10;
        protected T op;
        protected int oq;
        protected U or;
        protected int os;

        @Platforms(value={Platform.HOSTED_ONLY.class})
        b() {
        }

        @Uninterruptible(reason="G1 may only call uninterruptible code.")
        public abstract void dz();

        @Uninterruptible(reason="G1 may only call uninterruptible code.")
        public abstract void dA();

        @Uninterruptible(reason="G1 may only call uninterruptible code.")
        public abstract void dB();

        @Uninterruptible(reason="G1 may only call uninterruptible code.")
        public T dE() {
            assert (this.or.isNull());
            assert (this.os == 0);
            T t2 = this.op;
            this.op = WordFactory.nullPointer();
            this.oq = 0;
            return t2;
        }

        @Uninterruptible(reason="G1 may only call uninterruptible code.")
        protected final boolean unknownFrame(Pointer pointer, CodePointer codePointer, Object object) {
            throw JavaStackWalker.fatalErrorUnknownFrameEncountered((Pointer)pointer, (CodePointer)codePointer);
        }
    }

    @RawStructure
    private static interface ContinuationStackFrameCollectorData
    extends StoredContinuationAccess.ContinuationStackFrameVisitorData {
        @RawField
        public int getCapacity();

        @RawField
        public void setCapacity(int var1);

        @RawField
        public SharedGCStructs.StackFrames getStack();

        @RawField
        public void setStack(SharedGCStructs.StackFrames var1);
    }

    private static class c
    extends StoredContinuationAccess.ContinuationStackFrameVisitor {
        private static final int ot = 10;

        @Platforms(value={Platform.HOSTED_ONLY.class})
        c() {
        }

        @Uninterruptible(reason="G1 may only call uninterruptible code and StoredContinuation must not move.", callerMustBe=true)
        public static void a(ContinuationStackFrameCollectorData continuationStackFrameCollectorData) {
            UnsignedWord unsignedWord = c.B(10);
            SharedGCStructs.StackFrames stackFrames = (SharedGCStructs.StackFrames)G1StackWalker.e(unsignedWord);
            stackFrames.setCount(0L);
            continuationStackFrameCollectorData.setStack(stackFrames);
            continuationStackFrameCollectorData.setCapacity(10);
        }

        @Uninterruptible(reason="G1 may only call uninterruptible code and StoredContinuation must not move.", callerMustBe=true)
        public void visitFrame(StoredContinuationAccess.ContinuationStackFrameVisitorData continuationStackFrameVisitorData, Pointer pointer, NonmovableArray<Byte> nonmovableArray, long l2, StoredContinuationAccess.ContinuationStackFrameVisitor continuationStackFrameVisitor) {
            Object object;
            ContinuationStackFrameCollectorData continuationStackFrameCollectorData = (ContinuationStackFrameCollectorData)continuationStackFrameVisitorData;
            long l3 = continuationStackFrameCollectorData.getStack().count();
            if (l3 == (long)continuationStackFrameCollectorData.getCapacity()) {
                int n2 = continuationStackFrameCollectorData.getCapacity() * 2;
                object = G1StackWalker.a(continuationStackFrameCollectorData.getStack(), c.B(n2));
                continuationStackFrameCollectorData.setStack((SharedGCStructs.StackFrames)object);
                continuationStackFrameCollectorData.setCapacity(n2);
            }
            SharedGCStructs.StackFrames stackFrames = continuationStackFrameCollectorData.getStack();
            object = stackFrames.frames().h(l3);
            object.setStackPointer(pointer);
            object.setEncodedReferenceMap((CCharPointer)NonmovableArrays.getArrayBase(nonmovableArray));
            object.setReferenceMapIndex(l2);
            stackFrames.setCount(l3 + 1L);
        }

        @Uninterruptible(reason="G1 may only execute uninterruptible code.")
        private static UnsignedWord B(int n2) {
            return SizeOf.unsigned(SharedGCStructs.StackFrames.class).add(SizeOf.unsigned(SharedGCStructs.StackFrame.class).multiply(n2));
        }
    }

    private static class a
    extends b<SharedGCStructs.CodeInfosPerThread, SharedGCStructs.CodeInfos> {
        @Platforms(value={Platform.HOSTED_ONLY.class})
        a() {
        }

        @Override
        @Uninterruptible(reason="G1 may only call uninterruptible code.")
        public void dz() {
            assert (((SharedGCStructs.CodeInfosPerThread)this.op).isNull() && this.oq == 0 && ((SharedGCStructs.CodeInfos)this.or).isNull() && this.os == 0);
            this.oq = 5;
            this.op = G1StackWalker.e(this.dC());
            ((SharedGCStructs.CodeInfosPerThread)this.op).setCount(0L);
        }

        @Override
        @Uninterruptible(reason="G1 may only call uninterruptible code.")
        public void dA() {
            assert (((SharedGCStructs.CodeInfos)this.or).isNull() && this.os == 0);
            this.os = 10;
            this.or = G1StackWalker.e(this.dD());
            ((SharedGCStructs.CodeInfos)this.or).setCount(0L);
        }

        @Override
        @Uninterruptible(reason="G1 may only call uninterruptible code.")
        public void dB() {
            long l2 = ((SharedGCStructs.CodeInfosPerThread)this.op).count();
            if (l2 == (long)this.oq) {
                this.oq *= 2;
                this.op = G1StackWalker.a((SharedGCStructs.CodeInfosPerThread)this.op, this.dC());
            }
            ((SharedGCStructs.CodeInfosPerThread)this.op).threads().f(l2).a((SharedGCStructs.CodeInfos)this.or);
            ((SharedGCStructs.CodeInfosPerThread)this.op).setCount(l2 + 1L);
            this.or = WordFactory.nullPointer();
            this.os = 0;
        }

        @Uninterruptible(reason="G1 may only call uninterruptible code.")
        public boolean visitRegularFrame(Pointer pointer, CodePointer codePointer, CodeInfo codeInfo, Object object) {
            if (!CodeInfoAccess.isAOTImageCode((CodeInfo)codeInfo)) {
                this.d(codeInfo);
            }
            return true;
        }

        @Uninterruptible(reason="G1 may only call uninterruptible code.")
        protected boolean visitDeoptimizedFrame(Pointer pointer, CodePointer codePointer, DeoptimizedFrame deoptimizedFrame, Object object) {
            return true;
        }

        @Uninterruptible(reason="G1 may only call uninterruptible code.")
        private void d(CodeInfo codeInfo) {
            long l2 = ((SharedGCStructs.CodeInfos)this.or).count();
            if (l2 == (long)this.os) {
                this.os *= 2;
                this.or = G1StackWalker.a((SharedGCStructs.CodeInfos)this.or, this.dD());
            }
            ((SharedGCStructs.CodeInfos)this.or).codeInfos().addressOf(l2).write(codeInfo);
            ((SharedGCStructs.CodeInfos)this.or).setCount(l2 + 1L);
        }

        @Uninterruptible(reason="G1 may only call uninterruptible code.")
        private UnsignedWord dC() {
            return SizeOf.unsigned(SharedGCStructs.StackFramesPerThread.class).add(SizeOf.unsigned(SharedGCStructs.StackFrames.class).multiply(this.oq));
        }

        @Uninterruptible(reason="G1 may only call uninterruptible code.")
        private UnsignedWord dD() {
            return SizeOf.unsigned(SharedGCStructs.StackFrames.class).add(SizeOf.unsigned(SharedGCStructs.StackFrame.class).multiply(this.os));
        }
    }

    private static class f
    implements BooleanSupplier {
        @Platforms(value={Platform.HOSTED_ONLY.class})
        f() {
        }

        @Override
        public boolean getAsBoolean() {
            return SubstrateOptions.useG1GC() && ContinuationSupport.isSupported();
        }
    }

    private static class d
    implements CEntryPointOptions.Prologue {
        private d() {
        }

        @Uninterruptible(reason="prologue")
        public static void b(PointerBase pointerBase) {
            CEntryPointSnippets.setHeapBase((PointerBase)pointerBase);
            WriteCurrentVMThreadNode.writeCurrentVMThread((IsolateThread)((IsolateThread)WordFactory.nullPointer()));
        }
    }
}

