/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jipher.internal.spi;

import com.oracle.jipher.internal.common.Util;
import com.oracle.jipher.internal.tools.asn1.Asn1;
import com.oracle.jipher.internal.tools.asn1.Asn1BerValue;
import com.oracle.jipher.internal.tools.asn1.Asn1DecodeException;
import com.oracle.jipher.internal.tools.asn1.UniversalTag;
import java.io.IOException;
import java.security.AlgorithmParametersSpi;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEParameterSpec;

public abstract class Pbes2Parameters
extends AlgorithmParametersSpi {
    private static final int AES_BLOCK_SIZE = 16;
    private static final Asn1BerValue ID_PBES2 = Asn1.newOid("1.2.840.113549.1.5.13");
    private static final Asn1BerValue ID_PBKDF2 = Asn1.newOid("1.2.840.113549.1.5.12");
    private static final Asn1BerValue ID_AES128_CBC_PAD = Asn1.newOid("2.16.840.1.101.3.4.1.2");
    private static final Asn1BerValue ID_AES256_CBC_PAD = Asn1.newOid("2.16.840.1.101.3.4.1.42");
    private static final Asn1BerValue ID_HMAC_WITH_SHA1 = Asn1.newOid("1.2.840.113549.2.7");
    private static final Asn1BerValue ID_HMAC_WITH_SHA224 = Asn1.newOid("1.2.840.113549.2.8");
    private static final Asn1BerValue ID_HMAC_WITH_SHA256 = Asn1.newOid("1.2.840.113549.2.9");
    private static final Asn1BerValue ID_HMAC_WITH_SHA384 = Asn1.newOid("1.2.840.113549.2.10");
    private static final Asn1BerValue ID_HMAC_WITH_SHA512 = Asn1.newOid("1.2.840.113549.2.11");
    private static final Map<Asn1BerValue, String> CIPHER_MAP;
    private static final Map<Asn1BerValue, String> PRF_MAP;
    private Asn1BerValue prfOid;
    private Asn1BerValue cipherOid;
    private PBEParameterSpec pbeSpec;

    Pbes2Parameters(Asn1BerValue prfOid, Asn1BerValue cipherOid) {
        this.prfOid = prfOid;
        this.cipherOid = cipherOid;
    }

    @Override
    protected byte[] engineGetEncoded() throws IOException {
        IvParameterSpec ivSpec = (IvParameterSpec)this.pbeSpec.getParameterSpec();
        if (ivSpec == null) {
            throw new IOException("Wrong parameter type: IV expected");
        }
        byte[] iv = ivSpec.getIV();
        byte[] salt = this.pbeSpec.getSalt();
        int iterationCount = this.pbeSpec.getIterationCount();
        int keyLength = this.cipherOid.equals(ID_AES128_CBC_PAD) ? 16 : 32;
        Asn1BerValue pbes2Params = Asn1.newSequence(Asn1.newSequence(ID_PBKDF2, Asn1.newSequence(Asn1.newOctetString(salt), Asn1.newInteger(iterationCount), Asn1.newInteger(keyLength), Asn1.newSequence(this.prfOid, Asn1.newNull()))), Asn1.newSequence(this.cipherOid, Asn1.newOctetString(iv)));
        return pbes2Params.encodeDerOctets();
    }

    @Override
    protected byte[] engineGetEncoded(String format) throws IOException {
        return this.engineGetEncoded();
    }

    @Override
    protected <T extends AlgorithmParameterSpec> T engineGetParameterSpec(Class<T> paramSpec) throws InvalidParameterSpecException {
        if (paramSpec != null && paramSpec.isAssignableFrom(PBEParameterSpec.class)) {
            return (T)((AlgorithmParameterSpec)paramSpec.cast(this.pbeSpec));
        }
        throw new InvalidParameterSpecException("Expected ParameterSpec class to be assignable from PBEParameterSpec");
    }

    @Override
    protected void engineInit(byte[] params) throws IOException {
        try {
            List<Asn1BerValue> aesAlgId;
            Asn1BerValue aesOid;
            Asn1BerValue pbes2Params = Asn1.decodeOne(params);
            Util.assertAllUniversal(pbes2Params);
            List<Asn1BerValue> pbes2PValues = pbes2Params.count(2).sequence();
            if (pbes2PValues.get(0).hasTag(UniversalTag.OBJECT_IDENTIFIER)) {
                pbes2PValues = Pbes2Parameters.getParam(pbes2Params, ID_PBES2, 2, 2);
            }
            if (!CIPHER_MAP.containsKey(aesOid = (aesAlgId = Pbes2Parameters.getParam(pbes2PValues.get(1))).get(0))) {
                throw new Asn1DecodeException("Unsupported cipher algorithm: " + aesOid.getOid());
            }
            byte[] aesIv = aesAlgId.get(1).getOctetString();
            if (aesIv.length != 16) {
                throw new Asn1DecodeException("Invalid IV length; was: " + aesIv.length + ", expected: " + 16);
            }
            List<Asn1BerValue> pbkdf2Params = Pbes2Parameters.getParam(pbes2PValues.get(0), ID_PBKDF2, 2, 4);
            byte[] salt = pbkdf2Params.get(0).getOctetString();
            if (salt.length == 0) {
                throw new Asn1DecodeException("Invalid salt parameter");
            }
            int iterationCount = pbkdf2Params.get(1).getInteger().intValueExact();
            if (iterationCount < 1) {
                throw new Asn1DecodeException("Invalid iterationCount parameter");
            }
            int i = 2;
            if (pbkdf2Params.size() > i && pbkdf2Params.get(i).hasTag(UniversalTag.INTEGER)) {
                int aesKeyLen;
                int keyLength = pbkdf2Params.get(i++).getInteger().intValueExact();
                int n = aesKeyLen = aesOid.equals(ID_AES128_CBC_PAD) ? 16 : 32;
                if (keyLength != aesKeyLen) {
                    throw new Asn1DecodeException("Invalid keyLength parameter for cipher; was: " + keyLength + ", expected: " + aesKeyLen);
                }
            }
            Asn1BerValue hmacOid = ID_HMAC_WITH_SHA1;
            if (pbkdf2Params.size() > i) {
                List<Asn1BerValue> prfAlgId = Pbes2Parameters.getParam(pbkdf2Params.get(i));
                hmacOid = prfAlgId.get(0);
                if (!PRF_MAP.containsKey(hmacOid)) {
                    throw new Asn1DecodeException("Unsupported PRF algorithm: " + hmacOid.getOid());
                }
                prfAlgId.get(1).getNull();
            }
            this.pbeSpec = new PBEParameterSpec(salt, iterationCount, new IvParameterSpec(aesIv));
            this.prfOid = hmacOid;
            this.cipherOid = aesOid;
        }
        catch (Asn1DecodeException | ArithmeticException ex) {
            throw new IOException("Invalid PBES2 parameters", ex);
        }
    }

    private static List<Asn1BerValue> getParam(Asn1BerValue algId, Asn1BerValue expectedOid, int min, int max) {
        return Pbes2Parameters.getParam(algId, expectedOid).count(min, max).sequence();
    }

    private static Asn1BerValue getParam(Asn1BerValue algId, Asn1BerValue expectedOid) {
        List<Asn1BerValue> values = Pbes2Parameters.getParam(algId);
        Asn1BerValue algorithm = values.get(0);
        if (!algorithm.equals(expectedOid)) {
            throw new Asn1DecodeException("Unsupported PBE algorithm; was: " + algorithm.getOid() + ", expected: " + expectedOid.getOid());
        }
        return values.get(1);
    }

    private static List<Asn1BerValue> getParam(Asn1BerValue algId) {
        List<Asn1BerValue> values = algId.count(2).sequence();
        values.get(0).tag(UniversalTag.OBJECT_IDENTIFIER);
        return values;
    }

    @Override
    protected void engineInit(byte[] params, String format) throws IOException {
        this.engineInit(params);
    }

    @Override
    protected String engineToString() {
        if (this.prfOid == null || this.cipherOid == null) {
            return null;
        }
        String prfAlg = PRF_MAP.get(this.prfOid);
        String cipherAlg = CIPHER_MAP.get(this.cipherOid);
        return "PBEWith" + prfAlg + "And" + cipherAlg;
    }

    @Override
    protected void engineInit(AlgorithmParameterSpec paramSpec) throws InvalidParameterSpecException {
        if (this.pbeSpec != null) {
            throw new InvalidParameterSpecException("already initialized");
        }
        if (!(paramSpec instanceof PBEParameterSpec)) {
            throw new InvalidParameterSpecException("Inappropriate parameter specification");
        }
        this.pbeSpec = (PBEParameterSpec)paramSpec;
    }

    static {
        HashMap<Asn1BerValue, String> cipherMap = new HashMap<Asn1BerValue, String>();
        cipherMap.put(ID_AES128_CBC_PAD, "AES_128");
        cipherMap.put(ID_AES256_CBC_PAD, "AES_256");
        CIPHER_MAP = Collections.unmodifiableMap(cipherMap);
        HashMap<Asn1BerValue, String> prfMap = new HashMap<Asn1BerValue, String>();
        prfMap.put(ID_HMAC_WITH_SHA1, "HmacSHA1");
        prfMap.put(ID_HMAC_WITH_SHA224, "HmacSHA224");
        prfMap.put(ID_HMAC_WITH_SHA256, "HmacSHA256");
        prfMap.put(ID_HMAC_WITH_SHA384, "HmacSHA384");
        prfMap.put(ID_HMAC_WITH_SHA512, "HmacSHA512");
        PRF_MAP = Collections.unmodifiableMap(prfMap);
    }

    public static final class PBEWithHmacSHA512AndAES256
    extends Pbes2Parameters {
        public PBEWithHmacSHA512AndAES256() {
            super(ID_HMAC_WITH_SHA512, ID_AES256_CBC_PAD);
        }
    }

    public static final class PBEWithHmacSHA384AndAES256
    extends Pbes2Parameters {
        public PBEWithHmacSHA384AndAES256() {
            super(ID_HMAC_WITH_SHA384, ID_AES256_CBC_PAD);
        }
    }

    public static final class PBEWithHmacSHA256AndAES256
    extends Pbes2Parameters {
        public PBEWithHmacSHA256AndAES256() {
            super(ID_HMAC_WITH_SHA256, ID_AES256_CBC_PAD);
        }
    }

    public static final class PBEWithHmacSHA224AndAES256
    extends Pbes2Parameters {
        public PBEWithHmacSHA224AndAES256() {
            super(ID_HMAC_WITH_SHA224, ID_AES256_CBC_PAD);
        }
    }

    public static final class PBEWithHmacSHA1AndAES256
    extends Pbes2Parameters {
        public PBEWithHmacSHA1AndAES256() {
            super(ID_HMAC_WITH_SHA1, ID_AES256_CBC_PAD);
        }
    }

    public static final class PBEWithHmacSHA512AndAES128
    extends Pbes2Parameters {
        public PBEWithHmacSHA512AndAES128() {
            super(ID_HMAC_WITH_SHA512, ID_AES128_CBC_PAD);
        }
    }

    public static final class PBEWithHmacSHA384AndAES128
    extends Pbes2Parameters {
        public PBEWithHmacSHA384AndAES128() {
            super(ID_HMAC_WITH_SHA384, ID_AES128_CBC_PAD);
        }
    }

    public static final class PBEWithHmacSHA256AndAES128
    extends Pbes2Parameters {
        public PBEWithHmacSHA256AndAES128() {
            super(ID_HMAC_WITH_SHA256, ID_AES128_CBC_PAD);
        }
    }

    public static final class PBEWithHmacSHA224AndAES128
    extends Pbes2Parameters {
        public PBEWithHmacSHA224AndAES128() {
            super(ID_HMAC_WITH_SHA224, ID_AES128_CBC_PAD);
        }
    }

    public static final class PBEWithHmacSHA1AndAES128
    extends Pbes2Parameters {
        public PBEWithHmacSHA1AndAES128() {
            super(ID_HMAC_WITH_SHA1, ID_AES128_CBC_PAD);
        }
    }

    public static final class PBES2
    extends Pbes2Parameters {
        public PBES2() {
            super(null, null);
        }
    }
}

