/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.jvmti;

import com.oracle.graal.pointsto.meta.AnalysisMetaAccess;
import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.feature.AutomaticallyRegisteredFeature;
import com.oracle.svm.core.feature.InternalFeature;
import com.oracle.svm.core.jdk.RuntimeSupport;
import com.oracle.svm.core.jvmti.JvmtiAgents;
import com.oracle.svm.core.jvmti.JvmtiEnvs;
import com.oracle.svm.core.jvmti.JvmtiFunctionTable;
import com.oracle.svm.core.jvmti.JvmtiFunctions;
import com.oracle.svm.core.jvmti.JvmtiSupport;
import com.oracle.svm.core.jvmti.headers.JvmtiInterface;
import com.oracle.svm.core.meta.MethodPointer;
import com.oracle.svm.core.option.SubstrateOptionsParser;
import com.oracle.svm.core.util.UserError;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.FeatureImpl;
import com.oracle.svm.hosted.c.NativeLibraries;
import com.oracle.svm.hosted.c.info.ElementInfo;
import com.oracle.svm.hosted.c.info.StructFieldInfo;
import com.oracle.svm.hosted.c.info.StructInfo;
import com.oracle.svm.hosted.code.CEntryPointCallStubSupport;
import com.oracle.svm.hosted.code.CEntryPointData;
import com.oracle.svm.hosted.meta.HostedMetaAccess;
import com.oracle.svm.hosted.meta.HostedMethod;
import java.lang.reflect.AnnotatedElement;
import jdk.vm.ci.meta.JavaMethod;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.nativeimage.AnnotationAccess;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.c.function.CEntryPoint;
import org.graalvm.nativeimage.c.function.CFunctionPointer;
import org.graalvm.nativeimage.hosted.Feature;

@AutomaticallyRegisteredFeature
public class JvmtiFeature
implements InternalFeature {
    public boolean isInConfiguration(Feature.IsInConfigurationAccess access) {
        return SubstrateOptions.JVMTI.getValue();
    }

    public void duringSetup(Feature.DuringSetupAccess access) {
        UserError.guarantee(SubstrateOptions.JNI.getValue(), "JVMTI requires JNI. Please use option '%s' to enable JNI.", SubstrateOptionsParser.commandArgument(SubstrateOptions.JNI, "+"));
        ImageSingletons.add(JvmtiSupport.class, (Object)new JvmtiSupport());
        ImageSingletons.add(JvmtiAgents.class, (Object)new JvmtiAgents());
        ImageSingletons.add(JvmtiEnvs.class, (Object)new JvmtiEnvs());
        ImageSingletons.add(JvmtiFunctionTable.class, (Object)new JvmtiFunctionTable());
        RuntimeSupport.getRuntimeSupport().addInitializationHook(JvmtiSupport.initializationHook());
        RuntimeSupport.getRuntimeSupport().addTearDownHook(JvmtiSupport.teardownHook());
    }

    public void beforeAnalysis(Feature.BeforeAnalysisAccess arg) {
        FeatureImpl.BeforeAnalysisAccessImpl access = (FeatureImpl.BeforeAnalysisAccessImpl)arg;
        AnalysisMetaAccess metaAccess = access.getMetaAccess();
        JvmtiFeature.registerCEntryPoints(metaAccess);
    }

    private static void registerCEntryPoints(AnalysisMetaAccess metaAccess) {
        AnalysisType type = metaAccess.lookupJavaType(JvmtiFunctions.class);
        for (AnalysisMethod method : type.getDeclaredMethods(false)) {
            VMError.guarantee(AnnotationAccess.getAnnotation((AnnotatedElement)method, CEntryPoint.class) != null, "Method %s does not have a @CEntryPoint annotation.", method.format("%H.%n(%p)"));
            CEntryPointCallStubSupport.singleton().registerStubForMethod(method, () -> CEntryPointData.create((ResolvedJavaMethod)method));
        }
    }

    public void beforeCompilation(Feature.BeforeCompilationAccess a) {
        FeatureImpl.BeforeCompilationAccessImpl access = (FeatureImpl.BeforeCompilationAccessImpl)a;
        JvmtiFeature.fillJvmtiFunctionTable(access);
        access.registerAsImmutable(JvmtiFunctionTable.singleton().getReadOnlyFunctionTable());
    }

    private static void fillJvmtiFunctionTable(FeatureImpl.CompilationAccessImpl access) {
        NativeLibraries nativeLibraries = access.getNativeLibraries();
        HostedMetaAccess metaAccess = access.getMetaAccess();
        ResolvedJavaType jvmtiInterface = metaAccess.lookupJavaType(JvmtiInterface.class);
        StructInfo jvmtiInterfaceMetadata = (StructInfo)nativeLibraries.findElementInfo((AnnotatedElement)jvmtiInterface);
        JvmtiFunctionTable functionTable = JvmtiFunctionTable.singleton();
        ResolvedJavaType type = access.getMetaAccess().lookupJavaType((Class)JvmtiFunctions.class);
        for (HostedMethod method : type.getDeclaredMethods(false)) {
            StructFieldInfo field = JvmtiFeature.findFieldFor(jvmtiInterfaceMetadata, method.getName());
            int offset = field.getOffsetInfo().getProperty();
            functionTable.init(offset, JvmtiFeature.getStubFunctionPointer(access, method));
        }
    }

    private static CFunctionPointer getStubFunctionPointer(FeatureImpl.CompilationAccessImpl access, HostedMethod method) {
        AnalysisMethod stub = CEntryPointCallStubSupport.singleton().getStubForMethod(method.getWrapped());
        return new MethodPointer(access.getUniverse().lookup((JavaMethod)stub));
    }

    private static StructFieldInfo findFieldFor(StructInfo info, String name) {
        for (ElementInfo element : info.getChildren()) {
            StructFieldInfo field;
            if (!(element instanceof StructFieldInfo) || !(field = (StructFieldInfo)element).getName().equals(name)) continue;
            return field;
        }
        throw VMError.shouldNotReachHere("Cannot find function table field for: " + name);
    }
}

