/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.windows;

import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.feature.AutomaticallyRegisteredImageSingleton;
import com.oracle.svm.core.stack.StackOverflowCheck;
import com.oracle.svm.core.thread.PlatformThreads;
import com.oracle.svm.core.thread.VMThreads;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.core.windows.headers.Process;
import com.oracle.svm.core.windows.headers.SynchAPI;
import com.oracle.svm.core.windows.headers.WinBase;
import jdk.graal.compiler.core.common.NumUtil;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.c.function.CFunctionPointer;
import org.graalvm.nativeimage.c.struct.SizeOf;
import org.graalvm.nativeimage.c.type.CIntPointer;
import org.graalvm.nativeimage.c.type.VoidPointer;
import org.graalvm.nativeimage.c.type.WordPointer;
import org.graalvm.word.PointerBase;
import org.graalvm.word.WordBase;
import org.graalvm.word.WordFactory;

@AutomaticallyRegisteredImageSingleton(value={PlatformThreads.class})
@Platforms(value={Platform.WINDOWS.class})
public final class WindowsPlatformThreads
extends PlatformThreads {
    @Platforms(value={Platform.HOSTED_ONLY.class})
    WindowsPlatformThreads() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean doStartThread(Thread thread, long stackSize) {
        int threadStackSize = NumUtil.safeToUInt((long)stackSize);
        int initFlag = 0;
        if (threadStackSize != 0) {
            initFlag |= Process.STACK_SIZE_PARAM_IS_A_RESERVATION();
        }
        StackOverflowCheck.singleton().makeYellowZoneAvailable();
        try {
            boolean bl = this.doStartThread0(thread, threadStackSize, initFlag);
            return bl;
        }
        finally {
            StackOverflowCheck.singleton().protectYellowZone();
        }
    }

    private boolean doStartThread0(Thread thread, int threadStackSize, int initFlag) {
        Object startData = this.prepareStart(thread, SizeOf.get(PlatformThreads.ThreadStartData.class));
        try {
            WinBase.HANDLE osThreadHandle = Process._beginthreadex(WordFactory.nullPointer(), threadStackSize, (PointerBase)threadStartRoutine.getFunctionPointer(), startData, initFlag, (CIntPointer)WordFactory.nullPointer());
            if (osThreadHandle.isNull()) {
                this.undoPrepareStartOnError(thread, (PlatformThreads.ThreadStartData)startData);
                return false;
            }
            WinBase.CloseHandle(osThreadHandle);
            return true;
        }
        catch (Throwable e) {
            throw VMError.shouldNotReachHere("No exception must be thrown after creating the thread start data.", e);
        }
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public VMThreads.OSThreadHandle startThreadUnmanaged(CFunctionPointer threadRoutine, PointerBase userData, int stackSize) {
        int initFlag = 0;
        if (stackSize != 0) {
            initFlag |= Process.STACK_SIZE_PARAM_IS_A_RESERVATION();
        }
        WinBase.HANDLE osThreadHandle = Process.NoTransitions._beginthreadex(WordFactory.nullPointer(), stackSize, (PointerBase)threadRoutine, (WordBase)userData, initFlag, (CIntPointer)WordFactory.nullPointer());
        return (VMThreads.OSThreadHandle)((Object)osThreadHandle);
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public boolean joinThreadUnmanaged(VMThreads.OSThreadHandle threadHandle, WordPointer threadExitStatus) {
        if (SynchAPI.NoTransitions.WaitForSingleObject((WinBase.HANDLE)((Object)threadHandle), SynchAPI.INFINITE()) != SynchAPI.WAIT_OBJECT_0()) {
            return false;
        }
        if (threadExitStatus.isNull()) {
            return true;
        }
        threadExitStatus.write(WordFactory.zero());
        return Process.NoTransitions.GetExitCodeThread((WinBase.HANDLE)((Object)threadHandle), (CIntPointer)threadExitStatus) != 0;
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public PlatformThreads.ThreadLocalKey createUnmanagedThreadLocal() {
        int result = Process.NoTransitions.TlsAlloc();
        VMError.guarantee(result != Process.TLS_OUT_OF_INDEXES(), "TlsAlloc failed.");
        return (PlatformThreads.ThreadLocalKey)WordFactory.unsigned((int)result);
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public void deleteUnmanagedThreadLocal(PlatformThreads.ThreadLocalKey key) {
        int dwTlsIndex = (int)key.rawValue();
        int result = Process.NoTransitions.TlsFree(dwTlsIndex);
        VMError.guarantee(result != 0, "TlsFree failed.");
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public <T extends WordBase> T getUnmanagedThreadLocalValue(PlatformThreads.ThreadLocalKey key) {
        int dwTlsIndex = (int)key.rawValue();
        VoidPointer result = Process.NoTransitions.TlsGetValue(dwTlsIndex);
        assert (result.isNonNull() || WinBase.GetLastError() == WinBase.ERROR_SUCCESS());
        return (T)result;
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public void setUnmanagedThreadLocalValue(PlatformThreads.ThreadLocalKey key, WordBase value) {
        int dwTlsIndex = (int)key.rawValue();
        int result = Process.NoTransitions.TlsSetValue(dwTlsIndex, (VoidPointer)value);
        VMError.guarantee(result != 0, "TlsSetValue failed.");
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public void closeOSThreadHandle(VMThreads.OSThreadHandle threadHandle) {
        WinBase.CloseHandle((WinBase.HANDLE)((Object)threadHandle));
    }

    @Override
    protected void setNativeName(Thread thread, String name) {
    }

    @Override
    protected void yieldCurrent() {
        Process.SwitchToThread();
    }
}

