/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.stack;

import com.oracle.svm.core.code.CodeInfo;
import com.oracle.svm.core.code.CodeInfoQueryResult;
import com.oracle.svm.core.code.CodeInfoTable;
import com.oracle.svm.core.code.FrameInfoQueryResult;
import com.oracle.svm.core.code.FrameSourceInfo;
import com.oracle.svm.core.deopt.DeoptimizedFrame;
import com.oracle.svm.core.interpreter.InterpreterSupport;
import com.oracle.svm.core.stack.StackFrameVisitor;
import com.oracle.svm.core.util.VMError;
import org.graalvm.nativeimage.c.function.CodePointer;
import org.graalvm.word.Pointer;

public abstract class JavaStackFrameVisitor
extends StackFrameVisitor {
    @Override
    public boolean visitRegularFrame(Pointer sp, CodePointer ip, CodeInfo codeInfo) {
        CodeInfoQueryResult queryResult = CodeInfoTable.lookupCodeInfoQueryResult(codeInfo, ip);
        for (FrameInfoQueryResult frameInfo = queryResult.getFrameInfo(); frameInfo != null; frameInfo = frameInfo.getCaller()) {
            if (this.dispatchPossiblyInterpretedFrame(frameInfo, sp)) continue;
            return false;
        }
        return true;
    }

    @Override
    protected boolean visitDeoptimizedFrame(Pointer originalSP, CodePointer deoptStubIP, DeoptimizedFrame deoptimizedFrame) {
        for (DeoptimizedFrame.VirtualFrame frame = deoptimizedFrame.getTopFrame(); frame != null; frame = frame.getCaller()) {
            if (this.dispatchPossiblyInterpretedFrame(frame.getFrameInfo(), originalSP)) continue;
            return false;
        }
        return true;
    }

    private static FrameSourceInfo interpreterToInterpretedMethodFrame(FrameInfoQueryResult frameInfo, Pointer sp) {
        InterpreterSupport interpreter = InterpreterSupport.singleton();
        VMError.guarantee(interpreter.isInterpreterRoot(frameInfo.getSourceClass()));
        return interpreter.getInterpretedMethodFrameInfo(frameInfo, sp);
    }

    protected final boolean dispatchPossiblyInterpretedFrame(FrameInfoQueryResult frameInfo, Pointer sp) {
        if (InterpreterSupport.isEnabled() && InterpreterSupport.singleton().isInterpreterRoot(frameInfo.getSourceClass())) {
            return this.visitFrame(JavaStackFrameVisitor.interpreterToInterpretedMethodFrame(frameInfo, sp), sp);
        }
        return this.visitFrame(frameInfo, sp);
    }

    public boolean visitFrame(FrameSourceInfo frameInfo, Pointer sp) {
        return this.visitFrame(frameInfo);
    }

    public boolean visitFrame(FrameSourceInfo frameInfo) {
        throw VMError.shouldNotReachHere("override this method or visitFrame::(FrameSourceInfo,Pointer)");
    }
}

