/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.option;

import com.oracle.svm.common.option.LocatableOption;
import com.oracle.svm.common.option.MultiOptionValue;
import com.oracle.svm.core.option.LocatableMultiOptionValue;
import com.oracle.svm.core.option.OptionOrigin;
import com.oracle.svm.core.util.VMError;
import java.nio.file.Path;
import java.util.List;

public abstract class AccumulatingLocatableMultiOptionValue<T>
extends LocatableMultiOptionValue<T> {
    protected AccumulatingLocatableMultiOptionValue(Class<T> valueType, String delimiter, List<T> defaults) {
        super(valueType, delimiter, defaults);
    }

    private AccumulatingLocatableMultiOptionValue(AccumulatingLocatableMultiOptionValue<T> other) {
        super(other);
    }

    public void valueUpdate(Object value) {
        Class<?> rawValueElementType;
        Object rawValue = LocatableOption.rawValue((Object)value);
        OptionOrigin origin = OptionOrigin.from(LocatableOption.valueOrigin((Object)value));
        Class<?> rawValueClass = rawValue.getClass();
        boolean multipleElements = rawValueClass.isArray();
        Class<?> clazz = rawValueElementType = multipleElements ? rawValueClass.getComponentType() : rawValueClass;
        if (!this.valueType.isAssignableFrom(rawValueElementType)) {
            VMError.shouldNotReachHere("Cannot update LocatableMultiOptionValue of type " + String.valueOf(this.valueType) + " with value of type " + String.valueOf(rawValueElementType));
        }
        if (multipleElements) {
            for (Object singleRawValue : (Object[])rawValue) {
                this.values.add(new LocatableMultiOptionValue.ValueWithOrigin(this.valueType.cast(singleRawValue), origin));
            }
        } else {
            this.values.add(new LocatableMultiOptionValue.ValueWithOrigin(this.valueType.cast(rawValue), origin));
        }
    }

    public static final class Paths
    extends AccumulatingLocatableMultiOptionValue<Path> {
        private Paths(Paths other) {
            super(other);
        }

        public MultiOptionValue<Path> createCopy() {
            return new Paths(this);
        }

        private Paths(String delimiter, List<Path> defaultPaths) {
            super(Path.class, delimiter, defaultPaths);
        }

        public static Paths build() {
            return new Paths("", List.of());
        }

        public static Paths buildWithCommaDelimiter() {
            return new Paths(",", List.of());
        }

        public static Paths buildWithCustomDelimiter(String delimiter) {
            return new Paths(delimiter, List.of());
        }

        public static Paths buildWithDefaults(Path ... defaultPaths) {
            return new Paths("", List.of(defaultPaths));
        }
    }

    public static final class Strings
    extends AccumulatingLocatableMultiOptionValue<String> {
        private Strings(Strings other) {
            super(other);
        }

        public MultiOptionValue<String> createCopy() {
            return new Strings(this);
        }

        @Override
        public void valueUpdate(Object value) {
            if (value instanceof Strings) {
                this.values.addAll(((Strings)value).values);
                return;
            }
            super.valueUpdate(value);
        }

        public boolean contains(String s) {
            return this.values.stream().map(LocatableMultiOptionValue.ValueWithOrigin::value).anyMatch(val -> val.equals(s));
        }

        public void removeFirst() {
            this.values.removeFirst();
        }

        private Strings(String delimiter, List<String> defaultStrings) {
            super(String.class, delimiter, defaultStrings);
        }

        public static Strings build() {
            return new Strings("", List.of());
        }

        public static Strings buildWithCommaDelimiter() {
            return new Strings(",", List.of());
        }

        public static Strings buildWithCommaDelimiter(String ... defaultStrings) {
            return new Strings(",", List.of(defaultStrings));
        }

        public static Strings buildWithDefaults(String ... defaultStrings) {
            return new Strings("", List.of(defaultStrings));
        }
    }
}

