/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.identityhashcode;

import com.oracle.svm.core.config.ConfigurationValues;
import com.oracle.svm.core.config.ObjectLayout;
import com.oracle.svm.core.heap.Heap;
import com.oracle.svm.core.heap.ObjectHeader;
import com.oracle.svm.core.hub.LayoutEncoding;
import com.oracle.svm.core.identityhashcode.IdentityHashCodeSupport;
import com.oracle.svm.core.snippets.SnippetRuntime;
import jdk.graal.compiler.core.common.spi.ForeignCallDescriptor;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.nodes.extended.BranchProbabilityNode;
import jdk.graal.compiler.nodes.extended.ForeignCallNode;
import jdk.graal.compiler.options.OptionValues;
import jdk.graal.compiler.phases.util.Providers;
import jdk.graal.compiler.replacements.IdentityHashCodeSnippets;
import jdk.graal.compiler.word.ObjectAccess;
import jdk.graal.compiler.word.Word;
import org.graalvm.word.LocationIdentity;
import org.graalvm.word.Pointer;

final class SubstrateIdentityHashCodeSnippets
extends IdentityHashCodeSnippets {
    static final SnippetRuntime.SubstrateForeignCallDescriptor GENERATE_IDENTITY_HASH_CODE = SnippetRuntime.findForeignCall(IdentityHashCodeSupport.class, "generateIdentityHashCode", ForeignCallDescriptor.CallSideEffect.NO_SIDE_EFFECT, IdentityHashCodeSupport.IDENTITY_HASHCODE_LOCATION);

    SubstrateIdentityHashCodeSnippets() {
    }

    static IdentityHashCodeSnippets.Templates createTemplates(OptionValues options, Providers providers) {
        return new IdentityHashCodeSnippets.Templates((IdentityHashCodeSnippets)new SubstrateIdentityHashCodeSnippets(), options, providers, IdentityHashCodeSupport.IDENTITY_HASHCODE_LOCATION);
    }

    protected int computeIdentityHashCode(Object obj) {
        ObjectLayout ol = ConfigurationValues.getObjectLayout();
        if (ol.isIdentityHashFieldOptional()) {
            int identityHashCode;
            Word objPtr;
            Word header;
            ObjectHeader oh = Heap.getHeap().getObjectHeader();
            if (BranchProbabilityNode.probability((double)0.6, (boolean)oh.hasOptionalIdentityHashField(header = ObjectHeader.readHeaderFromPointer((Pointer)(objPtr = Word.objectToUntrackedPointer((Object)obj)))))) {
                int offset = LayoutEncoding.getIdentityHashOffset(obj);
                identityHashCode = ObjectAccess.readInt((Object)obj, (int)offset, (LocationIdentity)IdentityHashCodeSupport.IDENTITY_HASHCODE_LOCATION);
            } else {
                identityHashCode = IdentityHashCodeSupport.computeHashCodeFromAddress(obj);
                if (BranchProbabilityNode.probability((double)0.09999999999999998, (!oh.hasIdentityHashFromAddress(header) ? 1 : 0) != 0)) {
                    oh.setIdentityHashFromAddress((Pointer)objPtr, header);
                }
            }
            return identityHashCode;
        }
        int offset = LayoutEncoding.getIdentityHashOffset(obj);
        int identityHashCode = ObjectAccess.readInt((Object)obj, (int)offset, (LocationIdentity)IdentityHashCodeSupport.IDENTITY_HASHCODE_LOCATION);
        if (BranchProbabilityNode.probability((double)0.010000000000000009, (identityHashCode == 0 ? 1 : 0) != 0)) {
            identityHashCode = SubstrateIdentityHashCodeSnippets.generateIdentityHashCode(GENERATE_IDENTITY_HASH_CODE, obj);
        }
        return identityHashCode;
    }

    @Node.NodeIntrinsic(value=ForeignCallNode.class)
    private static native int generateIdentityHashCode(@Node.ConstantNodeParameter ForeignCallDescriptor var0, Object var1);
}

