/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.graal.aarch64;

import com.oracle.svm.core.FrameAccess;
import com.oracle.svm.core.ReservedRegisters;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.config.ConfigurationValues;
import com.oracle.svm.core.deopt.Deoptimizer;
import com.oracle.svm.core.graal.aarch64.AArch64CGlobalDataLoadAddressOp;
import com.oracle.svm.core.graal.aarch64.AArch64CalleeSavedRegisters;
import com.oracle.svm.core.graal.aarch64.AArch64FarReturnOp;
import com.oracle.svm.core.graal.aarch64.AArch64InstructionSynchronizationBarrierOp;
import com.oracle.svm.core.graal.aarch64.AArch64LoadMethodPointerConstantOp;
import com.oracle.svm.core.graal.aarch64.AArch64SafepointCheckOp;
import com.oracle.svm.core.graal.aarch64.SubstrateAArch64RegisterConfig;
import com.oracle.svm.core.graal.code.PatchConsumerFactory;
import com.oracle.svm.core.graal.code.SubstrateBackend;
import com.oracle.svm.core.graal.code.SubstrateCallingConvention;
import com.oracle.svm.core.graal.code.SubstrateCallingConventionKind;
import com.oracle.svm.core.graal.code.SubstrateCallingConventionType;
import com.oracle.svm.core.graal.code.SubstrateCompiledCode;
import com.oracle.svm.core.graal.code.SubstrateDataBuilder;
import com.oracle.svm.core.graal.code.SubstrateDebugInfoBuilder;
import com.oracle.svm.core.graal.code.SubstrateLIRGenerator;
import com.oracle.svm.core.graal.code.SubstrateNodeLIRBuilder;
import com.oracle.svm.core.graal.lir.VerificationMarkerOp;
import com.oracle.svm.core.graal.meta.KnownOffsets;
import com.oracle.svm.core.graal.meta.SharedConstantReflectionProvider;
import com.oracle.svm.core.graal.meta.SubstrateForeignCallLinkage;
import com.oracle.svm.core.graal.meta.SubstrateRegisterConfig;
import com.oracle.svm.core.graal.nodes.CGlobalDataLoadAddressNode;
import com.oracle.svm.core.graal.nodes.ComputedIndirectCallTargetNode;
import com.oracle.svm.core.heap.ReferenceAccess;
import com.oracle.svm.core.heap.SubstrateReferenceMapBuilder;
import com.oracle.svm.core.imagelayer.ImageLayerBuildingSupport;
import com.oracle.svm.core.meta.CompressedNullConstant;
import com.oracle.svm.core.meta.SharedField;
import com.oracle.svm.core.meta.SharedMethod;
import com.oracle.svm.core.meta.SubstrateMethodPointerConstant;
import com.oracle.svm.core.meta.SubstrateObjectConstant;
import com.oracle.svm.core.nodes.SafepointCheckNode;
import com.oracle.svm.core.pltgot.PLTGOTConfiguration;
import com.oracle.svm.core.thread.VMThreads;
import com.oracle.svm.core.util.VMError;
import java.util.Collection;
import java.util.function.BiConsumer;
import jdk.graal.compiler.asm.Assembler;
import jdk.graal.compiler.asm.BranchTargetOutOfBoundsException;
import jdk.graal.compiler.asm.Label;
import jdk.graal.compiler.asm.aarch64.AArch64Address;
import jdk.graal.compiler.asm.aarch64.AArch64Assembler;
import jdk.graal.compiler.asm.aarch64.AArch64MacroAssembler;
import jdk.graal.compiler.code.CompilationResult;
import jdk.graal.compiler.core.aarch64.AArch64AddressLoweringByUse;
import jdk.graal.compiler.core.aarch64.AArch64ArithmeticLIRGenerator;
import jdk.graal.compiler.core.aarch64.AArch64LIRGenerator;
import jdk.graal.compiler.core.aarch64.AArch64LIRKindTool;
import jdk.graal.compiler.core.aarch64.AArch64MoveFactory;
import jdk.graal.compiler.core.aarch64.AArch64NodeLIRBuilder;
import jdk.graal.compiler.core.aarch64.AArch64NodeMatchRules;
import jdk.graal.compiler.core.common.CompilationIdentifier;
import jdk.graal.compiler.core.common.CompressEncoding;
import jdk.graal.compiler.core.common.GraalOptions;
import jdk.graal.compiler.core.common.LIRKind;
import jdk.graal.compiler.core.common.alloc.RegisterAllocationConfig;
import jdk.graal.compiler.core.common.memory.MemoryExtendKind;
import jdk.graal.compiler.core.common.memory.MemoryOrderMode;
import jdk.graal.compiler.core.common.spi.ForeignCallDescriptor;
import jdk.graal.compiler.core.common.spi.ForeignCallLinkage;
import jdk.graal.compiler.core.common.spi.LIRKindTool;
import jdk.graal.compiler.core.common.type.CompressibleConstant;
import jdk.graal.compiler.core.gen.DebugInfoBuilder;
import jdk.graal.compiler.core.gen.LIRGenerationProvider;
import jdk.graal.compiler.debug.DebugContext;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.lir.ConstantValue;
import jdk.graal.compiler.lir.LIR;
import jdk.graal.compiler.lir.LIRFrameState;
import jdk.graal.compiler.lir.LIRInstruction;
import jdk.graal.compiler.lir.LIRInstructionClass;
import jdk.graal.compiler.lir.LIRValueUtil;
import jdk.graal.compiler.lir.LabelRef;
import jdk.graal.compiler.lir.Opcode;
import jdk.graal.compiler.lir.StandardOp;
import jdk.graal.compiler.lir.Variable;
import jdk.graal.compiler.lir.aarch64.AArch64AddressValue;
import jdk.graal.compiler.lir.aarch64.AArch64BreakpointOp;
import jdk.graal.compiler.lir.aarch64.AArch64Call;
import jdk.graal.compiler.lir.aarch64.AArch64ControlFlow;
import jdk.graal.compiler.lir.aarch64.AArch64FrameMap;
import jdk.graal.compiler.lir.aarch64.AArch64FrameMapBuilder;
import jdk.graal.compiler.lir.aarch64.AArch64LIRInstruction;
import jdk.graal.compiler.lir.aarch64.AArch64Move;
import jdk.graal.compiler.lir.aarch64.AArch64PrefetchOp;
import jdk.graal.compiler.lir.asm.CompilationResultBuilder;
import jdk.graal.compiler.lir.asm.CompilationResultBuilderFactory;
import jdk.graal.compiler.lir.asm.DataBuilder;
import jdk.graal.compiler.lir.asm.EntryPointDecorator;
import jdk.graal.compiler.lir.asm.FrameContext;
import jdk.graal.compiler.lir.framemap.FrameMap;
import jdk.graal.compiler.lir.framemap.FrameMapBuilder;
import jdk.graal.compiler.lir.framemap.FrameMapBuilderTool;
import jdk.graal.compiler.lir.framemap.ReferenceMapBuilder;
import jdk.graal.compiler.lir.gen.LIRGenerationResult;
import jdk.graal.compiler.lir.gen.LIRGeneratorTool;
import jdk.graal.compiler.lir.gen.MoveFactory;
import jdk.graal.compiler.nodes.BreakpointNode;
import jdk.graal.compiler.nodes.CallTargetNode;
import jdk.graal.compiler.nodes.DirectCallTargetNode;
import jdk.graal.compiler.nodes.IndirectCallTargetNode;
import jdk.graal.compiler.nodes.InvokeWithExceptionNode;
import jdk.graal.compiler.nodes.LogicNode;
import jdk.graal.compiler.nodes.LoweredCallTargetNode;
import jdk.graal.compiler.nodes.NodeView;
import jdk.graal.compiler.nodes.ParameterNode;
import jdk.graal.compiler.nodes.SafepointNode;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.spi.CoreProviders;
import jdk.graal.compiler.nodes.spi.NodeLIRBuilderTool;
import jdk.graal.compiler.nodes.spi.NodeValueMap;
import jdk.graal.compiler.options.OptionValues;
import jdk.graal.compiler.phases.BasePhase;
import jdk.graal.compiler.phases.common.AddressLoweringByUsePhase;
import jdk.graal.compiler.phases.util.Providers;
import jdk.vm.ci.aarch64.AArch64;
import jdk.vm.ci.aarch64.AArch64Kind;
import jdk.vm.ci.code.CallingConvention;
import jdk.vm.ci.code.CodeCacheProvider;
import jdk.vm.ci.code.CodeUtil;
import jdk.vm.ci.code.CompilationRequest;
import jdk.vm.ci.code.CompiledCode;
import jdk.vm.ci.code.Register;
import jdk.vm.ci.code.RegisterConfig;
import jdk.vm.ci.code.RegisterValue;
import jdk.vm.ci.code.StackSlot;
import jdk.vm.ci.code.ValueKindFactory;
import jdk.vm.ci.code.ValueUtil;
import jdk.vm.ci.meta.AllocatableValue;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.ConstantReflectionProvider;
import jdk.vm.ci.meta.InvokeTarget;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.JavaType;
import jdk.vm.ci.meta.PlatformKind;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.Value;
import jdk.vm.ci.meta.ValueKind;
import org.graalvm.nativeimage.ImageSingletons;

public class SubstrateAArch64Backend
extends SubstrateBackend
implements LIRGenerationProvider {
    protected static CompressEncoding getCompressEncoding() {
        return (CompressEncoding)ImageSingletons.lookup(CompressEncoding.class);
    }

    public SubstrateAArch64Backend(Providers providers) {
        super(providers);
    }

    static void maybeTransitionToNative(CompilationResultBuilder crb, AArch64MacroAssembler masm, Value javaFrameAnchor, LIRFrameState state, int newThreadStatus) {
        if (ValueUtil.isIllegal((Value)javaFrameAnchor)) {
            assert (newThreadStatus == -1);
            return;
        }
        assert (VMThreads.StatusSupport.isValidStatus(newThreadStatus));
        Register anchor = ValueUtil.asRegister((Value)javaFrameAnchor);
        int startPos = masm.position();
        KnownOffsets knownOffsets = KnownOffsets.singleton();
        try (AArch64MacroAssembler.ScratchRegister scratch = masm.getScratchRegister();){
            Register tempRegister = scratch.getRegister();
            masm.adr(tempRegister, 4);
            crb.recordIndirectCall(startPos, masm.position(), null, state);
            masm.str(64, tempRegister, AArch64Address.createImmediateAddress((int)64, (AArch64Address.AddressingMode)AArch64Address.AddressingMode.IMMEDIATE_UNSIGNED_SCALED, (Register)anchor, (int)knownOffsets.getJavaFrameAnchorLastIPOffset()));
            masm.mov(64, tempRegister, AArch64.sp);
            masm.str(64, tempRegister, AArch64Address.createImmediateAddress((int)64, (AArch64Address.AddressingMode)AArch64Address.AddressingMode.IMMEDIATE_UNSIGNED_SCALED, (Register)anchor, (int)knownOffsets.getJavaFrameAnchorLastSPOffset()));
        }
        try (AArch64MacroAssembler.ScratchRegister scratch1 = masm.getScratchRegister();
             AArch64MacroAssembler.ScratchRegister scratch2 = masm.getScratchRegister();){
            Register statusValueRegister = scratch1.getRegister();
            Register statusAddressRegister = scratch2.getRegister();
            masm.mov(statusValueRegister, newThreadStatus);
            masm.loadAlignedAddress(32, statusAddressRegister, ReservedRegisters.singleton().getThreadRegister(), (long)knownOffsets.getVMThreadStatusOffset());
            masm.stlr(32, statusValueRegister, statusAddressRegister);
        }
    }

    public FrameMapBuilder newFrameMapBuilder(RegisterConfig registerConfig) {
        RegisterConfig registerConfigNonNull = registerConfig == null ? this.getCodeCache().getRegisterConfig() : registerConfig;
        return new AArch64FrameMapBuilder(this.newFrameMap(registerConfigNonNull), this.getCodeCache(), registerConfigNonNull);
    }

    public FrameMap newFrameMap(RegisterConfig registerConfig) {
        return new AArch64FrameMap(this.getProviders().getCodeCache(), registerConfig, (FrameMap.ReferenceMapBuilderFactory)new SubstrateReferenceMapBuilderFactory());
    }

    public CompilationResultBuilder newCompilationResultBuilder(LIRGenerationResult lirGenResult, FrameMap frameMap, CompilationResult compilationResult, CompilationResultBuilderFactory factory, EntryPointDecorator entryPointDecorator) {
        AArch64MacroAssembler masm = new AArch64MacroAssembler(this.getTarget());
        PatchConsumerFactory patchConsumerFactory = SubstrateUtil.HOSTED ? PatchConsumerFactory.HostedPatchConsumerFactory.factory() : PatchConsumerFactory.NativePatchConsumerFactory.factory();
        masm.setCodePatchingAnnotationConsumer(patchConsumerFactory.newConsumer(compilationResult));
        SharedMethod method = ((SubstrateLIRGenerationResult)lirGenResult).getMethod();
        Deoptimizer.StubType stubType = method.getDeoptStubType();
        SubstrateDataBuilder dataBuilder = new SubstrateDataBuilder();
        CallingConvention callingConvention = lirGenResult.getCallingConvention();
        FrameContext frameContext = this.createFrameContext(method, stubType, callingConvention);
        LIR lir = lirGenResult.getLIR();
        OptionValues options = lir.getOptions();
        DebugContext debug = lir.getDebug();
        Register uncompressedNullRegister = SubstrateAArch64Backend.useLinearPointerCompression() ? ReservedRegisters.singleton().getHeapBaseRegister() : Register.None;
        CompilationResultBuilder crb = factory.createBuilder((CoreProviders)this.getProviders(), lirGenResult.getFrameMap(), (Assembler)masm, (DataBuilder)dataBuilder, frameContext, options, debug, compilationResult, uncompressedNullRegister, lir);
        crb.setTotalFrameSize(lirGenResult.getFrameMap().totalFrameSize());
        return crb;
    }

    protected FrameContext createFrameContext(SharedMethod method, Deoptimizer.StubType stubType, CallingConvention callingConvention) {
        if (stubType == Deoptimizer.StubType.EntryStub) {
            return new DeoptEntryStubContext(method, callingConvention);
        }
        if (stubType == Deoptimizer.StubType.ExitStub) {
            return new DeoptExitStubContext(method, callingConvention);
        }
        return new SubstrateAArch64FrameContext(method);
    }

    protected AArch64ArithmeticLIRGenerator createArithmeticLIRGen(AllocatableValue nullRegisterValue) {
        return new AArch64ArithmeticLIRGenerator(nullRegisterValue);
    }

    protected AArch64MoveFactory createMoveFactory(LIRGenerationResult lirGenRes) {
        SharedMethod method = ((SubstrateLIRGenerationResult)lirGenRes).getMethod();
        return new SubstrateAArch64MoveFactory(method, (LIRKindTool)this.createLirKindTool());
    }

    protected AArch64LIRKindTool createLirKindTool() {
        return new SubstrateAArch64LIRKindTool();
    }

    public LIRGeneratorTool newLIRGenerator(LIRGenerationResult lirGenRes) {
        RegisterValue nullRegisterValue = SubstrateAArch64Backend.useLinearPointerCompression() ? ReservedRegisters.singleton().getHeapBaseRegister().asValue((ValueKind)LIRKind.unknownReference((PlatformKind)AArch64Kind.QWORD)) : null;
        AArch64ArithmeticLIRGenerator arithmeticLIRGen = this.createArithmeticLIRGen((AllocatableValue)nullRegisterValue);
        AArch64MoveFactory moveFactory = this.createMoveFactory(lirGenRes);
        return new SubstrateAArch64LIRGenerator(this, (LIRKindTool)this.createLirKindTool(), arithmeticLIRGen, (MoveFactory)moveFactory, this.getProviders(), lirGenRes);
    }

    protected AArch64NodeMatchRules createMatchRules(LIRGeneratorTool lirGen) {
        return new AArch64NodeMatchRules(lirGen);
    }

    public NodeLIRBuilderTool newNodeLIRBuilder(StructuredGraph graph, LIRGeneratorTool lirGen) {
        AArch64NodeMatchRules nodeMatchRules = this.createMatchRules(lirGen);
        return new SubstrateAArch64NodeLIRBuilder(graph, lirGen, nodeMatchRules);
    }

    protected static boolean useLinearPointerCompression() {
        return SubstrateOptions.SpawnIsolates.getValue();
    }

    @Override
    public RegisterAllocationConfig newRegisterAllocationConfig(RegisterConfig registerConfig, String[] allocationRestrictedTo, Object stub) {
        RegisterConfig registerConfigNonNull = registerConfig == null ? this.getCodeCache().getRegisterConfig() : registerConfig;
        return new RegisterAllocationConfig(registerConfigNonNull, allocationRestrictedTo);
    }

    @Override
    public CompilationResult createJNITrampolineMethod(ResolvedJavaMethod method, CompilationIdentifier identifier, RegisterValue threadArg, int threadIsolateOffset, RegisterValue methodIdArg, int methodObjEntryPointOffset) {
        CompilationResult result = new CompilationResult(identifier);
        AArch64MacroAssembler asm = new AArch64MacroAssembler(this.getTarget());
        try (AArch64MacroAssembler.ScratchRegister scratch = asm.getScratchRegister();){
            Register scratchRegister = scratch.getRegister();
            asm.ldr(64, scratchRegister, AArch64Address.createImmediateAddress((int)64, (AArch64Address.AddressingMode)AArch64Address.AddressingMode.IMMEDIATE_UNSIGNED_SCALED, (Register)threadArg.getRegister(), (int)threadIsolateOffset));
            asm.add(64, scratchRegister, scratchRegister, methodIdArg.getRegister());
            asm.ldr(64, scratchRegister, AArch64Address.createImmediateAddress((int)64, (AArch64Address.AddressingMode)AArch64Address.AddressingMode.IMMEDIATE_UNSIGNED_SCALED, (Register)scratchRegister, (int)methodObjEntryPointOffset));
            asm.jmp(scratchRegister);
        }
        result.recordMark(asm.position(), (CompilationResult.MarkId)SubstrateBackend.SubstrateMarkId.PROLOGUE_DECD_RSP);
        result.recordMark(asm.position(), (CompilationResult.MarkId)SubstrateBackend.SubstrateMarkId.PROLOGUE_END);
        byte[] instructions = asm.close(true);
        result.setTargetCode(instructions, instructions.length);
        result.setTotalFrameSize(this.getTarget().stackAlignment);
        return result;
    }

    protected CompiledCode createCompiledCode(ResolvedJavaMethod method, CompilationRequest compilationRequest, CompilationResult compilationResult, boolean isDefault, OptionValues options) {
        return new SubstrateCompiledCode(compilationResult);
    }

    public void emitCode(CompilationResultBuilder crb, ResolvedJavaMethod installedCodeOwner, EntryPointDecorator entryPointDecorator) {
        try {
            crb.buildLabelOffsets();
            crb.emitLIR();
            this.finalizeCode(crb);
        }
        catch (BranchTargetOutOfBoundsException e) {
            this.resetForEmittingCode(crb);
            crb.resetForEmittingCode();
            crb.setConservativeLabelRanges();
            crb.emitLIR();
            this.finalizeCode(crb);
        }
    }

    protected void finalizeCode(CompilationResultBuilder crb) {
    }

    protected void resetForEmittingCode(CompilationResultBuilder crb) {
    }

    public LIRGenerationResult newLIRGenerationResult(CompilationIdentifier compilationId, LIR lir, RegisterAllocationConfig registerAllocationConfig, StructuredGraph graph, Object stub) {
        SharedMethod method = (SharedMethod)graph.method();
        CallingConvention callingConvention = CodeUtil.getCallingConvention((CodeCacheProvider)this.getCodeCache(), (CallingConvention.Type)method.getCallingConventionKind().toType(false), (ResolvedJavaMethod)method, (ValueKindFactory)this);
        return new SubstrateLIRGenerationResult(compilationId, lir, this.newFrameMapBuilder(registerAllocationConfig.getRegisterConfig()), registerAllocationConfig, callingConvention, method);
    }

    @Override
    public BasePhase<CoreProviders> newAddressLoweringPhase(CodeCacheProvider codeCache) {
        return new AddressLoweringByUsePhase((AddressLoweringByUsePhase.AddressLoweringByUse)new AArch64AddressLoweringByUse(this.createLirKindTool(), false));
    }

    static class SubstrateReferenceMapBuilderFactory
    implements FrameMap.ReferenceMapBuilderFactory {
        SubstrateReferenceMapBuilderFactory() {
        }

        public ReferenceMapBuilder newReferenceMapBuilder(int totalFrameSize) {
            return new SubstrateReferenceMapBuilder(totalFrameSize);
        }
    }

    protected static final class SubstrateLIRGenerationResult
    extends LIRGenerationResult {
        private final SharedMethod method;

        public SubstrateLIRGenerationResult(CompilationIdentifier compilationId, LIR lir, FrameMapBuilder frameMapBuilder, RegisterAllocationConfig registerAllocationConfig, CallingConvention callingConvention, SharedMethod method) {
            super(compilationId, lir, frameMapBuilder, registerAllocationConfig, callingConvention);
            this.method = method;
            if (method.hasCalleeSavedRegisters()) {
                AArch64CalleeSavedRegisters calleeSavedRegisters = AArch64CalleeSavedRegisters.singleton();
                FrameMap frameMap = ((FrameMapBuilderTool)frameMapBuilder).getFrameMap();
                int registerSaveAreaSizeInBytes = calleeSavedRegisters.getSaveAreaSize();
                StackSlot calleeSaveArea = frameMap.allocateStackMemory(registerSaveAreaSizeInBytes, frameMap.getTarget().wordSize);
                calleeSavedRegisters.verifySaveAreaOffsetInFrame(calleeSaveArea.getRawOffset());
            }
            if (method.canDeoptimize() || method.isDeoptTarget()) {
                ((FrameMapBuilderTool)frameMapBuilder).getFrameMap().reserveOutgoing(16);
            }
        }

        public SharedMethod getMethod() {
            return this.method;
        }
    }

    protected static class DeoptEntryStubContext
    extends SubstrateAArch64FrameContext {
        protected final CallingConvention callingConvention;

        protected DeoptEntryStubContext(SharedMethod method, CallingConvention callingConvention) {
            super(method);
            this.callingConvention = callingConvention;
        }

        @Override
        public void enter(CompilationResultBuilder crb) {
            AArch64MacroAssembler masm = (AArch64MacroAssembler)crb.asm;
            RegisterConfig registerConfig = crb.frameMap.getRegisterConfig();
            Register gpReturnReg = registerConfig.getReturnRegister(JavaKind.Object);
            Register fpReturnReg = registerConfig.getReturnRegister(JavaKind.Double);
            Register secondParameter = ValueUtil.asRegister((Value)this.callingConvention.getArgument(1));
            masm.mov(64, secondParameter, gpReturnReg);
            Register thirdParameter = ValueUtil.asRegister((Value)this.callingConvention.getArgument(2));
            masm.fmov(64, thirdParameter, fpReturnReg);
            Register firstParameter = ValueUtil.asRegister((Value)this.callingConvention.getArgument(0));
            masm.mov(64, firstParameter, registerConfig.getFrameRegister());
            super.enter(crb);
        }
    }

    protected static class DeoptExitStubContext
    extends SubstrateAArch64FrameContext {
        protected final CallingConvention callingConvention;

        protected DeoptExitStubContext(SharedMethod method, CallingConvention callingConvention) {
            super(method);
            this.callingConvention = callingConvention;
        }

        @Override
        public void enter(CompilationResultBuilder crb) {
            AArch64MacroAssembler masm = (AArch64MacroAssembler)crb.asm;
            Register firstParameter = ValueUtil.asRegister((Value)this.callingConvention.getArgument(0));
            masm.mov(64, AArch64.sp, firstParameter);
            Register thirdParameter = ValueUtil.asRegister((Value)this.callingConvention.getArgument(2));
            masm.str(64, thirdParameter, AArch64Address.createImmediateAddress((int)64, (AArch64Address.AddressingMode)AArch64Address.AddressingMode.IMMEDIATE_PRE_INDEXED, (Register)AArch64.sp, (int)-32));
            super.enter(crb);
        }

        @Override
        public void leave(CompilationResultBuilder crb) {
            AArch64MacroAssembler masm = (AArch64MacroAssembler)crb.asm;
            RegisterConfig registerConfig = crb.frameMap.getRegisterConfig();
            Register fpReturnReg = registerConfig.getReturnRegister(JavaKind.Double);
            super.leave(crb);
            masm.fldr(64, fpReturnReg, AArch64Address.createImmediateAddress((int)64, (AArch64Address.AddressingMode)AArch64Address.AddressingMode.IMMEDIATE_POST_INDEXED, (Register)AArch64.sp, (int)16));
            masm.ldp(64, SubstrateAArch64RegisterConfig.fp, AArch64.lr, AArch64Address.createImmediateAddress((int)64, (AArch64Address.AddressingMode)AArch64Address.AddressingMode.IMMEDIATE_PAIR_POST_INDEXED, (Register)AArch64.sp, (int)16));
        }
    }

    public static class SubstrateAArch64FrameContext
    implements FrameContext {
        protected final SharedMethod method;

        protected SubstrateAArch64FrameContext(SharedMethod method) {
            this.method = method;
        }

        public void enter(CompilationResultBuilder crb) {
            FrameMap frameMap = crb.frameMap;
            int frameSize = frameMap.frameSize();
            int totalFrameSize = frameMap.totalFrameSize();
            assert (frameSize + 2 * crb.target.arch.getWordSize() == totalFrameSize) : "totalFramesize should be frameSize + 2 words";
            AArch64MacroAssembler masm = (AArch64MacroAssembler)crb.asm;
            crb.blockComment("[method prologue]");
            this.makeFrame(crb, masm, totalFrameSize, frameSize);
            crb.recordMark((CompilationResult.MarkId)SubstrateBackend.SubstrateMarkId.PROLOGUE_DECD_RSP);
            if (((Boolean)GraalOptions.ZapStackOnMethodEntry.getValue(crb.getOptions())).booleanValue()) {
                try (AArch64MacroAssembler.ScratchRegister sc = masm.getScratchRegister();){
                    Register scratch = sc.getRegister();
                    int longSize = 8;
                    masm.mov(64, scratch, AArch64.sp);
                    AArch64Address address = AArch64Address.createImmediateAddress((int)64, (AArch64Address.AddressingMode)AArch64Address.AddressingMode.IMMEDIATE_POST_INDEXED, (Register)scratch, (int)longSize);
                    try (AArch64MacroAssembler.ScratchRegister sc2 = masm.getScratchRegister();){
                        Register value = sc2.getRegister();
                        masm.mov(value, 841573668843749358L);
                        for (int i = 0; i < frameSize; i += longSize) {
                            masm.str(64, value, address);
                        }
                    }
                }
            }
            if (this.method.hasCalleeSavedRegisters()) {
                VMError.guarantee(!this.method.isDeoptTarget(), "Deoptimization runtime cannot fill the callee saved registers");
                AArch64CalleeSavedRegisters.singleton().emitSave(masm, totalFrameSize);
            }
            crb.recordMark((CompilationResult.MarkId)SubstrateBackend.SubstrateMarkId.PROLOGUE_END);
        }

        protected void makeFrame(CompilationResultBuilder crb, AArch64MacroAssembler masm, int totalFrameSize, int frameSize) {
            boolean preserveFramePointer = ((SubstrateAArch64RegisterConfig)crb.frameMap.getRegisterConfig()).shouldPreserveFramePointer();
            try (AArch64MacroAssembler.ScratchRegister sc = masm.getScratchRegister();){
                Register scratch = sc.getRegister();
                assert (totalFrameSize > 0);
                AArch64Address.AddressingMode addressingMode = AArch64Address.AddressingMode.IMMEDIATE_PAIR_SIGNED_SCALED;
                if (AArch64Address.isValidImmediateAddress((int)64, (AArch64Address.AddressingMode)addressingMode, (int)frameSize)) {
                    masm.sub(64, AArch64.sp, AArch64.sp, totalFrameSize);
                    masm.stp(64, SubstrateAArch64RegisterConfig.fp, AArch64.lr, AArch64Address.createImmediateAddress((int)64, (AArch64Address.AddressingMode)addressingMode, (Register)AArch64.sp, (int)frameSize));
                    if (preserveFramePointer) {
                        masm.add(64, SubstrateAArch64RegisterConfig.fp, AArch64.sp, frameSize);
                    }
                } else {
                    int frameRecordSize = totalFrameSize - frameSize;
                    masm.stp(64, SubstrateAArch64RegisterConfig.fp, AArch64.lr, AArch64Address.createImmediateAddress((int)64, (AArch64Address.AddressingMode)AArch64Address.AddressingMode.IMMEDIATE_PAIR_PRE_INDEXED, (Register)AArch64.sp, (int)(-frameRecordSize)));
                    if (preserveFramePointer) {
                        masm.mov(64, SubstrateAArch64RegisterConfig.fp, AArch64.sp);
                    }
                    masm.sub(64, AArch64.sp, AArch64.sp, frameSize, scratch);
                }
            }
        }

        public void leave(CompilationResultBuilder crb) {
            FrameMap frameMap = crb.frameMap;
            int frameSize = frameMap.frameSize();
            int totalFrameSize = frameMap.totalFrameSize();
            assert (frameSize + 2 * crb.target.arch.getWordSize() == totalFrameSize) : "totalFramesize should be frameSize + 2 words";
            AArch64MacroAssembler masm = (AArch64MacroAssembler)crb.asm;
            crb.blockComment("[method epilogue]");
            crb.recordMark((CompilationResult.MarkId)SubstrateBackend.SubstrateMarkId.EPILOGUE_START);
            if (this.method.hasCalleeSavedRegisters()) {
                JavaKind returnKind = this.method.getSignature().getReturnKind();
                Register returnRegister = null;
                if (returnKind != JavaKind.Void) {
                    returnRegister = frameMap.getRegisterConfig().getReturnRegister(returnKind);
                }
                AArch64CalleeSavedRegisters.singleton().emitRestore(masm, totalFrameSize, returnRegister);
            }
            try (AArch64MacroAssembler.ScratchRegister sc = masm.getScratchRegister();){
                Register scratch = sc.getRegister();
                assert (totalFrameSize > 0);
                AArch64Address.AddressingMode addressingMode = AArch64Address.AddressingMode.IMMEDIATE_PAIR_SIGNED_SCALED;
                if (AArch64Address.isValidImmediateAddress((int)64, (AArch64Address.AddressingMode)addressingMode, (int)frameSize)) {
                    masm.ldp(64, SubstrateAArch64RegisterConfig.fp, AArch64.lr, AArch64Address.createImmediateAddress((int)64, (AArch64Address.AddressingMode)addressingMode, (Register)AArch64.sp, (int)frameSize));
                    masm.add(64, AArch64.sp, AArch64.sp, totalFrameSize);
                } else {
                    int frameRecordSize = totalFrameSize - frameSize;
                    masm.add(64, AArch64.sp, AArch64.sp, totalFrameSize - frameRecordSize, scratch);
                    masm.ldp(64, SubstrateAArch64RegisterConfig.fp, AArch64.lr, AArch64Address.createImmediateAddress((int)64, (AArch64Address.AddressingMode)AArch64Address.AddressingMode.IMMEDIATE_PAIR_POST_INDEXED, (Register)AArch64.sp, (int)frameRecordSize));
                }
            }
            crb.recordMark((CompilationResult.MarkId)SubstrateBackend.SubstrateMarkId.EPILOGUE_INCD_RSP);
        }

        public void returned(CompilationResultBuilder crb) {
            crb.recordMark((CompilationResult.MarkId)SubstrateBackend.SubstrateMarkId.EPILOGUE_END);
        }
    }

    protected static class SubstrateAArch64MoveFactory
    extends AArch64MoveFactory {
        private final SharedMethod method;
        private final LIRKindTool lirKindTool;

        protected SubstrateAArch64MoveFactory(SharedMethod method, LIRKindTool lirKindTool) {
            this.method = method;
            this.lirKindTool = lirKindTool;
        }

        public boolean allowConstantToStackMove(Constant constant) {
            if (constant instanceof SubstrateObjectConstant && this.method.isDeoptTarget()) {
                return false;
            }
            return super.allowConstantToStackMove(constant);
        }

        private static JavaConstant getZeroConstant(AllocatableValue dst) {
            int size = dst.getPlatformKind().getSizeInBytes() * 8;
            switch (size) {
                case 32: {
                    return JavaConstant.INT_0;
                }
                case 64: {
                    return JavaConstant.LONG_0;
                }
            }
            throw VMError.shouldNotReachHereUnexpectedInput(size);
        }

        public AArch64LIRInstruction createLoadMethodPointerConstant(AllocatableValue dst, SubstrateMethodPointerConstant constant) {
            SharedMethod sharedMethod;
            ResolvedJavaMethod resolvedJavaMethod;
            if (ImageLayerBuildingSupport.buildingExtensionLayer() && (resolvedJavaMethod = constant.pointer().getMethod()) instanceof SharedMethod && (sharedMethod = (SharedMethod)resolvedJavaMethod).forceIndirectCall()) {
                throw VMError.unimplemented("AArch64 does not currently support layered images.");
            }
            return new AArch64LoadMethodPointerConstantOp(dst, constant);
        }

        public AArch64LIRInstruction createLoad(AllocatableValue dst, Constant src) {
            if (CompressedNullConstant.COMPRESSED_NULL.equals((Object)src)) {
                return super.createLoad(dst, (Constant)SubstrateAArch64MoveFactory.getZeroConstant(dst));
            }
            if (src instanceof CompressibleConstant) {
                CompressibleConstant constant = (CompressibleConstant)src;
                return this.loadObjectConstant(dst, constant);
            }
            if (src instanceof SubstrateMethodPointerConstant) {
                SubstrateMethodPointerConstant constant = (SubstrateMethodPointerConstant)src;
                return this.createLoadMethodPointerConstant(dst, constant);
            }
            return super.createLoad(dst, src);
        }

        public LIRInstruction createStackLoad(AllocatableValue dst, Constant src) {
            if (CompressedNullConstant.COMPRESSED_NULL.equals((Object)src)) {
                return super.createStackLoad(dst, (Constant)SubstrateAArch64MoveFactory.getZeroConstant(dst));
            }
            if (src instanceof CompressibleConstant) {
                CompressibleConstant constant = (CompressibleConstant)src;
                return this.loadObjectConstant(dst, constant);
            }
            if (src instanceof SubstrateMethodPointerConstant) {
                SubstrateMethodPointerConstant constant = (SubstrateMethodPointerConstant)src;
                return this.createLoadMethodPointerConstant(dst, constant);
            }
            return super.createStackLoad(dst, src);
        }

        protected AArch64LIRInstruction loadObjectConstant(AllocatableValue dst, CompressibleConstant constant) {
            if (ReferenceAccess.singleton().haveCompressedReferences()) {
                RegisterValue heapBase = ReservedRegisters.singleton().getHeapBaseRegister().asValue();
                return new LoadCompressedObjectConstantOp(dst, constant, (AllocatableValue)heapBase, SubstrateAArch64Backend.getCompressEncoding(), this.lirKindTool);
            }
            return new AArch64Move.LoadInlineConstant((JavaConstant)constant, dst);
        }
    }

    protected static class SubstrateAArch64LIRKindTool
    extends AArch64LIRKindTool {
        protected SubstrateAArch64LIRKindTool() {
        }

        public LIRKind getNarrowOopKind() {
            return LIRKind.compressedReference((PlatformKind)AArch64Kind.QWORD);
        }

        public LIRKind getNarrowPointerKind() {
            throw VMError.shouldNotReachHereAtRuntime();
        }
    }

    protected class SubstrateAArch64LIRGenerator
    extends AArch64LIRGenerator
    implements SubstrateLIRGenerator {
        public SubstrateAArch64LIRGenerator(SubstrateAArch64Backend this$0, LIRKindTool lirKindTool, AArch64ArithmeticLIRGenerator arithmeticLIRGen, MoveFactory moveFactory, Providers providers, LIRGenerationResult lirGenRes) {
            super(lirKindTool, arithmeticLIRGen, null, moveFactory, providers, lirGenRes);
        }

        public SubstrateLIRGenerationResult getResult() {
            return (SubstrateLIRGenerationResult)super.getResult();
        }

        public SubstrateRegisterConfig getRegisterConfig() {
            return (SubstrateRegisterConfig)super.getRegisterConfig();
        }

        protected boolean getDestroysCallerSavedRegisters(ResolvedJavaMethod targetMethod) {
            if (this.getResult().getMethod().isDeoptTarget()) {
                return true;
            }
            return targetMethod == null || !((SharedMethod)targetMethod).hasCalleeSavedRegisters();
        }

        protected Value emitIndirectForeignCallAddress(ForeignCallLinkage linkage) {
            if (!SubstrateBackend.shouldEmitOnlyIndirectCalls()) {
                return null;
            }
            SubstrateForeignCallLinkage callTarget = (SubstrateForeignCallLinkage)linkage;
            SharedMethod targetMethod = (SharedMethod)callTarget.getMethod();
            LIRKind wordKind = this.getLIRKindTool().getWordKind();
            Value codeOffsetInImage = this.emitConstant(wordKind, (Constant)JavaConstant.forLong((long)targetMethod.getImageCodeOffset()));
            Value codeInfo = this.emitJavaConstant(SubstrateObjectConstant.forObject(targetMethod.getImageCodeInfo()));
            int size = wordKind.getPlatformKind().getSizeInBytes() * 8;
            int codeStartFieldOffset = KnownOffsets.singleton().getImageCodeInfoCodeStartOffset();
            AArch64AddressValue codeStartField = AArch64AddressValue.makeAddress((ValueKind)wordKind, (int)size, (AllocatableValue)this.asAllocatable(codeInfo), (int)codeStartFieldOffset);
            Variable codeStart = this.getArithmetic().emitLoad(wordKind, (Value)codeStartField, null, MemoryOrderMode.PLAIN, MemoryExtendKind.DEFAULT);
            return this.getArithmetic().emitAdd((Value)codeStart, codeOffsetInImage, false);
        }

        protected void emitForeignCallOp(ForeignCallLinkage linkage, Value targetAddress, Value result, Value[] arguments, Value[] temps, LIRFrameState info) {
            SubstrateForeignCallLinkage callTarget = (SubstrateForeignCallLinkage)linkage;
            SharedMethod targetMethod = (SharedMethod)callTarget.getMethod();
            Value exceptionTemp = this.getExceptionTemp(info != null && info.exceptionEdge != null);
            if (SubstrateBackend.shouldEmitOnlyIndirectCalls()) {
                RegisterValue targetRegister = AArch64.lr.asValue((ValueKind)FrameAccess.getWordStamp().getLIRKind(this.getLIRKindTool()));
                this.emitMove((AllocatableValue)targetRegister, targetAddress);
                this.append((LIRInstruction)new SubstrateAArch64IndirectCallOp(targetMethod, result, arguments, temps, (Value)targetRegister, info, (Value)Value.ILLEGAL, -1, this.getDestroysCallerSavedRegisters(targetMethod), exceptionTemp, null));
            } else {
                assert (targetAddress == null);
                this.append((LIRInstruction)new SubstrateAArch64DirectCallOp(targetMethod, result, arguments, temps, info, (Value)Value.ILLEGAL, -1, this.getDestroysCallerSavedRegisters(targetMethod), exceptionTemp));
            }
        }

        private Value getExceptionTemp(boolean hasExceptionEdge) {
            if (hasExceptionEdge) {
                return this.getRegisterConfig().getReturnRegister(JavaKind.Object).asValue();
            }
            return Value.ILLEGAL;
        }

        public void emitUnwind(Value operand) {
            throw VMError.shouldNotReachHere("handled by lowering");
        }

        public void emitDeoptimize(Value actionAndReason, Value failedSpeculation, LIRFrameState state) {
            throw VMError.shouldNotReachHere("Substrate VM does not use deoptimization");
        }

        @Override
        public void emitVerificationMarker(Object marker) {
            this.append(new VerificationMarkerOp(marker));
        }

        @Override
        public void emitInstructionSynchronizationBarrier() {
            this.append((LIRInstruction)new AArch64InstructionSynchronizationBarrierOp());
        }

        @Override
        public void emitFarReturn(AllocatableValue result, Value stackPointer, Value ip, boolean fromMethodWithCalleeSavedRegisters) {
            this.append((LIRInstruction)new AArch64FarReturnOp(this.asAllocatable((Value)result), this.asAllocatable(stackPointer), this.asAllocatable(ip), fromMethodWithCalleeSavedRegisters));
        }

        @Override
        public void emitDeadEnd() {
            this.append(new DeadEndOp());
        }

        public void emitPrefetchAllocate(Value address) {
            this.append((LIRInstruction)new AArch64PrefetchOp(this.asAddressValue(address, -1), AArch64Assembler.PrefetchMode.PSTL1KEEP));
        }

        public Value emitCompress(Value pointer, CompressEncoding encoding, boolean isNonNull) {
            Variable result = this.newVariable((ValueKind)this.getLIRKindTool().getNarrowOopKind());
            boolean nonNull = SubstrateAArch64Backend.useLinearPointerCompression() || isNonNull;
            this.append((LIRInstruction)new AArch64Move.CompressPointerOp((AllocatableValue)result, (Value)this.asAllocatable(pointer), (AllocatableValue)ReservedRegisters.singleton().getHeapBaseRegister().asValue(), encoding, nonNull, this.getLIRKindTool()));
            return result;
        }

        public Value emitUncompress(Value pointer, CompressEncoding encoding, boolean isNonNull) {
            assert (((LIRKind)pointer.getValueKind(LIRKind.class)).getPlatformKind() == this.getLIRKindTool().getNarrowOopKind().getPlatformKind());
            Variable result = this.newVariable((ValueKind)this.getLIRKindTool().getObjectKind());
            boolean nonNull = SubstrateAArch64Backend.useLinearPointerCompression() || isNonNull;
            this.append((LIRInstruction)new AArch64Move.UncompressPointerOp((AllocatableValue)result, (Value)this.asAllocatable(pointer), (AllocatableValue)ReservedRegisters.singleton().getHeapBaseRegister().asValue(), encoding, nonNull, this.getLIRKindTool()));
            return result;
        }

        public void emitConvertNullToZero(AllocatableValue result, AllocatableValue value) {
            if (SubstrateAArch64Backend.useLinearPointerCompression()) {
                this.append((LIRInstruction)new AArch64Move.ConvertNullToZeroOp(result, value));
            } else {
                this.emitMove(result, (Value)value);
            }
        }

        public void emitConvertZeroToNull(AllocatableValue result, Value value) {
            if (SubstrateAArch64Backend.useLinearPointerCompression()) {
                this.append((LIRInstruction)new AArch64Move.ConvertZeroToNullOp(result, (AllocatableValue)value));
            } else {
                this.emitMove(result, value);
            }
        }

        public void emitReturn(JavaKind kind, Value input) {
            AllocatableValue operand = Value.ILLEGAL;
            if (input != null) {
                operand = this.resultOperandFor(kind, input.getValueKind());
                this.emitMove(operand, input);
            }
            this.append((LIRInstruction)new AArch64ControlFlow.ReturnOp((Value)operand));
        }

        public int getArrayLengthOffset() {
            return ConfigurationValues.getObjectLayout().getArrayLengthOffset();
        }

        public Register getHeapBaseRegister() {
            return ReservedRegisters.singleton().getHeapBaseRegister();
        }

        protected int getVMPageSize() {
            return SubstrateOptions.getPageSize();
        }

        @Override
        public void emitExitMethodAddressResolution(Value ip) {
            PLTGOTConfiguration configuration = PLTGOTConfiguration.singleton();
            RegisterValue exitThroughRegisterValue = configuration.getExitMethodAddressResolutionRegister(this.getRegisterConfig()).asValue(ip.getValueKind());
            this.emitMove((AllocatableValue)exitThroughRegisterValue, ip);
            this.append(configuration.createExitMethodAddressResolutionOp(exitThroughRegisterValue));
        }
    }

    public class SubstrateAArch64NodeLIRBuilder
    extends AArch64NodeLIRBuilder
    implements SubstrateNodeLIRBuilder {
        public SubstrateAArch64NodeLIRBuilder(StructuredGraph graph, LIRGeneratorTool gen, AArch64NodeMatchRules nodeMatchRules) {
            super(graph, gen, nodeMatchRules);
        }

        public void visitSafepointNode(SafepointNode node) {
            throw VMError.shouldNotReachHere("handled by lowering");
        }

        public void visitBreakpointNode(BreakpointNode node) {
            JavaType[] sig = new JavaType[node.arguments().size()];
            for (int i = 0; i < sig.length; ++i) {
                sig[i] = ((ValueNode)node.arguments().get(i)).stamp(NodeView.DEFAULT).javaType(this.gen.getMetaAccess());
            }
            CallingConvention convention = this.gen.getRegisterConfig().getCallingConvention((CallingConvention.Type)SubstrateCallingConventionKind.Java.toType(true), null, sig, (ValueKindFactory)this.gen);
            this.append((LIRInstruction)new AArch64BreakpointOp(this.visitInvokeArguments(convention, (Collection)node.arguments())));
        }

        protected DebugInfoBuilder createDebugInfoBuilder(StructuredGraph graph, NodeValueMap nodeValueMap) {
            return new SubstrateDebugInfoBuilder(graph, this.gen.getProviders().getMetaAccessExtensionProvider(), nodeValueMap);
        }

        private boolean getDestroysCallerSavedRegisters(ResolvedJavaMethod targetMethod) {
            return ((SubstrateAArch64LIRGenerator)this.gen).getDestroysCallerSavedRegisters(targetMethod);
        }

        protected void prologSetParameterNodes(StructuredGraph graph, Value[] params) {
            SubstrateCallingConvention convention = (SubstrateCallingConvention)this.gen.getResult().getCallingConvention();
            for (ParameterNode param : graph.getNodes(ParameterNode.TYPE)) {
                Value inputValue = params[param.index()];
                Variable paramValue = this.gen.emitMove(inputValue);
                if (inputValue.getPlatformKind().getSizeInBytes() < 4) {
                    SubstrateCallingConventionType type = (SubstrateCallingConventionType)convention.getType();
                    assert (!type.outgoing && type.nativeABI());
                    JavaKind kind = convention.getArgumentStorageKinds()[param.index()];
                    JavaKind stackKind = kind.getStackKind();
                    paramValue = kind.isUnsigned() ? this.gen.getArithmetic().emitZeroExtend((Value)paramValue, kind.getBitCount(), stackKind.getBitCount()) : this.gen.getArithmetic().emitSignExtend((Value)paramValue, kind.getBitCount(), stackKind.getBitCount());
                }
                assert (paramValue.getValueKind().equals(this.gen.getLIRKind(param.stamp(NodeView.DEFAULT))));
                this.setResult((ValueNode)param, (Value)paramValue);
            }
        }

        private Value getExceptionTemp(CallTargetNode callTarget) {
            return ((SubstrateAArch64LIRGenerator)this.gen).getExceptionTemp(callTarget.invoke() instanceof InvokeWithExceptionNode);
        }

        public BiConsumer<CompilationResultBuilder, Integer> getOffsetRecorder(IndirectCallTargetNode callTargetNode) {
            return null;
        }

        protected void emitInvoke(LoweredCallTargetNode callTarget, Value[] parameters, LIRFrameState callState, Value result) {
            SubstrateAArch64Backend.verifyCallTarget(callTarget);
            if (callTarget instanceof ComputedIndirectCallTargetNode) {
                this.emitComputedIndirectCall((ComputedIndirectCallTargetNode)callTarget, result, parameters, (Value[])AllocatableValue.NONE, callState);
            } else {
                super.emitInvoke(callTarget, parameters, callState, result);
            }
        }

        protected void emitDirectCall(DirectCallTargetNode callTarget, Value result, Value[] parameters, Value[] temps, LIRFrameState callState) {
            ResolvedJavaMethod targetMethod = callTarget.targetMethod();
            this.append((LIRInstruction)new SubstrateAArch64DirectCallOp(targetMethod, result, parameters, temps, callState, (Value)this.setupJavaFrameAnchor((CallTargetNode)callTarget), SubstrateBackend.getNewThreadStatus((CallTargetNode)callTarget), this.getDestroysCallerSavedRegisters(targetMethod), this.getExceptionTemp((CallTargetNode)callTarget)));
        }

        protected void emitIndirectCall(IndirectCallTargetNode callTarget, Value result, Value[] parameters, Value[] temps, LIRFrameState callState) {
            Register targetRegister = AArch64.lr;
            RegisterValue targetAddress = targetRegister.asValue((ValueKind)FrameAccess.getWordStamp().getLIRKind(this.getLIRGeneratorTool().getLIRKindTool()));
            this.gen.emitMove((AllocatableValue)targetAddress, this.operand((Node)callTarget.computedAddress()));
            ResolvedJavaMethod targetMethod = callTarget.targetMethod();
            this.append((LIRInstruction)new SubstrateAArch64IndirectCallOp(targetMethod, result, parameters, temps, (Value)targetAddress, callState, (Value)this.setupJavaFrameAnchor((CallTargetNode)callTarget), SubstrateBackend.getNewThreadStatus((CallTargetNode)callTarget), this.getDestroysCallerSavedRegisters(targetMethod), this.getExceptionTemp((CallTargetNode)callTarget), this.getOffsetRecorder(callTarget)));
        }

        protected void emitComputedIndirectCall(ComputedIndirectCallTargetNode callTarget, Value result, Value[] parameters, Value[] temps, LIRFrameState callState) {
            assert (!((SubstrateCallingConventionType)callTarget.callType()).nativeABI());
            RegisterValue addressBase = AArch64.lr.asValue((ValueKind)callTarget.getAddressBase().stamp(NodeView.DEFAULT).getLIRKind(this.getLIRGeneratorTool().getLIRKindTool()));
            this.gen.emitMove((AllocatableValue)addressBase, this.operand((Node)callTarget.getAddressBase()));
            ResolvedJavaMethod targetMethod = callTarget.targetMethod();
            this.append((LIRInstruction)new SubstrateAArch64ComputedIndirectCallOp(targetMethod, result, parameters, temps, (Value)addressBase, callTarget.getAddressComputation(), callState, this.getExceptionTemp((CallTargetNode)callTarget), this.gen.getLIRKindTool(), SubstrateAArch64Backend.this.getConstantReflection()));
        }

        private AllocatableValue setupJavaFrameAnchor(CallTargetNode callTarget) {
            if (!SubstrateBackend.hasJavaFrameAnchor(callTarget)) {
                return Value.ILLEGAL;
            }
            Register frameAnchorRegister = AArch64.r13;
            RegisterValue frameAnchor = frameAnchorRegister.asValue((ValueKind)FrameAccess.getWordStamp().getLIRKind(this.getLIRGeneratorTool().getLIRKindTool()));
            this.gen.emitMove((AllocatableValue)frameAnchor, this.operand((Node)SubstrateBackend.getJavaFrameAnchor(callTarget)));
            return frameAnchor;
        }

        public void emitBranch(LogicNode node, LabelRef trueSuccessor, LabelRef falseSuccessor, double trueSuccessorProbability) {
            if (node instanceof SafepointCheckNode) {
                AArch64SafepointCheckOp op = new AArch64SafepointCheckOp();
                this.append((LIRInstruction)op);
                this.append((LIRInstruction)new AArch64ControlFlow.BranchOp(op.getConditionFlag(), trueSuccessor, falseSuccessor, trueSuccessorProbability));
            } else {
                super.emitBranch(node, trueSuccessor, falseSuccessor, trueSuccessorProbability);
            }
        }

        @Override
        public void emitCGlobalDataLoadAddress(CGlobalDataLoadAddressNode node) {
            Variable result = this.gen.newVariable((ValueKind)this.gen.getLIRKindTool().getWordKind());
            this.append((LIRInstruction)new AArch64CGlobalDataLoadAddressOp(node.getDataInfo(), (AllocatableValue)result));
            this.setResult((ValueNode)node, (Value)result);
        }

        @Override
        public Variable emitReadReturnAddress() {
            return this.getLIRGeneratorTool().emitMove((Value)StackSlot.get((ValueKind)this.getLIRGeneratorTool().getLIRKind(FrameAccess.getWordStamp()), (int)(-FrameAccess.returnAddressSize()), (boolean)true));
        }

        public ForeignCallLinkage lookupGraalStub(ValueNode valueNode, ForeignCallDescriptor foreignCallDescriptor) {
            SharedMethod method = (SharedMethod)valueNode.graph().method();
            if (method != null && method.isForeignCallTarget()) {
                return null;
            }
            return this.gen.getForeignCalls().lookupForeignCall(foreignCallDescriptor);
        }
    }

    public static final class LoadCompressedObjectConstantOp
    extends AArch64Move.PointerCompressionOp
    implements StandardOp.LoadConstantOp {
        public static final LIRInstructionClass<LoadCompressedObjectConstantOp> TYPE = LIRInstructionClass.create(LoadCompressedObjectConstantOp.class);
        private final CompressibleConstant constant;

        static Constant asCompressed(CompressibleConstant constant) {
            return constant.isCompressed() ? constant : constant.compress();
        }

        public LoadCompressedObjectConstantOp(AllocatableValue result, CompressibleConstant constant, AllocatableValue baseRegister, CompressEncoding encoding, LIRKindTool lirKindTool) {
            super(TYPE, result, (Value)new ConstantValue((ValueKind)lirKindTool.getNarrowOopKind(), LoadCompressedObjectConstantOp.asCompressed(constant)), baseRegister, encoding, true, lirKindTool);
            this.constant = constant;
        }

        public Constant getConstant() {
            return this.constant;
        }

        public void emitCode(CompilationResultBuilder crb, AArch64MacroAssembler masm) {
            Register resultReg = this.getResultRegister();
            int referenceSize = ConfigurationValues.getObjectLayout().getReferenceSize();
            Constant inputConstant = LIRValueUtil.asConstantValue((Value)this.getInput()).getConstant();
            if (masm.inlineObjects()) {
                crb.recordInlineDataInCode(inputConstant);
                if (referenceSize == 4) {
                    masm.mov(resultReg, -559030611, true);
                } else {
                    masm.mov(resultReg, -2401018187971961171L, true);
                }
            } else {
                crb.recordDataReferenceInCode(inputConstant, referenceSize);
                int srcSize = referenceSize * 8;
                masm.adrpLdr(srcSize, resultReg, resultReg);
            }
            if (!this.constant.isCompressed()) {
                Register baseReg = this.getBaseRegister();
                assert (!baseReg.equals((Object)Register.None) || this.getShift() != 0) : "no compression in place";
                masm.add(64, resultReg, baseReg, resultReg, AArch64Assembler.ShiftType.LSL, this.getShift());
            }
        }
    }

    @Opcode(value="DEAD_END")
    public static class DeadEndOp
    extends LIRInstruction
    implements StandardOp.BlockEndOp {
        public static final LIRInstructionClass<DeadEndOp> TYPE = LIRInstructionClass.create(DeadEndOp.class);

        public DeadEndOp() {
            super(TYPE);
        }

        public void emitCode(CompilationResultBuilder crb) {
            if (SubstrateUtil.assertionsEnabled()) {
                ((AArch64MacroAssembler)crb.asm).brk(AArch64MacroAssembler.AArch64ExceptionCode.BREAKPOINT);
            }
        }
    }

    @Opcode(value="CALL_COMPUTED_INDIRECT")
    public static class SubstrateAArch64ComputedIndirectCallOp
    extends AArch64Call.MethodCallOp {
        public static final LIRInstructionClass<SubstrateAArch64ComputedIndirectCallOp> TYPE = LIRInstructionClass.create(SubstrateAArch64ComputedIndirectCallOp.class);
        @LIRInstruction.Use(value={LIRInstruction.OperandFlag.REG})
        private Value addressBase;
        @LIRInstruction.Temp(value={LIRInstruction.OperandFlag.REG})
        private Value addressBaseTemp;
        @LIRInstruction.Temp(value={LIRInstruction.OperandFlag.REG, LIRInstruction.OperandFlag.ILLEGAL})
        private Value exceptionTemp;
        private final ComputedIndirectCallTargetNode.Computation[] addressComputation;
        private final LIRKindTool lirKindTool;
        private final ConstantReflectionProvider constantReflection;

        public SubstrateAArch64ComputedIndirectCallOp(ResolvedJavaMethod callTarget, Value result, Value[] parameters, Value[] temps, Value addressBase, ComputedIndirectCallTargetNode.Computation[] addressComputation, LIRFrameState state, Value exceptionTemp, LIRKindTool lirKindTool, ConstantReflectionProvider constantReflection) {
            super(TYPE, callTarget, result, parameters, temps, state);
            this.addressBase = this.addressBaseTemp = addressBase;
            this.exceptionTemp = exceptionTemp;
            this.addressComputation = addressComputation;
            this.lirKindTool = lirKindTool;
            this.constantReflection = constantReflection;
            assert (LIRValueUtil.differentRegisters((Object[])new Object[]{parameters, temps, addressBase}));
        }

        public void emitCode(CompilationResultBuilder crb, AArch64MacroAssembler masm) {
            VMError.guarantee(SubstrateOptions.SpawnIsolates.getValue(), "Memory access without isolates is not implemented");
            try (AArch64MacroAssembler.ScratchRegister sc1 = masm.getScratchRegister();
                 AArch64MacroAssembler.ScratchRegister sc2 = masm.getScratchRegister();){
                Register immediateScratch = sc1.getRegister();
                Register addressScratch = sc2.getRegister();
                int compressionShift = ReferenceAccess.singleton().getCompressionShift();
                Register computeRegister = ValueUtil.asRegister((Value)this.addressBase);
                int addressBitSize = this.addressBase.getPlatformKind().getSizeInBytes() * 8;
                boolean nextMemoryAccessNeedsDecompress = false;
                for (ComputedIndirectCallTargetNode.Computation computation : this.addressComputation) {
                    AArch64Address memoryAddress;
                    SharedField field;
                    Label done = null;
                    if (computation instanceof ComputedIndirectCallTargetNode.FieldLoad) {
                        field = (SharedField)((ComputedIndirectCallTargetNode.FieldLoad)computation).getField();
                        addressBitSize = this.getFieldSize(field);
                        if (nextMemoryAccessNeedsDecompress) {
                            masm.add(64, addressScratch, ReservedRegisters.singleton().getHeapBaseRegister(), computeRegister, AArch64Assembler.ShiftType.LSL, compressionShift);
                            memoryAddress = masm.makeAddress(addressBitSize, addressScratch, (long)field.getOffset(), immediateScratch);
                        } else {
                            memoryAddress = masm.makeAddress(addressBitSize, computeRegister, (long)field.getOffset(), immediateScratch);
                        }
                    } else if (computation instanceof ComputedIndirectCallTargetNode.FieldLoadIfZero) {
                        done = new Label();
                        VMError.guarantee(!nextMemoryAccessNeedsDecompress, "Comparison with compressed null value not implemented");
                        masm.cbnz(addressBitSize, computeRegister, done);
                        JavaConstant object = ((ComputedIndirectCallTargetNode.FieldLoadIfZero)computation).getObject();
                        field = (SharedField)((ComputedIndirectCallTargetNode.FieldLoadIfZero)computation).getField();
                        addressBitSize = this.getFieldSize(field);
                        if (SubstrateUtil.HOSTED) {
                            crb.recordInlineDataInCode((Constant)object);
                            int referenceSize = ConfigurationValues.getObjectLayout().getReferenceSize();
                            if (referenceSize == 4) {
                                masm.mov(addressScratch, -559030611, true);
                            } else {
                                masm.mov(addressScratch, -2401018187971961171L, true);
                            }
                            masm.add(64, addressScratch, ReservedRegisters.singleton().getHeapBaseRegister(), addressScratch, AArch64Assembler.ShiftType.LSL, compressionShift);
                            memoryAddress = masm.makeAddress(addressBitSize, addressScratch, (long)field.getOffset(), immediateScratch);
                        } else {
                            memoryAddress = masm.makeAddress(addressBitSize, ReservedRegisters.singleton().getHeapBaseRegister(), (long)(field.getOffset() + ((SharedConstantReflectionProvider)this.constantReflection).getImageHeapOffset(object)), immediateScratch);
                        }
                    } else {
                        throw VMError.shouldNotReachHere("Computation is not supported yet: " + computation.getClass().getTypeName());
                    }
                    nextMemoryAccessNeedsDecompress = field.getStorageKind() == JavaKind.Object;
                    masm.ldr(addressBitSize, computeRegister, memoryAddress);
                    if (done == null) continue;
                    masm.bind(done);
                }
                VMError.guarantee(!nextMemoryAccessNeedsDecompress, "Final computed call target address is not a primitive value");
                AArch64Call.indirectCall((CompilationResultBuilder)crb, (AArch64MacroAssembler)masm, (Register)computeRegister, (InvokeTarget)this.callTarget, (LIRFrameState)this.state);
            }
        }

        private int getFieldSize(SharedField field) {
            switch (field.getStorageKind()) {
                case Int: {
                    return 32;
                }
                case Long: {
                    return 64;
                }
                case Object: {
                    return this.lirKindTool.getNarrowOopKind().getPlatformKind().getSizeInBytes() * 8;
                }
            }
            throw VMError.shouldNotReachHere("Kind is not supported yet: " + String.valueOf(field.getStorageKind()));
        }
    }

    @Opcode(value="CALL_INDIRECT")
    public static class SubstrateAArch64IndirectCallOp
    extends AArch64Call.IndirectCallOp {
        public static final LIRInstructionClass<SubstrateAArch64IndirectCallOp> TYPE = LIRInstructionClass.create(SubstrateAArch64IndirectCallOp.class);
        private final int newThreadStatus;
        @LIRInstruction.Use(value={LIRInstruction.OperandFlag.REG, LIRInstruction.OperandFlag.ILLEGAL})
        private Value javaFrameAnchor;
        private final boolean destroysCallerSavedRegisters;
        @LIRInstruction.Temp(value={LIRInstruction.OperandFlag.REG, LIRInstruction.OperandFlag.ILLEGAL})
        private Value exceptionTemp;
        @LIRInstruction.Temp(value={LIRInstruction.OperandFlag.REG})
        private Value linkReg;
        private final BiConsumer<CompilationResultBuilder, Integer> offsetRecorder;

        public SubstrateAArch64IndirectCallOp(ResolvedJavaMethod callTarget, Value result, Value[] parameters, Value[] temps, Value targetAddress, LIRFrameState state, Value javaFrameAnchor, int newThreadStatus, boolean destroysCallerSavedRegisters, Value exceptionTemp, BiConsumer<CompilationResultBuilder, Integer> offsetRecorder) {
            super(TYPE, callTarget, result, parameters, temps, targetAddress, state);
            this.javaFrameAnchor = javaFrameAnchor;
            this.newThreadStatus = newThreadStatus;
            this.destroysCallerSavedRegisters = destroysCallerSavedRegisters;
            this.exceptionTemp = exceptionTemp;
            this.linkReg = AArch64.lr.asValue((ValueKind)LIRKind.value((PlatformKind)AArch64Kind.QWORD));
            this.offsetRecorder = offsetRecorder;
        }

        public void emitCode(CompilationResultBuilder crb, AArch64MacroAssembler masm) {
            SubstrateAArch64Backend.maybeTransitionToNative(crb, masm, this.javaFrameAnchor, this.state, this.newThreadStatus);
            Register target = ValueUtil.asRegister((Value)this.targetAddress);
            int offset = AArch64Call.indirectCall((CompilationResultBuilder)crb, (AArch64MacroAssembler)masm, (Register)target, (InvokeTarget)this.callTarget, (LIRFrameState)this.state);
            if (this.offsetRecorder != null) {
                this.offsetRecorder.accept(crb, offset);
            }
        }

        public boolean destroysCallerSavedRegisters() {
            return this.destroysCallerSavedRegisters;
        }
    }

    @Opcode(value="CALL_DIRECT")
    public static class SubstrateAArch64DirectCallOp
    extends AArch64Call.DirectCallOp {
        public static final LIRInstructionClass<SubstrateAArch64DirectCallOp> TYPE = LIRInstructionClass.create(SubstrateAArch64DirectCallOp.class);
        private final int newThreadStatus;
        @LIRInstruction.Use(value={LIRInstruction.OperandFlag.REG, LIRInstruction.OperandFlag.ILLEGAL})
        private Value javaFrameAnchor;
        private final boolean destroysCallerSavedRegisters;
        @LIRInstruction.Temp(value={LIRInstruction.OperandFlag.REG, LIRInstruction.OperandFlag.ILLEGAL})
        private Value exceptionTemp;
        @LIRInstruction.Temp(value={LIRInstruction.OperandFlag.REG})
        private Value linkReg;

        public SubstrateAArch64DirectCallOp(ResolvedJavaMethod callTarget, Value result, Value[] parameters, Value[] temps, LIRFrameState state, Value javaFrameAnchor, int newThreadStatus, boolean destroysCallerSavedRegisters, Value exceptionTemp) {
            super(TYPE, callTarget, result, parameters, temps, state);
            this.javaFrameAnchor = javaFrameAnchor;
            this.newThreadStatus = newThreadStatus;
            this.destroysCallerSavedRegisters = destroysCallerSavedRegisters;
            this.exceptionTemp = exceptionTemp;
            this.linkReg = AArch64.lr.asValue((ValueKind)LIRKind.value((PlatformKind)AArch64Kind.QWORD));
        }

        public void emitCode(CompilationResultBuilder crb, AArch64MacroAssembler masm) {
            SubstrateAArch64Backend.maybeTransitionToNative(crb, masm, this.javaFrameAnchor, this.state, this.newThreadStatus);
            AArch64Call.directCall((CompilationResultBuilder)crb, (AArch64MacroAssembler)masm, (InvokeTarget)this.callTarget, null, (LIRFrameState)this.state);
        }

        public boolean destroysCallerSavedRegisters() {
            return this.destroysCallerSavedRegisters;
        }
    }
}

