/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.genscavenge;

import com.oracle.svm.core.AlwaysInline;
import com.oracle.svm.core.MemoryWalker;
import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.genscavenge.AlignedHeapChunk;
import com.oracle.svm.core.genscavenge.HeapChunk;
import com.oracle.svm.core.genscavenge.HeapParameters;
import com.oracle.svm.core.genscavenge.ImageHeapInfo;
import com.oracle.svm.core.genscavenge.ReadOnlyHugeMemoryWalkerAccess;
import com.oracle.svm.core.genscavenge.ReadOnlyRegularMemoryWalkerAccess;
import com.oracle.svm.core.genscavenge.ReadOnlyRelocatableMemoryWalkerAccess;
import com.oracle.svm.core.genscavenge.UnalignedHeapChunk;
import com.oracle.svm.core.genscavenge.WritableHugeMemoryWalkerAccess;
import com.oracle.svm.core.genscavenge.WritableRegularMemoryWalkerAccess;
import com.oracle.svm.core.heap.Heap;
import com.oracle.svm.core.heap.ObjectVisitor;
import com.oracle.svm.core.hub.LayoutEncoding;
import com.oracle.svm.core.util.UnsignedUtils;
import jdk.graal.compiler.word.Word;
import org.graalvm.word.Pointer;
import org.graalvm.word.UnsignedWord;

public final class ImageHeapWalker {
    private static final MemoryWalker.NativeImageHeapRegionAccess<ImageHeapInfo> READ_ONLY_REGULAR_WALKER = new ReadOnlyRegularMemoryWalkerAccess();
    private static final MemoryWalker.NativeImageHeapRegionAccess<ImageHeapInfo> READ_ONLY_RELOCATABLE_WALKER = new ReadOnlyRelocatableMemoryWalkerAccess();
    private static final MemoryWalker.NativeImageHeapRegionAccess<ImageHeapInfo> WRITABLE_REGULAR_WALKER = new WritableRegularMemoryWalkerAccess();
    private static final MemoryWalker.NativeImageHeapRegionAccess<ImageHeapInfo> WRITABLE_HUGE_WALKER = new WritableHugeMemoryWalkerAccess();
    private static final MemoryWalker.NativeImageHeapRegionAccess<ImageHeapInfo> READ_ONLY_HUGE_WALKER = new ReadOnlyHugeMemoryWalkerAccess();

    private ImageHeapWalker() {
    }

    public static boolean walkRegions(ImageHeapInfo heapInfo, MemoryWalker.ImageHeapRegionVisitor visitor) {
        return visitor.visitNativeImageHeapRegion(heapInfo, READ_ONLY_REGULAR_WALKER) && visitor.visitNativeImageHeapRegion(heapInfo, READ_ONLY_RELOCATABLE_WALKER) && visitor.visitNativeImageHeapRegion(heapInfo, WRITABLE_REGULAR_WALKER) && visitor.visitNativeImageHeapRegion(heapInfo, WRITABLE_HUGE_WALKER) && visitor.visitNativeImageHeapRegion(heapInfo, READ_ONLY_HUGE_WALKER);
    }

    public static boolean walkImageHeapObjects(ImageHeapInfo heapInfo, ObjectVisitor visitor) {
        return ImageHeapWalker.walkPartition(heapInfo.firstReadOnlyRegularObject, heapInfo.lastReadOnlyRegularObject, visitor, true) && ImageHeapWalker.walkPartition(heapInfo.firstReadOnlyRelocatableObject, heapInfo.lastReadOnlyRelocatableObject, visitor, true) && ImageHeapWalker.walkPartition(heapInfo.firstWritableRegularObject, heapInfo.lastWritableRegularObject, visitor, true) && ImageHeapWalker.walkPartition(heapInfo.firstWritableHugeObject, heapInfo.lastWritableHugeObject, visitor, false) && ImageHeapWalker.walkPartition(heapInfo.firstReadOnlyHugeObject, heapInfo.lastReadOnlyHugeObject, visitor, false);
    }

    @Uninterruptible(reason="Forced inlining (StoredContinuation objects must not move).")
    static boolean walkPartition(Object firstObject, Object lastObject, ObjectVisitor visitor, boolean alignedChunks) {
        return ImageHeapWalker.walkPartitionInline(firstObject, lastObject, visitor, alignedChunks, false);
    }

    @AlwaysInline(value="GC performance")
    @Uninterruptible(reason="Forced inlining (StoredContinuation objects must not move).", callerMustBe=true)
    static boolean walkPartitionInline(Object firstObject, Object lastObject, ObjectVisitor visitor, boolean alignedChunks) {
        return ImageHeapWalker.walkPartitionInline(firstObject, lastObject, visitor, alignedChunks, true);
    }

    @AlwaysInline(value="GC performance")
    @Uninterruptible(reason="Forced inlining (StoredContinuation objects must not move).", callerMustBe=true)
    private static boolean walkPartitionInline(Object firstObject, Object lastObject, ObjectVisitor visitor, boolean alignedChunks, boolean inlineObjectVisit) {
        if (firstObject == null || lastObject == null) {
            assert (firstObject == null && lastObject == null);
            return true;
        }
        Word firstPointer = Word.objectToUntrackedPointer((Object)firstObject);
        Word lastPointer = Word.objectToUntrackedPointer((Object)lastObject);
        Word current = firstPointer;
        Pointer base = Heap.getHeap().getImageHeapStart();
        Pointer offset = current.subtract((UnsignedWord)base);
        UnsignedWord chunkOffset = alignedChunks ? UnsignedUtils.roundDown((UnsignedWord)offset, HeapParameters.getAlignedHeapChunkAlignment()) : offset.subtract(UnalignedHeapChunk.getObjectStartOffset());
        HeapChunk.Header currentChunk = (HeapChunk.Header)chunkOffset.add((UnsignedWord)base);
        do {
            Word limit = lastPointer;
            Pointer chunkTop = HeapChunk.getTopPointer(currentChunk);
            if (lastPointer.aboveThan((UnsignedWord)chunkTop)) {
                limit = chunkTop.subtract(1);
            }
            while (current.belowOrEqual((UnsignedWord)limit)) {
                Object currentObject = current.toObject();
                if (inlineObjectVisit ? !ImageHeapWalker.visitObjectInline(visitor, currentObject) : !ImageHeapWalker.visitObject(visitor, currentObject)) {
                    return false;
                }
                current = LayoutEncoding.getImageHeapObjectEnd(current.toObject());
            }
            if (!current.belowThan((UnsignedWord)lastPointer)) continue;
            currentChunk = HeapChunk.getNext(currentChunk);
            Pointer pointer = current = alignedChunks ? AlignedHeapChunk.getObjectsStart((AlignedHeapChunk.AlignedHeader)currentChunk) : UnalignedHeapChunk.getObjectStart((UnalignedHeapChunk.UnalignedHeader)currentChunk);
        } while (current.belowOrEqual((UnsignedWord)lastPointer));
        return true;
    }

    @Uninterruptible(reason="Bridge between uninterruptible and potentially interruptible code.", mayBeInlined=true, calleeMustBe=false)
    private static boolean visitObject(ObjectVisitor visitor, Object currentObject) {
        return visitor.visitObject(currentObject);
    }

    @AlwaysInline(value="de-virtualize calls to ObjectReferenceVisitor")
    @Uninterruptible(reason="Bridge between uninterruptible and potentially interruptible code.", mayBeInlined=true, calleeMustBe=false)
    private static boolean visitObjectInline(ObjectVisitor visitor, Object currentObject) {
        return visitor.visitObjectInline(currentObject);
    }
}

