/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.deopt;

import com.oracle.svm.core.Uninterruptible;

public interface DeoptimizationSlotPacking {
    public static final long MAX_SIZE_VARIABLE_FRAMESIZE = 255L;
    public static final int POS_VARIABLE_FRAMESIZE = 56;
    public static final int STACK_ALIGNMENT = 4;
    public static final long MASK_VARIABLE_FRAMESIZE = -72057594037927936L;
    public static final long MASK_GOT_INDEX = 0xFFFFFFFFFFFFFFL;

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static long encodeVariableFrameSizeIntoDeoptSlot(long varSize) {
        if (!1.$assertionsDisabled && (varSize >> 4 & 0xFFFFFFFFFFFFFF00L) != 0L) {
            throw new AssertionError();
        }
        return varSize >> 4 << 56;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static long decodeVariableFrameSizeFromDeoptSlot(long deoptSlot) {
        long stackSize = deoptSlot >> 56 & 0xFFL;
        return stackSize << 4;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static long decodeGOTIndex(long deoptSlot) {
        return deoptSlot & 0xFFFFFFFFFFFFFFL;
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
    }
}

