/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.code;

import com.oracle.svm.core.code.CodeInfoImpl;
import com.oracle.svm.core.code.ImageCodeInfoStorage;
import com.oracle.svm.core.config.ConfigurationValues;
import com.oracle.svm.core.feature.AutomaticallyRegisteredFeature;
import com.oracle.svm.core.feature.InternalFeature;
import com.oracle.svm.core.layeredimagesingleton.FeatureSingleton;
import com.oracle.svm.core.layeredimagesingleton.UnsavedSingleton;
import jdk.graal.compiler.core.common.NumUtil;
import jdk.vm.ci.meta.JavaKind;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.c.struct.SizeOf;
import org.graalvm.nativeimage.hosted.Feature;

@AutomaticallyRegisteredFeature
class ImageCodeInfoStorageFeature
implements InternalFeature,
UnsavedSingleton,
FeatureSingleton {
    ImageCodeInfoStorageFeature() {
    }

    public void duringSetup(Feature.DuringSetupAccess access) {
        long size = SizeOf.unsigned(CodeInfoImpl.class).rawValue();
        int arrayBaseOffset = ConfigurationValues.getObjectLayout().getArrayBaseOffset(JavaKind.Byte);
        int actualOffset = ImageCodeInfoStorage.calculateOffset();
        int addend = actualOffset - arrayBaseOffset;
        ImageSingletons.add(ImageCodeInfoStorage.class, (Object)new ImageCodeInfoStorage(NumUtil.safeToInt((long)(size + (long)addend))));
    }
}

