/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core;

import com.oracle.svm.core.NeverInline;
import com.oracle.svm.core.SubstrateDiagnostics;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.config.ConfigurationValues;
import com.oracle.svm.core.heap.StoredContinuation;
import com.oracle.svm.core.heap.StoredContinuationAccess;
import com.oracle.svm.core.snippets.KnownIntrinsics;
import com.oracle.svm.core.stack.JavaFrameAnchor;
import com.oracle.svm.core.stack.JavaFrameAnchors;
import com.oracle.svm.core.thread.VMOperation;
import com.oracle.svm.core.thread.VMThreads;
import com.oracle.svm.core.util.VMError;
import jdk.graal.compiler.api.replacements.Fold;
import jdk.graal.compiler.core.common.type.Stamp;
import jdk.graal.compiler.core.common.type.StampFactory;
import jdk.vm.ci.meta.JavaKind;
import org.graalvm.nativeimage.CurrentIsolate;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.IsolateThread;
import org.graalvm.nativeimage.c.function.CodePointer;
import org.graalvm.word.Pointer;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordBase;

public abstract class FrameAccess {
    @Fold
    public static FrameAccess singleton() {
        return (FrameAccess)ImageSingletons.lookup(FrameAccess.class);
    }

    @Fold
    public static int returnAddressSize() {
        return FrameAccess.singleton().getReturnAddressSize();
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public CodePointer readReturnAddress(IsolateThread thread, Pointer sourceSp) {
        this.verifyReturnAddressWithinJavaStack(thread, sourceSp);
        return this.unsafeReadReturnAddress(sourceSp);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public void writeReturnAddress(IsolateThread thread, Pointer sourceSp, CodePointer newReturnAddress) {
        this.verifyReturnAddressWithinJavaStack(thread, sourceSp);
        this.unsafeReturnAddressLocation(sourceSp).writeWord(0, (WordBase)newReturnAddress);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public UnsignedWord getReturnAddressLocation(IsolateThread thread, Pointer sourceSp) {
        assert (thread.isNonNull());
        return this.unsafeReturnAddressLocation(sourceSp);
    }

    @Uninterruptible(reason="StoredContinuation must not move.", callerMustBe=true)
    public CodePointer readReturnAddress(StoredContinuation continuation, Pointer sourceSp) {
        this.verifyReturnAddressWithinStoredContinuation(continuation, sourceSp);
        return this.unsafeReadReturnAddress(sourceSp);
    }

    @Uninterruptible(reason="StoredContinuation must not move.", callerMustBe=true)
    public UnsignedWord getReturnAddressLocation(StoredContinuation continuation, Pointer sourceSp) {
        assert (continuation != null);
        return this.unsafeReturnAddressLocation(sourceSp);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public CodePointer unsafeReadReturnAddress(Pointer sourceSp) {
        return (CodePointer)this.unsafeReturnAddressLocation(sourceSp).readWord(0);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public Pointer unsafeReturnAddressLocation(Pointer sourceSp) {
        return sourceSp.subtract(FrameAccess.returnAddressSize());
    }

    @Fold
    protected int getReturnAddressSize() {
        int value = ConfigurationValues.getTarget().arch.getReturnAddressSize();
        assert (value > 0);
        return value;
    }

    @Fold
    public static int wordSize() {
        return ConfigurationValues.getTarget().arch.getWordSize();
    }

    @Fold
    public static int uncompressedReferenceSize() {
        return FrameAccess.wordSize();
    }

    public static Stamp getWordStamp() {
        return StampFactory.forKind((JavaKind)ConfigurationValues.getTarget().wordJavaKind);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private void verifyReturnAddressWithinJavaStack(IsolateThread thread, Pointer sourceSp) {
        if (SubstrateOptions.VerifyFrameAccess.getValue().booleanValue()) {
            this.verifyReturnAddressWithinJavaStack0(thread, sourceSp, true);
        } else assert (this.verifyReturnAddressWithinJavaStack0(thread, sourceSp, false));
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private boolean verifyReturnAddressWithinJavaStack0(IsolateThread thread, Pointer sourceSp, boolean verifyReturnAddress) {
        if (SubstrateDiagnostics.isFatalErrorHandlingThread()) {
            return true;
        }
        VMError.guarantee(CurrentIsolate.getCurrentThread() == thread || VMOperation.isInProgressAtSafepoint(), "Unsafe access to IsolateThread");
        UnsignedWord stackBase = VMThreads.StackBase.get(thread);
        UnsignedWord stackEnd = VMThreads.StackEnd.get(thread);
        Pointer returnAddressLocation = this.unsafeReturnAddressLocation(sourceSp);
        VMError.guarantee(stackBase.equal(0) || returnAddressLocation.belowThan(stackBase), "Access is outside of the stack memory that is reserved for this thread.");
        VMError.guarantee(returnAddressLocation.aboveOrEqual(stackEnd), "Access is outside of the stack memory that is reserved for this thread.");
        Pointer topOfStack = FrameAccess.getTopOfStack(thread);
        VMError.guarantee(returnAddressLocation.aboveOrEqual((UnsignedWord)topOfStack), "Access is outside of the part of the stack that is currently used by the thread.");
        if (verifyReturnAddress) {
            JavaFrameAnchor anchor = JavaFrameAnchors.getFrameAnchor(thread);
            while (anchor.isNonNull()) {
                VMError.guarantee(anchor.getLastJavaSP() != sourceSp, "Potentially accessing a return address that is stored in a native frame.");
                anchor = anchor.getPreviousAnchor();
            }
        }
        return true;
    }

    @NeverInline(value="Accesses the caller stack pointer")
    @Uninterruptible(reason="Called from uninterruptible code.")
    private static Pointer getTopOfStack(IsolateThread thread) {
        if (thread == CurrentIsolate.getCurrentThread()) {
            return KnownIntrinsics.readCallerStackPointer();
        }
        JavaFrameAnchor anchor = JavaFrameAnchors.getFrameAnchor(thread);
        VMError.guarantee(anchor.isNonNull(), "When accessing the stack of another thread, the other thread must have a frame anchor.");
        return anchor.getLastJavaSP();
    }

    @Uninterruptible(reason="StoredContinuation must not move.", callerMustBe=true)
    private void verifyReturnAddressWithinStoredContinuation(StoredContinuation continuation, Pointer sourceSP) {
        if (SubstrateOptions.VerifyFrameAccess.getValue().booleanValue()) {
            this.verifyReturnAddressWithinStoredContinuation0(continuation, sourceSP);
        } else assert (this.verifyReturnAddressWithinStoredContinuation0(continuation, sourceSP));
    }

    @Uninterruptible(reason="StoredContinuation must not move.", callerMustBe=true)
    private boolean verifyReturnAddressWithinStoredContinuation0(StoredContinuation continuation, Pointer sourceSP) {
        if (SubstrateDiagnostics.isFatalErrorHandlingThread()) {
            return true;
        }
        Pointer stackEnd = StoredContinuationAccess.getFramesStart(continuation);
        Pointer stackBase = StoredContinuationAccess.getFramesEnd(continuation);
        Pointer returnAddressLocation = this.unsafeReturnAddressLocation(sourceSP);
        VMError.guarantee(returnAddressLocation.belowThan((UnsignedWord)stackBase), "Access is outside of the stack of the stored continuation");
        VMError.guarantee(returnAddressLocation.aboveOrEqual((UnsignedWord)stackEnd), "Access is outside of the stack of the stored continuation");
        return true;
    }
}

