/*
 * Copyright (c) 2012, 2025, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2022 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in https://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that either
 * (a) this copyright and permission notice appear with all copies
 * of the Data Files or Software, or
 * (b) this copyright and permission notice appear in associated
 * Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.TimeZoneNamesBundle;

public class TimeZoneNames_af extends TimeZoneNamesBundle {
    @Override
    protected final Object[][] getContents() {
        final String[] GMT = new String[] {
               "Greenwich-tyd",
               "GMT",
               "",
               "GMT",
               "",
               "GMT",
            };
        final String[] Apia = new String[] {
               "Apia-standaardtyd",
               "",
               "Apia-dagligtyd",
               "",
               "Apia-tyd",
               "",
            };
        final String[] Cook = new String[] {
               "Cookeilande-standaardtyd",
               "",
               "Cookeilande-halfsomertyd",
               "",
               "Cookeilande-tyd",
               "",
            };
        final String[] Cuba = new String[] {
               "Kuba-standaardtyd",
               "CST",
               "Kuba-dagligtyd",
               "CDT",
               "Kuba-tyd",
               "CT",
            };
        final String[] Fiji = new String[] {
               "Fidji-standaardtyd",
               "",
               "Fidji-somertyd",
               "",
               "Fidji-tyd",
               "",
            };
        final String[] Gulf = new String[] {
               "Persiese Golf-standaardtyd",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hovd = new String[] {
               "Hovd-standaardtyd",
               "",
               "Hovd-somertyd",
               "",
               "Hovd-tyd",
               "",
            };
        final String[] Iran = new String[] {
               "Iran-standaardtyd",
               "",
               "Iran-dagligtyd",
               "",
               "Iran-tyd",
               "",
            };
        final String[] Niue = new String[] {
               "Niue-tyd",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Omsk = new String[] {
               "Omsk-standaardtyd",
               "",
               "Omsk-somertyd",
               "",
               "Omsk-tyd",
               "",
            };
        final String[] Peru = new String[] {
               "Peru-standaardtyd",
               "",
               "Peru-somertyd",
               "",
               "Peru-tyd",
               "",
            };
        final String[] Truk = new String[] {
               "Chuuk-tyd",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wake = new String[] {
               "Wake-eiland-tyd",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Chile = new String[] {
               "Chili-standaardtyd",
               "",
               "Chili-somertyd",
               "",
               "Chili-tyd",
               "",
            };
        final String[] China = new String[] {
               "China-standaardtyd",
               "CST",
               "China-dagligtyd",
               "CDT",
               "China-tyd",
               "CT",
            };
        final String[] Cocos = new String[] {
               "Kokoseilande-tyd",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Davis = new String[] {
               "Davis-tyd",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] India = new String[] {
               "Indi\u00eb-standaardtyd",
               "IST",
               "",
               "IST",
               "",
               "IST",
            };
        final String[] Japan = new String[] {
               "Japan-standaardtyd",
               "JST",
               "Japan-dagligtyd",
               "JDT",
               "Japan-tyd",
               "JT",
            };
        final String[] Korea = new String[] {
               "Koreaanse standaardtyd",
               "KST",
               "Koreaanse dagligtyd",
               "KST",
               "Koreaanse tyd",
               "KST",
            };
        final String[] Nauru = new String[] {
               "Nauru-tyd",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Nepal = new String[] {
               "Nepal-tyd",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Palau = new String[] {
               "Palau-tyd",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Samoa = new String[] {
               "Samoa-standaardtyd",
               "SST",
               "Samoa-dagligtyd",
               "SST",
               "Samoa-tyd",
               "SST",
            };
        final String[] Syowa = new String[] {
               "Syowa-tyd",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tonga = new String[] {
               "Tonga-standaardtyd",
               "",
               "Tonga-somertyd",
               "",
               "Tonga-tyd",
               "",
            };
        final String[] Yukon = new String[] {
               "Yukontyd",
               "MST",
               "",
               "MST",
               "",
               "MST",
            };
        final String[] Alaska = new String[] {
               "Alaska-standaardtyd",
               "AKST",
               "Alaska-dagligtyd",
               "AKDT",
               "Alaska-tyd",
               "AKT",
            };
        final String[] Amazon = new String[] {
               "Amasone-standaardtyd",
               "",
               "Amasone-somertyd",
               "",
               "Amasone-tyd",
               "",
            };
        final String[] Anadyr = new String[] {
               "Anadyr-standaardtyd",
               "",
               "Anadyr-somertyd",
               "",
               "Anadyr-tyd",
               "",
            };
        final String[] Azores = new String[] {
               "Asore-standaardtyd",
               "",
               "Asore-somertyd",
               "",
               "Asore-tyd",
               "",
            };
        final String[] Bhutan = new String[] {
               "Bhoetan-tyd",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Brunei = new String[] {
               "Broenei Darussalam-tyd",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Easter = new String[] {
               "Paaseiland-standaardtyd",
               "",
               "Paaseiland-somertyd",
               "",
               "Paaseiland-tyd",
               "",
            };
        final String[] Guyana = new String[] {
               "Guiana-tyd",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Israel = new String[] {
               "Israel-standaardtyd",
               "IST",
               "Israel-dagligtyd",
               "IDT",
               "Israel-tyd",
               "IT",
            };
        final String[] Kosrae = new String[] {
               "Kosrae-tyd",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mawson = new String[] {
               "Mawson-tyd",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Moscow = new String[] {
               "Moskou-standaardtyd",
               "MSK",
               "Moskou-somertyd",
               "MSK",
               "Moskou-tyd",
               "MSK",
            };
        final String[] Ponape = new String[] {
               "Ponape-tyd",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Samara = new String[] {
               "Samara-standaardtyd",
               "",
               "Samara-dagligtyd",
               "",
               "Samara-tyd",
               "",
            };
        final String[] Tahiti = new String[] {
               "Tahiti-tyd",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Taipei = new String[] {
               "Taipei-standaardtyd",
               "CST",
               "Taipei-dagligtyd",
               "CDT",
               "Taipei-tyd",
               "CT",
            };
        final String[] Tuvalu = new String[] {
               "Tuvalu-tyd",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Vostok = new String[] {
               "Wostok-tyd",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wallis = new String[] {
               "Wallis en Futuna-tyd",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Arabian = new String[] {
               "Arabiese standaardtyd",
               "",
               "Arabiese dagligtyd",
               "",
               "Arabiese tyd",
               "",
            };
        final String[] Armenia = new String[] {
               "Armeni\u00eb-standaardtyd",
               "",
               "Armeni\u00eb-somertyd",
               "",
               "Armeni\u00eb-tyd",
               "",
            };
        final String[] Bolivia = new String[] {
               "Bolivi\u00eb-tyd",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Chatham = new String[] {
               "Chatham-standaardtyd",
               "",
               "Chatham-dagligtyd",
               "",
               "Chatham-tyd",
               "",
            };
        final String[] ETC_UTC = new String[] {
               "Geko\u00f6rdineerde universele tyd",
               "UTC",
               "",
               "",
               "",
               "",
            };
        final String[] Ecuador = new String[] {
               "Ecuador-tyd",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Gambier = new String[] {
               "Gambier-tyd",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Georgia = new String[] {
               "Georgi\u00eb-standaardtyd",
               "",
               "Georgi\u00eb-somertyd",
               "",
               "Georgi\u00eb-tyd",
               "",
            };
        final String[] Irkutsk = new String[] {
               "Irkoetsk-standaardtyd",
               "",
               "Irkoetsk-somertyd",
               "",
               "Irkoetsk-tyd",
               "",
            };
        final String[] Magadan = new String[] {
               "Magadan-standaardtyd",
               "",
               "Magadan-somertyd",
               "",
               "Magadan-tyd",
               "",
            };
        final String[] Myanmar = new String[] {
               "Mianmar-tyd",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Norfolk = new String[] {
               "Norfolkeiland-standaardtyd",
               "",
               "Norfolkeiland-dagligtyd",
               "",
               "Norfolkeiland-tyd",
               "",
            };
        final String[] Noronha = new String[] {
               "Fernando de Noronha-standaardtyd",
               "",
               "Fernando de Noronha-somertyd",
               "",
               "Fernando de Noronha-tyd",
               "",
            };
        final String[] Reunion = new String[] {
               "R\u00e9union-tyd",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Rothera = new String[] {
               "Rothera-tyd",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Solomon = new String[] {
               "Salomonseilande-tyd",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tokelau = new String[] {
               "Tokelau-tyd",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uruguay = new String[] {
               "Uruguay-standaardtyd",
               "",
               "Uruguay-somertyd",
               "",
               "Uruguay-tyd",
               "",
            };
        final String[] Vanuatu = new String[] {
               "Vanuatu-standaardtyd",
               "",
               "Vanuatu-somertyd",
               "",
               "Vanuatu-tyd",
               "",
            };
        final String[] Yakutsk = new String[] {
               "Jakoetsk-standaardtyd",
               "",
               "Jakoetsk-somertyd",
               "",
               "Jakoetsk-tyd",
               "",
            };
        final String[] Atlantic = new String[] {
               "Atlantiese standaardtyd",
               "AST",
               "Atlantiese dagligtyd",
               "AST",
               "Atlantiese tyd",
               "AST",
            };
        final String[] Brasilia = new String[] {
               "Brasilia-standaardtyd",
               "",
               "Brasilia-somertyd",
               "",
               "Brasilia-tyd",
               "",
            };
        final String[] Chamorro = new String[] {
               "Chamorro-standaardtyd",
               "ChST",
               "",
               "ChST",
               "",
               "ChST",
            };
        final String[] Colombia = new String[] {
               "Colombi\u00eb-standaardtyd",
               "",
               "Colombi\u00eb-somertyd",
               "",
               "Colombi\u00eb-tyd",
               "",
            };
        final String[] Falkland = new String[] {
               "Falklandeilande-standaardtyd",
               "",
               "Falklandeilande-somertyd",
               "",
               "Falklandeilande-tyd",
               "",
            };
        final String[] Malaysia = new String[] {
               "Maleisi\u00eb-tyd",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Maldives = new String[] {
               "Maledive-tyd",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mongolia = new String[] {
               "Ulaanbaatar-standaardtyd",
               "",
               "Ulaanbaatar-somertyd",
               "",
               "Ulaanbaatar-tyd",
               "",
            };
        final String[] Pakistan = new String[] {
               "Pakistan-standaardtyd",
               "PKT",
               "Pakistan-somertyd",
               "PKST",
               "Pakistan-tyd",
               "PKT",
            };
        final String[] Paraguay = new String[] {
               "Paraguay-standaardtyd",
               "",
               "Paraguay-somertyd",
               "",
               "Paraguay-tyd",
               "",
            };
        final String[] Pitcairn = new String[] {
               "Pitcairn-tyd",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Sakhalin = new String[] {
               "Sakhalin-standaardtyd",
               "",
               "Sakhalin-somertyd",
               "",
               "Sakhalin-tyd",
               "",
            };
        final String[] Suriname = new String[] {
               "Suriname-tyd",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Argentina = new String[] {
               "Argentini\u00eb-standaardtyd",
               "",
               "Argentini\u00eb-somertyd",
               "",
               "Argentini\u00eb-tyd",
               "",
            };
        final String[] Christmas = new String[] {
               "Christmaseiland-tyd",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Galapagos = new String[] {
               "Galapagos-tyd",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hong_Kong = new String[] {
               "Hongkong-standaardtyd",
               "HKT",
               "Hongkong-somertyd",
               "HKST",
               "Hongkong-tyd",
               "HKT",
            };
        final String[] Indochina = new String[] {
               "Indosjina-tyd",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kamchatka = new String[] {
               "Petropavlovsk-Kamchatski-standaardtyd",
               "",
               "Petropavlovsk-Kamchatski-somertyd",
               "",
               "Petropavlovsk-Kamchatski-tyd",
               "",
            };
        final String[] Kyrgystan = new String[] {
               "Kirgistan-tyd",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Lord_Howe = new String[] {
               "Lord Howe-standaardtyd",
               "",
               "Lord Howe-dagligtyd",
               "",
               "Lord Howe-tyd",
               "",
            };
        final String[] Marquesas = new String[] {
               "Marquesas-tyd",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mauritius = new String[] {
               "Mauritius-standaardtyd",
               "",
               "Mauritius-somertyd",
               "",
               "Mauritius-tyd",
               "",
            };
        final String[] Singapore = new String[] {
               "Singapoer-standaardtyd",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Venezuela = new String[] {
               "Venezuela-tyd",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Volgograd = new String[] {
               "Wolgograd-standaardtyd",
               "MSK",
               "Wolgograd-somertyd",
               "MSK",
               "Wolgograd-tyd",
               "MSK",
            };
        final String[] Azerbaijan = new String[] {
               "Aserbeidjan-standaardtyd",
               "",
               "Aserbeidjan-somertyd",
               "",
               "Aserbeidjan-tyd",
               "",
            };
        final String[] Bangladesh = new String[] {
               "Bangladesj-standaardtyd",
               "",
               "Bangladesj-somertyd",
               "",
               "Bangladesj-tyd",
               "",
            };
        final String[] Cape_Verde = new String[] {
               "Kaap Verde-standaardtyd",
               "",
               "Kaap Verde-somertyd",
               "",
               "Kaap Verde-tyd",
               "",
            };
        final String[] East_Timor = new String[] {
               "Oos-Timor-tyd",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kazakhstan = new String[] {
               "Kazakstan-tyd",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Seychelles = new String[] {
               "Seychelle-tyd",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tajikistan = new String[] {
               "Tadjikistan-tyd",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uzbekistan = new String[] {
               "Oesbekistan-standaardtyd",
               "",
               "Oesbekistan-somertyd",
               "",
               "Oesbekistan-tyd",
               "",
            };
        final String[] Afghanistan = new String[] {
               "Afganistan-tyd",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Krasnoyarsk = new String[] {
               "Krasnojarsk-standaardtyd",
               "",
               "Krasnojarsk-somertyd",
               "",
               "Krasnojarsk-tyd",
               "",
            };
        final String[] New_Zealand = new String[] {
               "Nieu-Seeland-standaardtyd",
               "NZST",
               "Nieu-Seeland-dagligtyd",
               "NZDT",
               "Nieu-Seeland-tyd",
               "NZT",
            };
        final String[] Novosibirsk = new String[] {
               "Novosibirsk-standaardtyd",
               "",
               "Novosibirsk-somertyd",
               "",
               "Novosibirsk-tyd",
               "",
            };
        final String[] Philippines = new String[] {
               "Filippynse standaardtyd",
               "PST",
               "Filippynse somertyd",
               "PDT",
               "Filippynse tyd",
               "PT",
            };
        final String[] Vladivostok = new String[] {
               "Wladiwostok-standaardtyd",
               "",
               "Wladiwostok-somertyd",
               "",
               "Wladiwostok-tyd",
               "",
            };
        final String[] Indian_Ocean = new String[] {
               "Indiese Oseaan-tyd",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Line_Islands = new String[] {
               "Line-eilande-tyd",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Newfoundland = new String[] {
               "Newfoundland-standaardtyd",
               "NST",
               "Newfoundland-dagligtyd",
               "NDT",
               "Newfoundland-tyd",
               "NT",
            };
        final String[] Turkmenistan = new String[] {
               "Turkmenistan-standaardtyd",
               "",
               "Turkmenistan-somertyd",
               "",
               "Turkmenistan-tyd",
               "",
            };
        final String[] French_Guiana = new String[] {
               "Frans-Guiana-tyd",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] New_Caledonia = new String[] {
               "Nieu-Kaledoni\u00eb-standaardtyd",
               "",
               "Nieu-Kaledoni\u00eb-somertyd",
               "",
               "Nieu-Kaledoni\u00eb-tyd",
               "",
            };
        final String[] South_Georgia = new String[] {
               "Suid-Georgi\u00eb-tyd",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Yekaterinburg = new String[] {
               "Jekaterinburg-standaardtyd",
               "",
               "Jekaterinburg-somertyd",
               "",
               "Jekaterinburg-tyd",
               "",
            };
        final String[] Africa_Central = new String[] {
               "Sentraal-Afrika-tyd",
               "CAT",
               "",
               "CAT",
               "",
               "CAT",
            };
        final String[] Africa_Eastern = new String[] {
               "Oos-Afrika-tyd",
               "EAT",
               "",
               "EAT",
               "",
               "EAT",
            };
        final String[] Africa_Western = new String[] {
               "Wes-Afrika-standaardtyd",
               "WAT",
               "Wes-Afrika-somertyd",
               "WAST",
               "Wes-Afrika-tyd",
               "WAT",
            };
        final String[] DumontDUrville = new String[] {
               "Dumont-d\u2019Urville-tyd",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Europe_Central = new String[] {
               "Sentraal-Europese standaardtyd",
               "CET",
               "Sentraal-Europese somertyd",
               "CEST",
               "Sentraal-Europese tyd",
               "CET",
            };
        final String[] Europe_Eastern = new String[] {
               "Oos-Europese standaardtyd",
               "EET",
               "Oos-Europese somertyd",
               "EEST",
               "Oos-Europese tyd",
               "EET",
            };
        final String[] Europe_Western = new String[] {
               "Wes-Europese standaardtyd",
               "WET",
               "Wes-Europese somertyd",
               "WEST",
               "Wes-Europese tyd",
               "WET",
            };
        final String[] Mexico_Pacific = new String[] {
               "Meksikaanse Pasifiese standaardtyd",
               "MST",
               "Meksikaanse Pasifiese dagligtyd",
               "MDT",
               "Meksikaanse Pasifiese tyd",
               "MT",
            };
        final String[] Africa_Southern = new String[] {
               "Suid-Afrika-standaardtyd",
               "SAST",
               "",
               "SAST",
               "",
               "SAST",
            };
        final String[] America_Central = new String[] {
               "Noord-Amerikaanse sentrale standaardtyd",
               "CST",
               "Noord-Amerikaanse sentrale dagligtyd",
               "CDT",
               "Noord-Amerikaanse sentrale tyd",
               "CT",
            };
        final String[] America_Eastern = new String[] {
               "Noord-Amerikaanse oostelike standaardtyd",
               "EST",
               "Noord-Amerikaanse oostelike dagligtyd",
               "EST",
               "Noord-Amerikaanse oostelike tyd",
               "EST",
            };
        final String[] America_Pacific = new String[] {
               "Pasifiese standaardtyd",
               "PST",
               "Pasifiese dagligtyd",
               "PDT",
               "Pasifiese tyd",
               "PT",
            };
        final String[] French_Southern = new String[] {
               "Franse Suider- en Antarktiese tyd",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Gilbert_Islands = new String[] {
               "Gilberteilande-tyd",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hawaii_Aleutian = new String[] {
               "Hawaii-Aleoete-standaardtyd",
               "HST",
               "Hawaii-Aleoete-dagligtyd",
               "HST",
               "Hawaii-Aleoete-tyd",
               "HST",
            };
        final String[] Phoenix_Islands = new String[] {
               "Fenikseilande-tyd",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Pierre_Miquelon = new String[] {
               "Sint-Pierre en Miquelon-standaardtyd",
               "",
               "Sint-Pierre en Miquelon-dagligtyd",
               "",
               "Sint-Pierre en Miquelon-tyd",
               "",
            };
        final String[] America_Mountain = new String[] {
               "Noord-Amerikaanse berg-standaardtyd",
               "MST",
               "Noord-Amerikaanse berg-dagligtyd",
               "MST",
               "Noord-Amerikaanse bergtyd",
               "MST",
            };
        final String[] Marshall_Islands = new String[] {
               "Marshalleilande-tyd",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Papua_New_Guinea = new String[] {
               "Papoea-Nieu-Guinee-tyd",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Australia_Central = new String[] {
               "Sentraal-Australiese standaardtyd",
               "ACST",
               "Sentraal-Australiese dagligtyd",
               "ACDT",
               "Sentraal-Australiese tyd",
               "ACT",
            };
        final String[] Australia_Eastern = new String[] {
               "Oostelike Australiese standaardtyd",
               "AEST",
               "Oostelike Australiese dagligtyd",
               "AEDT",
               "Oostelike Australiese tyd",
               "AET",
            };
        final String[] Australia_Western = new String[] {
               "Westelike Australiese standaardtyd",
               "AWST",
               "Westelike Australiese dagligtyd",
               "AWDT",
               "Westelike Australiese tyd",
               "AWT",
            };
        final String[] Indonesia_Central = new String[] {
               "Sentraal-Indonesiese tyd",
               "WITA",
               "",
               "WITA",
               "",
               "WITA",
            };
        final String[] Indonesia_Eastern = new String[] {
               "Oos-Indonesi\u00eb-tyd",
               "WIT",
               "",
               "WIT",
               "",
               "WIT",
            };
        final String[] Indonesia_Western = new String[] {
               "Wes-Indonesi\u00eb-tyd",
               "WIB",
               "",
               "WIB",
               "",
               "WIB",
            };
        final String[] Australia_CentralWestern = new String[] {
               "Sentraal-westelike Australiese standaard-tyd",
               "",
               "Sentraal-westelike Australiese dagligtyd",
               "",
               "Sentraal-westelike Australiese tyd",
               "",
            };
        final Object[][] data = new Object[][] {
            { "America/Los_Angeles", America_Pacific },
            { "America/Denver", America_Mountain },
            { "America/Phoenix", America_Mountain },
            { "America/Chicago", America_Central },
            { "America/New_York", America_Eastern },
            { "America/Indianapolis", America_Eastern },
            { "Pacific/Honolulu", Hawaii_Aleutian },
            { "America/Anchorage", Alaska },
            { "America/Halifax", Atlantic },
            { "America/Sitka", Alaska },
            { "America/St_Johns", Newfoundland },
            { "Europe/Paris", Europe_Central },
            { "GMT", GMT },
            { "Asia/Jerusalem", Israel },
            { "Asia/Tokyo", Japan },
            { "Europe/Bucharest", Europe_Eastern },
            { "Asia/Shanghai", China },
            { "UTC", ETC_UTC },
            { "GB",
                new String[] {
                    "Greenwich-tyd",
                    "GMT",
                    "Britse somertyd",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "NZ", New_Zealand },
            { "ACT", Australia_Central },
            { "AET", Australia_Eastern },
            { "AGT", Argentina },
            { "ART", Europe_Eastern },
            { "AST", Alaska },
            { "BET", Brasilia },
            { "BST", Bangladesh },
            { "CAT", Africa_Central },
            { "CET", Europe_Central },
            { "CNT", Newfoundland },
            { "CST", America_Central },
            { "CTT", China },
            { "EAT", Africa_Eastern },
            { "ECT", Europe_Central },
            { "EET", Europe_Eastern },
            { "EST", America_Eastern },
            { "HST", Hawaii_Aleutian },
            { "IET", America_Eastern },
            { "IST", India },
            { "JST", Japan },
            { "MET", Europe_Central },
            { "MIT", Apia },
            { "MST", America_Mountain },
            { "NET", Armenia },
            { "NST", New_Zealand },
            { "PLT", Pakistan },
            { "PNT", America_Mountain },
            { "PRC", China },
            { "PRT", Atlantic },
            { "PST", America_Pacific },
            { "ROK", Korea },
            { "SST", Solomon },
            { "UCT",
                new String[] {
                    "Geko\u00f6rdineerde universele tyd",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "VST", Indochina },
            { "WET", Europe_Western },
            { "Cuba", Cuba },
            { "Eire",
                new String[] {
                    "Greenwich-tyd",
                    "GMT",
                    "Ierse standaardtyd",
                    "IST",
                    "",
                    "GMT",
                }
            },
            { "GMT0", GMT },
            { "Iran", Iran },
            { "W-SU", Moscow },
            { "Zulu",
                new String[] {
                    "Geko\u00f6rdineerde universele tyd",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Egypt", Europe_Eastern },
            { "Japan", Japan },
            { "Libya", Europe_Eastern },
            { "Israel", Israel },
            { "Navajo", America_Mountain },
            { "Poland", Europe_Central },
            { "CST6CDT", America_Central },
            { "EST5EDT", America_Eastern },
            { "Etc/GMT", GMT },
            { "Etc/UCT",
                new String[] {
                    "Geko\u00f6rdineerde universele tyd",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Etc/UTC", ETC_UTC },
            { "GB-Eire",
                new String[] {
                    "Greenwich-tyd",
                    "GMT",
                    "Britse somertyd",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Iceland", GMT },
            { "Jamaica", America_Eastern },
            { "MST7MDT", America_Mountain },
            { "NZ-CHAT", Chatham },
            { "PST8PDT", America_Pacific },
            { "Etc/GMT0", GMT },
            { "Etc/Zulu",
                new String[] {
                    "Geko\u00f6rdineerde universele tyd",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Hongkong", Hong_Kong },
            { "Portugal", Europe_Western },
            { "US/Samoa", Samoa },
            { "Asia/Aden", Arabian },
            { "Asia/Baku", Azerbaijan },
            { "Asia/Dili", East_Timor },
            { "Asia/Gaza", Europe_Eastern },
            { "Asia/Hovd", Hovd },
            { "Asia/Omsk", Omsk },
            { "Asia/Oral", Kazakhstan },
            { "Etc/GMT+0", GMT },
            { "Etc/GMT-0", GMT },
            { "Greenwich", GMT },
            { "Kwajalein", Marshall_Islands },
            { "Singapore", Singapore },
            { "US/Alaska", Alaska },
            { "US/Hawaii", Hawaii_Aleutian },
            { "Universal",
                new String[] {
                    "Geko\u00f6rdineerde universele tyd",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Asia/Aqtau", Kazakhstan },
            { "Asia/Chita", Yakutsk },
            { "Asia/Dacca", Bangladesh },
            { "Asia/Dhaka", Bangladesh },
            { "Asia/Dubai", Gulf },
            { "Asia/Kabul", Afghanistan },
            { "Asia/Macao", China },
            { "Asia/Macau", China },
            { "Asia/Qatar", Arabian },
            { "Asia/Seoul", Korea },
            { "US/Arizona", America_Mountain },
            { "US/Central", America_Central },
            { "US/Eastern", America_Eastern },
            { "US/Pacific", America_Pacific },
            { "Africa/Juba", Africa_Central },
            { "Africa/Lome", GMT },
            { "Asia/Almaty", Kazakhstan },
            { "Asia/Anadyr", Anadyr },
            { "Asia/Aqtobe", Kazakhstan },
            { "Asia/Atyrau", Kazakhstan },
            { "Asia/Beirut", Europe_Eastern },
            { "Asia/Brunei", Brunei },
            { "Asia/Harbin", China },
            { "Asia/Hebron", Europe_Eastern },
            { "Asia/Kuwait", Arabian },
            { "Asia/Manila", Philippines },
            { "Asia/Muscat", Gulf },
            { "Asia/Riyadh", Arabian },
            { "Asia/Saigon", Indochina },
            { "Asia/Taipei", Taipei },
            { "Asia/Tehran", Iran },
            { "Asia/Thimbu", Bhutan },
            { "Asia/Yangon", Cocos },
            { "Brazil/East", Brasilia },
            { "Brazil/West", Amazon },
            { "Europe/Kiev", Europe_Eastern },
            { "Europe/Kyiv", Europe_Eastern },
            { "Europe/Oslo", Europe_Central },
            { "Europe/Riga", Europe_Eastern },
            { "Europe/Rome", Europe_Central },
            { "Indian/Mahe", Seychelles },
            { "Pacific/Yap", Papua_New_Guinea },
            { "US/Aleutian", Hawaii_Aleutian },
            { "US/Michigan", America_Eastern },
            { "US/Mountain", America_Mountain },
            { "Africa/Accra", GMT },
            { "Africa/Cairo", Europe_Eastern },
            { "Africa/Ceuta", Europe_Central },
            { "Africa/Dakar", GMT },
            { "Africa/Lagos", Africa_Western },
            { "Africa/Tunis", Europe_Central },
            { "America/Adak", Hawaii_Aleutian },
            { "America/Atka", Hawaii_Aleutian },
            { "America/Lima", Peru },
            { "America/Nome", Alaska },
            { "Asia/Baghdad", Arabian },
            { "Asia/Bahrain", Arabian },
            { "Asia/Bangkok", Indochina },
            { "Asia/Bishkek", Kyrgystan },
            { "Asia/Colombo", India },
            { "Asia/Irkutsk", Irkutsk },
            { "Asia/Jakarta", Indonesia_Western },
            { "Asia/Karachi", Pakistan },
            { "Asia/Kolkata", India },
            { "Asia/Kuching", Brunei },
            { "Asia/Magadan", Magadan },
            { "Asia/Nicosia", Europe_Eastern },
            { "Asia/Rangoon", Myanmar },
            { "Asia/Tbilisi", Georgia },
            { "Asia/Thimphu", Bhutan },
            { "Asia/Yakutsk", Yakutsk },
            { "Asia/Yerevan", Armenia },
            { "Canada/Yukon", Yukon },
            { "Europe/Malta", Europe_Central },
            { "Europe/Minsk", Moscow },
            { "Europe/Sofia", Europe_Eastern },
            { "Europe/Vaduz", Europe_Central },
            { "Indian/Cocos", Cocos },
            { "Pacific/Apia", Apia },
            { "Pacific/Fiji", Fiji },
            { "Pacific/Guam", Chamorro },
            { "Pacific/Niue", Niue },
            { "Pacific/Truk", Truk },
            { "Pacific/Wake", Wake },
            { "SystemV/AST4", Atlantic },
            { "SystemV/CST6", America_Central },
            { "SystemV/EST5", America_Eastern },
            { "SystemV/MST7", America_Mountain },
            { "SystemV/PST8", Pitcairn },
            { "SystemV/YST9", Gambier },
            { "Africa/Asmara", Africa_Eastern },
            { "Africa/Asmera", Africa_Eastern },
            { "Africa/Bamako", GMT },
            { "Africa/Bangui", Africa_Western },
            { "Africa/Banjul", GMT },
            { "Africa/Bissau", GMT },
            { "Africa/Douala", Africa_Western },
            { "Africa/Harare", Africa_Central },
            { "Africa/Kigali", Africa_Central },
            { "Africa/Luanda", Africa_Western },
            { "Africa/Lusaka", Africa_Central },
            { "Africa/Malabo", Africa_Western },
            { "Africa/Maputo", Africa_Central },
            { "Africa/Maseru", Africa_Southern },
            { "Africa/Niamey", Africa_Western },
            { "America/Aruba", Atlantic },
            { "America/Bahia", Brasilia },
            { "America/Belem", Brasilia },
            { "America/Boise", America_Mountain },
            { "America/Jujuy", Argentina },
            { "America/Thule", Atlantic },
            { "Asia/Ashgabat", Turkmenistan },
            { "Asia/Calcutta", India },
            { "Asia/Dushanbe", Tajikistan },
            { "Asia/Jayapura", Indonesia_Eastern },
            { "Asia/Katmandu", Nepal },
            { "Asia/Khandyga", Yakutsk },
            { "Asia/Makassar", Indonesia_Central },
            { "Asia/Qostanay", Kazakhstan },
            { "Asia/Sakhalin", Sakhalin },
            { "Asia/Tashkent", Uzbekistan },
            { "Asia/Tel_Aviv", Israel },
            { "Asia/Ust-Nera", Vladivostok },
            { "Australia/ACT", Australia_Eastern },
            { "Australia/LHI", Lord_Howe },
            { "Australia/NSW", Australia_Eastern },
            { "Etc/Greenwich", GMT },
            { "Etc/Universal",
                new String[] {
                    "Geko\u00f6rdineerde universele tyd",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Europe/Athens", Europe_Eastern },
            { "Europe/Berlin", Europe_Central },
            { "Europe/Dublin",
                new String[] {
                    "Greenwich-tyd",
                    "GMT",
                    "Ierse standaardtyd",
                    "IST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Jersey",
                new String[] {
                    "Greenwich-tyd",
                    "GMT",
                    "Britse somertyd",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Lisbon", Europe_Western },
            { "Europe/London",
                new String[] {
                    "Greenwich-tyd",
                    "GMT",
                    "Britse somertyd",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Madrid", Europe_Central },
            { "Europe/Monaco", Europe_Central },
            { "Europe/Moscow", Moscow },
            { "Europe/Prague", Europe_Central },
            { "Europe/Samara", Samara },
            { "Europe/Skopje", Europe_Central },
            { "Europe/Tirane", Europe_Central },
            { "Europe/Vienna", Europe_Central },
            { "Europe/Warsaw", Europe_Central },
            { "Europe/Zagreb", Europe_Central },
            { "Europe/Zurich", Europe_Central },
            { "Indian/Chagos", Indian_Ocean },
            { "Indian/Comoro", Africa_Eastern },
            { "Pacific/Chuuk", Papua_New_Guinea },
            { "Pacific/Efate", Vanuatu },
            { "Pacific/Nauru", Nauru },
            { "Pacific/Palau", Palau },
            { "Pacific/Samoa", Samoa },
            { "SystemV/HST10", Hawaii_Aleutian },
            { "Africa/Abidjan", GMT },
            { "Africa/Algiers", Europe_Central },
            { "Africa/Conakry", GMT },
            { "Africa/Kampala", Africa_Eastern },
            { "Africa/Mbabane", Africa_Southern },
            { "Africa/Nairobi", Africa_Eastern },
            { "Africa/Tripoli", Europe_Eastern },
            { "America/Belize", America_Central },
            { "America/Bogota", Colombia },
            { "America/Cancun", America_Eastern },
            { "America/Cayman", America_Eastern },
            { "America/Cuiaba", Amazon },
            { "America/Dawson", Yukon },
            { "America/Guyana", Guyana },
            { "America/Havana", Cuba },
            { "America/Inuvik", America_Mountain },
            { "America/Juneau", Alaska },
            { "America/La_Paz", Bolivia },
            { "America/Maceio", Brasilia },
            { "America/Manaus", Amazon },
            { "America/Merida", America_Central },
            { "America/Nassau", America_Eastern },
            { "America/Panama", America_Eastern },
            { "America/Recife", Brasilia },
            { "America/Regina", America_Central },
            { "America/Virgin", Atlantic },
            { "Asia/Ashkhabad", Turkmenistan },
            { "Asia/Chongqing", China },
            { "Asia/Chungking", China },
            { "Asia/Hong_Kong", Hong_Kong },
            { "Asia/Kamchatka", Kamchatka },
            { "Asia/Kathmandu", Nepal },
            { "Asia/Pontianak", Indonesia_Western },
            { "Asia/Pyongyang", Korea },
            { "Asia/Qyzylorda", Kazakhstan },
            { "Asia/Samarkand", Uzbekistan },
            { "Asia/Singapore", Singapore },
            { "Asia/Vientiane", Indochina },
            { "Atlantic/Faroe", Europe_Western },
            { "Australia/West", Australia_Western },
            { "Canada/Central", America_Central },
            { "Canada/Eastern", America_Eastern },
            { "Canada/Pacific", America_Pacific },
            { "Europe/Andorra", Europe_Central },
            { "Europe/Belfast",
                new String[] {
                    "Greenwich-tyd",
                    "GMT",
                    "Britse somertyd",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Nicosia", Europe_Eastern },
            { "Europe/Tallinn", Europe_Eastern },
            { "Europe/Vatican", Europe_Central },
            { "Europe/Vilnius", Europe_Eastern },
            { "Indian/Mayotte", Africa_Eastern },
            { "Indian/Reunion", Reunion },
            { "Mexico/BajaSur", Mexico_Pacific },
            { "Mexico/General", America_Central },
            { "Pacific/Easter", Easter },
            { "Pacific/Kanton", Phoenix_Islands },
            { "Pacific/Kosrae", Kosrae },
            { "Pacific/Majuro", Marshall_Islands },
            { "Pacific/Midway", Samoa },
            { "Pacific/Noumea", New_Caledonia },
            { "Pacific/Ponape", Solomon },
            { "Pacific/Saipan", Chamorro },
            { "Pacific/Tahiti", Tahiti },
            { "Pacific/Tarawa", Marshall_Islands },
            { "Pacific/Wallis", Gilbert_Islands },
            { "Africa/Blantyre", Africa_Central },
            { "Africa/Djibouti", Africa_Eastern },
            { "Africa/Freetown", GMT },
            { "Africa/Gaborone", Africa_Central },
            { "Africa/Khartoum", Africa_Central },
            { "Africa/Kinshasa", Africa_Western },
            { "Africa/Monrovia", GMT },
            { "Africa/Ndjamena", Africa_Western },
            { "Africa/Sao_Tome", GMT },
            { "Africa/Timbuktu", GMT },
            { "Africa/Windhoek", Africa_Central },
            { "America/Antigua", Atlantic },
            { "America/Caracas", Venezuela },
            { "America/Cayenne", French_Guiana },
            { "America/Cordoba", Argentina },
            { "America/Creston", America_Mountain },
            { "America/Curacao", Atlantic },
            { "America/Detroit", America_Eastern },
            { "America/Grenada", Atlantic },
            { "America/Iqaluit", America_Eastern },
            { "America/Jamaica", America_Eastern },
            { "America/Knox_IN", America_Central },
            { "America/Managua", America_Central },
            { "America/Marigot", Atlantic },
            { "America/Mendoza", Argentina },
            { "America/Moncton", Atlantic },
            { "America/Nipigon", America_Eastern },
            { "America/Noronha", Noronha },
            { "America/Ojinaga", America_Central },
            { "America/Tijuana", America_Pacific },
            { "America/Toronto", America_Eastern },
            { "America/Tortola", Atlantic },
            { "America/Yakutat", Alaska },
            { "Asia/Choibalsan", Mongolia },
            { "Asia/Phnom_Penh", Indochina },
            { "Asia/Ulan_Bator", Mongolia },
            { "Atlantic/Azores", Azores },
            { "Atlantic/Canary", Europe_Western },
            { "Atlantic/Faeroe", Europe_Western },
            { "Australia/Eucla", Australia_CentralWestern },
            { "Australia/North", Australia_Central },
            { "Australia/Perth", Australia_Western },
            { "Australia/South", Australia_Central },
            { "Canada/Atlantic", Atlantic },
            { "Canada/Mountain", America_Mountain },
            { "Europe/Belgrade", Europe_Central },
            { "Europe/Brussels", Europe_Central },
            { "Europe/Budapest", Europe_Central },
            { "Europe/Busingen", Europe_Central },
            { "Europe/Chisinau", Europe_Eastern },
            { "Europe/Guernsey",
                new String[] {
                    "Greenwich-tyd",
                    "GMT",
                    "Britse somertyd",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Helsinki", Europe_Eastern },
            { "Europe/Sarajevo", Europe_Central },
            { "Europe/Tiraspol", Europe_Eastern },
            { "Europe/Uzhgorod", Europe_Eastern },
            { "Indian/Maldives", French_Southern },
            { "Pacific/Chatham", Chatham },
            { "Pacific/Fakaofo", Tokelau },
            { "Pacific/Gambier", Gambier },
            { "Pacific/Norfolk", Norfolk },
            { "Pacific/Pohnpei", Solomon },
            { "SystemV/AST4ADT", Atlantic },
            { "SystemV/CST6CDT", America_Central },
            { "SystemV/EST5EDT", America_Eastern },
            { "SystemV/MST7MDT", America_Mountain },
            { "SystemV/PST8PDT", America_Pacific },
            { "SystemV/YST9YDT", Alaska },
            { "Africa/Bujumbura", Africa_Central },
            { "Africa/Mogadishu", Africa_Eastern },
            { "America/Anguilla", Atlantic },
            { "America/Asuncion", Paraguay },
            { "America/Atikokan", America_Eastern },
            { "America/Barbados", Atlantic },
            { "America/Dominica", Atlantic },
            { "America/Edmonton", America_Mountain },
            { "America/Ensenada", America_Pacific },
            { "America/Mazatlan", Mexico_Pacific },
            { "America/Miquelon", Pierre_Miquelon },
            { "America/Montreal", America_Eastern },
            { "America/Resolute", America_Central },
            { "America/Santarem", Brasilia },
            { "America/Santiago", Chile },
            { "America/Shiprock", America_Mountain },
            { "America/St_Kitts", Atlantic },
            { "America/St_Lucia", Atlantic },
            { "America/Winnipeg", America_Central },
            { "Antarctica/Casey", Australia_Western },
            { "Antarctica/Davis", Davis },
            { "Antarctica/Syowa", Syowa },
            { "Antarctica/Troll", GMT },
            { "Asia/Ho_Chi_Minh", Indochina },
            { "Asia/Krasnoyarsk", Krasnoyarsk },
            { "Asia/Novosibirsk", Novosibirsk },
            { "Asia/Ulaanbaatar", Mongolia },
            { "Asia/Vladivostok", Vladivostok },
            { "Atlantic/Bermuda", Atlantic },
            { "Atlantic/Madeira", Europe_Western },
            { "Atlantic/Stanley", Falkland },
            { "Australia/Currie", Australia_Eastern },
            { "Australia/Darwin", Australia_Central },
            { "Australia/Hobart", Australia_Eastern },
            { "Australia/Sydney", Australia_Eastern },
            { "Brazil/DeNoronha", Noronha },
            { "Europe/Amsterdam", Europe_Central },
            { "Europe/Gibraltar", Europe_Central },
            { "Europe/Ljubljana", Europe_Central },
            { "Europe/Mariehamn", Europe_Eastern },
            { "Europe/Podgorica", Europe_Central },
            { "Europe/Stockholm", Europe_Central },
            { "Europe/Volgograd", Volgograd },
            { "Indian/Christmas", Christmas },
            { "Indian/Kerguelen", French_Southern },
            { "Indian/Mauritius", Mauritius },
            { "Mexico/BajaNorte", America_Pacific },
            { "Pacific/Auckland", New_Zealand },
            { "Pacific/Funafuti", Tuvalu },
            { "Pacific/Johnston", Hawaii_Aleutian },
            { "Pacific/Pitcairn", Pitcairn },
            { "Africa/Libreville", Africa_Western },
            { "Africa/Lubumbashi", Africa_Central },
            { "Africa/Nouakchott", GMT },
            { "Africa/Porto-Novo", Africa_Western },
            { "America/Araguaina", Brasilia },
            { "America/Boa_Vista", Amazon },
            { "America/Catamarca", Argentina },
            { "America/Chihuahua", America_Central },
            { "America/Fortaleza", Brasilia },
            { "America/Glace_Bay", Atlantic },
            { "America/Goose_Bay", Atlantic },
            { "America/Guatemala", America_Central },
            { "America/Guayaquil", Ecuador },
            { "America/Matamoros", America_Central },
            { "America/Menominee", America_Central },
            { "America/Monterrey", America_Central },
            { "America/Sao_Paulo", Brasilia },
            { "America/St_Thomas", Atlantic },
            { "America/Vancouver", America_Pacific },
            { "Antarctica/Mawson", Mawson },
            { "Antarctica/Vostok", Vostok },
            { "Asia/Kuala_Lumpur", Malaysia },
            { "Asia/Novokuznetsk", Krasnoyarsk },
            { "Chile/Continental", Chile },
            { "Europe/Bratislava", Europe_Central },
            { "Europe/Copenhagen", Europe_Central },
            { "Europe/Luxembourg", Europe_Central },
            { "Europe/San_Marino", Europe_Central },
            { "Europe/Simferopol", Moscow },
            { "Europe/Zaporozhye", Europe_Eastern },
            { "Pacific/Enderbury", Phoenix_Islands },
            { "Pacific/Galapagos", Galapagos },
            { "Pacific/Kwajalein", Marshall_Islands },
            { "Pacific/Marquesas", Marquesas },
            { "Pacific/Pago_Pago", Samoa },
            { "Pacific/Rarotonga", Cook },
            { "Pacific/Tongatapu", Tonga },
            { "US/Indiana-Starke", America_Central },
            { "Africa/Addis_Ababa", Africa_Eastern },
            { "Africa/Brazzaville", Africa_Western },
            { "Africa/Ouagadougou", GMT },
            { "America/Costa_Rica", America_Central },
            { "America/Grand_Turk", America_Eastern },
            { "America/Guadeloupe", Atlantic },
            { "America/Hermosillo", Mexico_Pacific },
            { "America/Kralendijk", Atlantic },
            { "America/Louisville", America_Eastern },
            { "America/Martinique", Atlantic },
            { "America/Metlakatla", Alaska },
            { "America/Montevideo", Uruguay },
            { "America/Montserrat", Atlantic },
            { "America/Paramaribo", Suriname },
            { "America/St_Vincent", Atlantic },
            { "America/Whitehorse", Yukon },
            { "Antarctica/McMurdo", New_Zealand },
            { "Antarctica/Rothera", Rothera },
            { "Asia/Ujung_Pandang", Indonesia_Central },
            { "Asia/Yekaterinburg", Yekaterinburg },
            { "Atlantic/Jan_Mayen", Europe_Central },
            { "Atlantic/Reykjavik", GMT },
            { "Atlantic/St_Helena", GMT },
            { "Australia/Adelaide", Australia_Central },
            { "Australia/Brisbane", Australia_Eastern },
            { "Australia/Canberra", Australia_Eastern },
            { "Australia/Lindeman", Australia_Eastern },
            { "Australia/Tasmania", Australia_Eastern },
            { "Australia/Victoria", Australia_Eastern },
            { "Chile/EasterIsland", Easter },
            { "Europe/Isle_of_Man",
                new String[] {
                    "Greenwich-tyd",
                    "GMT",
                    "Britse somertyd",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Kaliningrad", Europe_Eastern },
            { "Pacific/Kiritimati", Line_Islands },
            { "Africa/Johannesburg", Africa_Southern },
            { "America/El_Salvador", America_Central },
            { "America/Fort_Nelson", America_Mountain },
            { "America/Mexico_City", America_Central },
            { "America/Pangnirtung", America_Eastern },
            { "America/Porto_Velho", Amazon },
            { "America/Puerto_Rico", Atlantic },
            { "America/Rainy_River", America_Central },
            { "America/Tegucigalpa", America_Central },
            { "America/Thunder_Bay", America_Eastern },
            { "America/Yellowknife", America_Mountain },
            { "Arctic/Longyearbyen", Europe_Central },
            { "Atlantic/Cape_Verde", Cape_Verde },
            { "Australia/Lord_Howe", Lord_Howe },
            { "Australia/Melbourne", Australia_Eastern },
            { "Canada/Newfoundland", Newfoundland },
            { "Canada/Saskatchewan", America_Central },
            { "Indian/Antananarivo", Africa_Eastern },
            { "Pacific/Guadalcanal", Solomon },
            { "Africa/Dar_es_Salaam", Africa_Eastern },
            { "America/Blanc-Sablon", Atlantic },
            { "America/Buenos_Aires", Argentina },
            { "America/Campo_Grande", Amazon },
            { "America/Danmarkshavn", GMT },
            { "America/Dawson_Creek", America_Mountain },
            { "America/Indiana/Knox", America_Central },
            { "America/Rankin_Inlet", America_Central },
            { "America/Santa_Isabel", America_Pacific },
            { "Antarctica/Macquarie", Australia_Eastern },
            { "Australia/Queensland", Australia_Eastern },
            { "Australia/Yancowinna", Australia_Central },
            { "Pacific/Port_Moresby", DumontDUrville },
            { "America/Cambridge_Bay", America_Mountain },
            { "America/Ciudad_Juarez", America_Mountain },
            { "America/Coral_Harbour", America_Eastern },
            { "America/Indiana/Vevay", America_Eastern },
            { "America/Lower_Princes", Atlantic },
            { "America/Port_of_Spain", Atlantic },
            { "America/Santo_Domingo", Atlantic },
            { "America/St_Barthelemy", Atlantic },
            { "America/Swift_Current", America_Central },
            { "Antarctica/South_Pole", New_Zealand },
            { "Australia/Broken_Hill", Australia_Central },
            { "America/Bahia_Banderas", America_Central },
            { "America/Port-au-Prince", America_Eastern },
            { "Atlantic/South_Georgia", South_Georgia },
            { "America/Argentina/Jujuy", Argentina },
            { "America/Argentina/Salta", Argentina },
            { "America/Indiana/Marengo", America_Eastern },
            { "America/Indiana/Winamac", America_Eastern },
            { "America/Argentina/Cordoba", Argentina },
            { "America/Argentina/Mendoza", Argentina },
            { "America/Argentina/Tucuman", Argentina },
            { "America/Argentina/Ushuaia", Argentina },
            { "America/Indiana/Tell_City", America_Central },
            { "America/Indiana/Vincennes", America_Eastern },
            { "Antarctica/DumontDUrville", DumontDUrville },
            { "timezone.excity.Asia/Baku", "Bakoe" },
            { "America/Argentina/La_Rioja", Argentina },
            { "America/Argentina/San_Juan", Argentina },
            { "America/Argentina/San_Luis", Argentina },
            { "America/Indiana/Petersburg", America_Eastern },
            { "timezone.excity.Asia/Dubai", "Doebai" },
            { "timezone.excity.Asia/Kabul", "Kaboel" },
            { "timezone.excity.Asia/Macau", "Macau" },
            { "timezone.excity.Asia/Qatar", "Katar" },
            { "timezone.excity.Asia/Seoul", "Seoel" },
            { "timezone.excity.Asia/Tokyo", "Tokio" },
            { "America/Argentina/Catamarca", Argentina },
            { "America/Kentucky/Louisville", America_Eastern },
            { "America/Kentucky/Monticello", America_Eastern },
            { "America/North_Dakota/Beulah", America_Central },
            { "America/North_Dakota/Center", America_Central },
            { "timezone.excity.Asia/Beirut", "Beiroet" },
            { "timezone.excity.Asia/Brunei", "Broenei" },
            { "timezone.excity.Asia/Kuwait", "Koeweit" },
            { "timezone.excity.Asia/Muscat", "Muskat" },
            { "timezone.excity.Asia/Riyadh", "Riaad" },
            { "timezone.excity.Asia/Saigon", "Ho Tsji Minhstad" },
            { "timezone.excity.Etc/Unknown", "Onbekende stad" },
            { "timezone.excity.Europe/Kiev", "Ki\u00ebf" },
            { "America/Indiana/Indianapolis", America_Eastern },
            { "timezone.excity.Africa/Cairo", "Ka\u00efro" },
            { "timezone.excity.Asia/Baghdad", "Bagdad" },
            { "timezone.excity.Asia/Bahrain", "Bahrein" },
            { "timezone.excity.Asia/Bishkek", "Bisjkek" },
            { "timezone.excity.Asia/Irkutsk", "Irkoetsk" },
            { "timezone.excity.Asia/Jakarta", "Djakarta" },
            { "timezone.excity.Asia/Karachi", "Karatsji" },
            { "timezone.excity.Asia/Yakutsk", "Jakoetsk" },
            { "timezone.excity.Europe/Paris", "Parys" },
            { "timezone.excity.Indian/Cocos", "Kokos" },
            { "timezone.excity.Pacific/Fiji", "Fidji" },
            { "timezone.excity.Asia/Ashgabat", "Asjchabad" },
            { "timezone.excity.Asia/Damascus", "Damaskus" },
            { "timezone.excity.Asia/Katmandu", "Katmandoe" },
            { "timezone.excity.Asia/Qostanay", "Kostanay" },
            { "timezone.excity.Europe/Athens", "Athene" },
            { "timezone.excity.Europe/Berlin", "Berlyn" },
            { "timezone.excity.Europe/Lisbon", "Lissabon" },
            { "timezone.excity.Europe/London", "Londen" },
            { "timezone.excity.Europe/Moscow", "Moskou" },
            { "timezone.excity.Europe/Prague", "Praag" },
            { "timezone.excity.Europe/Vienna", "Wene" },
            { "timezone.excity.Europe/Warsaw", "Warskou" },
            { "timezone.excity.Europe/Zurich", "Z\u00fcrich" },
            { "timezone.excity.Indian/Comoro", "Comore" },
            { "America/Argentina/Buenos_Aires", Argentina },
            { "America/Argentina/Rio_Gallegos", Argentina },
            { "America/North_Dakota/New_Salem", America_Central },
            { "timezone.excity.America/Cayman", "Kaaiman" },
            { "timezone.excity.Asia/Hong_Kong", "Hongkong" },
            { "timezone.excity.Asia/Kamchatka", "Kamtsjatka" },
            { "timezone.excity.Asia/Singapore", "Singapoer" },
            { "timezone.excity.Europe/Saratov", "Saratof" },
            { "timezone.excity.Europe/Vatican", "Vatikaanstad" },
            { "timezone.excity.Pacific/Easter", "Paas" },
            { "timezone.excity.Pacific/Noumea", "Noum\u00e9a" },
            { "timezone.excity.Pacific/Wallis", "Mata-Utu" },
            { "timezone.excity.Africa/Djibouti", "Djiboeti" },
            { "timezone.excity.Africa/Khartoum", "Kartoem" },
            { "timezone.excity.America/Jamaica", "Jamaika" },
            { "timezone.excity.Atlantic/Azores", "Asore" },
            { "timezone.excity.Atlantic/Canary", "Kanarie" },
            { "timezone.excity.Europe/Brussels", "Brussel" },
            { "timezone.excity.Europe/Budapest", "Boedapest" },
            { "timezone.excity.Indian/Maldives", "Maledive" },
            { "timezone.excity.Africa/Mogadishu", "Mogadisjoe" },
            { "timezone.excity.America/St_Johns", "Sint John\u2019s" },
            { "timezone.excity.America/St_Kitts", "Sint Kitts" },
            { "timezone.excity.America/St_Lucia", "Sint Lucia" },
            { "timezone.excity.Asia/Krasnoyarsk", "Krasnojarsk" },
            { "timezone.excity.Asia/Vladivostok", "Wladiwostok" },
            { "timezone.excity.Europe/Bucharest", "Boekarest" },
            { "timezone.excity.Europe/Volgograd", "Wolgograd" },
            { "timezone.excity.Pacific/Honolulu", "Honolulu" },
            { "timezone.excity.America/Glace_Bay", "Glacebaai" },
            { "timezone.excity.America/Goose_Bay", "Goosebaai" },
            { "timezone.excity.America/St_Thomas", "Sint Thomas" },
            { "timezone.excity.Antarctica/Vostok", "Wostok" },
            { "timezone.excity.Asia/Kuala_Lumpur", "Koeala-Loempoer" },
            { "timezone.excity.Europe/Copenhagen", "Kopenhagen" },
            { "timezone.excity.Europe/Luxembourg", "Luxemburg" },
            { "timezone.excity.Pacific/Enderbury", "Enderbury" },
            { "timezone.excity.Africa/Addis_Ababa", "Addis Abeba" },
            { "timezone.excity.America/St_Vincent", "Sint Vincent" },
            { "timezone.excity.Asia/Yekaterinburg", "Jekaterinburg" },
            { "timezone.excity.Atlantic/St_Helena", "Sint Helena" },
            { "timezone.excity.Europe/Isle_of_Man", "Eiland Man" },
            { "timezone.excity.America/Mexico_City", "Meksikostad" },
            { "timezone.excity.Atlantic/Cape_Verde", "Kaap Verde" },
            { "timezone.excity.America/Cambridge_Bay", "Cambridgebaai" },
            { "timezone.excity.America/St_Barthelemy", "Sint Bartholomeus" },
            { "timezone.excity.America/Bahia_Banderas", "Bahia Banderas" },
            { "timezone.excity.Atlantic/South_Georgia", "Suid-Georgi\u00eb" },
            { "timezone.excity.America/North_Dakota/Beulah", "Beulah, Noord-Dakota" },
            { "timezone.excity.America/North_Dakota/Center", "Center, Noord-Dakota" },
            { "timezone.excity.America/North_Dakota/New_Salem", "New Salem, Noord-Dakota" },
        };
        return data;
    }
}
