// CheckStyle: stop header check
// CheckStyle: stop line length check
// GENERATED CONTENT - DO NOT EDIT
// Source: SubstrateOptions.java
package com.oracle.svm.core;

import java.util.*;
import jdk.graal.compiler.options.*;
import jdk.graal.compiler.options.OptionType;
import jdk.graal.compiler.options.OptionStability;

public class SubstrateOptions_OptionDescriptors implements OptionDescriptors {
    @Override
    public OptionDescriptor get(String value) {
        switch (value) {
        // CheckStyle: stop line length check
        case "AOTInline": {
            return OptionDescriptor.create(
                /*name*/ "AOTInline",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Deprecated",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "AOTInline",
                /*option*/ SubstrateOptions.AOTInline,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ true,
                /*deprecationMessage*/ "");
        }
        case "AOTTrivialInline": {
            return OptionDescriptor.create(
                /*name*/ "AOTTrivialInline",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Perform trivial method inlining in the AOT compiled native image",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "AOTTrivialInline",
                /*option*/ SubstrateOptions.AOTTrivialInline,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "APIFunctionPrefix": {
            return OptionDescriptor.create(
                /*name*/ "APIFunctionPrefix",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ String.class,
                /*help*/ "Prefix that is added to the names of API functions.",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "APIFunctionPrefix",
                /*option*/ SubstrateOptions.APIFunctionPrefix,
                /*stability*/ OptionStability.STABLE,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "AbortOnNameConflict": {
            return OptionDescriptor.create(
                /*name*/ "AbortOnNameConflict",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Throws an exception on potential type conflict during heap persisting if enabled",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "AbortOnNameConflict",
                /*option*/ SubstrateOptions.AbortOnNameConflict,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "ActiveProcessorCount": {
            return OptionDescriptor.create(
                /*name*/ "ActiveProcessorCount",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Integer.class,
                /*help*/ "Overwrites the available number of processors provided by the OS. Any value <= 0 means using the processor count from the OS.",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "ActiveProcessorCount",
                /*option*/ SubstrateOptions.ActiveProcessorCount,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "AdditionalHeaderBytes": {
            return OptionDescriptor.create(
                /*name*/ "AdditionalHeaderBytes",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Integer.class,
                /*help*/ "Add additional header bytes to each object, for diagnostic purposes.",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "AdditionalHeaderBytes",
                /*option*/ SubstrateOptions.AdditionalHeaderBytes,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "AllocateInstancePrefetchLines": {
            return OptionDescriptor.create(
                /*name*/ "AllocateInstancePrefetchLines",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Integer.class,
                /*help*/ "Number of cache lines to load after the object address using prefetch instructions.",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "AllocateInstancePrefetchLines",
                /*option*/ SubstrateOptions.AllocateInstancePrefetchLines,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "AllocatePrefetchDistance": {
            return OptionDescriptor.create(
                /*name*/ "AllocatePrefetchDistance",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Integer.class,
                /*help*/ "Sets the size (in bytes) of the prefetch distance for object allocation. Memory about to be written with the value of new objects is prefetched up to this distance starting from the address of the last allocated object. Each Java thread has its own allocation point.",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "AllocatePrefetchDistance",
                /*option*/ SubstrateOptions.AllocatePrefetchDistance,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "AllocatePrefetchInstr": {
            return OptionDescriptor.create(
                /*name*/ "AllocatePrefetchInstr",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Integer.class,
                /*help*/ "Sets the prefetch instruction to prefetch ahead of the allocation pointer. Possible values are from 0 to 3. The actual instructions behind the values depend on the platform.",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "AllocatePrefetchInstr",
                /*option*/ SubstrateOptions.AllocatePrefetchInstr,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "AllocatePrefetchLines": {
            return OptionDescriptor.create(
                /*name*/ "AllocatePrefetchLines",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Integer.class,
                /*help*/ "Number of cache lines to load after the array allocation using prefetch instructions.",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "AllocatePrefetchLines",
                /*option*/ SubstrateOptions.AllocatePrefetchLines,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "AllocatePrefetchStepSize": {
            return OptionDescriptor.create(
                /*name*/ "AllocatePrefetchStepSize",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Integer.class,
                /*help*/ "Sets the step size (in bytes) for sequential prefetch instructions.",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "AllocatePrefetchStepSize",
                /*option*/ SubstrateOptions.AllocatePrefetchStepSize,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "AllocatePrefetchStyle": {
            return OptionDescriptor.create(
                /*name*/ "AllocatePrefetchStyle",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Integer.class,
                /*help*/ "Generated code style for prefetch instructions: for 0 or less no prefetch instructions are generated and for 1 or more prefetch instructions are introduced after each allocation.",
                /*declaringClass*/ SubstrateOptions.ConcealedOptions.class,
                /*fieldName*/ "AllocatePrefetchStyle",
                /*option*/ SubstrateOptions.ConcealedOptions.AllocatePrefetchStyle,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "AllowDeprecatedBuilderClassesOnImageClasspath": {
            return OptionDescriptor.create(
                /*name*/ "AllowDeprecatedBuilderClassesOnImageClasspath",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Instead of abort, only warn if image builder classes are found on the image class-path.",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "AllowDeprecatedBuilderClassesOnImageClasspath",
                /*option*/ SubstrateOptions.AllowDeprecatedBuilderClassesOnImageClasspath,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ true,
                /*deprecationMessage*/ "This option was introduced to simplify migration to GraalVM 23.0 and will be removed in a future release");
        }
        case "AllowUnsafeAllocationOfAllInstantiatedTypes": {
            return OptionDescriptor.create(
                /*name*/ "AllowUnsafeAllocationOfAllInstantiatedTypes",
                /*optionType*/ OptionType.Expert,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Allow all instantiated types to be allocated via Unsafe.allocateInstance().",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "AllowUnsafeAllocationOfAllInstantiatedTypes",
                /*option*/ SubstrateOptions.AllowUnsafeAllocationOfAllInstantiatedTypes,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ true,
                /*deprecationMessage*/ "ThrowMissingRegistrationErrors is the preferred way of configuring this on a per-type level.");
        }
        case "AllowVMInternalThreads": {
            return OptionDescriptor.create(
                /*name*/ "AllowVMInternalThreads",
                /*optionType*/ OptionType.Expert,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Determines if VM internal threads (e.g., a dedicated VM operation or reference handling thread) are allowed in this image.",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "AllowVMInternalThreads",
                /*option*/ SubstrateOptions.AllowVMInternalThreads,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "ApplicationLayerOnlySingletons": {
            return OptionDescriptor.create(
                /*name*/ "ApplicationLayerOnlySingletons",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ com.oracle.svm.core.option.AccumulatingLocatableMultiOptionValue.Strings.class,
                /*help*/ "Mark singleton as application layer only",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "ApplicationLayerOnlySingletons",
                /*option*/ SubstrateOptions.ApplicationLayerOnlySingletons,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "AsyncSignalSafeDiagnostics": {
            return OptionDescriptor.create(
                /*name*/ "AsyncSignalSafeDiagnostics",
                /*optionType*/ OptionType.Expert,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Only print diagnostic output that is async signal safe.",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "AsyncSignalSafeDiagnostics",
                /*option*/ SubstrateOptions.AsyncSignalSafeDiagnostics,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "AutomaticReferenceHandling": {
            return OptionDescriptor.create(
                /*name*/ "AutomaticReferenceHandling",
                /*optionType*/ OptionType.Expert,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Determines if the reference handling is executed automatically or manually.",
                /*declaringClass*/ SubstrateOptions.ConcealedOptions.class,
                /*fieldName*/ "AutomaticReferenceHandling",
                /*option*/ SubstrateOptions.ConcealedOptions.AutomaticReferenceHandling,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "BuildOutputBreakdowns": {
            return OptionDescriptor.create(
                /*name*/ "BuildOutputBreakdowns",
                /*optionType*/ OptionType.User,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Show code and heap breakdowns as part of the build output",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "BuildOutputBreakdowns",
                /*option*/ SubstrateOptions.BuildOutputBreakdowns,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ true,
                /*deprecationMessage*/ "Deprecated without replacement");
        }
        case "BuildOutputColorful": {
            return OptionDescriptor.create(
                /*name*/ "BuildOutputColorful",
                /*optionType*/ OptionType.User,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Color build output (enabled by default if colors are supported by terminal)",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "BuildOutputColorful",
                /*option*/ SubstrateOptions.BuildOutputColorful,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ true,
                /*deprecationMessage*/ "Please use '--color' instead.");
        }
        case "BuildOutputGCWarnings": {
            return OptionDescriptor.create(
                /*name*/ "BuildOutputGCWarnings",
                /*optionType*/ OptionType.User,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Print GC warnings as part of build output",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "BuildOutputGCWarnings",
                /*option*/ SubstrateOptions.BuildOutputGCWarnings,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "BuildOutputJSONFile": {
            return OptionDescriptor.create(
                /*name*/ "BuildOutputJSONFile",
                /*optionType*/ OptionType.User,
                /*optionValueType*/ com.oracle.svm.core.option.AccumulatingLocatableMultiOptionValue.Paths.class,
                /*help*/ "Print build output statistics as JSON to the specified file. The output conforms to the JSON schema located at: docs/reference-manual/native-image/assets/build-output-schema-v0.9.3.json",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "BuildOutputJSONFile",
                /*option*/ SubstrateOptions.BuildOutputJSONFile,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "BuildOutputLinks": {
            return OptionDescriptor.create(
                /*name*/ "BuildOutputLinks",
                /*optionType*/ OptionType.User,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Show links in build output (defaults to the value of BuildOutputColorful)",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "BuildOutputLinks",
                /*option*/ SubstrateOptions.BuildOutputLinks,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "BuildOutputNativeImageOptionsEnvVarValue": {
            return OptionDescriptor.create(
                /*name*/ "BuildOutputNativeImageOptionsEnvVarValue",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ String.class,
                /*help*/ "Internal option to forward the value of NATIVE_IMAGE_OPTIONS",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "BuildOutputNativeImageOptionsEnvVarValue",
                /*option*/ SubstrateOptions.BuildOutputNativeImageOptionsEnvVarValue,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "BuildOutputPrefix": {
            return OptionDescriptor.create(
                /*name*/ "BuildOutputPrefix",
                /*optionType*/ OptionType.User,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Deprecated, option no longer has any effect.",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "BuildOutputPrefix",
                /*option*/ SubstrateOptions.BuildOutputPrefix,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ true,
                /*deprecationMessage*/ "It no longer has any effect, and no replacement is available");
        }
        case "BuildOutputProgress": {
            return OptionDescriptor.create(
                /*name*/ "BuildOutputProgress",
                /*optionType*/ OptionType.User,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Report progress in build output (default is adaptive)",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "BuildOutputProgress",
                /*option*/ SubstrateOptions.BuildOutputProgress,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "BuildOutputRecommendations": {
            return OptionDescriptor.create(
                /*name*/ "BuildOutputRecommendations",
                /*optionType*/ OptionType.User,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Show recommendations as part of the build output",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "BuildOutputRecommendations",
                /*option*/ SubstrateOptions.BuildOutputRecommendations,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "BuildOutputSilent": {
            return OptionDescriptor.create(
                /*name*/ "BuildOutputSilent",
                /*optionType*/ OptionType.User,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Silence build output",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "BuildOutputSilent",
                /*option*/ SubstrateOptions.BuildOutputSilent,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "CCompilerOption": {
            return OptionDescriptor.create(
                /*name*/ "CCompilerOption",
                /*optionType*/ OptionType.User,
                /*optionValueType*/ com.oracle.svm.core.option.AccumulatingLocatableMultiOptionValue.Strings.class,
                /*help*/ "Provide custom C compiler option used for query code compilation.",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "CCompilerOption",
                /*option*/ SubstrateOptions.CCompilerOption,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "CCompilerPath": {
            return OptionDescriptor.create(
                /*name*/ "CCompilerPath",
                /*optionType*/ OptionType.User,
                /*optionValueType*/ String.class,
                /*help*/ "Provide custom path to C compiler used for query code compilation and linking.",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "CCompilerPath",
                /*option*/ SubstrateOptions.CCompilerPath,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "CLibraryPath": {
            return OptionDescriptor.create(
                /*name*/ "CLibraryPath",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ com.oracle.svm.core.option.AccumulatingLocatableMultiOptionValue.Paths.class,
                /*help*/ "Search path for C libraries passed to the linker (list of comma-separated directories)",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "CLibraryPath",
                /*option*/ SubstrateOptions.CLibraryPath,
                /*stability*/ OptionStability.STABLE,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "CheckBootModuleDependencies": {
            return OptionDescriptor.create(
                /*name*/ "CheckBootModuleDependencies",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Integer.class,
                /*help*/ "Temporary option to disable checking of image builder module dependencies or increasing its verbosity",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "CheckBootModuleDependencies",
                /*option*/ SubstrateOptions.CheckBootModuleDependencies,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "CheckIsolateThreadAtEntry": {
            return OptionDescriptor.create(
                /*name*/ "CheckIsolateThreadAtEntry",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "At CEntryPoints check that the passed IsolateThread is valid.",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "CheckIsolateThreadAtEntry",
                /*option*/ SubstrateOptions.CheckIsolateThreadAtEntry,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "CheckToolchain": {
            return OptionDescriptor.create(
                /*name*/ "CheckToolchain",
                /*optionType*/ OptionType.Expert,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Check if native-toolchain is known to work with native-image",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "CheckToolchain",
                /*option*/ SubstrateOptions.CheckToolchain,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "Class": {
            return OptionDescriptor.create(
                /*name*/ "Class",
                /*optionType*/ OptionType.User,
                /*optionValueType*/ String.class,
                /*help*/ "Class containing the default entry point method. Optional if --shared is used.",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "Class",
                /*option*/ SubstrateOptions.Class,
                /*stability*/ OptionStability.STABLE,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "ClosedTypeWorld": {
            return OptionDescriptor.create(
                /*name*/ "ClosedTypeWorld",
                /*optionType*/ OptionType.Expert,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Assume new types cannot be added after analysis",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "ClosedTypeWorld",
                /*option*/ SubstrateOptions.ClosedTypeWorld,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "ClosedTypeWorldHubLayout": {
            return OptionDescriptor.create(
                /*name*/ "ClosedTypeWorldHubLayout",
                /*optionType*/ OptionType.Expert,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Use the closed type world dynamic hub representation. This is only allowed when the option ClosedTypeWorld is also set to true.",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "ClosedTypeWorldHubLayout",
                /*option*/ SubstrateOptions.ClosedTypeWorldHubLayout,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "CodeAlignment": {
            return OptionDescriptor.create(
                /*name*/ "CodeAlignment",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Integer.class,
                /*help*/ "Alignment of AOT and JIT compiled code in bytes.",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "CodeAlignment",
                /*option*/ SubstrateOptions.CodeAlignment,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "Color": {
            return OptionDescriptor.create(
                /*name*/ "Color",
                /*optionType*/ OptionType.User,
                /*optionValueType*/ String.class,
                /*help*/ "Color build output ('always', 'never', or 'auto')",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "Color",
                /*option*/ SubstrateOptions.Color,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "CompilationIsolateAddressSpaceSize": {
            return OptionDescriptor.create(
                /*name*/ "CompilationIsolateAddressSpaceSize",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Long.class,
                /*help*/ "Size of the reserved address space of each compilation isolate (0: default for new isolates).",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "CompilationIsolateAddressSpaceSize",
                /*option*/ SubstrateOptions.CompilationIsolateAddressSpaceSize,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "CompilationIsolateOptions": {
            return OptionDescriptor.create(
                /*name*/ "CompilationIsolateOptions",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ String.class,
                /*help*/ "Options that are passed to each compilation isolate. Individual arguments are separated by spaces. Arguments that contain spaces need to be enclosed by single quotes.",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "CompilationIsolateOptions",
                /*option*/ SubstrateOptions.CompilationIsolateOptions,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "CompileInIsolates": {
            return OptionDescriptor.create(
                /*name*/ "CompileInIsolates",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Activate runtime compilation in separate isolates (enable support during image build with option SupportCompileInIsolates).",
                /*declaringClass*/ SubstrateOptions.ConcealedOptions.class,
                /*fieldName*/ "CompileInIsolates",
                /*option*/ SubstrateOptions.ConcealedOptions.CompileInIsolates,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "CompilerBackend": {
            return OptionDescriptor.create(
                /*name*/ "CompilerBackend",
                /*optionType*/ OptionType.User,
                /*optionValueType*/ String.class,
                /*help*/ "Backend used by the compiler",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "CompilerBackend",
                /*option*/ SubstrateOptions.CompilerBackend,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "ConfigureReflectionMetadata": {
            return OptionDescriptor.create(
                /*name*/ "ConfigureReflectionMetadata",
                /*optionType*/ OptionType.Expert,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Enable runtime instantiation of reflection objects for non-invoked methods.",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "ConfigureReflectionMetadata",
                /*option*/ SubstrateOptions.ConfigureReflectionMetadata,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ true,
                /*deprecationMessage*/ "");
        }
        case "ContendedPaddingWidth": {
            return OptionDescriptor.create(
                /*name*/ "ContendedPaddingWidth",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Integer.class,
                /*help*/ "How many bytes to pad fields and classes marked @Contended with.",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "ContendedPaddingWidth",
                /*option*/ SubstrateOptions.ContendedPaddingWidth,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "CopyLanguageResources": {
            return OptionDescriptor.create(
                /*name*/ "CopyLanguageResources",
                /*optionType*/ OptionType.User,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Automatically copy the necessary language resources to the resources directory next to the produced image.",
                /*declaringClass*/ SubstrateOptions.TruffleStableOptions.class,
                /*fieldName*/ "CopyLanguageResources",
                /*option*/ SubstrateOptions.TruffleStableOptions.CopyLanguageResources,
                /*stability*/ OptionStability.STABLE,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "DeadlockWatchdogExitOnTimeout": {
            return OptionDescriptor.create(
                /*name*/ "DeadlockWatchdogExitOnTimeout",
                /*optionType*/ OptionType.Expert,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Exit the image builder VM after printing call stacks",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "DeadlockWatchdogExitOnTimeout",
                /*option*/ SubstrateOptions.DeadlockWatchdogExitOnTimeout,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "DeadlockWatchdogInterval": {
            return OptionDescriptor.create(
                /*name*/ "DeadlockWatchdogInterval",
                /*optionType*/ OptionType.Expert,
                /*optionValueType*/ Integer.class,
                /*help*/ "The interval in minutes between watchdog checks (0 disables the watchdog)",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "DeadlockWatchdogInterval",
                /*option*/ SubstrateOptions.DeadlockWatchdogInterval,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "DebugCodeInfoMaxDepth": {
            return OptionDescriptor.create(
                /*name*/ "DebugCodeInfoMaxDepth",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Integer.class,
                /*help*/ "Specify maximum inlining depth to consider when building DebugCodeInfo",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "DebugCodeInfoMaxDepth",
                /*option*/ SubstrateOptions.DebugCodeInfoMaxDepth,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "DebugCodeInfoUseSourceMappings": {
            return OptionDescriptor.create(
                /*name*/ "DebugCodeInfoUseSourceMappings",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Do not use SourceMappings for generating DebugCodeInfo (i.e. only use Infopoints)",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "DebugCodeInfoUseSourceMappings",
                /*option*/ SubstrateOptions.DebugCodeInfoUseSourceMappings,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "DebugInfoSourceCacheRoot": {
            return OptionDescriptor.create(
                /*name*/ "DebugInfoSourceCacheRoot",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ String.class,
                /*help*/ "Directory under which to create source file cache for Application or GraalVM classes",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "DebugInfoSourceCacheRoot",
                /*option*/ SubstrateOptions.DebugInfoSourceCacheRoot,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "DeleteLocalSymbols": {
            return OptionDescriptor.create(
                /*name*/ "DeleteLocalSymbols",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Use linker option to remove all local symbols from image.",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "DeleteLocalSymbols",
                /*option*/ SubstrateOptions.DeleteLocalSymbols,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "DetectUserDirectoriesInImageHeap": {
            return OptionDescriptor.create(
                /*name*/ "DetectUserDirectoriesInImageHeap",
                /*optionType*/ OptionType.User,
                /*optionValueType*/ Boolean.class,
                /*help*/ "When set to true, the image generator verifies that the image heap does not contain a home directory as a substring",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "DetectUserDirectoriesInImageHeap",
                /*option*/ SubstrateOptions.DetectUserDirectoriesInImageHeap,
                /*stability*/ OptionStability.STABLE,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "DiagnosticBufferSize": {
            return OptionDescriptor.create(
                /*name*/ "DiagnosticBufferSize",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Integer.class,
                /*help*/ "Specifies the number of entries that diagnostic buffers have.",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "DiagnosticBufferSize",
                /*option*/ SubstrateOptions.DiagnosticBufferSize,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "DiagnosticDetails": {
            return OptionDescriptor.create(
                /*name*/ "DiagnosticDetails",
                /*optionType*/ OptionType.Expert,
                /*optionValueType*/ String.class,
                /*help*/ "Specifies how many details are printed for certain diagnostic thunks, e.g.: 'DumpThreads:1,DumpRegisters:2'. A value of 1 will result in the maximum amount of information, higher values will print less information. By default, the most detailed output is enabled for all diagnostic thunks. Wildcards (*) are supported in the name of the diagnostic thunk.",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "DiagnosticDetails",
                /*option*/ SubstrateOptions.DiagnosticDetails,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "DisableSubstitution": {
            return OptionDescriptor.create(
                /*name*/ "DisableSubstitution",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ com.oracle.svm.core.option.AccumulatingLocatableMultiOptionValue.Strings.class,
                /*help*/ "Disable the substitutions matched by the option value. A value can be a fully qualified method name with parameter list, a fully qualified method name without parameter list, or a fully qualified type name. When multiple methods match a value, then all matching substitutions are disabled.",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "DisableSubstitution",
                /*option*/ SubstrateOptions.DisableSubstitution,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "DisableTypeIdResultVerification": {
            return OptionDescriptor.create(
                /*name*/ "DisableTypeIdResultVerification",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "For internal purposes only. Disables type id result verification even when running with assertions enabled.",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "DisableTypeIdResultVerification",
                /*option*/ SubstrateOptions.DisableTypeIdResultVerification,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "DisableURLProtocols": {
            return OptionDescriptor.create(
                /*name*/ "DisableURLProtocols",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ com.oracle.svm.core.option.AccumulatingLocatableMultiOptionValue.Strings.class,
                /*help*/ "List of comma separated URL protocols that must never be included.",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "DisableURLProtocols",
                /*option*/ SubstrateOptions.DisableURLProtocols,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "DumpHeapAndExit": {
            return OptionDescriptor.create(
                /*name*/ "DumpHeapAndExit",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Create a heap dump and exit.",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "DumpHeapAndExit",
                /*option*/ SubstrateOptions.DumpHeapAndExit,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "DumpTargetInfo": {
            return OptionDescriptor.create(
                /*name*/ "DumpTargetInfo",
                /*optionType*/ OptionType.User,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Show native-toolchain information and image-build settings",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "DumpTargetInfo",
                /*option*/ SubstrateOptions.DumpTargetInfo,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "EnableAllSecurityServices": {
            return OptionDescriptor.create(
                /*name*/ "EnableAllSecurityServices",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Add all security service classes to the generated image.",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "EnableAllSecurityServices",
                /*option*/ SubstrateOptions.EnableAllSecurityServices,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ true,
                /*deprecationMessage*/ "");
        }
        case "EnableSignalHandling": {
            return OptionDescriptor.create(
                /*name*/ "EnableSignalHandling",
                /*optionType*/ OptionType.Expert,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Enables signal handling",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "EnableSignalHandling",
                /*option*/ SubstrateOptions.EnableSignalHandling,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "EnableURLProtocols": {
            return OptionDescriptor.create(
                /*name*/ "EnableURLProtocols",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ com.oracle.svm.core.option.AccumulatingLocatableMultiOptionValue.Strings.class,
                /*help*/ "List of comma separated URL protocols to enable.",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "EnableURLProtocols",
                /*option*/ SubstrateOptions.EnableURLProtocols,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "EnableWildcardExpansion": {
            return OptionDescriptor.create(
                /*name*/ "EnableWildcardExpansion",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Enable wildcard expansion in command line arguments on Windows.",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "EnableWildcardExpansion",
                /*option*/ SubstrateOptions.EnableWildcardExpansion,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "EntryPointNamePrefix": {
            return OptionDescriptor.create(
                /*name*/ "EntryPointNamePrefix",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ String.class,
                /*help*/ "Prefix that is added to the names of entry point methods.",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "EntryPointNamePrefix",
                /*option*/ SubstrateOptions.EntryPointNamePrefix,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "FallbackThreshold": {
            return OptionDescriptor.create(
                /*name*/ "FallbackThreshold",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Integer.class,
                /*help*/ "Define when fallback-image generation should be used.",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "FallbackThreshold",
                /*option*/ SubstrateOptions.FallbackThreshold,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "FlightRecorder": {
            return OptionDescriptor.create(
                /*name*/ "FlightRecorder",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Enable Java Flight Recorder.",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "FlightRecorder",
                /*option*/ SubstrateOptions.FlightRecorder,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "FlightRecorderLogging": {
            return OptionDescriptor.create(
                /*name*/ "FlightRecorderLogging",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ String.class,
                /*help*/ "Usage: -XX:FlightRecorderLogging=[tag1[+tag2...][*][=level][,...]]",
                /*extraHelp*/ new String[] {
                         "",
                         "When this option is not set, logging is enabled at a level of WARNING.",
                         "When this option is set to the empty string, logging is enabled at a level of INFO.",
                         "When this option is set to \"disable\", logging is disabled entirely.",
                         "",
                         "Otherwise, this option expects a comma separated list of tag combinations, each with an optional wildcard (*) and level.",
                         "A tag combination without a level is given a default level of INFO.",
                         "Messages with tags that match a given tag combination are set to log at that tag combination's level.",
                         "If a tag combination does not have a wildcard, then only messages with exactly the same tags are matched.",
                         "Otherwise, messages whose tags are a subset of the tag combination are matched.",
                         "Specifying \"all\" instead of a tag combination matches all tag combinations.",
                         "If more than one tag combination matches a message's tags, the rightmost one will apply.",
                         "Messages with tags that do not have any matching tag combinations are set to log at a default level of WARNING.",
                         "This option is case insensitive.",
                         "",
                         "Available log levels:",
                         "[trace, debug, info, warning, error, off]",
                         "",
                         "Available log tags:",
                         "[jfr, system, event, setting, bytecode, parser, metadata, dcmd]",
                              },
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "FlightRecorderLogging",
                /*option*/ SubstrateOptions.FlightRecorderLogging,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "FlightRecorderOptions": {
            return OptionDescriptor.create(
                /*name*/ "FlightRecorderOptions",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ String.class,
                /*help*/ "Usage: -XX:FlightRecorderOptions=[option[=value][,...]]",
                /*extraHelp*/ new String[] {
                         "",
                         "This option expects a comma separated list of key-value pairs. None of the options are mandatory. Possible option keys are as follows:",
                         "",
                         "globalbuffersize=512k      (Optional) Size of each global JFR buffer.",
                         "                           This value cannot be changed once JFR has been initialized.",
                         "                           The default value is determined by the value for memorysize.",
                         "",
                         "maxchunksize=12m           (Optional) Maximum size of each individual JFR data chunk.",
                         "                           This value cannot be changed once JFR has been initialized.",
                         "",
                         "memorysize=10m             (Optional) Total size of all global JFR buffers.",
                         "                           This value cannot be changed once JFR has been initialized.",
                         "",
                         "old-object-queue-size=256  (Optional) The maximum number of old objects to track when the JFR event",
                         "                           OldObjectSample is enabled.",
                         "",
                         "repository=...             (Optional) Path to the location where JFR recordings are stored until they are",
                         "                           written to a permanent file.",
                         "                           The default location is the temporary directory for the operating system.",
                         "",
                         "stackdepth=64              (Optional) Stack depth for stack traces.",
                         "                           Setting this value greater than the default may cause a performance degradation.",
                         "                           This value cannot be changed once JFR has been initialized.",
                         "",
                         "threadbuffersize=8k        (Optional) Size of each thread-local JFR buffer.",
                         "                           This value cannot be changed once JFR has been initialized.",
                         "",
                         "preserve-repository=false  (Optional) Preserve files stored in the disk repository after the process exits.",
                              },
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "FlightRecorderOptions",
                /*option*/ SubstrateOptions.FlightRecorderOptions,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "FoldSecurityManagerGetter": {
            return OptionDescriptor.create(
                /*name*/ "FoldSecurityManagerGetter",
                /*optionType*/ OptionType.Expert,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Fold SecurityManager getter.",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "FoldSecurityManagerGetter",
                /*option*/ SubstrateOptions.FoldSecurityManagerGetter,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "ForeignAPISupport": {
            return OptionDescriptor.create(
                /*name*/ "ForeignAPISupport",
                /*optionType*/ OptionType.Expert,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Support for calls via the Java Foreign Function and Memory API",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "ForeignAPISupport",
                /*option*/ SubstrateOptions.ForeignAPISupport,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "GenerateBuildArtifactsFile": {
            return OptionDescriptor.create(
                /*name*/ "GenerateBuildArtifactsFile",
                /*optionType*/ OptionType.User,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Create a build-artifacts.json file in the build directory. The output conforms to the JSON schema located at: docs/reference-manual/native-image/assets/build-artifacts-schema-v0.9.0.json",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "GenerateBuildArtifactsFile",
                /*option*/ SubstrateOptions.GenerateBuildArtifactsFile,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "GenerateDebugInfo": {
            return OptionDescriptor.create(
                /*name*/ "GenerateDebugInfo",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Integer.class,
                /*help*/ "Insert debug info into the generated native image or library",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "GenerateDebugInfo",
                /*option*/ SubstrateOptions.GenerateDebugInfo,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "HeapDumpDefaultFilenamePrefix": {
            return OptionDescriptor.create(
                /*name*/ "HeapDumpDefaultFilenamePrefix",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ String.class,
                /*help*/ "A prefix that is used for heap dump filenames if no heap dump filename was specified explicitly.",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "HeapDumpDefaultFilenamePrefix",
                /*option*/ SubstrateOptions.HeapDumpDefaultFilenamePrefix,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "HeapDumpOnOutOfMemoryError": {
            return OptionDescriptor.create(
                /*name*/ "HeapDumpOnOutOfMemoryError",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Dump heap to file (see HeapDumpPath) the first time the image throws java.lang.OutOfMemoryError because it ran out of Java heap.",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "HeapDumpOnOutOfMemoryError",
                /*option*/ SubstrateOptions.HeapDumpOnOutOfMemoryError,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "HeapDumpPath": {
            return OptionDescriptor.create(
                /*name*/ "HeapDumpPath",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ String.class,
                /*help*/ "Path of the file or directory in which heap dumps are created. An empty value means a default file name will be used. An existing directory means the dump will be placed in the directory and have the default file name.",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "HeapDumpPath",
                /*option*/ SubstrateOptions.HeapDumpPath,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "ImageBuildID": {
            return OptionDescriptor.create(
                /*name*/ "ImageBuildID",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ String.class,
                /*help*/ "Image Build ID is a 128-bit UUID string generated randomly, once per bundle or digest of input args when bundles are not used.",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "ImageBuildID",
                /*option*/ SubstrateOptions.ImageBuildID,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "ImageSymbolsPrefix": {
            return OptionDescriptor.create(
                /*name*/ "ImageSymbolsPrefix",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ String.class,
                /*help*/ "Common prefix used by method symbols in image.",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "ImageSymbolsPrefix",
                /*option*/ SubstrateOptions.ImageSymbolsPrefix,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "IncludeAllFromClassPath": {
            return OptionDescriptor.create(
                /*name*/ "IncludeAllFromClassPath",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Include all classes, methods, fields, and resources from the class path",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "IncludeAllFromClassPath",
                /*option*/ SubstrateOptions.IncludeAllFromClassPath,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "IncludeAllFromModule": {
            return OptionDescriptor.create(
                /*name*/ "IncludeAllFromModule",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ com.oracle.svm.core.option.AccumulatingLocatableMultiOptionValue.Strings.class,
                /*help*/ "Include all classes, methods, and fields from given modules",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "IncludeAllFromModule",
                /*option*/ SubstrateOptions.IncludeAllFromModule,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "IncludeAllFromPath": {
            return OptionDescriptor.create(
                /*name*/ "IncludeAllFromPath",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ com.oracle.svm.core.option.AccumulatingLocatableMultiOptionValue.Strings.class,
                /*help*/ "Include all classes, methods, fields, and resources from given paths",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "IncludeAllFromPath",
                /*option*/ SubstrateOptions.IncludeAllFromPath,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "IncludeDebugHelperMethods": {
            return OptionDescriptor.create(
                /*name*/ "IncludeDebugHelperMethods",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Determines if debugging-specific helper methods are embedded into the image. Those methods can be called directly from the debugger to obtain or print additional information.",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "IncludeDebugHelperMethods",
                /*option*/ SubstrateOptions.IncludeDebugHelperMethods,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "IncludeLanguageResources": {
            return OptionDescriptor.create(
                /*name*/ "IncludeLanguageResources",
                /*optionType*/ OptionType.User,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Automatically include the necessary language internal resources in the produced image.",
                /*declaringClass*/ SubstrateOptions.TruffleStableOptions.class,
                /*fieldName*/ "IncludeLanguageResources",
                /*option*/ SubstrateOptions.TruffleStableOptions.IncludeLanguageResources,
                /*stability*/ OptionStability.STABLE,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "IncludeMethodData": {
            return OptionDescriptor.create(
                /*name*/ "IncludeMethodData",
                /*optionType*/ OptionType.Expert,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Include a list of methods included in the image for runtime inspection.",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "IncludeMethodData",
                /*option*/ SubstrateOptions.IncludeMethodData,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "IncludeNodeSourcePositions": {
            return OptionDescriptor.create(
                /*name*/ "IncludeNodeSourcePositions",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Track NodeSourcePositions during runtime-compilation",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "IncludeNodeSourcePositions",
                /*option*/ SubstrateOptions.IncludeNodeSourcePositions,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "InstallExitHandlers": {
            return OptionDescriptor.create(
                /*name*/ "InstallExitHandlers",
                /*optionType*/ OptionType.User,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Provide java.lang.Terminator exit handlers",
                /*declaringClass*/ SubstrateOptions.ConcealedOptions.class,
                /*fieldName*/ "InstallExitHandlers",
                /*option*/ SubstrateOptions.ConcealedOptions.InstallExitHandlers,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "InternalSymbolsAreGlobal": {
            return OptionDescriptor.create(
                /*name*/ "InternalSymbolsAreGlobal",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Compatibility option to make symbols used for the image heap global. Using global symbols is problematic for shared libraries because the loader implicitly changes the value when the symbol is already defined in the executable loading the library. Setting this option to true preserves the broken behavior of old Native Image versions.",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "InternalSymbolsAreGlobal",
                /*option*/ SubstrateOptions.InternalSymbolsAreGlobal,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "InternalThreadStackSize": {
            return OptionDescriptor.create(
                /*name*/ "InternalThreadStackSize",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Long.class,
                /*help*/ "Deprecated, has no effect.",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "InternalThreadStackSize",
                /*option*/ SubstrateOptions.InternalThreadStackSize,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ true,
                /*deprecationMessage*/ "");
        }
        case "JNI": {
            return OptionDescriptor.create(
                /*name*/ "JNI",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Enable Java Native Interface (JNI) support.",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "JNI",
                /*option*/ SubstrateOptions.JNI,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "JNIEnhancedErrorCodes": {
            return OptionDescriptor.create(
                /*name*/ "JNIEnhancedErrorCodes",
                /*optionType*/ OptionType.User,
                /*optionValueType*/ Boolean.class,
                /*help*/ "JNI functions will return more specific error codes.",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "JNIEnhancedErrorCodes",
                /*option*/ SubstrateOptions.JNIEnhancedErrorCodes,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "JNIExportSymbols": {
            return OptionDescriptor.create(
                /*name*/ "JNIExportSymbols",
                /*optionType*/ OptionType.User,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Export Invocation API symbols.",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "JNIExportSymbols",
                /*option*/ SubstrateOptions.JNIExportSymbols,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "JNIVerboseLookupErrors": {
            return OptionDescriptor.create(
                /*name*/ "JNIVerboseLookupErrors",
                /*optionType*/ OptionType.User,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Report information about known JNI elements when lookup fails",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "JNIVerboseLookupErrors",
                /*option*/ SubstrateOptions.JNIVerboseLookupErrors,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "JVMTI": {
            return OptionDescriptor.create(
                /*name*/ "JVMTI",
                /*optionType*/ OptionType.User,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Enable JVM Tool Interface (JVMTI) support.",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "JVMTI",
                /*option*/ SubstrateOptions.JVMTI,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "JVMTIAgentLib": {
            return OptionDescriptor.create(
                /*name*/ "JVMTIAgentLib",
                /*optionType*/ OptionType.User,
                /*optionValueType*/ String.class,
                /*help*/ "Loads the specified native agent library. After the library name, a comma-separated list of options specific to the library can be used.",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "JVMTIAgentLib",
                /*option*/ SubstrateOptions.JVMTIAgentLib,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "JVMTIAgentPath": {
            return OptionDescriptor.create(
                /*name*/ "JVMTIAgentPath",
                /*optionType*/ OptionType.User,
                /*optionValueType*/ String.class,
                /*help*/ "Loads the specified native agent library specified by the absolute path name. After the library path, a comma-separated list of options specific to the library can be used.",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "JVMTIAgentPath",
                /*option*/ SubstrateOptions.JVMTIAgentPath,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "LayerCreate": {
            return OptionDescriptor.create(
                /*name*/ "LayerCreate",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ com.oracle.svm.core.option.AccumulatingLocatableMultiOptionValue.Strings.class,
                /*help*/ "Experimental: Build a Native Image layer.",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "LayerCreate",
                /*option*/ SubstrateOptions.LayerCreate,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "LayerUse": {
            return OptionDescriptor.create(
                /*name*/ "LayerUse",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ com.oracle.svm.core.option.AccumulatingLocatableMultiOptionValue.Paths.class,
                /*help*/ "Experimental: Build an image based on a Native Image layer.",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "LayerUse",
                /*option*/ SubstrateOptions.LayerUse,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "LinkerRPath": {
            return OptionDescriptor.create(
                /*name*/ "LinkerRPath",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ com.oracle.svm.core.option.AccumulatingLocatableMultiOptionValue.Strings.class,
                /*help*/ "Path passed to the linker as the -rpath (list of comma-separated directories)",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "LinkerRPath",
                /*option*/ SubstrateOptions.LinkerRPath,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "LoggingHashCodeInjection": {
            return OptionDescriptor.create(
                /*name*/ "LoggingHashCodeInjection",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Enables logging of failed hash code injection",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "LoggingHashCodeInjection",
                /*option*/ SubstrateOptions.LoggingHashCodeInjection,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "MaxDirectMemorySize": {
            return OptionDescriptor.create(
                /*name*/ "MaxDirectMemorySize",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Long.class,
                /*help*/ "Maximum total size of NIO direct-buffer allocations",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "MaxDirectMemorySize",
                /*option*/ SubstrateOptions.MaxDirectMemorySize,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "MaxInvokesInTrivialMethod": {
            return OptionDescriptor.create(
                /*name*/ "MaxInvokesInTrivialMethod",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Integer.class,
                /*help*/ "Maximum number of invokes in a method so that it is considered trivial (for testing only).",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "MaxInvokesInTrivialMethod",
                /*option*/ SubstrateOptions.MaxInvokesInTrivialMethod,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "MaxJavaStackTraceDepth": {
            return OptionDescriptor.create(
                /*name*/ "MaxJavaStackTraceDepth",
                /*optionType*/ OptionType.User,
                /*optionValueType*/ Integer.class,
                /*help*/ "The maximum number of lines in the stack trace for Java exceptions (0 means all)",
                /*declaringClass*/ SubstrateOptions.ConcealedOptions.class,
                /*fieldName*/ "MaxJavaStackTraceDepth",
                /*option*/ SubstrateOptions.ConcealedOptions.MaxJavaStackTraceDepth,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "MaxNodesAfterTrivialInlining": {
            return OptionDescriptor.create(
                /*name*/ "MaxNodesAfterTrivialInlining",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Integer.class,
                /*help*/ "The maximum number of nodes in a graph allowed after trivial inlining.",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "MaxNodesAfterTrivialInlining",
                /*option*/ SubstrateOptions.MaxNodesAfterTrivialInlining,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "MaxNodesInTrivialLeafMethod": {
            return OptionDescriptor.create(
                /*name*/ "MaxNodesInTrivialLeafMethod",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Integer.class,
                /*help*/ "Maximum number of nodes in a method so that it is considered trivial, if it does not have any invokes.",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "MaxNodesInTrivialLeafMethod",
                /*option*/ SubstrateOptions.MaxNodesInTrivialLeafMethod,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "MaxNodesInTrivialMethod": {
            return OptionDescriptor.create(
                /*name*/ "MaxNodesInTrivialMethod",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Integer.class,
                /*help*/ "Maximum number of nodes in a method so that it is considered trivial.",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "MaxNodesInTrivialMethod",
                /*option*/ SubstrateOptions.MaxNodesInTrivialMethod,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "MaxRAM": {
            return OptionDescriptor.create(
                /*name*/ "MaxRAM",
                /*optionType*/ OptionType.Expert,
                /*optionValueType*/ Long.class,
                /*help*/ "Physical memory size (in bytes). By default, the value is queried from the OS/container during VM startup.",
                /*declaringClass*/ SubstrateOptions.ConcealedOptions.class,
                /*fieldName*/ "MaxRAM",
                /*option*/ SubstrateOptions.ConcealedOptions.MaxRAM,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "MaxUnrolledObjectZeroingStores": {
            return OptionDescriptor.create(
                /*name*/ "MaxUnrolledObjectZeroingStores",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Integer.class,
                /*help*/ "Define the maximum number of stores for which the loop that zeroes out objects is unrolled.",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "MaxUnrolledObjectZeroingStores",
                /*option*/ SubstrateOptions.MaxUnrolledObjectZeroingStores,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "Method": {
            return OptionDescriptor.create(
                /*name*/ "Method",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ String.class,
                /*help*/ "Name of the main entry point method. Optional if --shared is used.",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "Method",
                /*option*/ SubstrateOptions.Method,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "MissingRegistrationReportingMode": {
            return OptionDescriptor.create(
                /*name*/ "MissingRegistrationReportingMode",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ com.oracle.svm.core.SubstrateOptions.ReportingMode.class,
                /*help*/ "Select the mode in which the missing reflection registrations will be reported.",
                /*extraHelp*/ new String[] {
                         "Possible values are:",
                         "\"Throw\" (default): Throw a MissingReflectionRegistrationError;",
                         "\"Exit\": Call System.exit() to avoid accidentally catching the error;",
                         "\"Warn\": Print a message to stdout, including a stack trace to see what caused the issue.",
                              },
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "MissingRegistrationReportingMode",
                /*option*/ SubstrateOptions.MissingRegistrationReportingMode,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "MissingRegistrationWarnContextLines": {
            return OptionDescriptor.create(
                /*name*/ "MissingRegistrationWarnContextLines",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Integer.class,
                /*help*/ "Number of context lines printed for each missing registration error in Warn mode",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "MissingRegistrationWarnContextLines",
                /*option*/ SubstrateOptions.MissingRegistrationWarnContextLines,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "Module": {
            return OptionDescriptor.create(
                /*name*/ "Module",
                /*optionType*/ OptionType.User,
                /*optionValueType*/ String.class,
                /*help*/ "Module containing the class that contains the main entry point. Optional if --shared is used.",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "Module",
                /*option*/ SubstrateOptions.Module,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "MremapImageHeap": {
            return OptionDescriptor.create(
                /*name*/ "MremapImageHeap",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Enable fallback to mremap for initializing the image heap.",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "MremapImageHeap",
                /*option*/ SubstrateOptions.MremapImageHeap,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "MultiThreaded": {
            return OptionDescriptor.create(
                /*name*/ "MultiThreaded",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Deprecated, has no effect.",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "MultiThreaded",
                /*option*/ SubstrateOptions.MultiThreaded,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ true,
                /*deprecationMessage*/ "");
        }
        case "Name": {
            return OptionDescriptor.create(
                /*name*/ "Name",
                /*optionType*/ OptionType.User,
                /*optionValueType*/ String.class,
                /*help*/ "Name of the output file to be generated",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "Name",
                /*option*/ SubstrateOptions.Name,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "NeverInline": {
            return OptionDescriptor.create(
                /*name*/ "NeverInline",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ com.oracle.svm.core.option.AccumulatingLocatableMultiOptionValue.Strings.class,
                /*help*/ "Pattern for disabling inlining of methods during image generation.",
                /*extraHelp*/ new String[] {
                         "The syntax for a pattern is:",
                         "",
                         "  SourcePatterns = SourcePattern [\",\" SourcePatterns] .",
                         "  SourcePattern = [ Class \".\" ] method [ \"(\" [ Parameter { \";\" Parameter } ] \")\" ] .",
                         "  Parameter = Class | \"int\" | \"long\" | \"float\" | \"double\" | \"short\" | \"char\" | \"boolean\" .",
                         "  Class = { package \".\" } class .",
                         "",
                         "Glob pattern matching (*, ?) is allowed in all parts of the source pattern.",
                         "",
                         "Examples of method filters:",
                         "---------",
                         "  visit(Argument;BlockScope)",
                         "",
                         "  Matches all methods named \"visit\", with the first parameter of",
                         "  type \"Argument\", and the second parameter of type \"BlockScope\".",
                         "  The packages of the parameter types are irrelevant.",
                         "---------",
                         "  arraycopy(Object;;;;)",
                         "",
                         "  Matches all methods named \"arraycopy\", with the first parameter",
                         "  of type \"Object\", and four more parameters of any type. The",
                         "  packages of the parameter types are irrelevant.",
                         "---------",
                         "  jdk.graal.compiler.core.graph.PostOrderNodeIterator.*",
                         "",
                         "  Matches all methods in the class \"jdk.graal.compiler.core.graph.PostOrderNodeIterator\".",
                         "---------",
                         "  *",
                         "",
                         "  Matches all methods in all classes",
                         "---------",
                         "  jdk.graal.compiler.core.graph.*.visit",
                         "",
                         "  Matches all methods named \"visit\" in classes in the package",
                         "  \"jdk.graal.compiler.core.graph\".",
                         "---------",
                         "  arraycopy,toString",
                         "",
                         "  Matches all methods named \"arraycopy\" or \"toString\", meaning that ',' acts as an or operator.",
                              },
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "NeverInline",
                /*option*/ SubstrateOptions.NeverInline,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "NoDirectRelocationsInText": {
            return OptionDescriptor.create(
                /*name*/ "NoDirectRelocationsInText",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Force no direct relocations to be present in the text section of the generated image",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "NoDirectRelocationsInText",
                /*option*/ SubstrateOptions.NoDirectRelocationsInText,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "OmitInlinedMethodDebugLineInfo": {
            return OptionDescriptor.create(
                /*name*/ "OmitInlinedMethodDebugLineInfo",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Omit generation of DebugLineInfo originating from inlined methods",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "OmitInlinedMethodDebugLineInfo",
                /*option*/ SubstrateOptions.OmitInlinedMethodDebugLineInfo,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "Optimize": {
            return OptionDescriptor.create(
                /*name*/ "Optimize",
                /*optionType*/ OptionType.User,
                /*optionValueType*/ String.class,
                /*help*/ "Control code optimizations: b - optimize for fastest build time, s - optimize for size, 0 - no optimizations, 1 - basic optimizations, 2 - advanced optimizations, 3 - all optimizations for best performance.",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "Optimize",
                /*option*/ SubstrateOptions.Optimize,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "PageSize": {
            return OptionDescriptor.create(
                /*name*/ "PageSize",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Integer.class,
                /*help*/ "The largest page size of machines that can run the image. The default of 0 automatically selects a typically suitable value.",
                /*declaringClass*/ SubstrateOptions.ConcealedOptions.class,
                /*fieldName*/ "PageSize",
                /*option*/ SubstrateOptions.ConcealedOptions.PageSize,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "ParseOnce": {
            return OptionDescriptor.create(
                /*name*/ "ParseOnce",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Deprecated, option no longer has any effect.",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "ParseOnce",
                /*option*/ SubstrateOptions.ParseOnce,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ true,
                /*deprecationMessage*/ "It no longer has any effect, and no replacement is available");
        }
        case "ParseOnceJIT": {
            return OptionDescriptor.create(
                /*name*/ "ParseOnceJIT",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Deprecated, option no longer has any effect.",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "ParseOnceJIT",
                /*option*/ SubstrateOptions.ParseOnceJIT,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ true,
                /*deprecationMessage*/ "It no longer has any effect, and no replacement is available");
        }
        case "ParseRuntimeOptions": {
            return OptionDescriptor.create(
                /*name*/ "ParseRuntimeOptions",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Parse and consume standard options and system properties from the command line arguments when the VM is created.",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "ParseRuntimeOptions",
                /*option*/ SubstrateOptions.ParseRuntimeOptions,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "Path": {
            return OptionDescriptor.create(
                /*name*/ "Path",
                /*optionType*/ OptionType.User,
                /*optionValueType*/ String.class,
                /*help*/ "Directory of the image file to be generated",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "Path",
                /*option*/ SubstrateOptions.Path,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "PinnedObjectAddressing": {
            return OptionDescriptor.create(
                /*name*/ "PinnedObjectAddressing",
                /*optionType*/ OptionType.Expert,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Allows the addresses of pinned objects to be passed to other code.",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "PinnedObjectAddressing",
                /*option*/ SubstrateOptions.PinnedObjectAddressing,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "PreserveFramePointer": {
            return OptionDescriptor.create(
                /*name*/ "PreserveFramePointer",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Saves stack base pointer on the stack on method entry.",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "PreserveFramePointer",
                /*option*/ SubstrateOptions.PreserveFramePointer,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "ReduceImplicitExceptionStackTraceInformation": {
            return OptionDescriptor.create(
                /*name*/ "ReduceImplicitExceptionStackTraceInformation",
                /*optionType*/ OptionType.Expert,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Reduce the amount of metadata in the image for implicit exceptions by removing inlining information from the stack trace. This makes the image smaller, but also the stack trace of implicit exceptions less precise.",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "ReduceImplicitExceptionStackTraceInformation",
                /*option*/ SubstrateOptions.ReduceImplicitExceptionStackTraceInformation,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "RemoveUnusedSymbols": {
            return OptionDescriptor.create(
                /*name*/ "RemoveUnusedSymbols",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Use linker option to prevent unreferenced symbols in image.",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "RemoveUnusedSymbols",
                /*option*/ SubstrateOptions.RemoveUnusedSymbols,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "ReportAnalysisForbiddenType": {
            return OptionDescriptor.create(
                /*name*/ "ReportAnalysisForbiddenType",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ com.oracle.svm.core.option.AccumulatingLocatableMultiOptionValue.Strings.class,
                /*help*/ "Report error if <typename>[:<UsageKind>{,<UsageKind>}] is discovered during analysis (valid values for UsageKind: Reachable, Instantiated).",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "ReportAnalysisForbiddenType",
                /*option*/ SubstrateOptions.ReportAnalysisForbiddenType,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "RunMainInNewThread": {
            return OptionDescriptor.create(
                /*name*/ "RunMainInNewThread",
                /*optionType*/ OptionType.Expert,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Initializes and runs main entry point in a new native thread.",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "RunMainInNewThread",
                /*option*/ SubstrateOptions.RunMainInNewThread,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "RunReachabilityHandlersConcurrently": {
            return OptionDescriptor.create(
                /*name*/ "RunReachabilityHandlersConcurrently",
                /*optionType*/ OptionType.Expert,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Run reachability handlers concurrently during analysis.",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "RunReachabilityHandlersConcurrently",
                /*option*/ SubstrateOptions.RunReachabilityHandlersConcurrently,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ true,
                /*deprecationMessage*/ "This option was introduced to simplify migration to GraalVM 22.2 and will be removed in a future release");
        }
        case "SharedLibrary": {
            return OptionDescriptor.create(
                /*name*/ "SharedLibrary",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Build shared library",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "SharedLibrary",
                /*option*/ SubstrateOptions.SharedLibrary,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "SourceLevelDebug": {
            return OptionDescriptor.create(
                /*name*/ "SourceLevelDebug",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Preserve the local variable information for every Java source line to allow line-by-line stepping in the debugger. Allow the lookup of Java-level method information, e.g., in stack traces.",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "SourceLevelDebug",
                /*option*/ SubstrateOptions.SourceLevelDebug,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "SourceLevelDebugFilter": {
            return OptionDescriptor.create(
                /*name*/ "SourceLevelDebugFilter",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ com.oracle.svm.core.option.AccumulatingLocatableMultiOptionValue.Strings.class,
                /*help*/ "Constrain debug info generation to the comma-separated list of package prefixes given to this option.",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "SourceLevelDebugFilter",
                /*option*/ SubstrateOptions.SourceLevelDebugFilter,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "SpawnIsolates": {
            return OptionDescriptor.create(
                /*name*/ "SpawnIsolates",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Support multiple isolates.",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "SpawnIsolates",
                /*option*/ SubstrateOptions.SpawnIsolates,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ true,
                /*deprecationMessage*/ "This option disables a major feature of GraalVM Native Image and will be removed in a future release");
        }
        case "StackSize": {
            return OptionDescriptor.create(
                /*name*/ "StackSize",
                /*optionType*/ OptionType.User,
                /*optionValueType*/ Long.class,
                /*help*/ "The size of each thread stack at run-time, in bytes.",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "StackSize",
                /*option*/ SubstrateOptions.StackSize,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "StackTrace": {
            return OptionDescriptor.create(
                /*name*/ "StackTrace",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Deprecated, has no effect.",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "StackTrace",
                /*option*/ SubstrateOptions.StackTrace,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ true,
                /*deprecationMessage*/ "");
        }
        case "StartFlightRecording": {
            return OptionDescriptor.create(
                /*name*/ "StartFlightRecording",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ String.class,
                /*help*/ "Start a flight recording by passing a comma-separated list of key-value pairs.",
                /*extraHelp*/ new String[] {
                         "",
                         "Usage: -XX:StartFlightRecording=[key[=value][,...]]",
                         "",
                         "The following key-value pairs are supported:",
                         "",
                         "name       (Optional) Specify a name to identify the recording, for example, `name=MyRecording` to identify the recording, for example, \"name=MyRecording\".",
                         "",
                         "settings   (Optional) Specify a settings file (profile.jfc, default.jfc, etc.), for example, \"settings=myprofile.jfc\".",
                         "",
                         "delay      (Optional) Delay recording start with (s)econds, (m)inutes, (h)ours, or (d)ays, for example, \"delay=5h\".",
                         "",
                         "duration   (Optional) Duration of recording in (s)econds, (m)inutes, (h)ours, or (d)ays for example, \"duration=300s\". Default: 0 (infinite).",
                         "",
                         "filename   (Optional) Specify a resulting recording filename, for example, \"filename=recording1.jfr\".",
                         "",
                         "maxage     (Optional) Maximum time to keep the recorded data on disk in (s)econds, (m)inutes, (h)ours, or (d)ays, e.g., 60m, or 0 for no limit, for example, \"maxage=1d\". Default: 0 (no limit).",
                         "",
                         "maxsize    (Optional) Maximum amount of bytes to keep on disk in (k)B, (M)B or (G)B, or 0 for no limit, for example, 500M, or 0 for no limit, for example, \"maxsize=1G\". Default: 0 (no limit).",
                         "",
                         "dumponexit (Optional) Whether to dump a running recording when the JVM shuts down, for example, \"dumponexit=true\". Default: false.",
                              },
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "StartFlightRecording",
                /*option*/ SubstrateOptions.StartFlightRecording,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "StaticExecutable": {
            return OptionDescriptor.create(
                /*name*/ "StaticExecutable",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Build statically linked executable (requires static libc and zlib)",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "StaticExecutable",
                /*option*/ SubstrateOptions.StaticExecutable,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "StaticExecutableWithDynamicLibC": {
            return OptionDescriptor.create(
                /*name*/ "StaticExecutableWithDynamicLibC",
                /*optionType*/ OptionType.Expert,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Build statically linked executable with libc dynamically linked",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "StaticExecutableWithDynamicLibC",
                /*option*/ SubstrateOptions.StaticExecutableWithDynamicLibC,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "StaticLibStdCpp": {
            return OptionDescriptor.create(
                /*name*/ "StaticLibStdCpp",
                /*optionType*/ OptionType.Expert,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Builds image with libstdc++ statically linked into the image (if needed)",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "StaticLibStdCpp",
                /*option*/ SubstrateOptions.StaticLibStdCpp,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "StrictQueryCodeCompilation": {
            return OptionDescriptor.create(
                /*name*/ "StrictQueryCodeCompilation",
                /*optionType*/ OptionType.User,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Use strict checks when performing query code compilation.",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "StrictQueryCodeCompilation",
                /*option*/ SubstrateOptions.StrictQueryCodeCompilation,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "StripDebugInfo": {
            return OptionDescriptor.create(
                /*name*/ "StripDebugInfo",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Use a separate file for debug info.",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "StripDebugInfo",
                /*option*/ SubstrateOptions.StripDebugInfo,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "SupportCompileInIsolates": {
            return OptionDescriptor.create(
                /*name*/ "SupportCompileInIsolates",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Support runtime compilation in separate isolates (enable at runtime with option CompileInIsolates).",
                /*declaringClass*/ SubstrateOptions.ConcealedOptions.class,
                /*fieldName*/ "SupportCompileInIsolates",
                /*option*/ SubstrateOptions.ConcealedOptions.SupportCompileInIsolates,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "SupportedGCs": {
            return OptionDescriptor.create(
                /*name*/ "SupportedGCs",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ com.oracle.svm.core.option.ReplacingLocatableMultiOptionValue.DelimitedString.class,
                /*help*/ "Please use '--gc=*' instead. Possible values are listed with '--help'.",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "SupportedGCs",
                /*option*/ SubstrateOptions.SupportedGCs,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "TargetPlatform": {
            return OptionDescriptor.create(
                /*name*/ "TargetPlatform",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ String.class,
                /*help*/ "Selects native-image compilation target (in <OS>-<architecture> format). Defaults to host's OS-architecture pair.",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "TargetPlatform",
                /*option*/ SubstrateOptions.TargetPlatform,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "TearDownFailureNanos": {
            return OptionDescriptor.create(
                /*name*/ "TearDownFailureNanos",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Long.class,
                /*help*/ "The number of nanoseconds before tearing down an isolate gives a failure message.  0 implies no message.",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "TearDownFailureNanos",
                /*option*/ SubstrateOptions.TearDownFailureNanos,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "TearDownWarningNanos": {
            return OptionDescriptor.create(
                /*name*/ "TearDownWarningNanos",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Long.class,
                /*help*/ "The number of nanoseconds before and between which tearing down an isolate gives a warning message.  0 implies no warning.",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "TearDownWarningNanos",
                /*option*/ SubstrateOptions.TearDownWarningNanos,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "ThrowLinkAtBuildTimeIOExceptions": {
            return OptionDescriptor.create(
                /*name*/ "ThrowLinkAtBuildTimeIOExceptions",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Instead of warning, throw IOExceptions for link-at-build-time resources at build time",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "ThrowLinkAtBuildTimeIOExceptions",
                /*option*/ SubstrateOptions.ThrowLinkAtBuildTimeIOExceptions,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "ThrowMissingRegistrationErrors": {
            return OptionDescriptor.create(
                /*name*/ "ThrowMissingRegistrationErrors",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ com.oracle.svm.core.option.AccumulatingLocatableMultiOptionValue.Strings.class,
                /*help*/ "Enables exact and user-friendly handling of reflection, resources, JNI, and serialization.",
                /*extraHelp*/ new String[] {
                         "When reachability metadata for an element is specified, the native executable will have expected and predictable behavior.",
                         "When reachability metadata for an element is not specified, the binary will fail fast with a subtype of `java.lang.Error`",
                         " that explains exactly which element was missing. The errors can happen on reflection, resource, JNI, and serialization accesses.",
                         "",
                         "Note: '--exact-reachability-metadata' will become the default in future versions of Native Image. It is recommended to adopt the mode early",
                         " to avoid breakage during migration to newer GraalVM versions.",
                         "",
                         "If errors occur in third-party code, exact reachability metadata can be applied only to a single package with",
                         " '--exact-reachability-metadata=pkg'. To apply to whole jars, modules, and class-path entries please use",
                         " '--exact-reachability-metadata-path'. Using '--exact-reachability-metadata=<pkg>' with arguments is allowed in every scope:",
                         "",
                         "  1. On command line",
                         "  2. Embedded in a 'native-image.properties' file of some zip/jar file on module-path",
                         "  3. Embedded in a 'native-image.properties' file of some zip/jar file on class-path",
                         "",
                         "If used without arguments (only '--exact-reachability-metadata'), the errors will be thrown when calling the corresponding query from any",
                         " class in scope of the option. Using '--exact-reachability-metadata' without arguments is only allowed on command line or when",
                         " embedded in a 'native-image.properties' file of some zip/jar file on the module-path (but not on class-path).",
                         " In the module path case, the option will cause all classes of the module to trigger missing registration errors.",
                         " If used without arguments on command line all classes will trigger missing registration errors.",
                         "",
                         "If the option is embedded in 'native-image.properties' file in some zip/jar file all class-names",
                         "and package-names passed to the option have to be found in the zip/jar files the option is embedded",
                         "in. Using '--exact-reachability-metadata' with arguments on command line does not have that restriction.",
                              },
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "ThrowMissingRegistrationErrors",
                /*option*/ SubstrateOptions.ThrowMissingRegistrationErrors,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "ThrowMissingRegistrationErrorsPaths": {
            return OptionDescriptor.create(
                /*name*/ "ThrowMissingRegistrationErrorsPaths",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ com.oracle.svm.core.option.AccumulatingLocatableMultiOptionValue.Strings.class,
                /*help*/ "Trigger exact handling of reflection, resources, JNI, and serialization from all types in the given class-path or module-path entries.",
                /*extraHelp*/ new String[] {
                         "",
                         "This option requires arguments that are of the same type as the arguments passed via -p (--module-path) or -cp (--class-path):",
                         "",
                         "  --exact-reachability-metadata-path <class-search path of directories and jar files>",
                         "",
                         "The given entries are searched and all classes inside are registered as '--exact-reachability-metadata' classes.",
                         "",
                         "This option is only allowed to be used on command line. The option will be rejected if it is provided",
                         "by 'Args' in a 'native-image.properties' file that is embedded in a jar file.",
                              },
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "ThrowMissingRegistrationErrorsPaths",
                /*option*/ SubstrateOptions.ThrowMissingRegistrationErrorsPaths,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "TraceClassInitialization": {
            return OptionDescriptor.create(
                /*name*/ "TraceClassInitialization",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ com.oracle.svm.core.option.AccumulatingLocatableMultiOptionValue.Strings.class,
                /*help*/ "Comma-separated list of fully-qualified class names that class initialization is traced for.",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "TraceClassInitialization",
                /*option*/ SubstrateOptions.TraceClassInitialization,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ true,
                /*deprecationMessage*/ "This option is not required anymore with the strict image heap enabled by default.");
        }
        case "TraceNativeToolUsage": {
            return OptionDescriptor.create(
                /*name*/ "TraceNativeToolUsage",
                /*optionType*/ OptionType.User,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Trace all native tool invocations as part of image building",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "TraceNativeToolUsage",
                /*option*/ SubstrateOptions.TraceNativeToolUsage,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "TraceObjectInstantiation": {
            return OptionDescriptor.create(
                /*name*/ "TraceObjectInstantiation",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ com.oracle.svm.core.option.AccumulatingLocatableMultiOptionValue.Strings.class,
                /*help*/ "Comma-separated list of fully-qualified class names that object instantiation is traced for.",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "TraceObjectInstantiation",
                /*option*/ SubstrateOptions.TraceObjectInstantiation,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "TraceVMOperations": {
            return OptionDescriptor.create(
                /*name*/ "TraceVMOperations",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Trace VMOperation execution.",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "TraceVMOperations",
                /*option*/ SubstrateOptions.TraceVMOperations,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "UnlockExperimentalVMOptions": {
            return OptionDescriptor.create(
                /*name*/ "UnlockExperimentalVMOptions",
                /*optionType*/ OptionType.Expert,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Enable and disable normal processing of flags relating to experimental options.",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "UnlockExperimentalVMOptions",
                /*option*/ SubstrateOptions.UnlockExperimentalVMOptions,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "UseBaseLayerInclusionPolicy": {
            return OptionDescriptor.create(
                /*name*/ "UseBaseLayerInclusionPolicy",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Force include include all public types and methods that can be reached using normal Java access rules.",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "UseBaseLayerInclusionPolicy",
                /*option*/ SubstrateOptions.UseBaseLayerInclusionPolicy,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "UseCalleeSavedRegisters": {
            return OptionDescriptor.create(
                /*name*/ "UseCalleeSavedRegisters",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Use callee saved registers to reduce spilling for low-frequency calls to stubs (if callee saved registers are supported by the architecture)",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "UseCalleeSavedRegisters",
                /*option*/ SubstrateOptions.UseCalleeSavedRegisters,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "UseContainerSupport": {
            return OptionDescriptor.create(
                /*name*/ "UseContainerSupport",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Enable detection and runtime container configuration support.",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "UseContainerSupport",
                /*option*/ SubstrateOptions.UseContainerSupport,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "UseDedicatedVMOperationThread": {
            return OptionDescriptor.create(
                /*name*/ "UseDedicatedVMOperationThread",
                /*optionType*/ OptionType.Expert,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Determines if VM operations should be executed in a dedicated thread.",
                /*declaringClass*/ SubstrateOptions.ConcealedOptions.class,
                /*fieldName*/ "UseDedicatedVMOperationThread",
                /*option*/ SubstrateOptions.ConcealedOptions.UseDedicatedVMOperationThread,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "UseDirectCallTrampolinesALot": {
            return OptionDescriptor.create(
                /*name*/ "UseDirectCallTrampolinesALot",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Force many trampolines to be needed for inter-method calls. Normally trampolines are only used when a method destination is outside the range of a pc-relative branch instruction.",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "UseDirectCallTrampolinesALot",
                /*option*/ SubstrateOptions.UseDirectCallTrampolinesALot,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "UseEpsilonGC": {
            return OptionDescriptor.create(
                /*name*/ "UseEpsilonGC",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Use a no-op GC",
                /*declaringClass*/ SubstrateOptions.DeprecatedOptions.class,
                /*fieldName*/ "UseEpsilonGC",
                /*option*/ SubstrateOptions.DeprecatedOptions.UseEpsilonGC,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ true,
                /*deprecationMessage*/ "Please use '--gc=epsilon' instead");
        }
        case "UseImagebuildDebugSections": {
            return OptionDescriptor.create(
                /*name*/ "UseImagebuildDebugSections",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Emit debuginfo debug.svm.imagebuild.* sections with detailed image-build options.",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "UseImagebuildDebugSections",
                /*option*/ SubstrateOptions.UseImagebuildDebugSections,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "UseLibC": {
            return OptionDescriptor.create(
                /*name*/ "UseLibC",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ String.class,
                /*help*/ "Selects the libc implementation to use. Available implementations: glibc, musl, bionic",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "UseLibC",
                /*option*/ SubstrateOptions.UseLibC,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "UseNullRegion": {
            return OptionDescriptor.create(
                /*name*/ "UseNullRegion",
                /*optionType*/ OptionType.Expert,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Determines if a null region is present between the heap base and the image heap.",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "UseNullRegion",
                /*option*/ SubstrateOptions.UseNullRegion,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "UseOldMethodHandleIntrinsics": {
            return OptionDescriptor.create(
                /*name*/ "UseOldMethodHandleIntrinsics",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Deprecated, option no longer has any effect.",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "UseOldMethodHandleIntrinsics",
                /*option*/ SubstrateOptions.UseOldMethodHandleIntrinsics,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ true,
                /*deprecationMessage*/ "It no longer has any effect, and no replacement is available");
        }
        case "UsePerfData": {
            return OptionDescriptor.create(
                /*name*/ "UsePerfData",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Flag to disable jvmstat instrumentation for performance testing.",
                /*declaringClass*/ SubstrateOptions.ConcealedOptions.class,
                /*fieldName*/ "UsePerfData",
                /*option*/ SubstrateOptions.ConcealedOptions.UsePerfData,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "UseSerialGC": {
            return OptionDescriptor.create(
                /*name*/ "UseSerialGC",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Use a serial GC",
                /*declaringClass*/ SubstrateOptions.DeprecatedOptions.class,
                /*fieldName*/ "UseSerialGC",
                /*option*/ SubstrateOptions.DeprecatedOptions.UseSerialGC,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ true,
                /*deprecationMessage*/ "Please use '--gc=serial' instead");
        }
        case "UseSharedLayerGraphs": {
            return OptionDescriptor.create(
                /*name*/ "UseSharedLayerGraphs",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Persist and reload graphs across layers. If false, graphs defined in the base layer can be reparsed by the current layer and inlined before analysis, but will not be inlined after analysis has completed via our other inlining infrastructure",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "UseSharedLayerGraphs",
                /*option*/ SubstrateOptions.UseSharedLayerGraphs,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "UseSystemLocale": {
            return OptionDescriptor.create(
                /*name*/ "UseSystemLocale",
                /*optionType*/ OptionType.Expert,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Determines if the system locale should be used at run-time. If this is disabled, the locale 'en-US' will be used instead.",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "UseSystemLocale",
                /*option*/ SubstrateOptions.UseSystemLocale,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "VectorAPISupport": {
            return OptionDescriptor.create(
                /*name*/ "VectorAPISupport",
                /*optionType*/ OptionType.Expert,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Support for intrinsics from the Java Vector API",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "VectorAPISupport",
                /*option*/ SubstrateOptions.VectorAPISupport,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "VerifyFrameAccess": {
            return OptionDescriptor.create(
                /*name*/ "VerifyFrameAccess",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Determines if frame accesses are verified at run-time.",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "VerifyFrameAccess",
                /*option*/ SubstrateOptions.VerifyFrameAccess,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "VerifyFrameAnchors": {
            return OptionDescriptor.create(
                /*name*/ "VerifyFrameAnchors",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Determines if frame anchors are verified at run-time.",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "VerifyFrameAnchors",
                /*option*/ SubstrateOptions.VerifyFrameAnchors,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "VerifyNamingConventions": {
            return OptionDescriptor.create(
                /*name*/ "VerifyNamingConventions",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Verify naming conventions during image construction.",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "VerifyNamingConventions",
                /*option*/ SubstrateOptions.VerifyNamingConventions,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "VerifyTypes": {
            return OptionDescriptor.create(
                /*name*/ "VerifyTypes",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Verify type states computed by the static analysis at run time. This is useful when diagnosing problems in the static analysis, but reduces peak performance significantly.",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "VerifyTypes",
                /*option*/ SubstrateOptions.VerifyTypes,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "ZapNativeMemory": {
            return OptionDescriptor.create(
                /*name*/ "ZapNativeMemory",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Fill unused and freed native memory with sentinel values. Needs NMT.",
                /*declaringClass*/ SubstrateOptions.class,
                /*fieldName*/ "ZapNativeMemory",
                /*option*/ SubstrateOptions.ZapNativeMemory,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        // CheckStyle: resume line length check
        }
        return null;
    }

    @Override
    public Iterator<OptionDescriptor> iterator() {
        return new Iterator<>() {
            int i = 0;
            @Override
            public boolean hasNext() {
                return i < 175;
            }
            @Override
            public OptionDescriptor next() {
                switch (i++) {
                    case 0: return get("AOTInline");
                    case 1: return get("AOTTrivialInline");
                    case 2: return get("APIFunctionPrefix");
                    case 3: return get("AbortOnNameConflict");
                    case 4: return get("ActiveProcessorCount");
                    case 5: return get("AdditionalHeaderBytes");
                    case 6: return get("AllocateInstancePrefetchLines");
                    case 7: return get("AllocatePrefetchDistance");
                    case 8: return get("AllocatePrefetchInstr");
                    case 9: return get("AllocatePrefetchLines");
                    case 10: return get("AllocatePrefetchStepSize");
                    case 11: return get("AllocatePrefetchStyle");
                    case 12: return get("AllowDeprecatedBuilderClassesOnImageClasspath");
                    case 13: return get("AllowUnsafeAllocationOfAllInstantiatedTypes");
                    case 14: return get("AllowVMInternalThreads");
                    case 15: return get("ApplicationLayerOnlySingletons");
                    case 16: return get("AsyncSignalSafeDiagnostics");
                    case 17: return get("AutomaticReferenceHandling");
                    case 18: return get("BuildOutputBreakdowns");
                    case 19: return get("BuildOutputColorful");
                    case 20: return get("BuildOutputGCWarnings");
                    case 21: return get("BuildOutputJSONFile");
                    case 22: return get("BuildOutputLinks");
                    case 23: return get("BuildOutputNativeImageOptionsEnvVarValue");
                    case 24: return get("BuildOutputPrefix");
                    case 25: return get("BuildOutputProgress");
                    case 26: return get("BuildOutputRecommendations");
                    case 27: return get("BuildOutputSilent");
                    case 28: return get("CCompilerOption");
                    case 29: return get("CCompilerPath");
                    case 30: return get("CLibraryPath");
                    case 31: return get("CheckBootModuleDependencies");
                    case 32: return get("CheckIsolateThreadAtEntry");
                    case 33: return get("CheckToolchain");
                    case 34: return get("Class");
                    case 35: return get("ClosedTypeWorld");
                    case 36: return get("ClosedTypeWorldHubLayout");
                    case 37: return get("CodeAlignment");
                    case 38: return get("Color");
                    case 39: return get("CompilationIsolateAddressSpaceSize");
                    case 40: return get("CompilationIsolateOptions");
                    case 41: return get("CompileInIsolates");
                    case 42: return get("CompilerBackend");
                    case 43: return get("ConfigureReflectionMetadata");
                    case 44: return get("ContendedPaddingWidth");
                    case 45: return get("CopyLanguageResources");
                    case 46: return get("DeadlockWatchdogExitOnTimeout");
                    case 47: return get("DeadlockWatchdogInterval");
                    case 48: return get("DebugCodeInfoMaxDepth");
                    case 49: return get("DebugCodeInfoUseSourceMappings");
                    case 50: return get("DebugInfoSourceCacheRoot");
                    case 51: return get("DeleteLocalSymbols");
                    case 52: return get("DetectUserDirectoriesInImageHeap");
                    case 53: return get("DiagnosticBufferSize");
                    case 54: return get("DiagnosticDetails");
                    case 55: return get("DisableSubstitution");
                    case 56: return get("DisableTypeIdResultVerification");
                    case 57: return get("DisableURLProtocols");
                    case 58: return get("DumpHeapAndExit");
                    case 59: return get("DumpTargetInfo");
                    case 60: return get("EnableAllSecurityServices");
                    case 61: return get("EnableSignalHandling");
                    case 62: return get("EnableURLProtocols");
                    case 63: return get("EnableWildcardExpansion");
                    case 64: return get("EntryPointNamePrefix");
                    case 65: return get("FallbackThreshold");
                    case 66: return get("FlightRecorder");
                    case 67: return get("FlightRecorderLogging");
                    case 68: return get("FlightRecorderOptions");
                    case 69: return get("FoldSecurityManagerGetter");
                    case 70: return get("ForeignAPISupport");
                    case 71: return get("GenerateBuildArtifactsFile");
                    case 72: return get("GenerateDebugInfo");
                    case 73: return get("HeapDumpDefaultFilenamePrefix");
                    case 74: return get("HeapDumpOnOutOfMemoryError");
                    case 75: return get("HeapDumpPath");
                    case 76: return get("ImageBuildID");
                    case 77: return get("ImageSymbolsPrefix");
                    case 78: return get("IncludeAllFromClassPath");
                    case 79: return get("IncludeAllFromModule");
                    case 80: return get("IncludeAllFromPath");
                    case 81: return get("IncludeDebugHelperMethods");
                    case 82: return get("IncludeLanguageResources");
                    case 83: return get("IncludeMethodData");
                    case 84: return get("IncludeNodeSourcePositions");
                    case 85: return get("InstallExitHandlers");
                    case 86: return get("InternalSymbolsAreGlobal");
                    case 87: return get("InternalThreadStackSize");
                    case 88: return get("JNI");
                    case 89: return get("JNIEnhancedErrorCodes");
                    case 90: return get("JNIExportSymbols");
                    case 91: return get("JNIVerboseLookupErrors");
                    case 92: return get("JVMTI");
                    case 93: return get("JVMTIAgentLib");
                    case 94: return get("JVMTIAgentPath");
                    case 95: return get("LayerCreate");
                    case 96: return get("LayerUse");
                    case 97: return get("LinkerRPath");
                    case 98: return get("LoggingHashCodeInjection");
                    case 99: return get("MaxDirectMemorySize");
                    case 100: return get("MaxInvokesInTrivialMethod");
                    case 101: return get("MaxJavaStackTraceDepth");
                    case 102: return get("MaxNodesAfterTrivialInlining");
                    case 103: return get("MaxNodesInTrivialLeafMethod");
                    case 104: return get("MaxNodesInTrivialMethod");
                    case 105: return get("MaxRAM");
                    case 106: return get("MaxUnrolledObjectZeroingStores");
                    case 107: return get("Method");
                    case 108: return get("MissingRegistrationReportingMode");
                    case 109: return get("MissingRegistrationWarnContextLines");
                    case 110: return get("Module");
                    case 111: return get("MremapImageHeap");
                    case 112: return get("MultiThreaded");
                    case 113: return get("Name");
                    case 114: return get("NeverInline");
                    case 115: return get("NoDirectRelocationsInText");
                    case 116: return get("OmitInlinedMethodDebugLineInfo");
                    case 117: return get("Optimize");
                    case 118: return get("PageSize");
                    case 119: return get("ParseOnce");
                    case 120: return get("ParseOnceJIT");
                    case 121: return get("ParseRuntimeOptions");
                    case 122: return get("Path");
                    case 123: return get("PinnedObjectAddressing");
                    case 124: return get("PreserveFramePointer");
                    case 125: return get("ReduceImplicitExceptionStackTraceInformation");
                    case 126: return get("RemoveUnusedSymbols");
                    case 127: return get("ReportAnalysisForbiddenType");
                    case 128: return get("RunMainInNewThread");
                    case 129: return get("RunReachabilityHandlersConcurrently");
                    case 130: return get("SharedLibrary");
                    case 131: return get("SourceLevelDebug");
                    case 132: return get("SourceLevelDebugFilter");
                    case 133: return get("SpawnIsolates");
                    case 134: return get("StackSize");
                    case 135: return get("StackTrace");
                    case 136: return get("StartFlightRecording");
                    case 137: return get("StaticExecutable");
                    case 138: return get("StaticExecutableWithDynamicLibC");
                    case 139: return get("StaticLibStdCpp");
                    case 140: return get("StrictQueryCodeCompilation");
                    case 141: return get("StripDebugInfo");
                    case 142: return get("SupportCompileInIsolates");
                    case 143: return get("SupportedGCs");
                    case 144: return get("TargetPlatform");
                    case 145: return get("TearDownFailureNanos");
                    case 146: return get("TearDownWarningNanos");
                    case 147: return get("ThrowLinkAtBuildTimeIOExceptions");
                    case 148: return get("ThrowMissingRegistrationErrors");
                    case 149: return get("ThrowMissingRegistrationErrorsPaths");
                    case 150: return get("TraceClassInitialization");
                    case 151: return get("TraceNativeToolUsage");
                    case 152: return get("TraceObjectInstantiation");
                    case 153: return get("TraceVMOperations");
                    case 154: return get("UnlockExperimentalVMOptions");
                    case 155: return get("UseBaseLayerInclusionPolicy");
                    case 156: return get("UseCalleeSavedRegisters");
                    case 157: return get("UseContainerSupport");
                    case 158: return get("UseDedicatedVMOperationThread");
                    case 159: return get("UseDirectCallTrampolinesALot");
                    case 160: return get("UseEpsilonGC");
                    case 161: return get("UseImagebuildDebugSections");
                    case 162: return get("UseLibC");
                    case 163: return get("UseNullRegion");
                    case 164: return get("UseOldMethodHandleIntrinsics");
                    case 165: return get("UsePerfData");
                    case 166: return get("UseSerialGC");
                    case 167: return get("UseSharedLayerGraphs");
                    case 168: return get("UseSystemLocale");
                    case 169: return get("VectorAPISupport");
                    case 170: return get("VerifyFrameAccess");
                    case 171: return get("VerifyFrameAnchors");
                    case 172: return get("VerifyNamingConventions");
                    case 173: return get("VerifyTypes");
                    case 174: return get("ZapNativeMemory");
                }
                throw new NoSuchElementException();
            }
        };
    }
}
