/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.jvmtiagentbase;

import com.oracle.svm.core.jni.JNIObjectHandles;
import com.oracle.svm.core.jni.headers.JNIEnvironment;
import com.oracle.svm.core.jni.headers.JNIFieldId;
import com.oracle.svm.core.jni.headers.JNIMethodId;
import com.oracle.svm.core.jni.headers.JNIObjectHandle;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.jvmtiagentbase.Support;
import java.util.concurrent.locks.ReentrantLock;
import org.graalvm.nativeimage.c.type.CTypeConversion;
import org.graalvm.word.ComparableWord;
import org.graalvm.word.WordFactory;

public abstract class JNIHandleSet {
    private static final int INITIAL_GLOBAL_HANDLE_CAPACITY = 16;
    private final ReentrantLock globalRefsLock = new ReentrantLock();
    private JNIObjectHandle[] globalRefs = new JNIObjectHandle[16];
    private int globalRefCount = 0;
    private boolean destroyed = false;
    final JNIMethodId javaLangClassGetName;
    final JNIObjectHandle javaIoSerializable;

    public JNIHandleSet(JNIEnvironment env) {
        this.javaIoSerializable = this.newClassGlobalRef(env, "java/io/Serializable");
        JNIObjectHandle javaLangClass = this.findClass(env, "java/lang/Class");
        this.javaLangClassGetName = this.getMethodId(env, javaLangClass, "getName", "()Ljava/lang/String;", false);
    }

    public JNIObjectHandle findClass(JNIEnvironment env, String className) {
        JNIObjectHandle h = this.findClassOptional(env, className);
        VMError.guarantee((boolean)h.notEqual((ComparableWord)JNIObjectHandles.nullHandle()));
        return h;
    }

    public JNIObjectHandle findClassOptional(JNIEnvironment env, String className) {
        assert (!this.destroyed);
        try (CTypeConversion.CCharPointerHolder name = Support.toCString(className);){
            JNIObjectHandle h = Support.jniFunctions().getFindClass().invoke(env, name.get());
            if (Support.clearException(env)) {
                JNIObjectHandle jNIObjectHandle = (JNIObjectHandle)JNIObjectHandles.nullHandle();
                return jNIObjectHandle;
            }
            JNIObjectHandle jNIObjectHandle = h;
            return jNIObjectHandle;
        }
    }

    public JNIObjectHandle newClassGlobalRef(JNIEnvironment env, String className) {
        assert (!this.destroyed);
        return this.newTrackedGlobalRef(env, this.findClass(env, className));
    }

    public JNIMethodId getMethodId(JNIEnvironment env, JNIObjectHandle clazz, String name, String signature, boolean isStatic) {
        assert (!this.destroyed);
        JNIMethodId id = this.getMethodIdOptional(env, clazz, name, signature, isStatic);
        VMError.guarantee((boolean)id.isNonNull());
        return id;
    }

    public JNIMethodId getMethodIdOptional(JNIEnvironment env, JNIObjectHandle clazz, String name, String signature, boolean isStatic) {
        assert (!this.destroyed);
        try (CTypeConversion.CCharPointerHolder cname = Support.toCString(name);){
            JNIMethodId jNIMethodId;
            block14: {
                CTypeConversion.CCharPointerHolder csignature = Support.toCString(signature);
                try {
                    JNIMethodId id;
                    JNIMethodId jNIMethodId2 = id = isStatic ? Support.jniFunctions().getGetStaticMethodID().invoke(env, clazz, cname.get(), csignature.get()) : Support.jniFunctions().getGetMethodID().invoke(env, clazz, cname.get(), csignature.get());
                    if (Support.clearException(env)) {
                        id = (JNIMethodId)WordFactory.nullPointer();
                    }
                    jNIMethodId = id;
                    if (csignature == null) break block14;
                }
                catch (Throwable throwable) {
                    if (csignature != null) {
                        try {
                            csignature.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                csignature.close();
            }
            return jNIMethodId;
        }
    }

    public JNIFieldId getFieldId(JNIEnvironment env, JNIObjectHandle clazz, String name, String signature, boolean isStatic) {
        assert (!this.destroyed);
        JNIFieldId id = this.getFieldIdOptional(env, clazz, name, signature, isStatic);
        VMError.guarantee((boolean)id.isNonNull());
        return id;
    }

    public JNIFieldId getFieldIdOptional(JNIEnvironment env, JNIObjectHandle clazz, String name, String signature, boolean isStatic) {
        assert (!this.destroyed);
        try (CTypeConversion.CCharPointerHolder cname = Support.toCString(name);){
            JNIFieldId jNIFieldId;
            block14: {
                CTypeConversion.CCharPointerHolder csignature = Support.toCString(signature);
                try {
                    JNIFieldId id;
                    JNIFieldId jNIFieldId2 = id = isStatic ? Support.jniFunctions().getGetStaticFieldID().invoke(env, clazz, cname.get(), csignature.get()) : Support.jniFunctions().getGetFieldID().invoke(env, clazz, cname.get(), csignature.get());
                    if (Support.clearException(env)) {
                        id = (JNIFieldId)WordFactory.nullPointer();
                    }
                    jNIFieldId = id;
                    if (csignature == null) break block14;
                }
                catch (Throwable throwable) {
                    if (csignature != null) {
                        try {
                            csignature.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                csignature.close();
            }
            return jNIFieldId;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JNIObjectHandle newTrackedGlobalRef(JNIEnvironment env, JNIObjectHandle ref) {
        assert (!this.destroyed);
        JNIObjectHandle global = Support.jniFunctions().getNewGlobalRef().invoke(env, ref);
        VMError.guarantee((boolean)global.notEqual((ComparableWord)JNIObjectHandles.nullHandle()));
        this.globalRefsLock.lock();
        try {
            if (this.globalRefCount == this.globalRefs.length) {
                this.globalRefs = JNIHandleSet.copyOf(this.globalRefs, this.globalRefs.length * 2);
            }
            this.globalRefs[this.globalRefCount] = global;
            ++this.globalRefCount;
        }
        finally {
            this.globalRefsLock.unlock();
        }
        return global;
    }

    private static JNIObjectHandle[] copyOf(JNIObjectHandle[] original, int newLength) {
        JNIObjectHandle[] copy = new JNIObjectHandle[newLength];
        System.arraycopy(original, 0, copy, 0, Math.min(original.length, newLength));
        return copy;
    }

    void destroy(JNIEnvironment env) {
        assert (!this.destroyed);
        this.destroyed = true;
        for (int i = 0; i < this.globalRefCount; ++i) {
            Support.jniFunctions().getDeleteGlobalRef().invoke(env, this.globalRefs[i]);
        }
    }
}

