/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.objectfile.elf.dwarf;

import com.oracle.objectfile.LayoutDecision;
import com.oracle.objectfile.LayoutDecisionMap;
import com.oracle.objectfile.ObjectFile;
import com.oracle.objectfile.debugentry.ClassEntry;
import com.oracle.objectfile.elf.dwarf.DwarfDebugInfo;
import com.oracle.objectfile.elf.dwarf.DwarfSectionImpl;
import com.oracle.objectfile.elf.dwarf.constants.DwarfRangeListEntry;
import com.oracle.objectfile.elf.dwarf.constants.DwarfSectionName;
import com.oracle.objectfile.elf.dwarf.constants.DwarfVersion;
import java.util.Map;
import jdk.graal.compiler.debug.DebugContext;

public class DwarfRangesSectionImpl
extends DwarfSectionImpl {
    public DwarfRangesSectionImpl(DwarfDebugInfo dwarfSections) {
        super(dwarfSections, DwarfSectionName.DW_RNGLISTS_SECTION, DwarfSectionName.DW_ARANGES_SECTION);
    }

    @Override
    public void createContent() {
        assert (!this.contentByteArrayCreated());
        byte[] buffer = null;
        int len = this.generateContent(null, buffer);
        buffer = new byte[len];
        super.setContent(buffer);
    }

    @Override
    public byte[] getOrDecideContent(Map<ObjectFile.Element, LayoutDecisionMap> alreadyDecided, byte[] contentHint) {
        Object valueObj;
        ObjectFile.Element textElement = this.getElement().getOwner().elementForName(".text");
        LayoutDecisionMap decisionMap = alreadyDecided.get(textElement);
        if (decisionMap != null && (valueObj = decisionMap.getDecidedValue(LayoutDecision.Kind.VADDR)) != null && valueObj instanceof Number) {
            this.debugTextBase = ((Number)valueObj).longValue();
        }
        return super.getOrDecideContent(alreadyDecided, contentHint);
    }

    @Override
    public void writeContent(DebugContext context) {
        assert (this.contentByteArrayCreated());
        byte[] buffer = this.getContent();
        int size = buffer.length;
        int pos = 0;
        this.enableLog(context, pos);
        this.log(context, "  [0x%08x] DEBUG_RANGES", pos);
        this.log(context, "  [0x%08x] size = 0x%08x", pos, size);
        pos = this.generateContent(context, buffer);
        assert (pos == size);
    }

    private int generateContent(DebugContext context, byte[] buffer) {
        int pos;
        int lengthPos = pos = 0;
        pos = this.writeRangeListsHeader(buffer, pos);
        pos = this.writeRangeLists(context, buffer, pos);
        this.patchLength(lengthPos, buffer, pos);
        return pos;
    }

    private int writeRangeListsHeader(byte[] buffer, int p) {
        int pos = p;
        pos = this.writeInt(0, buffer, pos);
        pos = this.writeDwarfVersion(DwarfVersion.DW_VERSION_5, buffer, pos);
        pos = this.writeByte((byte)8, buffer, pos);
        pos = this.writeByte((byte)0, buffer, pos);
        return this.writeInt(0, buffer, pos);
    }

    private int writeRangeLists(DebugContext context, byte[] buffer, int p) {
        DwarfSectionImpl.Cursor entryCursor = new DwarfSectionImpl.Cursor(this, p);
        this.instanceClassStream().filter(ClassEntry::hasCompiledEntries).forEachOrdered(classEntry -> {
            int pos = entryCursor.get();
            this.setCodeRangesIndex((ClassEntry)classEntry, pos);
            entryCursor.set(this.writeRangeList(context, (ClassEntry)classEntry, buffer, pos));
        });
        return entryCursor.get();
    }

    private int writeRangeList(DebugContext context, ClassEntry classEntry, byte[] buffer, int p) {
        int pos = p;
        this.log(context, "  [0x%08x] ranges start for class %s", pos, classEntry.getTypeName());
        int base = classEntry.compiledEntriesBase();
        this.log(context, "  [0x%08x] base 0x%x", pos, base);
        pos = this.writeRangeListEntry(DwarfRangeListEntry.DW_RLE_base_address, buffer, pos);
        pos = this.writeRelocatableCodeOffset(base, buffer, pos);
        DwarfSectionImpl.Cursor cursor = new DwarfSectionImpl.Cursor(this, pos);
        classEntry.compiledEntries().forEach(compiledMethodEntry -> {
            cursor.set(this.writeRangeListEntry(DwarfRangeListEntry.DW_RLE_offset_pair, buffer, cursor.get()));
            int loOffset = compiledMethodEntry.getPrimary().getLo() - base;
            int hiOffset = compiledMethodEntry.getPrimary().getHi() - base;
            this.log(context, "  [0x%08x] lo 0x%x (%s)", cursor.get(), loOffset, compiledMethodEntry.getPrimary().getFullMethodNameWithParams());
            cursor.set(this.writeULEB(loOffset, buffer, cursor.get()));
            this.log(context, "  [0x%08x] hi 0x%x", cursor.get(), hiOffset);
            cursor.set(this.writeULEB(hiOffset, buffer, cursor.get()));
        });
        pos = cursor.get();
        pos = this.writeRangeListEntry(DwarfRangeListEntry.DW_RLE_end_of_list, buffer, pos);
        this.log(context, "  [0x%08x] ranges size 0x%x  for class %s", pos, pos - p, classEntry.getTypeName());
        return pos;
    }
}

