/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.objectfile.elf.dwarf;

import com.oracle.objectfile.debugentry.ArrayTypeEntry;
import com.oracle.objectfile.debugentry.ClassEntry;
import com.oracle.objectfile.debugentry.CompiledMethodEntry;
import com.oracle.objectfile.debugentry.FieldEntry;
import com.oracle.objectfile.debugentry.FileEntry;
import com.oracle.objectfile.debugentry.ForeignTypeEntry;
import com.oracle.objectfile.debugentry.HeaderTypeEntry;
import com.oracle.objectfile.debugentry.InterfaceClassEntry;
import com.oracle.objectfile.debugentry.MethodEntry;
import com.oracle.objectfile.debugentry.PrimitiveTypeEntry;
import com.oracle.objectfile.debugentry.StructureTypeEntry;
import com.oracle.objectfile.debugentry.TypeEntry;
import com.oracle.objectfile.debugentry.range.PrimaryRange;
import com.oracle.objectfile.debugentry.range.Range;
import com.oracle.objectfile.debugentry.range.SubRange;
import com.oracle.objectfile.debuginfo.DebugInfoProvider;
import com.oracle.objectfile.elf.dwarf.DwarfDebugInfo;
import com.oracle.objectfile.elf.dwarf.DwarfSectionImpl;
import com.oracle.objectfile.elf.dwarf.constants.DwarfAccess;
import com.oracle.objectfile.elf.dwarf.constants.DwarfEncoding;
import com.oracle.objectfile.elf.dwarf.constants.DwarfExpressionOpcode;
import com.oracle.objectfile.elf.dwarf.constants.DwarfFlag;
import com.oracle.objectfile.elf.dwarf.constants.DwarfInline;
import com.oracle.objectfile.elf.dwarf.constants.DwarfLanguage;
import com.oracle.objectfile.elf.dwarf.constants.DwarfSectionName;
import com.oracle.objectfile.elf.dwarf.constants.DwarfUnitHeader;
import com.oracle.objectfile.elf.dwarf.constants.DwarfVersion;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Stream;
import jdk.graal.compiler.debug.DebugContext;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.PrimitiveConstant;
import org.graalvm.collections.EconomicSet;

public class DwarfInfoSectionImpl
extends DwarfSectionImpl {
    private static final int CU_DIE_HEADER_SIZE = 12;
    private static final int TU_DIE_HEADER_SIZE = 24;
    private int unitStart = -1;

    public DwarfInfoSectionImpl(DwarfDebugInfo dwarfSections) {
        super(dwarfSections, DwarfSectionName.DW_INFO_SECTION, DwarfSectionName.DW_LOCLISTS_SECTION);
    }

    @Override
    public void createContent() {
        assert (!this.contentByteArrayCreated());
        int len = this.generateContent(null, null);
        byte[] buffer = new byte[len];
        super.setContent(buffer);
    }

    @Override
    public void writeContent(DebugContext context) {
        assert (this.contentByteArrayCreated());
        byte[] buffer = this.getContent();
        int size = buffer.length;
        int pos = 0;
        this.enableLog(context, pos);
        this.log(context, "  [0x%08x] DEBUG_INFO", pos);
        this.log(context, "  [0x%08x] size = 0x%08x", pos, size);
        pos = this.generateContent(context, buffer);
        assert (pos == size);
    }

    DwarfEncoding computeEncoding(int flags, int bitCount) {
        assert (bitCount > 0);
        if ((flags & 1) != 0) {
            if ((flags & 2) != 0) {
                if ((flags & 4) != 0) {
                    switch (bitCount) {
                        case 8: {
                            return DwarfEncoding.DW_ATE_signed_char;
                        }
                    }
                    assert (bitCount == 16 || bitCount == 32 || bitCount == 64);
                    return DwarfEncoding.DW_ATE_signed;
                }
                assert (bitCount == 16);
                return DwarfEncoding.DW_ATE_unsigned;
            }
            assert (bitCount == 32 || bitCount == 64);
            return DwarfEncoding.DW_ATE_float;
        }
        assert (bitCount == 1);
        return DwarfEncoding.DW_ATE_boolean;
    }

    public int generateContent(DebugContext context, byte[] buffer) {
        int pos = 0;
        pos = this.writeBuiltInTypes(context, buffer, pos);
        pos = this.writeInstanceClasses(context, buffer, pos);
        pos = this.writeArrays(context, buffer, pos);
        pos = this.writeClassConstantObjects(context, buffer, pos);
        return pos;
    }

    private int writeSkeletonClassLayout(DebugContext context, ClassEntry classEntry, byte[] buffer, int p) {
        int pos = p;
        this.log(context, "  [0x%08x] class layout", pos);
        DwarfDebugInfo.AbbrevCode abbrevCode = DwarfDebugInfo.AbbrevCode.CLASS_LAYOUT_3;
        this.log(context, "  [0x%08x] <1> Abbrev Number %d", pos, abbrevCode.ordinal());
        pos = this.writeAbbrevCode(abbrevCode, buffer, pos);
        String name = classEntry.getTypeName();
        this.log(context, "  [0x%08x]     name  0x%x (%s)", pos, this.debugStringIndex(name), name);
        pos = this.writeStrSectionOffset(name, buffer, pos);
        this.log(context, "  [0x%08x]     declaration true", pos);
        pos = this.writeFlag(DwarfFlag.DW_FLAG_true, buffer, pos);
        long typeSignature = classEntry.getLayoutTypeSignature();
        this.log(context, "  [0x%08x]     type specification 0x%x", pos, typeSignature);
        pos = this.writeTypeSignature(typeSignature, buffer, pos);
        pos = this.writeStaticFieldDeclarations(context, classEntry, buffer, pos);
        pos = this.writeMethodDeclarations(context, classEntry, buffer, pos);
        return this.writeAttrNull(buffer, pos);
    }

    private int writeBuiltInTypes(DebugContext context, byte[] buffer, int p) {
        int pos = p;
        this.log(context, "  [0x%08x] primitive types", pos);
        DwarfSectionImpl.Cursor cursor = new DwarfSectionImpl.Cursor(this, pos);
        this.primitiveTypeStream().forEach(primitiveTypeEntry -> {
            if (primitiveTypeEntry.getBitCount() > 0) {
                cursor.set(this.writePrimitiveType(context, (PrimitiveTypeEntry)primitiveTypeEntry, buffer, cursor.get()));
            } else {
                cursor.set(this.writeVoidType(context, (PrimitiveTypeEntry)primitiveTypeEntry, buffer, cursor.get()));
            }
        });
        pos = cursor.get();
        this.log(context, "  [0x%08x] header type", pos);
        return this.writeHeaderType(context, this.headerType(), buffer, pos);
    }

    private int writeClassConstantObjects(DebugContext context, byte[] buffer, int p) {
        int pos;
        int lengthPos = pos = p;
        this.log(context, "  [0x%08x] <0> Java Builtin Compile Unit", pos);
        pos = this.writeCUHeader(buffer, pos);
        assert (pos == lengthPos + 12);
        DwarfDebugInfo.AbbrevCode abbrevCode = DwarfDebugInfo.AbbrevCode.CLASS_CONSTANT_UNIT;
        this.log(context, "  [0x%08x] <0> Abbrev Number %d", pos, abbrevCode.ordinal());
        pos = this.writeAbbrevCode(abbrevCode, buffer, pos);
        this.log(context, "  [0x%08x]     language  %s", pos, "DW_LANG_Java");
        pos = this.writeAttrLanguage(DwarfDebugInfo.LANG_ENCODING, buffer, pos);
        this.log(context, "  [0x%08x]     use_UTF8", pos);
        pos = this.writeFlag(DwarfFlag.DW_FLAG_true, buffer, pos);
        String name = this.uniqueDebugString("JAVA");
        this.log(context, "  [0x%08x]     name  0x%x (%s)", pos, this.debugStringIndex(name), name);
        pos = this.writeStrSectionOffset(name, buffer, pos);
        String compilationDirectory = this.dwarfSections.getCachePath();
        this.log(context, "  [0x%08x]     comp_dir  0x%x (%s)", pos, this.debugStringIndex(compilationDirectory), compilationDirectory);
        pos = this.writeStrSectionOffset(compilationDirectory, buffer, pos);
        DwarfSectionImpl.Cursor cursor = new DwarfSectionImpl.Cursor(this, pos);
        this.typeStream().forEach(typeEntry -> cursor.set(this.writeClassConstantDeclaration(context, (TypeEntry)typeEntry, buffer, cursor.get())));
        pos = cursor.get();
        pos = this.writeAttrNull(buffer, pos);
        this.patchLength(lengthPos, buffer, pos);
        return pos;
    }

    private int writePrimitiveType(DebugContext context, PrimitiveTypeEntry primitiveTypeEntry, byte[] buffer, int p) {
        int pos;
        assert (primitiveTypeEntry.getBitCount() > 0);
        int lengthPos = pos = p;
        pos = this.writeTUPreamble(context, primitiveTypeEntry.getTypeSignature(), "", buffer, p);
        this.log(context, "  [0x%08x] primitive type %s", pos, primitiveTypeEntry.getTypeName());
        DwarfDebugInfo.AbbrevCode abbrevCode = DwarfDebugInfo.AbbrevCode.PRIMITIVE_TYPE;
        this.log(context, "  [0x%08x] <1> Abbrev Number %d", pos, abbrevCode.ordinal());
        pos = this.writeAbbrevCode(abbrevCode, buffer, pos);
        byte byteSize = (byte)primitiveTypeEntry.getSize();
        this.log(context, "  [0x%08x]     byte_size  %d", pos, byteSize);
        pos = this.writeAttrData1(byteSize, buffer, pos);
        byte bitCount = (byte)primitiveTypeEntry.getBitCount();
        this.log(context, "  [0x%08x]     bitCount  %d", pos, bitCount);
        pos = this.writeAttrData1(bitCount, buffer, pos);
        DwarfEncoding encoding = this.computeEncoding(primitiveTypeEntry.getFlags(), bitCount);
        this.log(context, "  [0x%08x]     encoding  0x%x", pos, encoding.value());
        pos = this.writeAttrEncoding(encoding, buffer, pos);
        String name = primitiveTypeEntry.getTypeName();
        this.log(context, "  [0x%08x]     name  0x%x (%s)", pos, this.debugStringIndex(name), name);
        pos = this.writeStrSectionOffset(name, buffer, pos);
        pos = this.writeAttrNull(buffer, pos);
        this.patchLength(lengthPos, buffer, pos);
        return pos;
    }

    private int writeVoidType(DebugContext context, PrimitiveTypeEntry primitiveTypeEntry, byte[] buffer, int p) {
        int pos;
        assert (primitiveTypeEntry.getBitCount() == 0);
        int lengthPos = pos = p;
        pos = this.writeTUPreamble(context, primitiveTypeEntry.getTypeSignature(), "", buffer, p);
        this.log(context, "  [0x%08x] primitive type void", pos);
        DwarfDebugInfo.AbbrevCode abbrevCode = DwarfDebugInfo.AbbrevCode.VOID_TYPE;
        this.log(context, "  [0x%08x] <1> Abbrev Number %d", pos, abbrevCode.ordinal());
        pos = this.writeAbbrevCode(abbrevCode, buffer, pos);
        String name = primitiveTypeEntry.getTypeName();
        this.log(context, "  [0x%08x]     name  0x%x (%s)", pos, this.debugStringIndex(name), name);
        pos = this.writeStrSectionOffset(name, buffer, pos);
        pos = this.writeAttrNull(buffer, pos);
        this.patchLength(lengthPos, buffer, pos);
        return pos;
    }

    private int writeHeaderType(DebugContext context, HeaderTypeEntry headerTypeEntry, byte[] buffer, int p) {
        int pos;
        int lengthPos = pos = p;
        pos = this.writeTUPreamble(context, headerTypeEntry.getTypeSignature(), "", buffer, p);
        String name = headerTypeEntry.getTypeName();
        byte size = (byte)headerTypeEntry.getSize();
        this.log(context, "  [0x%08x] header type %s", pos, name);
        DwarfDebugInfo.AbbrevCode abbrevCode = DwarfDebugInfo.AbbrevCode.OBJECT_HEADER;
        this.log(context, "  [0x%08x] <1> Abbrev Number %d", pos, abbrevCode.ordinal());
        pos = this.writeAbbrevCode(abbrevCode, buffer, pos);
        this.log(context, "  [0x%08x]     name  0x%x (%s)", pos, this.debugStringIndex(name), name);
        pos = this.writeStrSectionOffset(name, buffer, pos);
        this.log(context, "  [0x%08x]     byte_size  0x%x", pos, size);
        pos = this.writeAttrData1(size, buffer, pos);
        pos = this.writeStructFields(context, headerTypeEntry.fields(), buffer, pos);
        pos = this.writeAttrNull(buffer, pos);
        pos = this.writeAttrNull(buffer, pos);
        this.patchLength(lengthPos, buffer, pos);
        return pos;
    }

    private int writeStructFields(DebugContext context, Stream<FieldEntry> fields, byte[] buffer, int p) {
        DwarfSectionImpl.Cursor cursor = new DwarfSectionImpl.Cursor(this, p);
        fields.forEach(fieldEntry -> cursor.set(this.writeStructField(context, (FieldEntry)fieldEntry, buffer, cursor.get())));
        return cursor.get();
    }

    private int writeStructField(DebugContext context, FieldEntry fieldEntry, byte[] buffer, int p) {
        int pos = p;
        String fieldName = fieldEntry.fieldName();
        TypeEntry valueType = fieldEntry.getValueType();
        long typeSignature = 0L;
        int typeIdx = 0;
        DwarfDebugInfo.AbbrevCode abbrevCode = DwarfDebugInfo.AbbrevCode.HEADER_FIELD;
        if (fieldEntry.isEmbedded()) {
            ForeignTypeEntry foreignValueType = (ForeignTypeEntry)valueType;
            int fieldSize = fieldEntry.getSize();
            int valueSize = foreignValueType.getSize();
            if (fieldEntry.getSize() != foreignValueType.getSize()) {
                assert (fieldSize % valueSize == 0) : "embedded field size is not a multiple of value type size!";
                typeIdx = pos;
                abbrevCode = DwarfDebugInfo.AbbrevCode.ARRAY_ELEMENT_FIELD;
                pos = this.writeEmbeddedArrayDataType(context, foreignValueType, valueSize, fieldSize / valueSize, buffer, pos);
            } else if (foreignValueType.isPointer()) {
                TypeEntry pointerTo = foreignValueType.getPointerTo();
                assert (pointerTo != null) : "ADDRESS field pointer type must have a known target type";
                typeSignature = pointerTo.getTypeSignature();
            } else {
                typeSignature = foreignValueType.getLayoutTypeSignature();
            }
        } else {
            typeSignature = valueType.getTypeSignatureForCompressed();
        }
        this.log(context, "  [0x%08x] struct field", pos);
        this.log(context, "  [0x%08x] <2> Abbrev Number %d", pos, abbrevCode.ordinal());
        pos = this.writeAbbrevCode(abbrevCode, buffer, pos);
        this.log(context, "  [0x%08x]     name  0x%x (%s)", pos, this.debugStringIndex(fieldName), fieldName);
        pos = this.writeStrSectionOffset(fieldName, buffer, pos);
        if (abbrevCode == DwarfDebugInfo.AbbrevCode.HEADER_FIELD) {
            this.log(context, "  [0x%08x]     type 0x%x (%s)", pos, typeSignature, valueType.getTypeName());
            pos = this.writeTypeSignature(typeSignature, buffer, pos);
        } else {
            this.log(context, "  [0x%08x]     type 0x%x (%s)", pos, typeIdx, valueType.getTypeName());
            pos = this.writeInfoSectionOffset(typeIdx, buffer, pos);
        }
        short offset = (short)fieldEntry.getOffset();
        int size = fieldEntry.getSize();
        this.log(context, "  [0x%08x]     offset 0x%x (size 0x%x)", pos, offset, size);
        pos = this.writeAttrData2(offset, buffer, pos);
        int modifiers = fieldEntry.getModifiers();
        this.log(context, "  [0x%08x]     modifiers %s", pos, fieldEntry.getModifiersString());
        return this.writeAttrAccessibility(modifiers, buffer, pos);
    }

    private int writeInstanceClasses(DebugContext context, byte[] buffer, int pos) {
        this.log(context, "  [0x%08x] instance classes", pos);
        DwarfSectionImpl.Cursor cursor = new DwarfSectionImpl.Cursor(this, pos);
        this.instanceClassStream().forEach(classEntry -> {
            cursor.set(this.writeTypeUnits(context, (StructureTypeEntry)classEntry, buffer, cursor.get()));
            this.setCUIndex((ClassEntry)classEntry, cursor.get());
            cursor.set(this.writeInstanceClassInfo(context, (ClassEntry)classEntry, buffer, cursor.get()));
        });
        return cursor.get();
    }

    private int writeTypeUnits(DebugContext context, StructureTypeEntry typeEntry, byte[] buffer, int p) {
        int pos = p;
        if (typeEntry.isForeign()) {
            ForeignTypeEntry foreignTypeEntry = (ForeignTypeEntry)typeEntry;
            pos = this.writeForeignLayoutTypeUnit(context, foreignTypeEntry, buffer, pos);
            pos = this.writeForeignTypeUnit(context, foreignTypeEntry, buffer, pos);
        } else {
            if (typeEntry.isArray()) {
                pos = this.writeArrayLayoutTypeUnit(context, (ArrayTypeEntry)typeEntry, buffer, pos);
            } else if (typeEntry.isInterface()) {
                pos = this.writeInterfaceLayoutTypeUnit(context, (InterfaceClassEntry)typeEntry, buffer, pos);
            } else {
                assert (typeEntry instanceof ClassEntry);
                pos = this.writeClassLayoutTypeUnit(context, (ClassEntry)typeEntry, buffer, pos);
            }
            pos = this.writePointerTypeUnit(context, typeEntry, buffer, pos);
            if (this.dwarfSections.useHeapBase()) {
                pos = this.writePointerTypeUnitForCompressed(context, typeEntry, buffer, pos);
            }
        }
        return pos;
    }

    private int writeTUPreamble(DebugContext context, long typeSignature, String loaderId, byte[] buffer, int p) {
        int pos = p;
        pos = this.writeTUHeader(typeSignature, buffer, pos);
        int typeOffsetPos = pos - 4;
        assert (pos == p + 24);
        DwarfDebugInfo.AbbrevCode abbrevCode = DwarfDebugInfo.AbbrevCode.TYPE_UNIT;
        this.log(context, "  [0x%08x] <0> Abbrev Number %d", pos, abbrevCode.ordinal());
        pos = this.writeAbbrevCode(abbrevCode, buffer, pos);
        this.log(context, "  [0x%08x]     language  %s", pos, "DW_LANG_Java");
        pos = this.writeAttrLanguage(DwarfDebugInfo.LANG_ENCODING, buffer, pos);
        this.log(context, "  [0x%08x]     use_UTF8", pos);
        pos = this.writeFlag(DwarfFlag.DW_FLAG_true, buffer, pos);
        if (!loaderId.isEmpty()) {
            pos = this.writeNameSpace(context, loaderId, buffer, pos);
        }
        this.writeInt(pos - p, buffer, typeOffsetPos);
        return pos;
    }

    private int writePointerTypeUnit(DebugContext context, StructureTypeEntry typeEntry, byte[] buffer, int p) {
        int pos = p;
        String loaderId = "";
        if (typeEntry.isArray()) {
            loaderId = ((ArrayTypeEntry)typeEntry).getLoaderId();
        } else if (typeEntry.isClass()) {
            loaderId = ((ClassEntry)typeEntry).getLoaderId();
        }
        int lengthPos = pos;
        long typeSignature = typeEntry.getTypeSignature();
        pos = this.writeTUPreamble(context, typeSignature, loaderId, buffer, p);
        this.log(context, "  [0x%08x] %s pointer type", pos, typeEntry.isInterface() ? "interface" : "class");
        DwarfDebugInfo.AbbrevCode abbrevCode = DwarfDebugInfo.AbbrevCode.TYPE_POINTER_SIG;
        this.log(context, "  [0x%08x] <1> Abbrev Number %d", pos, abbrevCode.ordinal());
        pos = this.writeAbbrevCode(abbrevCode, buffer, pos);
        int pointerSize = this.dwarfSections.pointerSize();
        this.log(context, "  [0x%08x]     byte_size 0x%x", pos, pointerSize);
        pos = this.writeAttrData1((byte)pointerSize, buffer, pos);
        long layoutTypeSignature = typeEntry.getLayoutTypeSignature();
        this.log(context, "  [0x%08x]     type 0x%x", pos, layoutTypeSignature);
        pos = this.writeTypeSignature(layoutTypeSignature, buffer, pos);
        if (!loaderId.isEmpty()) {
            pos = this.writeAttrNull(buffer, pos);
        }
        pos = this.writeAttrNull(buffer, pos);
        this.patchLength(lengthPos, buffer, pos);
        return pos;
    }

    private int writePointerTypeUnitForCompressed(DebugContext context, StructureTypeEntry typeEntry, byte[] buffer, int p) {
        int pos = p;
        long typeSignature = typeEntry.getTypeSignatureForCompressed();
        int lengthPos = pos;
        pos = this.writeTUHeader(typeSignature, buffer, pos);
        int typeOffsetPos = pos - 4;
        assert (pos == lengthPos + 24);
        DwarfDebugInfo.AbbrevCode abbrevCode = DwarfDebugInfo.AbbrevCode.TYPE_UNIT;
        this.log(context, "  [0x%08x] <0> Abbrev Number %d", pos, abbrevCode.ordinal());
        pos = this.writeAbbrevCode(abbrevCode, buffer, pos);
        this.log(context, "  [0x%08x]     language  %s", pos, "DW_LANG_Java");
        pos = this.writeAttrLanguage(DwarfDebugInfo.LANG_ENCODING, buffer, pos);
        this.log(context, "  [0x%08x]     use_UTF8", pos);
        pos = this.writeFlag(DwarfFlag.DW_FLAG_true, buffer, pos);
        String loaderId = "";
        if (typeEntry.isArray()) {
            loaderId = ((ArrayTypeEntry)typeEntry).getLoaderId();
        } else if (typeEntry.isClass()) {
            loaderId = ((ClassEntry)typeEntry).getLoaderId();
        }
        if (!loaderId.isEmpty()) {
            pos = this.writeNameSpace(context, loaderId, buffer, pos);
        }
        int refTypeIdx = pos;
        pos = this.writeLayoutTypeForCompressed(context, typeEntry, buffer, pos);
        this.writeInt(pos - lengthPos, buffer, typeOffsetPos);
        this.log(context, "  [0x%08x] %s compressed pointer type", pos, typeEntry.isInterface() ? "interface" : "class");
        abbrevCode = DwarfDebugInfo.AbbrevCode.TYPE_POINTER;
        this.log(context, "  [0x%08x] <1> Abbrev Number %d", pos, abbrevCode.ordinal());
        pos = this.writeAbbrevCode(abbrevCode, buffer, pos);
        int pointerSize = this.dwarfSections.referenceSize();
        this.log(context, "  [0x%08x]     byte_size 0x%x", pos, pointerSize);
        pos = this.writeAttrData1((byte)pointerSize, buffer, pos);
        this.log(context, "  [0x%08x]     type 0x%x", pos, refTypeIdx);
        pos = this.writeAttrRef4(refTypeIdx, buffer, pos);
        if (!loaderId.isEmpty()) {
            pos = this.writeAttrNull(buffer, pos);
        }
        pos = this.writeAttrNull(buffer, pos);
        this.patchLength(lengthPos, buffer, pos);
        return pos;
    }

    private int writeLayoutTypeForCompressed(DebugContext context, StructureTypeEntry typeEntry, byte[] buffer, int p) {
        int pos = p;
        this.log(context, "  [0x%08x] compressed %s layout", pos, typeEntry.isInterface() ? "interface" : "class");
        DwarfDebugInfo.AbbrevCode abbrevCode = DwarfDebugInfo.AbbrevCode.COMPRESSED_LAYOUT;
        this.log(context, "  [0x%08x] <1> Abbrev Number %d", pos, abbrevCode.ordinal());
        pos = this.writeAbbrevCode(abbrevCode, buffer, pos);
        String compressedName = this.uniqueDebugString("_z_." + typeEntry.getTypeName());
        String name = this.uniqueDebugString(typeEntry.getTypeName());
        this.log(context, "  [0x%08x]     name  0x%x (%s)", pos, this.debugStringIndex(compressedName), name);
        pos = this.writeStrSectionOffset(compressedName, buffer, pos);
        int size = typeEntry.getSize();
        this.log(context, "  [0x%08x]     byte_size 0x%x", pos, size);
        pos = this.writeAttrData2((short)size, buffer, pos);
        this.log(context, "  [0x%08x]     data_location", pos);
        pos = this.writeCompressedOopConversionExpression(this.dwarfSections.isHubClassEntry(typeEntry), buffer, pos);
        pos = this.writeSuperReference(context, typeEntry.getLayoutTypeSignature(), name, buffer, pos);
        return this.writeAttrNull(buffer, pos);
    }

    private int writeInterfaceLayoutTypeUnit(DebugContext context, InterfaceClassEntry interfaceClassEntry, byte[] buffer, int p) {
        int pos = p;
        String loaderId = interfaceClassEntry.getLoaderId();
        int lengthPos = pos;
        pos = this.writeTUPreamble(context, interfaceClassEntry.getLayoutTypeSignature(), loaderId, buffer, pos);
        this.log(context, "  [0x%08x] interface layout", pos);
        DwarfDebugInfo.AbbrevCode abbrevCode = DwarfDebugInfo.AbbrevCode.INTERFACE_LAYOUT;
        this.log(context, "  [0x%08x] <1> Abbrev Number %d", pos, abbrevCode.ordinal());
        pos = this.writeAbbrevCode(abbrevCode, buffer, pos);
        String name = interfaceClassEntry.getTypeName();
        this.log(context, "  [0x%08x]     name  0x%x (%s)", pos, this.debugStringIndex(name), name);
        pos = this.writeStrSectionOffset(name, buffer, pos);
        pos = this.writeInterfaceImplementors(context, interfaceClassEntry, buffer, pos);
        pos = this.writeSkeletonMethodDeclarations(context, interfaceClassEntry, buffer, pos);
        pos = this.writeAttrNull(buffer, pos);
        if (!loaderId.isEmpty()) {
            pos = this.writeAttrNull(buffer, pos);
        }
        pos = this.writeAttrNull(buffer, pos);
        this.patchLength(lengthPos, buffer, pos);
        return pos;
    }

    private int writeClassLayoutTypeUnit(DebugContext context, ClassEntry classEntry, byte[] buffer, int p) {
        StructureTypeEntry superClassEntry;
        int pos = p;
        String loaderId = classEntry.getLoaderId();
        int lengthPos = pos;
        pos = this.writeTUPreamble(context, classEntry.getLayoutTypeSignature(), loaderId, buffer, pos);
        this.log(context, "  [0x%08x] type layout", pos);
        DwarfDebugInfo.AbbrevCode abbrevCode = DwarfDebugInfo.AbbrevCode.CLASS_LAYOUT_1;
        if (!this.dwarfSections.useHeapBase() && this.dwarfSections.isHubClassEntry(classEntry)) {
            abbrevCode = DwarfDebugInfo.AbbrevCode.CLASS_LAYOUT_2;
        }
        this.log(context, "  [0x%08x] <1> Abbrev Number %d", pos, abbrevCode.ordinal());
        pos = this.writeAbbrevCode(abbrevCode, buffer, pos);
        String name = classEntry.getTypeName();
        this.log(context, "  [0x%08x]     name  0x%x (%s)", pos, this.debugStringIndex(name), name);
        pos = this.writeStrSectionOffset(name, buffer, pos);
        int size = classEntry.getSize();
        this.log(context, "  [0x%08x]     byte_size 0x%x", pos, size);
        pos = this.writeAttrData2((short)size, buffer, pos);
        int fileIdx = classEntry.getFileIdx();
        this.log(context, "  [0x%08x]     file  0x%x (%s)", pos, fileIdx, classEntry.getFileName());
        pos = this.writeAttrData2((short)fileIdx, buffer, pos);
        if (abbrevCode == DwarfDebugInfo.AbbrevCode.CLASS_LAYOUT_2) {
            this.log(context, "  [0x%08x]     data_location", pos);
            pos = this.writeCompressedOopConversionExpression(true, buffer, pos);
        }
        if ((superClassEntry = classEntry.getSuperClass()) == null) {
            superClassEntry = this.headerType();
        }
        pos = this.writeSuperReference(context, superClassEntry.getLayoutTypeSignature(), superClassEntry.getTypeName(), buffer, pos);
        pos = this.writeFields(context, classEntry, buffer, pos);
        pos = this.writeSkeletonMethodDeclarations(context, classEntry, buffer, pos);
        pos = this.writeAttrNull(buffer, pos);
        if (!loaderId.isEmpty()) {
            pos = this.writeAttrNull(buffer, pos);
        }
        pos = this.writeAttrNull(buffer, pos);
        this.patchLength(lengthPos, buffer, pos);
        return pos;
    }

    private int writeForeignTypeUnit(DebugContext context, ForeignTypeEntry foreignTypeEntry, byte[] buffer, int p) {
        int pos = p;
        long typeSignature = foreignTypeEntry.getTypeSignature();
        int lengthPos = pos;
        pos = this.writeTUHeader(typeSignature, buffer, pos);
        int typeOffsetPos = pos - 4;
        assert (pos == lengthPos + 24);
        DwarfDebugInfo.AbbrevCode abbrevCode = DwarfDebugInfo.AbbrevCode.TYPE_UNIT;
        this.log(context, "  [0x%08x] <0> Abbrev Number %d", pos, abbrevCode.ordinal());
        pos = this.writeAbbrevCode(abbrevCode, buffer, pos);
        this.log(context, "  [0x%08x]     language  %s", pos, "DW_LANG_Java");
        pos = this.writeAttrLanguage(DwarfDebugInfo.LANG_ENCODING, buffer, pos);
        this.log(context, "  [0x%08x]     use_UTF8", pos);
        pos = this.writeFlag(DwarfFlag.DW_FLAG_true, buffer, pos);
        String loaderId = foreignTypeEntry.getLoaderId();
        if (!loaderId.isEmpty()) {
            pos = this.writeNameSpace(context, loaderId, buffer, pos);
        }
        int refTypeIdx = pos;
        this.log(context, "  [0x%08x] foreign pointer type", pos);
        abbrevCode = DwarfDebugInfo.AbbrevCode.TYPE_POINTER_SIG;
        this.log(context, "  [0x%08x] <1> Abbrev Number %d", pos, abbrevCode.ordinal());
        pos = this.writeAbbrevCode(abbrevCode, buffer, pos);
        int pointerSize = this.dwarfSections.pointerSize();
        this.log(context, "  [0x%08x]     byte_size 0x%x", pos, pointerSize);
        pos = this.writeAttrData1((byte)pointerSize, buffer, pos);
        long layoutTypeSignature = foreignTypeEntry.getLayoutTypeSignature();
        this.log(context, "  [0x%08x]     type 0x%x", pos, layoutTypeSignature);
        pos = this.writeTypeSignature(layoutTypeSignature, buffer, pos);
        this.writeInt(pos - lengthPos, buffer, typeOffsetPos);
        this.log(context, "  [0x%08x] foreign typedef", pos);
        abbrevCode = DwarfDebugInfo.AbbrevCode.FOREIGN_TYPEDEF;
        this.log(context, "  [0x%08x] <1> Abbrev Number %d", pos, abbrevCode.ordinal());
        pos = this.writeAbbrevCode(abbrevCode, buffer, pos);
        String name = this.uniqueDebugString(foreignTypeEntry.getTypeName());
        this.log(context, "  [0x%08x]     name %s", pos, name);
        pos = this.writeStrSectionOffset(name, buffer, pos);
        this.log(context, "  [0x%08x]     type 0x%x", pos, refTypeIdx);
        pos = this.writeAttrRef4(refTypeIdx, buffer, pos);
        if (!loaderId.isEmpty()) {
            pos = this.writeAttrNull(buffer, pos);
        }
        pos = this.writeAttrNull(buffer, pos);
        this.patchLength(lengthPos, buffer, pos);
        return pos;
    }

    private int writeForeignLayoutTypeUnit(DebugContext context, ForeignTypeEntry foreignTypeEntry, byte[] buffer, int p) {
        int pos = p;
        String loaderId = foreignTypeEntry.getLoaderId();
        int lengthPos = pos;
        if (foreignTypeEntry.isWord() || foreignTypeEntry.isIntegral() || foreignTypeEntry.isFloat() || foreignTypeEntry.isStruct()) {
            pos = this.writeTUPreamble(context, foreignTypeEntry.getLayoutTypeSignature(), loaderId, buffer, pos);
        }
        int size = foreignTypeEntry.getSize();
        if (foreignTypeEntry.isWord()) {
            pos = this.writeForeignWordLayout(context, foreignTypeEntry, size, foreignTypeEntry.isSigned(), buffer, pos);
        } else if (foreignTypeEntry.isIntegral()) {
            pos = this.writeForeignIntegerLayout(context, foreignTypeEntry, size, foreignTypeEntry.isSigned(), buffer, pos);
        } else if (foreignTypeEntry.isFloat()) {
            pos = this.writeForeignFloatLayout(context, foreignTypeEntry, size, buffer, pos);
        } else if (foreignTypeEntry.isStruct()) {
            pos = this.writeForeignStructLayout(context, foreignTypeEntry, size, buffer, pos);
        } else {
            TypeEntry pointerTo;
            TypeEntry targetType = this.voidType();
            if (foreignTypeEntry.isPointer() && (pointerTo = foreignTypeEntry.getPointerTo()) != null) {
                targetType = pointerTo;
            }
            this.log(context, "  [0x%08x] foreign pointer type %s referent 0x%x (%s)", pos, foreignTypeEntry.getTypeName(), targetType.getTypeSignature(), targetType.getTypeName());
            foreignTypeEntry.setLayoutTypeSignature(targetType.getTypeSignature());
            return p;
        }
        pos = this.writeSkeletonMethodDeclarations(context, foreignTypeEntry, buffer, pos);
        if (!loaderId.isEmpty()) {
            pos = this.writeAttrNull(buffer, pos);
        }
        pos = this.writeAttrNull(buffer, pos);
        this.patchLength(lengthPos, buffer, pos);
        return pos;
    }

    private int writeInstanceClassInfo(DebugContext context, ClassEntry classEntry, byte[] buffer, int p) {
        String loaderId;
        int pos;
        int lengthPos = pos = p;
        this.log(context, "  [0x%08x] Instance class unit", pos);
        pos = this.writeCUHeader(buffer, pos);
        assert (pos == lengthPos + 12);
        DwarfDebugInfo.AbbrevCode abbrevCode = classEntry.hasCompiledEntries() ? (this.getLocationListIndex(classEntry) == 0 ? DwarfDebugInfo.AbbrevCode.CLASS_UNIT_2 : DwarfDebugInfo.AbbrevCode.CLASS_UNIT_3) : DwarfDebugInfo.AbbrevCode.CLASS_UNIT_1;
        this.log(context, "  [0x%08x] <0> Abbrev Number %d", pos, abbrevCode.ordinal());
        pos = this.writeAbbrevCode(abbrevCode, buffer, pos);
        this.log(context, "  [0x%08x]     language  %s", pos, "DW_LANG_Java");
        pos = this.writeAttrLanguage(DwarfDebugInfo.LANG_ENCODING, buffer, pos);
        this.log(context, "  [0x%08x]     use_UTF8", pos);
        pos = this.writeFlag(DwarfFlag.DW_FLAG_true, buffer, pos);
        Object name = classEntry.getFullFileName();
        if (name == null) {
            name = classEntry.getTypeName().replace('.', '/') + ".java";
        }
        this.log(context, "  [0x%08x]     name  0x%x (%s)", pos, this.debugStringIndex((String)name), name);
        pos = this.writeStrSectionOffset(this.uniqueDebugString((String)name), buffer, pos);
        String compilationDirectory = this.dwarfSections.getCachePath();
        this.log(context, "  [0x%08x]     comp_dir  0x%x (%s)", pos, this.debugStringIndex(compilationDirectory), compilationDirectory);
        pos = this.writeStrSectionOffset(compilationDirectory, buffer, pos);
        if (abbrevCode == DwarfDebugInfo.AbbrevCode.CLASS_UNIT_2 || abbrevCode == DwarfDebugInfo.AbbrevCode.CLASS_UNIT_3) {
            int codeRangesIndex = this.getCodeRangesIndex(classEntry);
            this.log(context, "  [0x%08x]     ranges  0x%x", pos, codeRangesIndex);
            pos = this.writeRangeListsSectionOffset(codeRangesIndex, buffer, pos);
            int lo = classEntry.lowpc();
            this.log(context, "  [0x%08x]     low_pc  0x%x", pos, codeRangesIndex);
            pos = this.writeAttrAddress(lo, buffer, pos);
            int lineIndex = this.getLineIndex(classEntry);
            this.log(context, "  [0x%08x]     stmt_list  0x%x", pos, lineIndex);
            pos = this.writeLineSectionOffset(lineIndex, buffer, pos);
            if (abbrevCode == DwarfDebugInfo.AbbrevCode.CLASS_UNIT_3) {
                int locationListIndex = this.getLocationListIndex(classEntry);
                this.log(context, "  [0x%08x]     loclists_base  0x%x", pos, locationListIndex);
                pos = this.writeLocSectionOffset(locationListIndex, buffer, pos);
            }
        }
        if (!(loaderId = classEntry.getLoaderId()).isEmpty()) {
            pos = this.writeNameSpace(context, loaderId, buffer, pos);
        }
        pos = this.writeSkeletonClassLayout(context, classEntry, buffer, pos);
        pos = this.writeMethodLocations(context, classEntry, buffer, pos);
        pos = this.writeAbstractInlineMethods(context, classEntry, buffer, pos);
        pos = this.writeStaticFieldLocations(context, classEntry, buffer, pos);
        if (!loaderId.isEmpty()) {
            pos = this.writeAttrNull(buffer, pos);
        }
        pos = this.writeAttrNull(buffer, pos);
        this.patchLength(lengthPos, buffer, pos);
        return pos;
    }

    private int writeNameSpace(DebugContext context, String id, byte[] buffer, int p) {
        int pos = p;
        String name = this.uniqueDebugString(id);
        assert (!id.isEmpty());
        this.log(context, "  [0x%08x] namespace %s", pos, name);
        DwarfDebugInfo.AbbrevCode abbrevCode = DwarfDebugInfo.AbbrevCode.NAMESPACE;
        this.log(context, "  [0x%08x] <1> Abbrev Number %d", pos, abbrevCode.ordinal());
        pos = this.writeAbbrevCode(abbrevCode, buffer, pos);
        this.log(context, "  [0x%08x]     name  0x%x (%s)", pos, this.debugStringIndex(name), name);
        pos = this.writeStrSectionOffset(name, buffer, pos);
        return pos;
    }

    private int writeClassConstantDeclaration(DebugContext context, TypeEntry typeEntry, byte[] buffer, int p) {
        int pos = p;
        this.log(context, "  [0x%08x] class constant", pos);
        long offset = typeEntry.getClassOffset();
        if (offset < 0L) {
            return pos;
        }
        DwarfDebugInfo.AbbrevCode abbrevCode = DwarfDebugInfo.AbbrevCode.CLASS_CONSTANT;
        this.log(context, "  [0x%08x] <1> Abbrev Number %d", pos, abbrevCode.ordinal());
        pos = this.writeAbbrevCode(abbrevCode, buffer, pos);
        String name = this.uniqueDebugString(typeEntry.getTypeName() + ".class");
        this.log(context, "  [0x%08x]     name  0x%x (%s)", pos, this.debugStringIndex(name), name);
        pos = this.writeStrSectionOffset(name, buffer, pos);
        ClassEntry valueType = this.dwarfSections.getHubClassEntry();
        long typeSignature = valueType == null ? this.lookupObjectClass().getLayoutTypeSignature() : valueType.getLayoutTypeSignature();
        this.log(context, "  [0x%08x]     type  0x%x (<hub type>)", pos, typeSignature);
        pos = this.writeTypeSignature(typeSignature, buffer, pos);
        this.log(context, "  [0x%08x]     accessibility public static final", pos);
        pos = this.writeAttrAccessibility(25, buffer, pos);
        this.log(context, "  [0x%08x]     external(true)", pos);
        pos = this.writeFlag(DwarfFlag.DW_FLAG_true, buffer, pos);
        this.log(context, "  [0x%08x]     location  heapbase + 0x%x (class constant)", pos, offset);
        pos = this.writeHeapLocationExprLoc(offset, buffer, pos);
        return pos;
    }

    private int writeSuperReference(DebugContext context, long typeSignature, String superName, byte[] buffer, int p) {
        int pos = p;
        this.log(context, "  [0x%08x] super reference", pos);
        DwarfDebugInfo.AbbrevCode abbrevCode = DwarfDebugInfo.AbbrevCode.SUPER_REFERENCE;
        this.log(context, "  [0x%08x] <2> Abbrev Number %d", pos, abbrevCode.ordinal());
        pos = this.writeAbbrevCode(abbrevCode, buffer, pos);
        this.log(context, "  [0x%08x]     type 0x%x (%s)", pos, typeSignature, superName);
        pos = this.writeTypeSignature(typeSignature, buffer, pos);
        this.log(context, "  [0x%08x]     data_member_location (super) 0x%x", pos, 0);
        pos = this.writeAttrData1((byte)0, buffer, pos);
        this.log(context, "  [0x%08x]     modifiers public", pos);
        int modifiers = 1;
        pos = this.writeAttrAccessibility(modifiers, buffer, pos);
        return pos;
    }

    private int writeFields(DebugContext context, ClassEntry classEntry, byte[] buffer, int p) {
        return classEntry.fields().filter(DwarfInfoSectionImpl::isManifestedField).reduce(p, (pos, fieldEntry) -> this.writeField(context, classEntry, (FieldEntry)fieldEntry, buffer, (int)pos), (oldPos, newPos) -> newPos);
    }

    private static boolean isManifestedField(FieldEntry fieldEntry) {
        return fieldEntry.getOffset() >= 0;
    }

    private int writeField(DebugContext context, StructureTypeEntry entry, FieldEntry fieldEntry, byte[] buffer, int p) {
        int pos = p;
        int modifiers = fieldEntry.getModifiers();
        boolean hasFile = !fieldEntry.getFileName().isEmpty();
        this.log(context, "  [0x%08x] field definition", pos);
        boolean isStatic = Modifier.isStatic(modifiers);
        DwarfDebugInfo.AbbrevCode abbrevCode = !isStatic ? (!hasFile ? DwarfDebugInfo.AbbrevCode.FIELD_DECLARATION_1 : DwarfDebugInfo.AbbrevCode.FIELD_DECLARATION_2) : (!hasFile ? DwarfDebugInfo.AbbrevCode.FIELD_DECLARATION_3 : DwarfDebugInfo.AbbrevCode.FIELD_DECLARATION_4);
        this.log(context, "  [0x%08x] <2> Abbrev Number %d", pos, abbrevCode.ordinal());
        pos = this.writeAbbrevCode(abbrevCode, buffer, pos);
        String name = fieldEntry.fieldName();
        this.log(context, "  [0x%08x]     name  0x%x (%s)", pos, this.debugStringIndex(name), name);
        pos = this.writeStrSectionOffset(name, buffer, pos);
        if (hasFile) {
            assert (entry instanceof ClassEntry);
            int fileIdx = fieldEntry.getFileIdx();
            assert (fileIdx > 0);
            this.log(context, "  [0x%08x]     filename  0x%x (%s)", pos, fileIdx, fieldEntry.getFileName());
            pos = this.writeAttrData2((short)fileIdx, buffer, pos);
        }
        TypeEntry valueType = fieldEntry.getValueType();
        long typeSignature = valueType.getTypeSignatureForCompressed();
        this.log(context, "  [0x%08x]     type  0x%x (%s)", pos, typeSignature, valueType.getTypeName());
        pos = this.writeTypeSignature(typeSignature, buffer, pos);
        if (!isStatic) {
            int memberOffset = fieldEntry.getOffset();
            this.log(context, "  [0x%08x]     member offset 0x%x", pos, memberOffset);
            pos = this.writeAttrData2((short)memberOffset, buffer, pos);
        }
        this.log(context, "  [0x%08x]     accessibility %s", pos, fieldEntry.getModifiersString());
        pos = this.writeAttrAccessibility(fieldEntry.getModifiers(), buffer, pos);
        if (isStatic) {
            this.log(context, "  [0x%08x]     external(true)", pos);
            pos = this.writeFlag(DwarfFlag.DW_FLAG_true, buffer, pos);
            this.log(context, "  [0x%08x]     definition(true)", pos);
            pos = this.writeFlag(DwarfFlag.DW_FLAG_true, buffer, pos);
        }
        return pos;
    }

    private int writeSkeletonMethodDeclarations(DebugContext context, ClassEntry classEntry, byte[] buffer, int p) {
        int pos = p;
        for (MethodEntry method : classEntry.getMethods()) {
            if (!method.isInRange() && !method.isInlined()) continue;
            pos = this.writeSkeletonMethodDeclaration(context, classEntry, method, buffer, pos);
        }
        return pos;
    }

    private int writeSkeletonMethodDeclaration(DebugContext context, ClassEntry classEntry, MethodEntry method, byte[] buffer, int p) {
        int pos = p;
        this.log(context, "  [0x%08x] method declaration %s::%s", pos, classEntry.getTypeName(), method.methodName());
        DwarfDebugInfo.AbbrevCode abbrevCode = DwarfDebugInfo.AbbrevCode.METHOD_DECLARATION_SKELETON;
        this.log(context, "  [0x%08x] <2> Abbrev Number %d", pos, abbrevCode.ordinal());
        pos = this.writeAbbrevCode(abbrevCode, buffer, pos);
        this.log(context, "  [0x%08x]     external  true", pos);
        pos = this.writeFlag(DwarfFlag.DW_FLAG_true, buffer, pos);
        String name = this.uniqueDebugString(method.methodName());
        this.log(context, "  [0x%08x]     name 0x%x (%s)", pos, this.debugStringIndex(name), name);
        pos = this.writeStrSectionOffset(name, buffer, pos);
        String linkageName = this.uniqueDebugString(method.getSymbolName());
        this.log(context, "  [0x%08x]     linkage_name %s", pos, linkageName);
        pos = this.writeStrSectionOffset(linkageName, buffer, pos);
        TypeEntry returnType = method.getValueType();
        long retTypeSignature = returnType.getTypeSignature();
        this.log(context, "  [0x%08x]     type 0x%x (%s)", pos, retTypeSignature, returnType.getTypeName());
        pos = this.writeTypeSignature(retTypeSignature, buffer, pos);
        this.log(context, "  [0x%08x]     artificial %s", pos, method.isDeopt() ? "true" : "false");
        pos = this.writeFlag(method.isDeopt() ? DwarfFlag.DW_FLAG_true : DwarfFlag.DW_FLAG_false, buffer, pos);
        int modifiers = method.getModifiers();
        this.log(context, "  [0x%08x]     accessibility %s", pos, method.getModifiersString());
        pos = this.writeAttrAccessibility(modifiers, buffer, pos);
        this.log(context, "  [0x%08x]     declaration true", pos);
        pos = this.writeFlag(DwarfFlag.DW_FLAG_true, buffer, pos);
        pos = this.writeSkeletonMethodParameterDeclarations(context, method, buffer, pos);
        return this.writeAttrNull(buffer, pos);
    }

    private int writeSkeletonMethodParameterDeclarations(DebugContext context, MethodEntry method, byte[] buffer, int p) {
        int pos = p;
        if (!Modifier.isStatic(method.getModifiers())) {
            DebugInfoProvider.DebugLocalInfo paramInfo = method.getThisParam();
            pos = this.writeSkeletonMethodParameterDeclaration(context, paramInfo, true, buffer, pos);
        }
        for (int i = 0; i < method.getParamCount(); ++i) {
            DebugInfoProvider.DebugLocalInfo paramInfo = method.getParam(i);
            pos = this.writeSkeletonMethodParameterDeclaration(context, paramInfo, false, buffer, pos);
        }
        return pos;
    }

    private int writeSkeletonMethodParameterDeclaration(DebugContext context, DebugInfoProvider.DebugLocalInfo paramInfo, boolean artificial, byte[] buffer, int p) {
        int pos = p;
        this.log(context, "  [0x%08x] method parameter declaration", pos);
        TypeEntry paramType = this.lookupType(paramInfo.valueType());
        DwarfDebugInfo.AbbrevCode abbrevCode = artificial ? DwarfDebugInfo.AbbrevCode.METHOD_PARAMETER_DECLARATION_4 : DwarfDebugInfo.AbbrevCode.METHOD_PARAMETER_DECLARATION_5;
        this.log(context, "  [0x%08x] <3> Abbrev Number %d", pos, abbrevCode.ordinal());
        pos = this.writeAbbrevCode(abbrevCode, buffer, pos);
        long typeSignature = paramType.getTypeSignature();
        this.log(context, "  [0x%08x]     type 0x%x (%s)", pos, typeSignature, paramType.getTypeName());
        pos = this.writeTypeSignature(typeSignature, buffer, pos);
        if (abbrevCode == DwarfDebugInfo.AbbrevCode.METHOD_PARAMETER_DECLARATION_4) {
            this.log(context, "  [0x%08x]     artificial true", pos);
            pos = this.writeFlag(DwarfFlag.DW_FLAG_true, buffer, pos);
        }
        return pos;
    }

    private int writeMethodDeclarations(DebugContext context, ClassEntry classEntry, byte[] buffer, int p) {
        int pos = p;
        for (MethodEntry method : classEntry.getMethods()) {
            if (!method.isInRange() && !method.isInlined()) continue;
            pos = this.writeMethodDeclaration(context, classEntry, method, buffer, pos);
        }
        return pos;
    }

    private int writeMethodDeclaration(DebugContext context, ClassEntry classEntry, MethodEntry method, byte[] buffer, int p) {
        int pos = p;
        String methodKey = method.getSymbolName();
        String linkageName = this.uniqueDebugString(methodKey);
        this.setMethodDeclarationIndex(method, pos);
        int modifiers = method.getModifiers();
        boolean isStatic = Modifier.isStatic(modifiers);
        this.log(context, "  [0x%08x] method declaration %s::%s", pos, classEntry.getTypeName(), method.methodName());
        DwarfDebugInfo.AbbrevCode abbrevCode = isStatic ? DwarfDebugInfo.AbbrevCode.METHOD_DECLARATION_STATIC : DwarfDebugInfo.AbbrevCode.METHOD_DECLARATION;
        this.log(context, "  [0x%08x] <2> Abbrev Number %d", pos, abbrevCode.ordinal());
        pos = this.writeAbbrevCode(abbrevCode, buffer, pos);
        this.log(context, "  [0x%08x]     external  true", pos);
        pos = this.writeFlag(DwarfFlag.DW_FLAG_true, buffer, pos);
        String name = this.uniqueDebugString(method.methodName());
        this.log(context, "  [0x%08x]     name 0x%x (%s)", pos, this.debugStringIndex(name), name);
        pos = this.writeStrSectionOffset(name, buffer, pos);
        FileEntry fileEntry = method.getFileEntry();
        if (fileEntry == null) {
            fileEntry = classEntry.getFileEntry();
        }
        assert (fileEntry != null);
        int fileIdx = classEntry.getFileIdx(fileEntry);
        this.log(context, "  [0x%08x]     file 0x%x (%s)", pos, fileIdx, fileEntry.getFullName());
        pos = this.writeAttrData2((short)fileIdx, buffer, pos);
        int line = method.getLine();
        this.log(context, "  [0x%08x]     line 0x%x", pos, line);
        pos = this.writeAttrData2((short)line, buffer, pos);
        this.log(context, "  [0x%08x]     linkage_name %s", pos, linkageName);
        pos = this.writeStrSectionOffset(linkageName, buffer, pos);
        TypeEntry returnType = method.getValueType();
        long retTypeSignature = returnType.getTypeSignature();
        this.log(context, "  [0x%08x]     type 0x%x (%s)", pos, retTypeSignature, returnType.getTypeName());
        pos = this.writeTypeSignature(retTypeSignature, buffer, pos);
        this.log(context, "  [0x%08x]     artificial %s", pos, method.isDeopt() ? "true" : "false");
        pos = this.writeFlag(method.isDeopt() ? DwarfFlag.DW_FLAG_true : DwarfFlag.DW_FLAG_false, buffer, pos);
        this.log(context, "  [0x%08x]     accessibility %s", pos, "public");
        pos = this.writeAttrAccessibility(modifiers, buffer, pos);
        this.log(context, "  [0x%08x]     declaration true", pos);
        pos = this.writeFlag(DwarfFlag.DW_FLAG_true, buffer, pos);
        long typeSignature = classEntry.getLayoutTypeSignature();
        this.log(context, "  [0x%08x]     containing_type 0x%x (%s)", pos, typeSignature, classEntry.getTypeName());
        pos = this.writeTypeSignature(typeSignature, buffer, pos);
        if (abbrevCode == DwarfDebugInfo.AbbrevCode.METHOD_DECLARATION) {
            int objectPointerIndex = pos;
            pos = this.writeAttrRef4(0, null, pos);
            this.log(context, "  [0x%08x]     object_pointer 0x%x", objectPointerIndex, pos);
            this.writeAttrRef4(pos, buffer, objectPointerIndex);
        }
        pos = this.writeMethodParameterDeclarations(context, classEntry, method, fileIdx, 3, buffer, pos);
        pos = this.writeMethodLocalDeclarations(context, classEntry, method, fileIdx, 3, buffer, pos);
        return this.writeAttrNull(buffer, pos);
    }

    private int writeMethodParameterDeclarations(DebugContext context, ClassEntry classEntry, MethodEntry method, int fileIdx, int level, byte[] buffer, int p) {
        int refAddr;
        int pos = p;
        if (!Modifier.isStatic(method.getModifiers())) {
            refAddr = pos;
            DebugInfoProvider.DebugLocalInfo paramInfo = method.getThisParam();
            this.setMethodLocalIndex(classEntry, method, paramInfo, refAddr);
            pos = this.writeMethodParameterDeclaration(context, paramInfo, fileIdx, true, level, buffer, pos);
        }
        for (int i = 0; i < method.getParamCount(); ++i) {
            refAddr = pos;
            DebugInfoProvider.DebugLocalInfo paramInfo = method.getParam(i);
            this.setMethodLocalIndex(classEntry, method, paramInfo, refAddr);
            pos = this.writeMethodParameterDeclaration(context, paramInfo, fileIdx, false, level, buffer, pos);
        }
        return pos;
    }

    private int writeMethodParameterDeclaration(DebugContext context, DebugInfoProvider.DebugLocalInfo paramInfo, int fileIdx, boolean artificial, int level, byte[] buffer, int p) {
        int pos = p;
        this.log(context, "  [0x%08x] method parameter declaration", pos);
        String paramName = paramInfo.name();
        TypeEntry paramType = this.lookupType(paramInfo.valueType());
        int line = paramInfo.line();
        DwarfDebugInfo.AbbrevCode abbrevCode = artificial ? DwarfDebugInfo.AbbrevCode.METHOD_PARAMETER_DECLARATION_1 : (line >= 0 ? DwarfDebugInfo.AbbrevCode.METHOD_PARAMETER_DECLARATION_2 : DwarfDebugInfo.AbbrevCode.METHOD_PARAMETER_DECLARATION_3);
        this.log(context, "  [0x%08x] <%d> Abbrev Number %d", pos, level, abbrevCode.ordinal());
        pos = this.writeAbbrevCode(abbrevCode, buffer, pos);
        this.log(context, "  [0x%08x]     name %s", pos, paramName);
        pos = this.writeStrSectionOffset(this.uniqueDebugString(paramName), buffer, pos);
        if (abbrevCode == DwarfDebugInfo.AbbrevCode.METHOD_PARAMETER_DECLARATION_2) {
            this.log(context, "  [0x%08x]     file 0x%x", pos, fileIdx);
            pos = this.writeAttrData2((short)fileIdx, buffer, pos);
            this.log(context, "  [0x%08x]     line 0x%x", pos, line);
            pos = this.writeAttrData2((short)line, buffer, pos);
        }
        long typeSignature = paramType.getTypeSignature();
        this.log(context, "  [0x%08x]     type 0x%x (%s)", pos, typeSignature, paramType.getTypeName());
        pos = this.writeTypeSignature(typeSignature, buffer, pos);
        if (abbrevCode == DwarfDebugInfo.AbbrevCode.METHOD_PARAMETER_DECLARATION_1) {
            this.log(context, "  [0x%08x]     artificial true", pos);
            pos = this.writeFlag(DwarfFlag.DW_FLAG_true, buffer, pos);
        }
        this.log(context, "  [0x%08x]     declaration true", pos);
        pos = this.writeFlag(DwarfFlag.DW_FLAG_true, buffer, pos);
        return pos;
    }

    private int writeMethodLocalDeclarations(DebugContext context, ClassEntry classEntry, MethodEntry method, int fileIdx, int level, byte[] buffer, int p) {
        int pos = p;
        for (int i = 0; i < method.getLocalCount(); ++i) {
            int refAddr = pos;
            DebugInfoProvider.DebugLocalInfo localInfo = method.getLocal(i);
            this.setMethodLocalIndex(classEntry, method, localInfo, refAddr);
            pos = this.writeMethodLocalDeclaration(context, localInfo, fileIdx, level, buffer, pos);
        }
        return pos;
    }

    private int writeMethodLocalDeclaration(DebugContext context, DebugInfoProvider.DebugLocalInfo paramInfo, int fileIdx, int level, byte[] buffer, int p) {
        int pos = p;
        this.log(context, "  [0x%08x] method local declaration", pos);
        String paramName = paramInfo.name();
        TypeEntry paramType = this.lookupType(paramInfo.valueType());
        int line = paramInfo.line();
        DwarfDebugInfo.AbbrevCode abbrevCode = line >= 0 ? DwarfDebugInfo.AbbrevCode.METHOD_LOCAL_DECLARATION_1 : DwarfDebugInfo.AbbrevCode.METHOD_LOCAL_DECLARATION_2;
        this.log(context, "  [0x%08x] <%d> Abbrev Number %d", pos, level, abbrevCode.ordinal());
        pos = this.writeAbbrevCode(abbrevCode, buffer, pos);
        this.log(context, "  [0x%08x]     name %s", pos, paramName);
        pos = this.writeStrSectionOffset(this.uniqueDebugString(paramName), buffer, pos);
        if (abbrevCode == DwarfDebugInfo.AbbrevCode.METHOD_LOCAL_DECLARATION_1) {
            this.log(context, "  [0x%08x]     file 0x%x", pos, fileIdx);
            pos = this.writeAttrData2((short)fileIdx, buffer, pos);
            this.log(context, "  [0x%08x]     line 0x%x", pos, line);
            pos = this.writeAttrData2((short)line, buffer, pos);
        }
        long typeSignature = paramType.getTypeSignature();
        this.log(context, "  [0x%08x]     type 0x%x (%s)", pos, typeSignature, paramType.getTypeName());
        pos = this.writeTypeSignature(typeSignature, buffer, pos);
        this.log(context, "  [0x%08x]     declaration true", pos);
        pos = this.writeFlag(DwarfFlag.DW_FLAG_true, buffer, pos);
        return pos;
    }

    private int writeInterfaceImplementors(DebugContext context, InterfaceClassEntry interfaceClassEntry, byte[] buffer, int p) {
        return interfaceClassEntry.implementors().reduce(p, (pos, classEntry) -> this.writeInterfaceImplementor(context, (ClassEntry)classEntry, buffer, (int)pos), (oldPos, newPos) -> newPos);
    }

    private int writeInterfaceImplementor(DebugContext context, ClassEntry classEntry, byte[] buffer, int p) {
        int pos = p;
        this.log(context, "  [0x%08x] interface implementor", pos);
        DwarfDebugInfo.AbbrevCode abbrevCode = DwarfDebugInfo.AbbrevCode.INTERFACE_IMPLEMENTOR;
        this.log(context, "  [0x%08x] <2> Abbrev Number %d", pos, abbrevCode.ordinal());
        pos = this.writeAbbrevCode(abbrevCode, buffer, pos);
        String name = this.uniqueDebugString("_" + classEntry.getTypeName());
        this.log(context, "  [0x%08x]     name  0x%x (%s)", pos, this.debugStringIndex(name), name);
        pos = this.writeStrSectionOffset(name, buffer, pos);
        long typeSignature = classEntry.getLayoutTypeSignature();
        this.log(context, "  [0x%08x]     type  0x%x (%s)", pos, typeSignature, classEntry.getTypeName());
        pos = this.writeTypeSignature(typeSignature, buffer, pos);
        int modifiers = 1;
        this.log(context, "  [0x%08x]     modifiers %s", pos, "public");
        pos = this.writeAttrAccessibility(modifiers, buffer, pos);
        return pos;
    }

    private int writeForeignStructLayout(DebugContext context, ForeignTypeEntry foreignTypeEntry, int size, byte[] buffer, int p) {
        int pos = p;
        this.log(context, "  [0x%08x] foreign struct type for %s", pos, foreignTypeEntry.getTypeName());
        DwarfDebugInfo.AbbrevCode abbrevCode = DwarfDebugInfo.AbbrevCode.FOREIGN_STRUCT;
        this.log(context, "  [0x%08x] <1> Abbrev Number %d", pos, abbrevCode.ordinal());
        pos = this.writeAbbrevCode(abbrevCode, buffer, pos);
        Object typedefName = foreignTypeEntry.getTypedefName();
        if (typedefName == null) {
            typedefName = "_" + foreignTypeEntry.getTypeName();
            this.verboseLog(context, "  [0x%08x]   using synthetic typedef name %s", pos, typedefName);
        }
        if (((String)typedefName).startsWith("struct ")) {
            this.log(context, "  [0x%08x]     typedefName includes redundant keyword struct %s", pos, typedefName);
            typedefName = ((String)typedefName).substring("struct ".length());
        }
        typedefName = this.uniqueDebugString((String)typedefName);
        this.log(context, "  [0x%08x]     name  0x%x (%s)", pos, this.debugStringIndex((String)typedefName), typedefName);
        pos = this.writeStrSectionOffset((String)typedefName, buffer, pos);
        this.log(context, "  [0x%08x]     byte_size  0x%x", pos, size);
        pos = this.writeAttrData1((byte)size, buffer, pos);
        ForeignTypeEntry parent = foreignTypeEntry.getParent();
        if (parent != null) {
            long typeSignature = parent.getLayoutTypeSignature();
            pos = this.writeSuperReference(context, typeSignature, parent.getTypedefName(), buffer, pos);
        }
        pos = this.writeStructFields(context, foreignTypeEntry.fields(), buffer, pos);
        return this.writeAttrNull(buffer, pos);
    }

    private int writeForeignWordLayout(DebugContext context, ForeignTypeEntry foreignTypeEntry, int size, boolean isSigned, byte[] buffer, int p) {
        int pos = p;
        this.log(context, "  [0x%08x] foreign primitive word type for %s", pos, foreignTypeEntry.getTypeName());
        DwarfDebugInfo.AbbrevCode abbrevCode = DwarfDebugInfo.AbbrevCode.PRIMITIVE_TYPE;
        this.log(context, "  [0x%08x] <1> Abbrev Number %d", pos, abbrevCode.ordinal());
        pos = this.writeAbbrevCode(abbrevCode, buffer, pos);
        assert (size >= 0);
        byte byteSize = (byte)(size > 0 ? size : this.dwarfSections.pointerSize());
        this.log(context, "  [0x%08x]     byte_size  %d", pos, byteSize);
        pos = this.writeAttrData1(byteSize, buffer, pos);
        byte bitCount = (byte)(byteSize * 8);
        this.log(context, "  [0x%08x]     bitCount  %d", pos, bitCount);
        pos = this.writeAttrData1(bitCount, buffer, pos);
        DwarfEncoding encoding = isSigned ? DwarfEncoding.DW_ATE_signed : DwarfEncoding.DW_ATE_unsigned;
        this.log(context, "  [0x%08x]     encoding  0x%x", pos, encoding.value());
        pos = this.writeAttrEncoding(encoding, buffer, pos);
        String name = this.uniqueDebugString(DwarfInfoSectionImpl.integralTypeName(byteSize, isSigned));
        this.log(context, "  [0x%08x]     name  0x%x (%s)", pos, this.debugStringIndex(name), name);
        return this.writeStrSectionOffset(name, buffer, pos);
    }

    private int writeForeignIntegerLayout(DebugContext context, ForeignTypeEntry foreignTypeEntry, int size, boolean isSigned, byte[] buffer, int p) {
        int pos = p;
        this.log(context, "  [0x%08x] foreign primitive integral type for %s", pos, foreignTypeEntry.getTypeName());
        DwarfDebugInfo.AbbrevCode abbrevCode = DwarfDebugInfo.AbbrevCode.PRIMITIVE_TYPE;
        this.log(context, "  [0x%08x] <1> Abbrev Number %d", pos, abbrevCode.ordinal());
        pos = this.writeAbbrevCode(abbrevCode, buffer, pos);
        assert (size > 0);
        byte byteSize = (byte)size;
        this.log(context, "  [0x%08x]     byte_size  %d", pos, byteSize);
        pos = this.writeAttrData1(byteSize, buffer, pos);
        byte bitCount = (byte)(byteSize * 8);
        this.log(context, "  [0x%08x]     bitCount  %d", pos, bitCount);
        pos = this.writeAttrData1(bitCount, buffer, pos);
        DwarfEncoding encoding = isSigned ? DwarfEncoding.DW_ATE_signed : DwarfEncoding.DW_ATE_unsigned;
        this.log(context, "  [0x%08x]     encoding  0x%x", pos, encoding.value());
        pos = this.writeAttrEncoding(encoding, buffer, pos);
        String name = this.uniqueDebugString(DwarfInfoSectionImpl.integralTypeName(byteSize, isSigned));
        this.log(context, "  [0x%08x]     name  0x%x (%s)", pos, this.debugStringIndex(name), name);
        return this.writeStrSectionOffset(name, buffer, pos);
    }

    private int writeForeignFloatLayout(DebugContext context, ForeignTypeEntry foreignTypeEntry, int size, byte[] buffer, int p) {
        int pos = p;
        this.log(context, "  [0x%08x] foreign primitive float type for %s", pos, foreignTypeEntry.getTypeName());
        DwarfDebugInfo.AbbrevCode abbrevCode = DwarfDebugInfo.AbbrevCode.PRIMITIVE_TYPE;
        this.log(context, "  [0x%08x] <1> Abbrev Number %d", pos, abbrevCode.ordinal());
        pos = this.writeAbbrevCode(abbrevCode, buffer, pos);
        assert (size > 0);
        byte byteSize = (byte)size;
        this.log(context, "  [0x%08x]     byte_size  %d", pos, byteSize);
        pos = this.writeAttrData1(byteSize, buffer, pos);
        byte bitCount = (byte)(byteSize * 8);
        this.log(context, "  [0x%08x]     bitCount  %d", pos, bitCount);
        pos = this.writeAttrData1(bitCount, buffer, pos);
        DwarfEncoding encoding = DwarfEncoding.DW_ATE_float;
        this.log(context, "  [0x%08x]     encoding  0x%x", pos, encoding.value());
        pos = this.writeAttrEncoding(encoding, buffer, pos);
        String name = this.uniqueDebugString(size == 4 ? "float" : (size == 8 ? "double" : "long double"));
        this.log(context, "  [0x%08x]     name  0x%x (%s)", pos, this.debugStringIndex(name), name);
        return this.writeStrSectionOffset(name, buffer, pos);
    }

    private static String integralTypeName(int byteSize, boolean isSigned) {
        assert ((byteSize & byteSize - 1) == 0) : "expecting a power of 2!";
        StringBuilder stringBuilder = new StringBuilder();
        if (!isSigned) {
            stringBuilder.append('u');
        }
        stringBuilder.append("int");
        stringBuilder.append(8 * byteSize);
        stringBuilder.append("_t");
        return stringBuilder.toString();
    }

    private int writeStaticFieldLocations(DebugContext context, ClassEntry classEntry, byte[] buffer, int p) {
        DwarfSectionImpl.Cursor cursor = new DwarfSectionImpl.Cursor(this, p);
        classEntry.fields().filter(DwarfInfoSectionImpl::isManifestedStaticField).forEach(fieldEntry -> cursor.set(this.writeClassStaticFieldLocation(context, classEntry, (FieldEntry)fieldEntry, buffer, cursor.get())));
        return cursor.get();
    }

    private int writeStaticFieldDeclarations(DebugContext context, ClassEntry classEntry, byte[] buffer, int p) {
        DwarfSectionImpl.Cursor cursor = new DwarfSectionImpl.Cursor(this, p);
        classEntry.fields().filter(DwarfInfoSectionImpl::isManifestedStaticField).forEach(fieldEntry -> cursor.set(this.writeClassStaticFieldDeclaration(context, classEntry, (FieldEntry)fieldEntry, buffer, cursor.get())));
        return cursor.get();
    }

    private static boolean isManifestedStaticField(FieldEntry fieldEntry) {
        return Modifier.isStatic(fieldEntry.getModifiers()) && fieldEntry.getOffset() >= 0;
    }

    private int writeClassStaticFieldDeclaration(DebugContext context, ClassEntry classEntry, FieldEntry fieldEntry, byte[] buffer, int p) {
        assert (Modifier.isStatic(fieldEntry.getModifiers()));
        int pos = p;
        boolean hasFile = !fieldEntry.getFileName().isEmpty();
        this.log(context, "  [0x%08x] field definition", pos);
        DwarfDebugInfo.AbbrevCode abbrevCode = !hasFile ? DwarfDebugInfo.AbbrevCode.FIELD_DECLARATION_3 : DwarfDebugInfo.AbbrevCode.FIELD_DECLARATION_4;
        this.setFieldDeclarationIndex(classEntry, fieldEntry.fieldName(), pos);
        this.log(context, "  [0x%08x] <2> Abbrev Number %d", pos, abbrevCode.ordinal());
        pos = this.writeAbbrevCode(abbrevCode, buffer, pos);
        String name = fieldEntry.fieldName();
        this.log(context, "  [0x%08x]     name  0x%x (%s)", pos, this.debugStringIndex(name), name);
        pos = this.writeStrSectionOffset(name, buffer, pos);
        if (hasFile) {
            int fileIdx = fieldEntry.getFileIdx();
            assert (fileIdx > 0);
            this.log(context, "  [0x%08x]     filename  0x%x (%s)", pos, fileIdx, fieldEntry.getFileName());
            pos = this.writeAttrData2((short)fileIdx, buffer, pos);
        }
        TypeEntry valueType = fieldEntry.getValueType();
        long typeSignature = valueType.getTypeSignatureForCompressed();
        this.log(context, "  [0x%08x]     type  0x%x (%s)", pos, typeSignature, valueType.getTypeName());
        pos = this.writeTypeSignature(typeSignature, buffer, pos);
        this.log(context, "  [0x%08x]     accessibility %s", pos, fieldEntry.getModifiersString());
        pos = this.writeAttrAccessibility(fieldEntry.getModifiers(), buffer, pos);
        this.log(context, "  [0x%08x]     external(true)", pos);
        pos = this.writeFlag(DwarfFlag.DW_FLAG_true, buffer, pos);
        this.log(context, "  [0x%08x]     definition(true)", pos);
        pos = this.writeFlag(DwarfFlag.DW_FLAG_true, buffer, pos);
        return pos;
    }

    private int writeClassStaticFieldLocation(DebugContext context, ClassEntry classEntry, FieldEntry fieldEntry, byte[] buffer, int p) {
        int pos = p;
        String fieldName = fieldEntry.fieldName();
        int fieldDefinitionOffset = this.getFieldDeclarationIndex(classEntry, fieldName);
        this.log(context, "  [0x%08x] static field location %s.%s", pos, classEntry.getTypeName(), fieldName);
        DwarfDebugInfo.AbbrevCode abbrevCode = DwarfDebugInfo.AbbrevCode.STATIC_FIELD_LOCATION;
        this.log(context, "  [0x%08x] <1> Abbrev Number %d", pos, abbrevCode.ordinal());
        pos = this.writeAbbrevCode(abbrevCode, buffer, pos);
        this.log(context, "  [0x%08x]     specification  0x%x", pos, fieldDefinitionOffset);
        pos = this.writeAttrRef4(fieldDefinitionOffset, buffer, pos);
        int offset = fieldEntry.getOffset();
        this.log(context, "  [0x%08x]     location  heapbase + 0x%x (%s)", pos, offset, fieldEntry.getValueType().isPrimitive() ? "primitive" : "object");
        pos = this.writeHeapLocationExprLoc(offset, buffer, pos);
        return pos;
    }

    private int writeArrays(DebugContext context, byte[] buffer, int p) {
        this.log(context, "  [0x%08x] array classes", p);
        DwarfSectionImpl.Cursor cursor = new DwarfSectionImpl.Cursor(this, p);
        this.arrayTypeStream().forEach(arrayTypeEntry -> {
            cursor.set(this.writeTypeUnits(context, (StructureTypeEntry)arrayTypeEntry, buffer, cursor.get()));
            cursor.set(this.writeArray(context, (ArrayTypeEntry)arrayTypeEntry, buffer, cursor.get()));
        });
        return cursor.get();
    }

    private int writeArrayLayoutTypeUnit(DebugContext context, ArrayTypeEntry arrayTypeEntry, byte[] buffer, int p) {
        int pos = p;
        String loaderId = arrayTypeEntry.getLoaderId();
        int lengthPos = pos;
        pos = this.writeTUPreamble(context, arrayTypeEntry.getLayoutTypeSignature(), loaderId, buffer, pos);
        TypeEntry elementType = arrayTypeEntry.getElementType();
        int size = arrayTypeEntry.getSize();
        this.log(context, "  [0x%08x] array layout", pos);
        DwarfDebugInfo.AbbrevCode abbrevCode = DwarfDebugInfo.AbbrevCode.ARRAY_LAYOUT;
        this.log(context, "  [0x%08x] <1> Abbrev Number %d", pos, abbrevCode.ordinal());
        pos = this.writeAbbrevCode(abbrevCode, buffer, pos);
        String name = arrayTypeEntry.getTypeName();
        this.log(context, "  [0x%08x]     name 0x%x (%s)", pos, this.debugStringIndex(name), name);
        pos = this.writeStrSectionOffset(name, buffer, pos);
        this.log(context, "  [0x%08x]     byte_size  0x%x", pos, size);
        int arrayDataTypeIdx = pos = this.writeAttrData2((short)size, buffer, pos);
        pos = this.writeArrayDataType(context, elementType, buffer, pos);
        pos = this.writeFields(context, arrayTypeEntry, buffer, pos);
        pos = this.writeArrayElementField(context, size, arrayDataTypeIdx, buffer, pos);
        ClassEntry objectType = this.lookupObjectClass();
        String superName = objectType.getTypeName();
        long typeSignature = objectType.getLayoutTypeSignature();
        pos = this.writeSuperReference(context, typeSignature, superName, buffer, pos);
        pos = this.writeAttrNull(buffer, pos);
        if (!loaderId.isEmpty()) {
            pos = this.writeAttrNull(buffer, pos);
        }
        pos = this.writeAttrNull(buffer, pos);
        this.patchLength(lengthPos, buffer, pos);
        return pos;
    }

    private int writeArray(DebugContext context, ArrayTypeEntry arrayTypeEntry, byte[] buffer, int p) {
        int pos;
        int lengthPos = pos = p;
        this.log(context, "  [0x%08x] Array class unit", pos);
        pos = this.writeCUHeader(buffer, pos);
        assert (pos == lengthPos + 12);
        DwarfDebugInfo.AbbrevCode abbrevCode = DwarfDebugInfo.AbbrevCode.CLASS_UNIT_1;
        this.log(context, "  [0x%08x] <0> Abbrev Number %d", pos, abbrevCode.ordinal());
        pos = this.writeAbbrevCode(abbrevCode, buffer, pos);
        this.log(context, "  [0x%08x]     language  %s", pos, "DW_LANG_Java");
        pos = this.writeAttrLanguage(DwarfDebugInfo.LANG_ENCODING, buffer, pos);
        this.log(context, "  [0x%08x]     use_UTF8", pos);
        pos = this.writeFlag(DwarfFlag.DW_FLAG_true, buffer, pos);
        String name = this.uniqueDebugString("JAVA");
        this.log(context, "  [0x%08x]     name  0x%x (%s)", pos, this.debugStringIndex(name), name);
        pos = this.writeStrSectionOffset(name, buffer, pos);
        String compilationDirectory = this.dwarfSections.getCachePath();
        this.log(context, "  [0x%08x]     comp_dir  0x%x (%s)", pos, this.debugStringIndex(compilationDirectory), compilationDirectory);
        pos = this.writeStrSectionOffset(compilationDirectory, buffer, pos);
        String loaderId = arrayTypeEntry.getLoaderId();
        if (!loaderId.isEmpty()) {
            pos = this.writeNameSpace(context, loaderId, buffer, pos);
        }
        pos = this.writeSkeletonArrayLayout(context, arrayTypeEntry, buffer, pos);
        if (!loaderId.isEmpty()) {
            pos = this.writeAttrNull(buffer, pos);
        }
        pos = this.writeAttrNull(buffer, pos);
        this.patchLength(lengthPos, buffer, pos);
        return pos;
    }

    private int writeSkeletonArrayLayout(DebugContext context, ArrayTypeEntry arrayTypeEntry, byte[] buffer, int p) {
        int pos = p;
        this.log(context, "  [0x%08x] array layout", pos);
        DwarfDebugInfo.AbbrevCode abbrevCode = DwarfDebugInfo.AbbrevCode.CLASS_LAYOUT_3;
        this.log(context, "  [0x%08x] <1> Abbrev Number %d", pos, abbrevCode.ordinal());
        pos = this.writeAbbrevCode(abbrevCode, buffer, pos);
        String name = arrayTypeEntry.getTypeName();
        this.log(context, "  [0x%08x]     name  0x%x (%s)", pos, this.debugStringIndex(name), name);
        pos = this.writeStrSectionOffset(name, buffer, pos);
        this.log(context, "  [0x%08x]     declaration true", pos);
        pos = this.writeFlag(DwarfFlag.DW_FLAG_true, buffer, pos);
        long typeSignature = arrayTypeEntry.getLayoutTypeSignature();
        this.log(context, "  [0x%08x]     type 0x%x", pos, typeSignature);
        pos = this.writeTypeSignature(typeSignature, buffer, pos);
        return this.writeAttrNull(buffer, pos);
    }

    private int writeFields(DebugContext context, ArrayTypeEntry arrayTypeEntry, byte[] buffer, int p) {
        DwarfSectionImpl.Cursor cursor = new DwarfSectionImpl.Cursor(this, p);
        arrayTypeEntry.fields().filter(DwarfInfoSectionImpl::isManifestedField).forEach(fieldEntry -> cursor.set(this.writeField(context, arrayTypeEntry, (FieldEntry)fieldEntry, buffer, cursor.get())));
        return cursor.get();
    }

    private int writeArrayDataType(DebugContext context, TypeEntry elementType, byte[] buffer, int p) {
        int pos = p;
        this.log(context, "  [0x%08x] array element data type", pos);
        DwarfDebugInfo.AbbrevCode abbrevCode = DwarfDebugInfo.AbbrevCode.ARRAY_DATA_TYPE_1;
        this.log(context, "  [0x%08x] <2> Abbrev Number %d", pos, abbrevCode.ordinal());
        pos = this.writeAbbrevCode(abbrevCode, buffer, pos);
        String elementTypeName = elementType.getTypeName();
        long elementTypeSignature = elementType.getTypeSignatureForCompressed();
        this.log(context, "  [0x%08x]     type idx 0x%x (%s)", pos, elementTypeSignature, elementTypeName);
        pos = this.writeTypeSignature(elementTypeSignature, buffer, pos);
        return pos;
    }

    private int writeEmbeddedArrayDataType(DebugContext context, ForeignTypeEntry foreignValueType, int valueSize, int arraySize, byte[] buffer, int p) {
        long elementTypeSignature;
        int pos = p;
        this.log(context, "  [0x%08x] embedded array element data type", pos);
        DwarfDebugInfo.AbbrevCode abbrevCode = DwarfDebugInfo.AbbrevCode.ARRAY_DATA_TYPE_2;
        this.log(context, "  [0x%08x] <2> Abbrev Number %d", pos, abbrevCode.ordinal());
        pos = this.writeAbbrevCode(abbrevCode, buffer, pos);
        int size = arraySize * valueSize;
        this.log(context, "  [0x%08x]     byte_size 0x%x", pos, size);
        pos = this.writeAttrData4(size, buffer, pos);
        String elementTypeName = foreignValueType.getTypeName();
        if (foreignValueType.isPointer()) {
            TypeEntry pointerTo = foreignValueType.getPointerTo();
            assert (pointerTo != null) : "ADDRESS field pointer type must have a known target type";
            elementTypeSignature = pointerTo.getTypeSignature();
        } else {
            elementTypeSignature = foreignValueType.getLayoutTypeSignature();
        }
        this.log(context, "  [0x%08x]     type idx 0x%x (%s)", pos, elementTypeSignature, elementTypeName);
        pos = this.writeTypeSignature(elementTypeSignature, buffer, pos);
        this.log(context, "  [0x%08x] embedded array element range", pos);
        abbrevCode = DwarfDebugInfo.AbbrevCode.ARRAY_SUBRANGE;
        this.log(context, "  [0x%08x] <3> Abbrev Number %d", pos, abbrevCode.ordinal());
        pos = this.writeAbbrevCode(abbrevCode, buffer, pos);
        this.log(context, "  [0x%08x]     count 0x%x", pos, arraySize);
        pos = this.writeAttrData4(arraySize, buffer, pos);
        return this.writeAttrNull(buffer, pos);
    }

    private int writeArrayElementField(DebugContext context, int offset, int arrayDataTypeIdx, byte[] buffer, int p) {
        int pos = p;
        this.log(context, "  [0x%08x] array element data field", pos);
        DwarfDebugInfo.AbbrevCode abbrevCode = DwarfDebugInfo.AbbrevCode.ARRAY_ELEMENT_FIELD;
        this.log(context, "  [0x%08x] <2> Abbrev Number %d", pos, abbrevCode.ordinal());
        pos = this.writeAbbrevCode(abbrevCode, buffer, pos);
        String fieldName = this.uniqueDebugString("data");
        this.log(context, "  [0x%08x]     name  0x%x (%s)", pos, this.debugStringIndex(fieldName), fieldName);
        pos = this.writeStrSectionOffset(fieldName, buffer, pos);
        this.log(context, "  [0x%08x]     type idx 0x%x", pos, arrayDataTypeIdx);
        pos = this.writeInfoSectionOffset(arrayDataTypeIdx, buffer, pos);
        int size = 0;
        this.log(context, "  [0x%08x]     offset 0x%x (size 0x%x)", pos, offset, size);
        pos = this.writeAttrData2((short)offset, buffer, pos);
        int modifiers = 1;
        this.log(context, "  [0x%08x]     modifiers %s", pos, "public");
        return this.writeAttrAccessibility(modifiers, buffer, pos);
    }

    private int writeMethodLocations(DebugContext context, ClassEntry classEntry, byte[] buffer, int p) {
        DwarfSectionImpl.Cursor cursor = new DwarfSectionImpl.Cursor(this, p);
        classEntry.compiledEntries().forEach(compiledMethodEntry -> cursor.set(this.writeMethodLocation(context, classEntry, (CompiledMethodEntry)compiledMethodEntry, buffer, cursor.get())));
        return cursor.get();
    }

    private int writeMethodLocation(DebugContext context, ClassEntry classEntry, CompiledMethodEntry compiledEntry, byte[] buffer, int p) {
        int pos = p;
        PrimaryRange primary = compiledEntry.getPrimary();
        this.log(context, "  [0x%08x] method location", pos);
        DwarfDebugInfo.AbbrevCode abbrevCode = DwarfDebugInfo.AbbrevCode.METHOD_LOCATION;
        this.log(context, "  [0x%08x] <1> Abbrev Number %d", pos, abbrevCode.ordinal());
        pos = this.writeAbbrevCode(abbrevCode, buffer, pos);
        this.log(context, "  [0x%08x]     lo_pc  0x%08x", pos, primary.getLo());
        pos = this.writeAttrAddress(primary.getLo(), buffer, pos);
        this.log(context, "  [0x%08x]     hi_pc  0x%08x", pos, primary.getHi());
        pos = this.writeAttrAddress(primary.getHi(), buffer, pos);
        this.log(context, "  [0x%08x]     external  true", pos);
        pos = this.writeFlag(DwarfFlag.DW_FLAG_true, buffer, pos);
        String methodKey = primary.getSymbolName();
        int methodSpecOffset = this.getMethodDeclarationIndex(primary.getMethodEntry());
        this.log(context, "  [0x%08x]     specification  0x%x (%s)", pos, methodSpecOffset, methodKey);
        pos = this.writeInfoSectionOffset(methodSpecOffset, buffer, pos);
        HashMap<DebugInfoProvider.DebugLocalInfo, List<SubRange>> varRangeMap = primary.getVarRangeMap();
        pos = this.writeMethodParameterLocations(context, classEntry, varRangeMap, primary, 2, buffer, pos);
        pos = this.writeMethodLocalLocations(context, classEntry, varRangeMap, primary, 2, buffer, pos);
        if (primary.includesInlineRanges()) {
            pos = this.generateConcreteInlinedMethods(context, classEntry, compiledEntry, buffer, pos);
        }
        return this.writeAttrNull(buffer, pos);
    }

    private int writeMethodParameterLocations(DebugContext context, ClassEntry classEntry, HashMap<DebugInfoProvider.DebugLocalInfo, List<SubRange>> varRangeMap, Range range, int depth, byte[] buffer, int p) {
        MethodEntry methodEntry;
        int pos = p;
        if (range.isPrimary()) {
            methodEntry = range.getMethodEntry();
        } else {
            assert (!range.isLeaf()) : "should only be looking up var ranges for inlined calls";
            methodEntry = range.getFirstCallee().getMethodEntry();
        }
        if (!Modifier.isStatic(methodEntry.getModifiers())) {
            DebugInfoProvider.DebugLocalInfo thisParamInfo = methodEntry.getThisParam();
            int refAddr = this.getMethodLocalIndex(classEntry, methodEntry, thisParamInfo);
            List<SubRange> ranges = varRangeMap.get(thisParamInfo);
            pos = this.writeMethodLocalLocation(context, range, thisParamInfo, refAddr, ranges, depth, true, buffer, pos);
        }
        for (int i = 0; i < methodEntry.getParamCount(); ++i) {
            DebugInfoProvider.DebugLocalInfo paramInfo = methodEntry.getParam(i);
            int refAddr = this.getMethodLocalIndex(classEntry, methodEntry, paramInfo);
            List<SubRange> ranges = varRangeMap.get(paramInfo);
            pos = this.writeMethodLocalLocation(context, range, paramInfo, refAddr, ranges, depth, true, buffer, pos);
        }
        return pos;
    }

    private int writeMethodLocalLocations(DebugContext context, ClassEntry classEntry, HashMap<DebugInfoProvider.DebugLocalInfo, List<SubRange>> varRangeMap, Range range, int depth, byte[] buffer, int p) {
        MethodEntry methodEntry;
        int pos = p;
        if (range.isPrimary()) {
            methodEntry = range.getMethodEntry();
        } else {
            assert (!range.isLeaf()) : "should only be looking up var ranges for inlined calls";
            methodEntry = range.getFirstCallee().getMethodEntry();
        }
        int count = methodEntry.getLocalCount();
        for (int i = 0; i < count; ++i) {
            DebugInfoProvider.DebugLocalInfo localInfo = methodEntry.getLocal(i);
            int refAddr = this.getMethodLocalIndex(classEntry, methodEntry, localInfo);
            List<SubRange> ranges = varRangeMap.get(localInfo);
            pos = this.writeMethodLocalLocation(context, range, localInfo, refAddr, ranges, depth, false, buffer, pos);
        }
        return pos;
    }

    private int writeMethodLocalLocation(DebugContext context, Range range, DebugInfoProvider.DebugLocalInfo localInfo, int refAddr, List<SubRange> ranges, int depth, boolean isParam, byte[] buffer, int p) {
        int pos = p;
        this.log(context, "  [0x%08x] method %s location %s:%s", pos, isParam ? "parameter" : "local", localInfo.name(), localInfo.typeName());
        ArrayList<DebugInfoProvider.DebugLocalValueInfo> localValues = new ArrayList<DebugInfoProvider.DebugLocalValueInfo>();
        for (SubRange subrange : ranges) {
            DebugInfoProvider.DebugLocalValueInfo value = subrange.lookupValue(localInfo);
            if (value == null) continue;
            this.log(context, "  [0x%08x]     local  %s:%s [0x%x, 0x%x] = %s", pos, value.name(), value.typeName(), subrange.getLo(), subrange.getHi(), DwarfInfoSectionImpl.formatValue(value));
            switch (value.localKind()) {
                case REGISTER: 
                case STACKSLOT: {
                    localValues.add(value);
                    break;
                }
                case CONSTANT: {
                    JavaConstant constant = value.constantValue();
                    if (!(constant instanceof PrimitiveConstant) && constant.getJavaKind() != JavaKind.Object) break;
                    localValues.add(value);
                    break;
                }
            }
        }
        DwarfDebugInfo.AbbrevCode abbrevCode = localValues.isEmpty() ? (isParam ? DwarfDebugInfo.AbbrevCode.METHOD_PARAMETER_LOCATION_1 : DwarfDebugInfo.AbbrevCode.METHOD_LOCAL_LOCATION_1) : (isParam ? DwarfDebugInfo.AbbrevCode.METHOD_PARAMETER_LOCATION_2 : DwarfDebugInfo.AbbrevCode.METHOD_LOCAL_LOCATION_2);
        this.log(context, "  [0x%08x] <%d> Abbrev Number %d", pos, depth, abbrevCode.ordinal());
        pos = this.writeAbbrevCode(abbrevCode, buffer, pos);
        this.log(context, "  [0x%08x]     specification  0x%x", pos, refAddr);
        pos = this.writeInfoSectionOffset(refAddr, buffer, pos);
        if (abbrevCode == DwarfDebugInfo.AbbrevCode.METHOD_LOCAL_LOCATION_2 || abbrevCode == DwarfDebugInfo.AbbrevCode.METHOD_PARAMETER_LOCATION_2) {
            int locRefOffset = this.getRangeLocalIndex(range, localInfo);
            this.log(context, "  [0x%08x]     loc list  0x%x", pos, locRefOffset);
            pos = this.writeULEB(locRefOffset, buffer, pos);
        }
        return pos;
    }

    private int generateConcreteInlinedMethods(DebugContext context, ClassEntry classEntry, CompiledMethodEntry compiledEntry, byte[] buffer, int p) {
        PrimaryRange primary = compiledEntry.getPrimary();
        if (((Range)primary).isLeaf()) {
            return p;
        }
        int pos = p;
        this.log(context, "  [0x%08x] concrete entries [0x%x,0x%x] %s", pos, primary.getLo(), primary.getHi(), primary.getFullMethodName());
        int depth = 0;
        Iterator<SubRange> iterator = compiledEntry.topDownRangeIterator();
        while (iterator.hasNext()) {
            SubRange subrange = iterator.next();
            if (subrange.isLeaf()) continue;
            while (depth > subrange.getDepth()) {
                pos = this.writeAttrNull(buffer, pos);
                --depth;
            }
            depth = subrange.getDepth();
            pos = this.writeInlineSubroutine(context, classEntry, subrange, depth + 2, buffer, pos);
            HashMap<DebugInfoProvider.DebugLocalInfo, List<SubRange>> varRangeMap = subrange.getVarRangeMap();
            pos = this.writeMethodParameterLocations(context, classEntry, varRangeMap, subrange, ++depth + 2, buffer, pos);
            pos = this.writeMethodLocalLocations(context, classEntry, varRangeMap, subrange, depth + 2, buffer, pos);
        }
        while (depth > 0) {
            pos = this.writeAttrNull(buffer, pos);
            --depth;
        }
        return pos;
    }

    private int writeInlineSubroutine(DebugContext context, ClassEntry classEntry, SubRange caller, int depth, byte[] buffer, int p) {
        int fileIndex;
        assert (!caller.isLeaf());
        SubRange callee = caller.getFirstCallee();
        MethodEntry methodEntry = callee.getMethodEntry();
        String methodKey = methodEntry.getSymbolName();
        int abstractOriginIndex = classEntry == methodEntry.ownerType() ? this.getMethodDeclarationIndex(methodEntry) : this.getAbstractInlineMethodIndex(classEntry, methodEntry);
        int pos = p;
        this.log(context, "  [0x%08x] concrete inline subroutine [0x%x, 0x%x] %s", pos, caller.getLo(), caller.getHi(), methodKey);
        int callLine = caller.getLine();
        assert (callLine >= -1) : callLine;
        if (callLine == -1) {
            this.log(context, "  Unable to retrieve call line for inlined method %s", callee.getFullMethodName());
            callLine = 0;
            fileIndex = classEntry.getFileIdx();
        } else {
            FileEntry subFileEntry = caller.getFileEntry();
            if (subFileEntry != null) {
                fileIndex = classEntry.getFileIdx(subFileEntry);
            } else {
                this.log(context, "  Unable to retrieve caller FileEntry for inlined method %s (caller method %s)", callee.getFullMethodName(), caller.getFullMethodName());
                fileIndex = classEntry.getFileIdx();
            }
        }
        DwarfDebugInfo.AbbrevCode abbrevCode = DwarfDebugInfo.AbbrevCode.INLINED_SUBROUTINE_WITH_CHILDREN;
        this.log(context, "  [0x%08x] <%d> Abbrev Number %d", pos, depth, abbrevCode.ordinal());
        pos = this.writeAbbrevCode(abbrevCode, buffer, pos);
        this.log(context, "  [0x%08x]     abstract_origin  0x%x", pos, abstractOriginIndex);
        pos = this.writeAttrRef4(abstractOriginIndex, buffer, pos);
        this.log(context, "  [0x%08x]     lo_pc  0x%08x", pos, caller.getLo());
        pos = this.writeAttrAddress(caller.getLo(), buffer, pos);
        this.log(context, "  [0x%08x]     hi_pc  0x%08x", pos, caller.getHi());
        pos = this.writeAttrAddress(caller.getHi(), buffer, pos);
        this.log(context, "  [0x%08x]     call_file  %d", pos, fileIndex);
        pos = this.writeAttrData4(fileIndex, buffer, pos);
        this.log(context, "  [0x%08x]     call_line  %d", pos, callLine);
        pos = this.writeAttrData4(callLine, buffer, pos);
        return pos;
    }

    private int writeAbstractInlineMethods(DebugContext context, ClassEntry classEntry, byte[] buffer, int p) {
        EconomicSet<MethodEntry> inlinedMethods = this.collectInlinedMethods(context, classEntry, p);
        int pos = p;
        for (MethodEntry methodEntry : inlinedMethods) {
            this.setAbstractInlineMethodIndex(classEntry, methodEntry, pos);
            pos = this.writeAbstractInlineMethod(context, classEntry, methodEntry, buffer, pos);
        }
        return pos;
    }

    private EconomicSet<MethodEntry> collectInlinedMethods(DebugContext context, ClassEntry classEntry, int p) {
        EconomicSet methods = EconomicSet.create();
        classEntry.compiledEntries().forEach(compiledEntry -> this.addInlinedMethods(context, (CompiledMethodEntry)compiledEntry, compiledEntry.getPrimary(), (EconomicSet<MethodEntry>)methods, p));
        return methods;
    }

    private void addInlinedMethods(DebugContext context, CompiledMethodEntry compiledEntry, Range primary, EconomicSet<MethodEntry> hashSet, int p) {
        if (primary.isLeaf()) {
            return;
        }
        this.verboseLog(context, "  [0x%08x] collect abstract inlined methods %s", p, primary.getFullMethodName());
        Iterator<SubRange> iterator = compiledEntry.topDownRangeIterator();
        while (iterator.hasNext()) {
            SubRange callee;
            MethodEntry methodEntry;
            SubRange subrange = iterator.next();
            if (subrange.isLeaf() || !hashSet.add((Object)(methodEntry = (callee = subrange.getFirstCallee()).getMethodEntry()))) continue;
            this.verboseLog(context, "  [0x%08x]   add abstract inlined method %s", p, methodEntry.getSymbolName());
        }
    }

    private int writeAbstractInlineMethod(DebugContext context, ClassEntry classEntry, MethodEntry method, byte[] buffer, int p) {
        int pos = p;
        this.log(context, "  [0x%08x] abstract inline method %s::%s", pos, classEntry.getTypeName(), method.methodName());
        DwarfDebugInfo.AbbrevCode abbrevCode = DwarfDebugInfo.AbbrevCode.ABSTRACT_INLINE_METHOD;
        this.log(context, "  [0x%08x] <1> Abbrev Number %d", pos, abbrevCode.ordinal());
        pos = this.writeAbbrevCode(abbrevCode, buffer, pos);
        this.log(context, "  [0x%08x]     inline  0x%x", pos, DwarfInline.DW_INL_inlined.value());
        pos = this.writeAttrInline(DwarfInline.DW_INL_inlined, buffer, pos);
        this.log(context, "  [0x%08x]     external  true", pos);
        pos = this.writeFlag(DwarfFlag.DW_FLAG_true, buffer, pos);
        int methodSpecOffset = this.getMethodDeclarationIndex(method);
        this.log(context, "  [0x%08x]     specification  0x%x", pos, methodSpecOffset);
        pos = this.writeInfoSectionOffset(methodSpecOffset, buffer, pos);
        if (classEntry != method.ownerType()) {
            FileEntry fileEntry = method.getFileEntry();
            if (fileEntry == null) {
                fileEntry = classEntry.getFileEntry();
            }
            assert (fileEntry != null);
            int fileIdx = classEntry.getFileIdx(fileEntry);
            int level = 3;
            pos = this.writeMethodParameterDeclarations(context, classEntry, method, fileIdx, level, buffer, pos);
            pos = this.writeMethodLocalDeclarations(context, classEntry, method, fileIdx, level, buffer, pos);
        }
        return this.writeAttrNull(buffer, pos);
    }

    private int writeAttrRef4(int reference, byte[] buffer, int p) {
        assert (this.unitStart >= 0);
        return this.writeAttrData4(reference - this.unitStart, buffer, p);
    }

    private int writeCUHeader(byte[] buffer, int p) {
        int pos;
        this.unitStart = pos = p;
        pos = this.writeInt(0, buffer, pos);
        pos = this.writeDwarfVersion(DwarfVersion.DW_VERSION_5, buffer, pos);
        pos = this.writeDwarfUnitHeader(DwarfUnitHeader.DW_UT_compile, buffer, pos);
        pos = this.writeByte((byte)8, buffer, pos);
        return this.writeAbbrevSectionOffset(0, buffer, pos);
    }

    private int writeTUHeader(long typeSignature, byte[] buffer, int p) {
        int pos;
        this.unitStart = pos = p;
        pos = this.writeInt(0, buffer, pos);
        pos = this.writeDwarfVersion(DwarfVersion.DW_VERSION_5, buffer, pos);
        pos = this.writeDwarfUnitHeader(DwarfUnitHeader.DW_UT_type, buffer, pos);
        pos = this.writeByte((byte)8, buffer, pos);
        pos = this.writeAbbrevSectionOffset(0, buffer, pos);
        pos = this.writeTypeSignature(typeSignature, buffer, pos);
        return this.writeInt(0, buffer, pos);
    }

    public int writeAttrString(String value, byte[] buffer, int p) {
        return this.writeUTF8StringBytes(value, buffer, p);
    }

    public int writeAttrLanguage(DwarfLanguage language, byte[] buffer, int p) {
        return this.writeByte(language.value(), buffer, p);
    }

    public int writeAttrEncoding(DwarfEncoding encoding, byte[] buffer, int p) {
        return this.writeByte(encoding.value(), buffer, p);
    }

    public int writeAttrInline(DwarfInline inline, byte[] buffer, int p) {
        return this.writeByte(inline.value(), buffer, p);
    }

    public int writeAttrAccessibility(int modifiers, byte[] buffer, int p) {
        DwarfAccess access = Modifier.isPublic(modifiers) ? DwarfAccess.DW_ACCESS_public : (Modifier.isProtected(modifiers) ? DwarfAccess.DW_ACCESS_protected : (Modifier.isPrivate(modifiers) ? DwarfAccess.DW_ACCESS_private : DwarfAccess.DW_ACCESS_public));
        return this.writeByte(access.value(), buffer, p);
    }

    public int writeCompressedOopConversionExpression(boolean isHub, byte[] buffer, int p) {
        int pos = p;
        boolean useHeapBase = this.dwarfSections.useHeapBase();
        int reservedBitsMask = this.dwarfSections.reservedBitsMask();
        int numReservedBits = this.dwarfSections.numReservedBits();
        int compressionShift = this.dwarfSections.compressionShift();
        int numAlignmentBits = this.dwarfSections.numAlignmentBits();
        int lengthPos = pos;
        int exprStart = pos = this.writeULEB(0L, buffer, pos);
        pos = this.writeExprOpcode(DwarfExpressionOpcode.DW_OP_push_object_address, buffer, pos);
        if (isHub && reservedBitsMask != 0) {
            if (numReservedBits == numAlignmentBits && compressionShift == 0) {
                pos = this.writeExprOpcodeLiteral(reservedBitsMask, buffer, pos);
                pos = this.writeExprOpcode(DwarfExpressionOpcode.DW_OP_not, buffer, pos);
                pos = this.writeExprOpcode(DwarfExpressionOpcode.DW_OP_and, buffer, pos);
            } else {
                pos = this.writeExprOpcodeLiteral(numReservedBits, buffer, pos);
                pos = this.writeExprOpcode(DwarfExpressionOpcode.DW_OP_shr, buffer, pos);
                if (compressionShift != numAlignmentBits) {
                    pos = this.writeExprOpcodeLiteral(numAlignmentBits - compressionShift, buffer, pos);
                    pos = this.writeExprOpcode(DwarfExpressionOpcode.DW_OP_shl, buffer, pos);
                }
            }
        }
        if (useHeapBase) {
            if (compressionShift != 0) {
                pos = this.writeExprOpcodeLiteral(compressionShift, buffer, pos);
                pos = this.writeExprOpcode(DwarfExpressionOpcode.DW_OP_shl, buffer, pos);
            }
            pos = this.writeExprOpcodeBReg(this.dwarfSections.getHeapbaseRegister(), buffer, pos);
            pos = this.writeSLEB(0L, buffer, pos);
            pos = this.writeExprOpcode(DwarfExpressionOpcode.DW_OP_plus, buffer, pos);
        }
        int exprSize = pos - exprStart;
        assert (exprSize > 0 && exprSize <= 10);
        this.writeULEB(exprSize, buffer, lengthPos);
        return pos;
    }
}

