/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.pltgot.amd64;

import com.oracle.objectfile.ObjectFile;
import com.oracle.svm.core.ReservedRegisters;
import com.oracle.svm.core.graal.amd64.SubstrateAMD64Backend;
import com.oracle.svm.core.graal.code.SubstrateBackend;
import com.oracle.svm.core.graal.code.SubstrateCallingConventionKind;
import com.oracle.svm.core.meta.SharedMethod;
import com.oracle.svm.core.pltgot.GOTAccess;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.image.NativeImage;
import com.oracle.svm.hosted.meta.HostedMethod;
import com.oracle.svm.hosted.pltgot.HostedPLTGOTConfiguration;
import com.oracle.svm.hosted.pltgot.PLTSectionSupport;
import com.oracle.svm.hosted.pltgot.PLTStubGenerator;
import java.util.ArrayList;
import java.util.List;
import jdk.graal.compiler.asm.Assembler;
import jdk.graal.compiler.asm.amd64.AMD64Address;
import jdk.graal.compiler.asm.amd64.AMD64BaseAssembler;
import jdk.graal.compiler.asm.amd64.AMD64MacroAssembler;
import jdk.vm.ci.code.Register;
import jdk.vm.ci.code.RegisterConfig;
import jdk.vm.ci.meta.ResolvedJavaMethod;

public class AMD64PLTStubGenerator
implements PLTStubGenerator {
    private List<Integer> resolverPatchOffsets = new ArrayList<Integer>();
    private int resolverKindAddend;
    private ObjectFile.RelocationKind resolverPatchRelocationKind = null;

    @Override
    public byte[] generatePLT(SharedMethod[] got, SubstrateBackend substrateBackend) {
        HostedPLTGOTConfiguration configuration = HostedPLTGOTConfiguration.singleton();
        VMError.guarantee(configuration.getArchSpecificResolverAsHostedMethod().getCallingConventionKind().equals((Object)SubstrateCallingConventionKind.ForwardReturnValue), "AMD64PLTStubGenerator assumes that %s is using %s ", configuration.getArchSpecificResolverAsHostedMethod().format("%H.%n(%p)"), SubstrateCallingConventionKind.ForwardReturnValue.name());
        SubstrateAMD64Backend amd64Backend = (SubstrateAMD64Backend)substrateBackend;
        RegisterConfig registerConfig = amd64Backend.getCodeCache().getRegisterConfig();
        Register register = configuration.getGOTPassingRegister(registerConfig);
        AMD64MacroAssembler asm = (AMD64MacroAssembler)amd64Backend.createAssemblerNoOptions();
        PLTSectionSupport support = HostedPLTGOTConfiguration.singleton().getPLTSectionSupport();
        asm.setCodePatchingAnnotationConsumer(this::recordResolverCallForPatching);
        for (int gotEntryNo = 0; gotEntryNo < got.length; ++gotEntryNo) {
            HostedMethod method = (HostedMethod)got[gotEntryNo];
            int pltStubStart = asm.position();
            support.recordMethodPLTStubStart(method, pltStubStart);
            int gotEntryOffset = GOTAccess.getGotEntryOffsetFromHeapRegister(gotEntryNo);
            asm.maybeEmitIndirectTargetMarker();
            asm.movq(register, new AMD64Address(ReservedRegisters.singleton().getHeapBaseRegister(), gotEntryOffset));
            asm.jmp(register);
            support.recordMethodPLTStubResolverOffset(method, asm.position() - pltStubStart);
            asm.maybeEmitIndirectTargetMarker();
            asm.movl(register, gotEntryNo);
            asm.jmp();
        }
        return asm.close(true);
    }

    @Override
    public void markResolverMethodPatch(ObjectFile.ProgbitsSectionImpl pltBuffer, ResolvedJavaMethod resolverMethod) {
        for (int resolverPatchOffset : this.resolverPatchOffsets) {
            pltBuffer.markRelocationSite(resolverPatchOffset, this.resolverPatchRelocationKind, NativeImage.localSymbolNameForMethod(resolverMethod), (long)this.resolverKindAddend);
        }
    }

    private void recordResolverCallForPatching(Assembler.CodeAnnotation a) {
        assert (a instanceof AMD64BaseAssembler.OperandDataAnnotation);
        AMD64BaseAssembler.OperandDataAnnotation annotation = (AMD64BaseAssembler.OperandDataAnnotation)a;
        this.resolverPatchOffsets.add(annotation.operandPosition);
        this.resolverKindAddend = -annotation.operandSize;
        this.resolverPatchRelocationKind = ObjectFile.RelocationKind.getPCRelative((int)annotation.operandSize);
    }
}

