/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.config;

import com.oracle.svm.core.configure.ConfigurationConditionResolver;
import com.oracle.svm.core.configure.ConfigurationFile;
import com.oracle.svm.core.configure.ConfigurationFiles;
import com.oracle.svm.core.configure.ConfigurationParser;
import com.oracle.svm.core.configure.ReflectionConfigurationParser;
import com.oracle.svm.core.option.AccumulatingLocatableMultiOptionValue;
import com.oracle.svm.core.option.HostedOptionKey;
import com.oracle.svm.core.util.UserError;
import com.oracle.svm.hosted.ImageClassLoader;
import com.oracle.svm.hosted.config.RegistryAdapter;
import com.oracle.svm.hosted.reflect.proxy.ProxyRegistry;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Spliterators;
import java.util.function.Consumer;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import jdk.graal.compiler.util.json.JsonParserException;
import org.graalvm.nativeimage.impl.ConfigurationCondition;
import org.graalvm.nativeimage.impl.ReflectionRegistry;

public final class ConfigurationParserUtils {
    public static ReflectionConfigurationParser<ConfigurationCondition, Class<?>> create(String combinedFileKey, boolean strictMetadata, ConfigurationConditionResolver<ConfigurationCondition> conditionResolver, ReflectionRegistry registry, ProxyRegistry proxyRegistry, ImageClassLoader imageClassLoader) {
        return ReflectionConfigurationParser.create(combinedFileKey, strictMetadata, conditionResolver, RegistryAdapter.create(registry, proxyRegistry, imageClassLoader), ConfigurationFiles.Options.StrictConfiguration.getValue(), ConfigurationFiles.Options.WarnAboutMissingReflectionOrJNIMetadataElements.getValue(), ConfigurationFiles.Options.TreatAllNameEntriesAsType.getValue());
    }

    public static int parseAndRegisterConfigurations(ConfigurationParser parser, ImageClassLoader classLoader, String featureName, HostedOptionKey<AccumulatingLocatableMultiOptionValue.Paths> configFilesOption, HostedOptionKey<AccumulatingLocatableMultiOptionValue.Strings> configResourcesOption, String directoryFileName) {
        List<Path> paths = configFilesOption.getValue().values();
        List<String> resourceValues = configResourcesOption.getValue().values();
        return ConfigurationParserUtils.parseAndRegisterConfigurations(parser, classLoader, featureName, directoryFileName, paths, resourceValues);
    }

    public static int parseAndRegisterConfigurationsFromCombinedFile(ConfigurationParser parser, ImageClassLoader classLoader, String featureName) {
        return ConfigurationParserUtils.parseAndRegisterConfigurations(parser, classLoader, featureName, ConfigurationFile.REACHABILITY_METADATA.getFileName(), Collections.emptyList(), ConfigurationFiles.Options.ReachabilityMetadataResources.getValue().values());
    }

    public static int parseAndRegisterConfigurations(ConfigurationParser parser, ImageClassLoader classLoader, String featureName, String directoryFileName, List<Path> paths, List<String> resourceValues) {
        int parsedCount = 0;
        Stream files = Stream.concat(paths.stream(), ConfigurationFiles.findConfigurationFiles(directoryFileName).stream());
        parsedCount += files.map(Path::toAbsolutePath).mapToInt(path -> {
            if (!Files.exists(path, new LinkOption[0])) {
                throw UserError.abort("The %s configuration file \"%s\" does not exist.", featureName, path);
            }
            ConfigurationParserUtils.doParseAndRegister(parser, featureName, path);
            return 1;
        }).sum();
        Stream configResourcesFromOption = resourceValues.stream().flatMap(s -> {
            Enumeration<URL> urls;
            try {
                urls = classLoader.findResourcesByName((String)s);
            }
            catch (IOException e) {
                throw UserError.abort(e, "Error while looking for %s in %s", s, classLoader);
            }
            if (!urls.hasMoreElements()) {
                throw UserError.abort("Could not find %s configuration resource \"%s\".", featureName, s);
            }
            return StreamSupport.stream(new Spliterators.AbstractSpliterator<URL>(Long.MAX_VALUE, 16){

                @Override
                public boolean tryAdvance(Consumer<? super URL> action) {
                    if (!urls.hasMoreElements()) {
                        return false;
                    }
                    action.accept((URL)urls.nextElement());
                    return true;
                }
            }, false);
        });
        Stream resources = Stream.concat(configResourcesFromOption, ConfigurationFiles.findConfigurationResources(directoryFileName, classLoader.getClassLoader()).stream());
        return parsedCount += resources.mapToInt(url -> {
            ConfigurationParserUtils.doParseAndRegister(parser, featureName, url);
            return 1;
        }).sum();
    }

    private static void doParseAndRegister(ConfigurationParser parser, String featureName, Object location) {
        try {
            URI uri = location instanceof Path ? ((Path)location).toUri() : ((URL)location).toURI();
            parser.parseAndRegister(uri);
        }
        catch (IOException | URISyntaxException | JsonParserException e) {
            String errorMessage = e.getMessage();
            if (errorMessage == null || errorMessage.isEmpty()) {
                errorMessage = e.toString();
            }
            throw UserError.abort("Error parsing %s configuration in %s:%n%s%nVerify that the configuration matches the corresponding schema at https://github.com/oracle/graal/blob/master/docs/reference-manual/native-image/assets/", featureName, location, errorMessage);
        }
    }
}

