/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted;

import com.oracle.svm.core.jdk.Resources;
import com.oracle.svm.hosted.ResourcesFeature;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

@Platforms(value={Platform.HOSTED_ONLY.class})
public class EmbeddedResourcesInfo {
    private final ConcurrentHashMap<Resources.ModuleResourceKey, List<SourceAndOrigin>> registeredResources = new ConcurrentHashMap();

    public ConcurrentHashMap<Resources.ModuleResourceKey, List<SourceAndOrigin>> getRegisteredResources() {
        return this.registeredResources;
    }

    public static EmbeddedResourcesInfo singleton() {
        return (EmbeddedResourcesInfo)ImageSingletons.lookup(EmbeddedResourcesInfo.class);
    }

    public void declareResourceAsRegistered(Module module, String resource, String source, Object origin) {
        if (!((ResourcesFeature)ImageSingletons.lookup(ResourcesFeature.class)).collectEmbeddedResourcesInfo()) {
            return;
        }
        Resources.ModuleResourceKey key = Resources.createStorageKey(module, resource);
        List<SourceAndOrigin> existingEntries = this.registeredResources.get(key);
        if (existingEntries != null && existingEntries.size() == 1 && EmbeddedResourcesInfo.isNegativeQuery(existingEntries.get(0))) {
            this.registeredResources.remove(key);
        }
        this.registeredResources.compute(key, (k, v) -> {
            if (v == null) {
                ArrayList<SourceAndOrigin> newValue = new ArrayList<SourceAndOrigin>();
                newValue.add(new SourceAndOrigin(source, origin));
                return newValue;
            }
            boolean found = false;
            for (SourceAndOrigin existing : v) {
                if (!existing.source.equals(source)) continue;
                found = true;
                break;
            }
            if (!found) {
                v.add(new SourceAndOrigin(source, origin));
            }
            return v;
        });
    }

    private static boolean isNegativeQuery(SourceAndOrigin entry) {
        return entry.source().equalsIgnoreCase("") && ((String)entry.origin()).equalsIgnoreCase("");
    }

    record SourceAndOrigin(String source, Object origin) {
    }
}

