/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.util;

import com.oracle.svm.core.BuildPhaseProvider;
import com.oracle.svm.core.util.RuntimeImageHeapList;
import com.oracle.svm.core.util.VMError;
import java.lang.reflect.Array;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

@Platforms(value={Platform.HOSTED_ONLY.class})
public final class ImageHeapList {
    @Platforms(value={Platform.HOSTED_ONLY.class})
    public static <E> List<E> create(Class<E> elementClass) {
        return ImageHeapList.create(elementClass, null);
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public static <E> List<E> create(Class<E> elementClass, Comparator<E> comparator) {
        VMError.guarantee(!BuildPhaseProvider.isAnalysisFinished(), "Trying to create an ImageHeapList after analysis.");
        return new HostedImageHeapList<E>(elementClass, comparator);
    }

    private ImageHeapList() {
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public static final class HostedImageHeapList<E>
    extends AbstractList<E> {
        private final Comparator<E> comparator;
        private final List<E> hostedList;
        public final RuntimeImageHeapList<E> runtimeList;
        private boolean modified;

        private HostedImageHeapList(Class<E> elementClass, Comparator<E> comparator) {
            this.comparator = comparator;
            this.hostedList = new ArrayList();
            this.runtimeList = new RuntimeImageHeapList<Object>((Object[])Array.newInstance(elementClass, 0));
        }

        public synchronized boolean needsUpdate() {
            return this.modified;
        }

        public synchronized void update() {
            this.runtimeList.elementData = this.hostedList.toArray(this.runtimeList.elementData);
            if (this.comparator != null) {
                Arrays.sort(this.runtimeList.elementData, this.comparator);
            }
            this.modified = false;
        }

        @Override
        public synchronized boolean add(E e) {
            this.modified = true;
            return this.hostedList.add(e);
        }

        @Override
        public synchronized void add(int index, E element) {
            this.modified = true;
            this.hostedList.add(index, element);
        }

        @Override
        public synchronized E remove(int index) {
            this.modified = true;
            return this.hostedList.remove(index);
        }

        @Override
        public synchronized E get(int index) {
            return this.hostedList.get(index);
        }

        @Override
        public synchronized E set(int index, E element) {
            E result = this.hostedList.set(index, element);
            if (result != element) {
                this.modified = true;
            }
            return result;
        }

        @Override
        public synchronized int size() {
            return this.hostedList.size();
        }
    }
}

