/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.thread;

import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import com.oracle.svm.core.jfr.JfrTicks;
import com.oracle.svm.core.jfr.events.ThreadParkEvent;
import com.oracle.svm.core.thread.PlatformThreads;
import java.util.concurrent.locks.LockSupport;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.impl.InternalPlatform;

@TargetClass(className="jdk.internal.misc.Unsafe")
@Platforms(value={InternalPlatform.NATIVE_ONLY.class})
final class Target_jdk_internal_misc_Unsafe_JavaThreads {
    Target_jdk_internal_misc_Unsafe_JavaThreads() {
    }

    @Substitute
    void park(boolean isAbsolute, long time) {
        long startTicks = JfrTicks.elapsedTicks();
        Thread t = Thread.currentThread();
        Object parkBlocker = LockSupport.getBlocker(t);
        PlatformThreads.parkCurrentPlatformOrCarrierThread(isAbsolute, time);
        ThreadParkEvent.emit(startTicks, parkBlocker, isAbsolute, time);
    }

    @Substitute
    void unpark(Object threadObj) {
        if (threadObj != null) {
            if (!(threadObj instanceof Thread)) {
                throw new IllegalArgumentException("Unsafe.unpark(!(thread instanceof Thread))");
            }
            PlatformThreads.unpark((Thread)threadObj);
        }
    }
}

