/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.reflect.fieldaccessor;

import com.oracle.svm.core.reflect.fieldaccessor.UnsafeQualifiedFieldAccessorImpl;
import java.lang.reflect.Field;

class UnsafeQualifiedFloatFieldAccessorImpl
extends UnsafeQualifiedFieldAccessorImpl {
    UnsafeQualifiedFloatFieldAccessorImpl(Field field, boolean isReadOnly) {
        super(field, isReadOnly);
    }

    @Override
    public Object get(Object obj) throws IllegalArgumentException {
        return Float.valueOf(this.getFloat(obj));
    }

    @Override
    public boolean getBoolean(Object obj) throws IllegalArgumentException {
        throw this.newGetBooleanIllegalArgumentException();
    }

    @Override
    public byte getByte(Object obj) throws IllegalArgumentException {
        throw this.newGetByteIllegalArgumentException();
    }

    @Override
    public char getChar(Object obj) throws IllegalArgumentException {
        throw this.newGetCharIllegalArgumentException();
    }

    @Override
    public short getShort(Object obj) throws IllegalArgumentException {
        throw this.newGetShortIllegalArgumentException();
    }

    @Override
    public int getInt(Object obj) throws IllegalArgumentException {
        throw this.newGetIntIllegalArgumentException();
    }

    @Override
    public long getLong(Object obj) throws IllegalArgumentException {
        throw this.newGetLongIllegalArgumentException();
    }

    @Override
    public float getFloat(Object obj) throws IllegalArgumentException {
        this.ensureObj(obj);
        return unsafe.getFloatVolatile(obj, this.fieldOffset);
    }

    @Override
    public double getDouble(Object obj) throws IllegalArgumentException {
        return this.getFloat(obj);
    }

    @Override
    public void set(Object obj, Object value) throws IllegalArgumentException, IllegalAccessException {
        this.ensureObj(obj);
        if (this.isReadOnly) {
            this.throwFinalFieldIllegalAccessException(value);
        }
        if (value == null) {
            this.throwSetIllegalArgumentException(value);
        }
        if (value instanceof Byte) {
            unsafe.putFloatVolatile(obj, this.fieldOffset, ((Byte)value).byteValue());
            return;
        }
        if (value instanceof Short) {
            unsafe.putFloatVolatile(obj, this.fieldOffset, ((Short)value).shortValue());
            return;
        }
        if (value instanceof Character) {
            unsafe.putFloatVolatile(obj, this.fieldOffset, ((Character)value).charValue());
            return;
        }
        if (value instanceof Integer) {
            unsafe.putFloatVolatile(obj, this.fieldOffset, ((Integer)value).intValue());
            return;
        }
        if (value instanceof Long) {
            unsafe.putFloatVolatile(obj, this.fieldOffset, ((Long)value).longValue());
            return;
        }
        if (value instanceof Float) {
            unsafe.putFloatVolatile(obj, this.fieldOffset, ((Float)value).floatValue());
            return;
        }
        this.throwSetIllegalArgumentException(value);
    }

    @Override
    public void setBoolean(Object obj, boolean z) throws IllegalArgumentException, IllegalAccessException {
        this.throwSetIllegalArgumentException(z);
    }

    @Override
    public void setByte(Object obj, byte b) throws IllegalArgumentException, IllegalAccessException {
        this.setFloat(obj, b);
    }

    @Override
    public void setChar(Object obj, char c) throws IllegalArgumentException, IllegalAccessException {
        this.setFloat(obj, c);
    }

    @Override
    public void setShort(Object obj, short s) throws IllegalArgumentException, IllegalAccessException {
        this.setFloat(obj, s);
    }

    @Override
    public void setInt(Object obj, int i) throws IllegalArgumentException, IllegalAccessException {
        this.setFloat(obj, i);
    }

    @Override
    public void setLong(Object obj, long l) throws IllegalArgumentException, IllegalAccessException {
        this.setFloat(obj, l);
    }

    @Override
    public void setFloat(Object obj, float f) throws IllegalArgumentException, IllegalAccessException {
        this.ensureObj(obj);
        if (this.isReadOnly) {
            this.throwFinalFieldIllegalAccessException(f);
        }
        unsafe.putFloatVolatile(obj, this.fieldOffset, f);
    }

    @Override
    public void setDouble(Object obj, double d) throws IllegalArgumentException, IllegalAccessException {
        this.throwSetIllegalArgumentException(d);
    }
}

