/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jvmti.headers;

import com.oracle.svm.core.collections.EnumBitmask;
import com.oracle.svm.core.jvmti.headers.JvmtiDirectives;
import org.graalvm.nativeimage.c.CContext;
import org.graalvm.nativeimage.c.constant.CConstant;
import org.graalvm.nativeimage.c.constant.CEnum;
import org.graalvm.nativeimage.c.constant.CEnumLookup;
import org.graalvm.nativeimage.c.constant.CEnumValue;

@CContext(value=JvmtiDirectives.class)
@CEnum(value="jvmtiEvent")
public final class JvmtiEvent
extends Enum<JvmtiEvent> {
    public static final /* enum */ JvmtiEvent JVMTI_EVENT_VM_INIT = new JvmtiEvent(true, JvmtiEventFlags.Global);
    public static final /* enum */ JvmtiEvent JVMTI_EVENT_VM_DEATH = new JvmtiEvent(true, JvmtiEventFlags.Global);
    public static final /* enum */ JvmtiEvent JVMTI_EVENT_THREAD_START = new JvmtiEvent(false, JvmtiEventFlags.Global);
    public static final /* enum */ JvmtiEvent JVMTI_EVENT_THREAD_END = new JvmtiEvent(false, new JvmtiEventFlags[0]);
    public static final /* enum */ JvmtiEvent JVMTI_EVENT_CLASS_FILE_LOAD_HOOK = new JvmtiEvent(false, new JvmtiEventFlags[0]);
    public static final /* enum */ JvmtiEvent JVMTI_EVENT_CLASS_LOAD = new JvmtiEvent(false, new JvmtiEventFlags[0]);
    public static final /* enum */ JvmtiEvent JVMTI_EVENT_CLASS_PREPARE = new JvmtiEvent(false, new JvmtiEventFlags[0]);
    public static final /* enum */ JvmtiEvent JVMTI_EVENT_VM_START = new JvmtiEvent(true, JvmtiEventFlags.Global);
    public static final /* enum */ JvmtiEvent JVMTI_EVENT_EXCEPTION = new JvmtiEvent(false, new JvmtiEventFlags[0]);
    public static final /* enum */ JvmtiEvent JVMTI_EVENT_EXCEPTION_CATCH = new JvmtiEvent(false, new JvmtiEventFlags[0]);
    public static final /* enum */ JvmtiEvent JVMTI_EVENT_SINGLE_STEP = new JvmtiEvent(false, new JvmtiEventFlags[0]);
    public static final /* enum */ JvmtiEvent JVMTI_EVENT_FRAME_POP = new JvmtiEvent(false, new JvmtiEventFlags[0]);
    public static final /* enum */ JvmtiEvent JVMTI_EVENT_BREAKPOINT = new JvmtiEvent(false, new JvmtiEventFlags[0]);
    public static final /* enum */ JvmtiEvent JVMTI_EVENT_FIELD_ACCESS = new JvmtiEvent(false, new JvmtiEventFlags[0]);
    public static final /* enum */ JvmtiEvent JVMTI_EVENT_FIELD_MODIFICATION = new JvmtiEvent(false, new JvmtiEventFlags[0]);
    public static final /* enum */ JvmtiEvent JVMTI_EVENT_METHOD_ENTRY = new JvmtiEvent(false, new JvmtiEventFlags[0]);
    public static final /* enum */ JvmtiEvent JVMTI_EVENT_METHOD_EXIT = new JvmtiEvent(false, new JvmtiEventFlags[0]);
    public static final /* enum */ JvmtiEvent JVMTI_EVENT_NATIVE_METHOD_BIND = new JvmtiEvent(false, new JvmtiEventFlags[0]);
    public static final /* enum */ JvmtiEvent JVMTI_EVENT_COMPILED_METHOD_LOAD = new JvmtiEvent(false, JvmtiEventFlags.Global);
    public static final /* enum */ JvmtiEvent JVMTI_EVENT_COMPILED_METHOD_UNLOAD = new JvmtiEvent(false, JvmtiEventFlags.Global);
    public static final /* enum */ JvmtiEvent JVMTI_EVENT_DYNAMIC_CODE_GENERATED = new JvmtiEvent(false, JvmtiEventFlags.Global);
    public static final /* enum */ JvmtiEvent JVMTI_EVENT_DATA_DUMP_REQUEST = new JvmtiEvent(false, JvmtiEventFlags.Global);
    public static final /* enum */ JvmtiEvent JVMTI_EVENT_MONITOR_WAIT = new JvmtiEvent(false, new JvmtiEventFlags[0]);
    public static final /* enum */ JvmtiEvent JVMTI_EVENT_MONITOR_WAITED = new JvmtiEvent(false, new JvmtiEventFlags[0]);
    public static final /* enum */ JvmtiEvent JVMTI_EVENT_MONITOR_CONTENDED_ENTER = new JvmtiEvent(false, new JvmtiEventFlags[0]);
    public static final /* enum */ JvmtiEvent JVMTI_EVENT_MONITOR_CONTENDED_ENTERED = new JvmtiEvent(false, new JvmtiEventFlags[0]);
    public static final /* enum */ JvmtiEvent JVMTI_EVENT_RESOURCE_EXHAUSTED = new JvmtiEvent(false, new JvmtiEventFlags[0]);
    public static final /* enum */ JvmtiEvent JVMTI_EVENT_GARBAGE_COLLECTION_START = new JvmtiEvent(false, new JvmtiEventFlags[0]);
    public static final /* enum */ JvmtiEvent JVMTI_EVENT_GARBAGE_COLLECTION_FINISH = new JvmtiEvent(false, new JvmtiEventFlags[0]);
    public static final /* enum */ JvmtiEvent JVMTI_EVENT_OBJECT_FREE = new JvmtiEvent(false, new JvmtiEventFlags[0]);
    public static final /* enum */ JvmtiEvent JVMTI_EVENT_VM_OBJECT_ALLOC = new JvmtiEvent(false, new JvmtiEventFlags[0]);
    public static final /* enum */ JvmtiEvent JVMTI_EVENT_SAMPLED_OBJECT_ALLOC = new JvmtiEvent(false, new JvmtiEventFlags[0]);
    public static final /* enum */ JvmtiEvent JVMTI_EVENT_VIRTUAL_THREAD_START = new JvmtiEvent(false, JvmtiEventFlags.Global);
    public static final /* enum */ JvmtiEvent JVMTI_EVENT_VIRTUAL_THREAD_END = new JvmtiEvent(false, new JvmtiEventFlags[0]);
    private final boolean isSupported;
    private final int flags;
    private static final /* synthetic */ JvmtiEvent[] $VALUES;

    public static JvmtiEvent[] values() {
        return (JvmtiEvent[])$VALUES.clone();
    }

    public static JvmtiEvent valueOf(String name) {
        return Enum.valueOf(JvmtiEvent.class, name);
    }

    private JvmtiEvent(boolean isSupported, JvmtiEventFlags ... flags) {
        this.isSupported = isSupported;
        this.flags = EnumBitmask.computeBitmask(flags);
    }

    public boolean isSupported() {
        return this.isSupported;
    }

    public boolean isGlobal() {
        return EnumBitmask.hasBit(this.flags, JvmtiEventFlags.Global);
    }

    public static long getBit(JvmtiEvent eventType) {
        int index = eventType.getCValue() - JvmtiEvent.getMinEventType();
        assert (index < 64);
        return 1L << index;
    }

    @CConstant(value="JVMTI_MIN_EVENT_TYPE_VAL")
    public static native int getMinEventType();

    @CEnumValue
    public native int getCValue();

    @CEnumLookup
    public static native JvmtiEvent fromValue(int var0);

    private static /* synthetic */ JvmtiEvent[] $values() {
        return new JvmtiEvent[]{JVMTI_EVENT_VM_INIT, JVMTI_EVENT_VM_DEATH, JVMTI_EVENT_THREAD_START, JVMTI_EVENT_THREAD_END, JVMTI_EVENT_CLASS_FILE_LOAD_HOOK, JVMTI_EVENT_CLASS_LOAD, JVMTI_EVENT_CLASS_PREPARE, JVMTI_EVENT_VM_START, JVMTI_EVENT_EXCEPTION, JVMTI_EVENT_EXCEPTION_CATCH, JVMTI_EVENT_SINGLE_STEP, JVMTI_EVENT_FRAME_POP, JVMTI_EVENT_BREAKPOINT, JVMTI_EVENT_FIELD_ACCESS, JVMTI_EVENT_FIELD_MODIFICATION, JVMTI_EVENT_METHOD_ENTRY, JVMTI_EVENT_METHOD_EXIT, JVMTI_EVENT_NATIVE_METHOD_BIND, JVMTI_EVENT_COMPILED_METHOD_LOAD, JVMTI_EVENT_COMPILED_METHOD_UNLOAD, JVMTI_EVENT_DYNAMIC_CODE_GENERATED, JVMTI_EVENT_DATA_DUMP_REQUEST, JVMTI_EVENT_MONITOR_WAIT, JVMTI_EVENT_MONITOR_WAITED, JVMTI_EVENT_MONITOR_CONTENDED_ENTER, JVMTI_EVENT_MONITOR_CONTENDED_ENTERED, JVMTI_EVENT_RESOURCE_EXHAUSTED, JVMTI_EVENT_GARBAGE_COLLECTION_START, JVMTI_EVENT_GARBAGE_COLLECTION_FINISH, JVMTI_EVENT_OBJECT_FREE, JVMTI_EVENT_VM_OBJECT_ALLOC, JVMTI_EVENT_SAMPLED_OBJECT_ALLOC, JVMTI_EVENT_VIRTUAL_THREAD_START, JVMTI_EVENT_VIRTUAL_THREAD_END};
    }

    static {
        $VALUES = JvmtiEvent.$values();
    }

    private static enum JvmtiEventFlags {
        Global;

    }
}

