/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jdk.resources.CompressedGlobTrie;

import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.heap.UnknownObjectField;
import com.oracle.svm.core.heap.UnknownPrimitiveField;
import com.oracle.svm.core.jdk.resources.CompressedGlobTrie.DoubleStarNode;
import com.oracle.svm.core.jdk.resources.CompressedGlobTrie.LiteralNode;
import com.oracle.svm.core.jdk.resources.CompressedGlobTrie.StarTrieNode;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

public class GlobTrieNode<C> {
    protected static final String STAR = "*";
    protected static final String STAR_STAR = "**";
    protected static final String LEVEL_IDENTIFIER = "/";
    public static final String SAME_LEVEL_IDENTIFIER = "#";
    private String content = "";
    @UnknownObjectField(fullyQualifiedTypes={"java.util.HashMap", "java.util.ImmutableCollections$MapN", "java.util.ImmutableCollections$Map1"})
    private Map<String, GlobTrieNode<C>> children = new HashMap<String, GlobTrieNode<C>>();
    @UnknownPrimitiveField
    private boolean isLeaf = false;
    @UnknownPrimitiveField
    private boolean isNewLevel = false;
    @Platforms(value={Platform.HOSTED_ONLY.class})
    private Set<C> hostedOnlyContent;

    protected GlobTrieNode() {
        if (SubstrateUtil.HOSTED) {
            this.hostedOnlyContent = new HashSet<C>();
        }
    }

    protected GlobTrieNode(String content) {
        this();
        this.content = content;
    }

    public boolean isNewLevel() {
        return this.isNewLevel;
    }

    protected void setNewLevel() {
        this.isNewLevel = true;
    }

    public boolean isLeaf() {
        return this.isLeaf;
    }

    protected void setLeaf() {
        this.isLeaf = true;
    }

    protected void makeNodeInternal() {
        this.isLeaf = false;
    }

    public String getContent() {
        return this.content;
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    protected Set<C> getHostedOnlyContent() {
        return this.hostedOnlyContent;
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    protected void removeHostedOnlyContent(List<C> ac) {
        this.hostedOnlyContent.removeAll(ac);
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    protected void addHostedOnlyContent(C ac) {
        this.hostedOnlyContent.add(ac);
    }

    public List<GlobTrieNode<C>> getChildren() {
        return this.children.values().stream().toList();
    }

    protected GlobTrieNode<C> getChild(String child) {
        return this.children.get(child);
    }

    protected void removeChildren(List<GlobTrieNode<C>> childKeys) {
        for (GlobTrieNode<C> child : childKeys) {
            String sameLevel = !child.isNewLevel() ? SAME_LEVEL_IDENTIFIER : "";
            String childKey = child.getContent() + sameLevel;
            this.children.remove(childKey);
        }
    }

    protected GlobTrieNode<C> getChildFromSameLevel(String child) {
        return this.children.get(child + SAME_LEVEL_IDENTIFIER);
    }

    protected GlobTrieNode<C> addChild(String child, GlobTrieNode<C> childValue) {
        StringBuilder sb = new StringBuilder(child);
        if (!childValue.isNewLevel()) {
            sb.append(SAME_LEVEL_IDENTIFIER);
        }
        this.children.putIfAbsent(sb.toString(), childValue);
        return this.children.get(sb.toString());
    }

    protected List<StarTrieNode<C>> getChildrenWithStar() {
        return this.getChildren().stream().filter(node -> node instanceof StarTrieNode).map(node -> (StarTrieNode)node).toList();
    }

    protected List<LiteralNode<C>> getChildrenWithLiteral() {
        return this.getChildren().stream().filter(node -> node instanceof LiteralNode).map(node -> (LiteralNode)node).toList();
    }

    protected DoubleStarNode<C> getDoubleStarNode() {
        return (DoubleStarNode)this.getChild(STAR_STAR);
    }

    protected void trim() {
        for (GlobTrieNode<C> child : this.children.values()) {
            child.trim();
        }
        this.hostedOnlyContent = Set.copyOf(this.hostedOnlyContent);
        this.children = Map.copyOf(this.children);
    }
}

