/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jdk;

import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.jdk.Target_java_lang_String;
import com.oracle.svm.core.jdk.Target_java_lang_StringLatin1;
import com.oracle.svm.core.jdk.Target_java_lang_StringUTF16;
import com.oracle.svm.core.util.VMError;
import jdk.graal.compiler.core.common.SuppressFBWarnings;
import jdk.internal.misc.Unsafe;
import org.graalvm.word.Pointer;
import org.graalvm.word.PointerBase;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordBase;
import org.graalvm.word.WordFactory;

public class UninterruptibleUtils {

    public static class CodeUtil {
        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        public static long signExtend(long value, int inputBits) {
            if (inputBits < 64) {
                if ((value >>> inputBits - 1 & 1L) == 1L) {
                    return value | -1L << inputBits;
                }
                return value & (-1L << inputBits ^ 0xFFFFFFFFFFFFFFFFL);
            }
            return value;
        }

        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        public static long zeroExtend(long value, int inputBits) {
            if (inputBits < 64) {
                return value & (-1L << inputBits ^ 0xFFFFFFFFFFFFFFFFL);
            }
            return value;
        }
    }

    public static final class ReplaceDotWithSlash
    implements CharReplacer {
        @Override
        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        public char replace(char ch) {
            if (ch == '.') {
                return '/';
            }
            return ch;
        }
    }

    @FunctionalInterface
    public static interface CharReplacer {
        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        public char replace(char var1);
    }

    public static class String {
        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        private static int modifiedUTF8Length(char c) {
            if (c >= '\u0001' && c <= '\u007f') {
                return 1;
            }
            if (c <= '\u07ff') {
                return 2;
            }
            return 3;
        }

        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        private static Pointer writeModifiedUTF8(Pointer buffer, char c) {
            Pointer pos = buffer;
            if (c >= '\u0001' && c <= '\u007f') {
                pos.writeByte(0, (byte)c);
                pos = pos.add(1);
            } else if (c <= '\u07ff') {
                pos.writeByte(0, (byte)(0xC0 | c >> 6));
                pos.writeByte(1, (byte)(0x80 | c & 0x3F));
                pos = pos.add(2);
            } else {
                pos.writeByte(0, (byte)(0xE0 | c >> 12));
                pos.writeByte(1, (byte)(0x80 | c >> 6 & 0x3F));
                pos.writeByte(2, (byte)(0x80 | c & 0x3F));
                pos = pos.add(3);
            }
            return pos;
        }

        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        public static int modifiedUTF8Length(java.lang.String string, boolean addNullTerminator) {
            return String.modifiedUTF8Length(string, addNullTerminator, null);
        }

        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        public static int modifiedUTF8Length(java.lang.String string, boolean addNullTerminator, CharReplacer replacer) {
            int result = 0;
            for (int index = 0; index < string.length(); ++index) {
                char ch = String.charAt(string, index);
                if (replacer != null) {
                    ch = replacer.replace(ch);
                }
                result += String.modifiedUTF8Length(ch);
            }
            return result + (addNullTerminator ? 1 : 0);
        }

        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        public static Pointer toModifiedUTF8(java.lang.String string, Pointer buffer, Pointer bufferEnd, boolean addNullTerminator) {
            return String.toModifiedUTF8(string, buffer, bufferEnd, addNullTerminator, null);
        }

        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        public static Pointer toModifiedUTF8(java.lang.String string, Pointer buffer, Pointer bufferEnd, boolean addNullTerminator, CharReplacer replacer) {
            return String.toModifiedUTF8(string, string.length(), buffer, bufferEnd, addNullTerminator, replacer);
        }

        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        public static Pointer toModifiedUTF8(java.lang.String string, int stringLength, Pointer buffer, Pointer bufferEnd, boolean addNullTerminator, CharReplacer replacer) {
            Pointer pos = buffer;
            for (int index = 0; index < stringLength; ++index) {
                char ch = String.charAt(string, index);
                if (replacer != null) {
                    ch = replacer.replace(ch);
                }
                pos = String.writeModifiedUTF8(pos, ch);
            }
            if (addNullTerminator) {
                pos.writeByte(0, (byte)0);
                pos = pos.add(1);
            }
            VMError.guarantee(pos.belowOrEqual((UnsignedWord)bufferEnd), "Must not write out of bounds.");
            return pos;
        }

        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        public static char charAt(java.lang.String string, int index) {
            Target_java_lang_String str = SubstrateUtil.cast(string, Target_java_lang_String.class);
            byte[] value = str.value;
            if (str.isLatin1()) {
                return Target_java_lang_StringLatin1.getChar(value, index);
            }
            return Target_java_lang_StringUTF16.getChar(value, index);
        }

        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        public static byte coder(java.lang.String string) {
            return SubstrateUtil.cast(string, Target_java_lang_String.class).coder();
        }

        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        public static byte[] value(java.lang.String string) {
            return SubstrateUtil.cast((Object)string, Target_java_lang_String.class).value;
        }

        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        public static boolean startsWith(java.lang.String string, java.lang.String prefix) {
            if (prefix.length() > string.length()) {
                return false;
            }
            byte coder = String.coder(string);
            if (coder != String.coder(prefix) && coder == Target_java_lang_String.LATIN1) {
                return false;
            }
            return String.compare(string, prefix, prefix.length());
        }

        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        @SuppressFBWarnings(value={""}, justification="The string comparison by reference is fine in this case.")
        public static boolean equals(java.lang.String a, java.lang.String b) {
            return a == b || (!Target_java_lang_String.COMPACT_STRINGS || String.coder(a) == String.coder(b)) && String.equals0(String.value(a), String.value(b));
        }

        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        private static boolean equals0(byte[] value, byte[] other) {
            if (value.length == other.length) {
                for (int i = 0; i < value.length; ++i) {
                    if (value[i] == other[i]) continue;
                    return false;
                }
                return true;
            }
            return false;
        }

        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        private static boolean compare(java.lang.String a, java.lang.String b, int length) {
            for (int index = 0; index < length; ++index) {
                if (String.charAt(a, index) == String.charAt(b, index)) continue;
                return false;
            }
            return true;
        }
    }

    public static class Integer {
        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        public static int numberOfLeadingZeros(int i) {
            if (i == 0) {
                return 32;
            }
            int n = 1;
            if (i >>> 16 == 0) {
                n += 16;
                i <<= 16;
            }
            if (i >>> 24 == 0) {
                n += 8;
                i <<= 8;
            }
            if (i >>> 28 == 0) {
                n += 4;
                i <<= 4;
            }
            if (i >>> 30 == 0) {
                n += 2;
                i <<= 2;
            }
            return n -= i >>> 31;
        }

        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        public static int highestOneBit(int i) {
            i |= i >> 1;
            i |= i >> 2;
            i |= i >> 4;
            i |= i >> 8;
            i |= i >> 16;
            return i - (i >>> 1);
        }

        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        public static int compare(int x, int y) {
            return x < y ? -1 : (x == y ? 0 : 1);
        }

        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        public static int compareUnsigned(int x, int y) {
            return Integer.compare(x + java.lang.Integer.MIN_VALUE, y + java.lang.Integer.MIN_VALUE);
        }
    }

    public static class Long {
        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        public static int numberOfLeadingZeros(long i) {
            if (i == 0L) {
                return 64;
            }
            int n = 1;
            int x = (int)(i >>> 32);
            if (x == 0) {
                n += 32;
                x = (int)i;
            }
            if (x >>> 16 == 0) {
                n += 16;
                x <<= 16;
            }
            if (x >>> 24 == 0) {
                n += 8;
                x <<= 8;
            }
            if (x >>> 28 == 0) {
                n += 4;
                x <<= 4;
            }
            if (x >>> 30 == 0) {
                n += 2;
                x <<= 2;
            }
            return n -= x >>> 31;
        }

        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        public static int hashCode(long value) {
            return (int)(value ^ value >>> 32);
        }
    }

    public static class Byte {
        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        public static int toUnsignedInt(byte x) {
            return x & 0xFF;
        }
    }

    public static class Math {
        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        public static int min(int a, int b) {
            return a <= b ? a : b;
        }

        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        public static long min(long a, long b) {
            return a <= b ? a : b;
        }

        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        public static int max(int a, int b) {
            return a >= b ? a : b;
        }

        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        public static long max(long a, long b) {
            return a >= b ? a : b;
        }

        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        public static int clamp(int value, int min, int max) {
            return Math.min(Math.max(value, min), max);
        }

        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        public static int abs(int a) {
            return a < 0 ? -a : a;
        }

        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        public static long abs(long a) {
            return a < 0L ? -a : a;
        }

        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        public static long floorToLong(double value) {
            assert (value == value) : "must not be NaN";
            return (long)value;
        }

        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        public static long ceilToLong(double a) {
            long floor = Math.floorToLong(a);
            return a > (double)floor ? floor + 1L : floor;
        }
    }

    public static class AtomicReference<T> {
        private static final Unsafe UNSAFE = Unsafe.getUnsafe();
        private static final long VALUE_OFFSET;
        private volatile T value;

        public AtomicReference() {
        }

        public AtomicReference(T value) {
            this.value = value;
        }

        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        public T get() {
            return this.value;
        }

        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        public void set(T newValue) {
            this.value = newValue;
        }

        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        public boolean compareAndSet(T expected, T update) {
            return UNSAFE.compareAndSetReference(this, VALUE_OFFSET, expected, update);
        }

        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        public final T getAndSet(T newValue) {
            return (T)UNSAFE.getAndSetReference(this, VALUE_OFFSET, newValue);
        }

        static {
            try {
                VALUE_OFFSET = UNSAFE.objectFieldOffset(AtomicReference.class.getDeclaredField("value"));
            }
            catch (Throwable ex) {
                throw VMError.shouldNotReachHere(ex);
            }
        }
    }

    public static class AtomicPointer<T extends PointerBase> {
        private static final Unsafe UNSAFE = Unsafe.getUnsafe();
        private static final long VALUE_OFFSET;
        private volatile long value;

        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        public T get() {
            return (T)WordFactory.pointer((long)this.value);
        }

        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        public void set(T newValue) {
            this.value = newValue.rawValue();
        }

        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        public boolean compareAndSet(T expected, T update) {
            return UNSAFE.compareAndSetLong(this, VALUE_OFFSET, expected.rawValue(), update.rawValue());
        }

        static {
            try {
                VALUE_OFFSET = UNSAFE.objectFieldOffset(AtomicPointer.class.getDeclaredField("value"));
            }
            catch (Throwable ex) {
                throw VMError.shouldNotReachHere(ex);
            }
        }
    }

    public static class AtomicUnsigned
    extends AtomicWord<UnsignedWord> {
        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        public final UnsignedWord getAndAdd(UnsignedWord delta) {
            return WordFactory.unsigned((long)this.value.getAndAdd(delta.rawValue()));
        }

        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        public final UnsignedWord addAndGet(UnsignedWord delta) {
            return WordFactory.unsigned((long)this.value.addAndGet(delta.rawValue()));
        }

        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        public final UnsignedWord getAndSubtract(UnsignedWord delta) {
            return WordFactory.unsigned((long)this.value.getAndAdd(-delta.rawValue()));
        }

        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        public final UnsignedWord subtractAndGet(UnsignedWord delta) {
            return WordFactory.unsigned((long)this.value.addAndGet(-delta.rawValue()));
        }
    }

    public static class AtomicWord<T extends WordBase> {
        protected final AtomicLong value = new AtomicLong(0L);

        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        public final T get() {
            return (T)WordFactory.unsigned((long)this.value.get());
        }

        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        public final void set(T newValue) {
            this.value.set(newValue.rawValue());
        }

        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        public final T getAndSet(T newValue) {
            return (T)WordFactory.unsigned((long)this.value.getAndSet(newValue.rawValue()));
        }

        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        public final boolean compareAndSet(T expect, T update) {
            return this.value.compareAndSet(expect.rawValue(), update.rawValue());
        }
    }

    public static class AtomicLong {
        private static final Unsafe UNSAFE = Unsafe.getUnsafe();
        private static final long VALUE_OFFSET;
        private volatile long value;

        public AtomicLong(long value) {
            this.value = value;
        }

        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        public long get() {
            return this.value;
        }

        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        public void set(long newValue) {
            this.value = newValue;
        }

        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        public long getAndSet(long newValue) {
            return UNSAFE.getAndSetLong(this, VALUE_OFFSET, newValue);
        }

        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        public long getAndAdd(long delta) {
            return UNSAFE.getAndAddLong(this, VALUE_OFFSET, delta);
        }

        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        public long addAndGet(long delta) {
            return this.getAndAdd(delta) + delta;
        }

        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        public long incrementAndGet() {
            return this.addAndGet(1L);
        }

        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        public long getAndIncrement() {
            return this.getAndAdd(1L);
        }

        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        public long decrementAndGet() {
            return this.addAndGet(-1L);
        }

        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        public long getAndDecrement() {
            return this.getAndAdd(-1L);
        }

        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        public boolean compareAndSet(long expected, long update) {
            return UNSAFE.compareAndSetLong(this, VALUE_OFFSET, expected, update);
        }

        static {
            try {
                VALUE_OFFSET = UNSAFE.objectFieldOffset(AtomicLong.class.getDeclaredField("value"));
            }
            catch (Throwable ex) {
                throw VMError.shouldNotReachHere(ex);
            }
        }
    }

    public static class AtomicInteger {
        private static final Unsafe UNSAFE = Unsafe.getUnsafe();
        private static final long VALUE_OFFSET;
        private volatile int value;

        public AtomicInteger(int value) {
            this.value = value;
        }

        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        public int get() {
            return this.value;
        }

        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        public void set(int newValue) {
            this.value = newValue;
        }

        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        public int incrementAndGet() {
            return UNSAFE.getAndAddInt(this, VALUE_OFFSET, 1) + 1;
        }

        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        public int getAndDecrement() {
            return UNSAFE.getAndAddInt(this, VALUE_OFFSET, -1);
        }

        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        public int decrementAndGet() {
            return UNSAFE.getAndAddInt(this, VALUE_OFFSET, -1) - 1;
        }

        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        public int getAndIncrement() {
            return UNSAFE.getAndAddInt(this, VALUE_OFFSET, 1);
        }

        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        public boolean compareAndSet(int expected, int update) {
            return UNSAFE.compareAndSetInt(this, VALUE_OFFSET, expected, update);
        }

        static {
            try {
                VALUE_OFFSET = UNSAFE.objectFieldOffset(AtomicInteger.class.getDeclaredField("value"));
            }
            catch (Throwable ex) {
                throw VMError.shouldNotReachHere(ex);
            }
        }
    }

    public static class AtomicBoolean {
        private static final Unsafe UNSAFE = Unsafe.getUnsafe();
        private static final long VALUE_OFFSET;
        private volatile boolean value;

        public AtomicBoolean(boolean value) {
            this.value = value;
        }

        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        public boolean get() {
            return this.value;
        }

        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        public void set(boolean newValue) {
            this.value = newValue;
        }

        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        public boolean compareAndSet(boolean expected, boolean update) {
            return UNSAFE.compareAndSetBoolean(this, VALUE_OFFSET, expected, update);
        }

        static {
            try {
                VALUE_OFFSET = UNSAFE.objectFieldOffset(AtomicBoolean.class.getDeclaredField("value"));
            }
            catch (Throwable ex) {
                throw VMError.shouldNotReachHere(ex);
            }
        }
    }
}

