/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jdk;

import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.VM;
import com.oracle.svm.core.c.locale.LocaleSupport;
import com.oracle.svm.core.config.ConfigurationValues;
import com.oracle.svm.core.util.VMError;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import jdk.graal.compiler.api.replacements.Fold;
import jdk.graal.compiler.nodes.extended.MembarNode;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.impl.RuntimeSystemPropertiesSupport;

public abstract class SystemPropertiesSupport
implements RuntimeSystemPropertiesSupport {
    @Platforms(value={Platform.HOSTED_ONLY.class})
    private static final String[] HOSTED_PROPERTIES = new String[]{"java.version", "java.version.date", "java.class.version", "java.runtime.version", "java.specification.name", "java.specification.vendor", "java.specification.version", "java.specification.maintenance.version", "java.vm.specification.name", "java.vm.specification.vendor", "java.vm.specification.version", "org.graalvm.nativeimage.kind", "line.separator", "path.separator", "file.separator", "file.encoding", "sun.jnu.encoding", "native.encoding", "stdout.encoding", "stderr.encoding"};
    private final Map<String, LazySystemProperty> lazySystemProperties = new HashMap<String, LazySystemProperty>();
    private final Map<String, String> initialProperties = new ConcurrentHashMap<String, String>();
    private final Map<String, String> readOnlyInitialProperties = Collections.unmodifiableMap(this.initialProperties);
    private Properties currentProperties = new Properties();
    private boolean allPropertiesInitialized;

    @Fold
    public static SystemPropertiesSupport singleton() {
        return (SystemPropertiesSupport)ImageSingletons.lookup(SystemPropertiesSupport.class);
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    protected SystemPropertiesSupport() {
        for (String key : HOSTED_PROPERTIES) {
            String value = System.getProperty(key);
            if (value == null) continue;
            this.initializeProperty(key, value);
        }
        this.initializeProperty("java.runtime.name", "GraalVM Runtime Environment");
        VM vm = (VM)ImageSingletons.lookup(VM.class);
        this.initializeProperty("java.vendor", vm.vendor);
        this.initializeProperty("java.vendor.url", vm.vendorUrl);
        this.initializeProperty("java.vendor.version", vm.vendorVersion);
        assert (vm.info.equals(vm.info.toLowerCase(Locale.ROOT))) : "java.vm.info should not contain uppercase characters";
        this.initializeProperty("java.vm.info", vm.info);
        this.initializeProperty("java.vm.name", "Substrate VM");
        this.initializeProperty("java.vm.vendor", vm.vendor);
        this.initializeProperty("java.vm.version", vm.version);
        this.initializeProperty("java.class.path", "");
        this.initializeProperty("java.endorsed.dirs", "");
        this.initializeProperty("java.ext.dirs", "");
        this.initializeProperty("sun.arch.data.model", Integer.toString(ConfigurationValues.getTarget().wordJavaKind.getBitCount()));
        this.initializeProperty("org.graalvm.nativeimage.imagecode", "runtime");
        ArrayList<LazySystemProperty> lazyProperties = new ArrayList<LazySystemProperty>();
        lazyProperties.add(new LazySystemProperty("user.name", this::userNameValue));
        lazyProperties.add(new LazySystemProperty("user.home", this::userHomeValue));
        lazyProperties.add(new LazySystemProperty("user.dir", this::userDirValue));
        lazyProperties.add(new LazySystemProperty("java.io.tmpdir", this::javaIoTmpdirValue));
        lazyProperties.add(new LazySystemProperty("java.library.path", this::javaLibraryPathValue));
        lazyProperties.add(new LazySystemProperty("os.version", this::osVersionValue));
        lazyProperties.add(new LazySystemProperty("user.language", () -> LocaleSupport.singleton().getLocale().language()));
        lazyProperties.add(new LazySystemProperty("user.language.display", () -> LocaleSupport.singleton().getLocale().displayLanguage()));
        lazyProperties.add(new LazySystemProperty("user.language.format", () -> LocaleSupport.singleton().getLocale().formatLanguage()));
        lazyProperties.add(new LazySystemProperty("user.script", () -> LocaleSupport.singleton().getLocale().script()));
        lazyProperties.add(new LazySystemProperty("user.script.display", () -> LocaleSupport.singleton().getLocale().displayScript()));
        lazyProperties.add(new LazySystemProperty("user.script.format", () -> LocaleSupport.singleton().getLocale().formatScript()));
        lazyProperties.add(new LazySystemProperty("user.country", () -> LocaleSupport.singleton().getLocale().country()));
        lazyProperties.add(new LazySystemProperty("user.country.display", () -> LocaleSupport.singleton().getLocale().displayCountry()));
        lazyProperties.add(new LazySystemProperty("user.country.format", () -> LocaleSupport.singleton().getLocale().formatCountry()));
        lazyProperties.add(new LazySystemProperty("user.variant", () -> LocaleSupport.singleton().getLocale().variant()));
        lazyProperties.add(new LazySystemProperty("user.variant.display", () -> LocaleSupport.singleton().getLocale().displayVariant()));
        lazyProperties.add(new LazySystemProperty("user.variant.format", () -> LocaleSupport.singleton().getLocale().formatVariant()));
        String targetName = System.getProperty("svm.targetName");
        if (targetName != null) {
            this.initializeProperty("os.name", targetName);
        } else {
            lazyProperties.add(new LazySystemProperty("os.name", this::osNameValue));
        }
        String targetArch = System.getProperty("svm.targetArch");
        if (targetArch != null) {
            this.initializeProperty("os.arch", targetArch);
        } else if (Platform.includedIn(Platform.DARWIN.class)) {
            this.initializeProperty("os.arch", System.getProperty("os.arch"));
        } else {
            this.initializeProperty("os.arch", ((Platform)ImageSingletons.lookup(Platform.class)).getArchitecture());
        }
        for (LazySystemProperty property : lazyProperties) {
            assert (!this.initialProperties.containsKey(property.getKey()));
            assert (!this.currentProperties.containsKey(property.getKey()));
            this.lazySystemProperties.put(property.getKey(), property);
        }
    }

    public void initializeProperty(String key, String value) {
        VMError.guarantee(key != null, "The key for a system property must not be null.");
        VMError.guarantee(value != null, "System property must have a non-null value.");
        this.initialProperties.put(key, value);
        this.currentProperties.setProperty(key, value);
        LazySystemProperty property = this.lazySystemProperties.get(key);
        if (property != null) {
            property.markAsInitialized();
        }
    }

    public Map<String, String> getInitialProperties() {
        this.ensureAllPropertiesInitialized();
        return this.readOnlyInitialProperties;
    }

    public String getInitialProperty(String key) {
        return this.getInitialProperty(key, true);
    }

    public String getInitialProperty(String key, boolean initializeLazyProperty) {
        if (initializeLazyProperty) {
            this.ensurePropertyInitialized(key);
        }
        return this.initialProperties.get(key);
    }

    public String getInitialProperty(String key, String defaultValue) {
        String value = this.getInitialProperty(key);
        return value != null ? value : defaultValue;
    }

    public Properties getCurrentProperties() {
        this.ensureAllPropertiesInitialized();
        return this.currentProperties;
    }

    public void setCurrentProperties(Properties props) {
        this.ensureAllPropertiesInitialized();
        if (props == null) {
            Properties newProps = new Properties();
            for (Map.Entry<String, String> e : this.initialProperties.entrySet()) {
                String value = e.getValue();
                newProps.setProperty(e.getKey(), value);
            }
            this.currentProperties = newProps;
        } else {
            this.currentProperties = props;
        }
    }

    protected String getCurrentProperty(String key) {
        this.ensurePropertyInitialized(key);
        return this.currentProperties.getProperty(key);
    }

    protected String getCurrentProperty(String key, String defaultValue) {
        String value = this.getCurrentProperty(key);
        return value != null ? value : defaultValue;
    }

    public String setCurrentProperty(String key, String value) {
        this.ensurePropertyInitialized(key);
        return (String)this.currentProperties.setProperty(key, value);
    }

    public String clearCurrentProperty(String key) {
        this.ensurePropertyInitialized(key);
        return (String)this.currentProperties.remove(key);
    }

    private void ensureAllPropertiesInitialized() {
        if (!this.allPropertiesInitialized) {
            this.initializeAllProperties();
        }
    }

    private synchronized void initializeAllProperties() {
        if (this.allPropertiesInitialized) {
            return;
        }
        for (Map.Entry<String, LazySystemProperty> entry : this.lazySystemProperties.entrySet()) {
            LazySystemProperty property = entry.getValue();
            this.initializeProperty(property);
        }
        this.allPropertiesInitialized = true;
    }

    private void ensurePropertyInitialized(String key) {
        if (this.allPropertiesInitialized) {
            return;
        }
        LazySystemProperty property = this.lazySystemProperties.get(key);
        if (property != null) {
            this.ensureInitialized(property);
        }
    }

    private void ensureInitialized(LazySystemProperty property) {
        if (!property.isInitialized()) {
            this.initializeProperty(property);
        }
    }

    private synchronized void initializeProperty(LazySystemProperty property) {
        if (property.isInitialized()) {
            return;
        }
        String key = property.getKey();
        String value = property.computeValue();
        if (value != null) {
            this.currentProperties.put(key, value);
            this.initialProperties.put(key, value);
        }
        property.markAsInitialized();
    }

    protected abstract String userNameValue();

    protected abstract String userHomeValue();

    protected abstract String userDirValue();

    protected abstract String osNameValue();

    protected abstract String osVersionValue();

    protected String javaIoTmpdirValue() {
        return this.tmpdirValue();
    }

    protected String tmpdirValue() {
        throw VMError.shouldNotReachHere("Subclasses must either implement javaIoTmpdirValue() or tmpdirValue().");
    }

    protected String javaLibraryPathValue() {
        return "";
    }

    private static class LazySystemProperty {
        private final String key;
        private final Supplier<String> supplier;
        private boolean initialized;

        @Platforms(value={Platform.HOSTED_ONLY.class})
        LazySystemProperty(String key, Supplier<String> supplier) {
            this.key = key;
            this.supplier = supplier;
        }

        public String getKey() {
            return this.key;
        }

        public boolean isInitialized() {
            return this.initialized;
        }

        public String computeValue() {
            return this.supplier.get();
        }

        public void markAsInitialized() {
            if (!SubstrateUtil.HOSTED) {
                MembarNode.memoryBarrier((MembarNode.FenceKind)MembarNode.FenceKind.STORE_STORE);
            }
            this.initialized = true;
        }
    }
}

