/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.graal.jdk;

import com.oracle.svm.core.graal.jdk.SubstrateObjectCloneSnippets;
import com.oracle.svm.core.meta.SharedType;
import jdk.graal.compiler.core.common.type.ObjectStamp;
import jdk.graal.compiler.core.common.type.Stamp;
import jdk.graal.compiler.core.common.type.StampFactory;
import jdk.graal.compiler.core.common.type.StampPair;
import jdk.graal.compiler.core.common.type.TypeReference;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.graph.NodeClass;
import jdk.graal.compiler.nodeinfo.InputType;
import jdk.graal.compiler.nodeinfo.NodeInfo;
import jdk.graal.compiler.nodes.DeoptimizingNode;
import jdk.graal.compiler.nodes.FrameState;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.java.LoadFieldNode;
import jdk.graal.compiler.nodes.spi.LoweringTool;
import jdk.graal.compiler.nodes.spi.VirtualizerTool;
import jdk.graal.compiler.replacements.nodes.BasicObjectCloneNode;
import jdk.graal.compiler.replacements.nodes.MacroNode;
import jdk.graal.compiler.replacements.nodes.ObjectClone;
import jdk.vm.ci.meta.Assumptions;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.ResolvedJavaField;
import jdk.vm.ci.meta.ResolvedJavaType;

@NodeInfo(allowedUsageTypes={InputType.Memory})
public final class SubstrateObjectCloneNode
extends BasicObjectCloneNode
implements DeoptimizingNode.DeoptBefore {
    public static final NodeClass<SubstrateObjectCloneNode> TYPE = NodeClass.create(SubstrateObjectCloneNode.class);
    @Node.OptionalInput(value=InputType.State)
    protected FrameState stateBefore;

    protected SubstrateObjectCloneNode(MacroNode.MacroParams p) {
        this(p, null, null);
    }

    private SubstrateObjectCloneNode(MacroNode.MacroParams p, FrameState stateBefore, FrameState stateAfter) {
        super(TYPE, p, stateAfter);
        this.stateBefore = stateBefore;
    }

    protected SubstrateObjectCloneNode duplicateWithNewStamp(ObjectStamp newStamp) {
        return new SubstrateObjectCloneNode(this.copyParamsWithImprovedStamp(newStamp), this.stateBefore(), this.stateAfter());
    }

    public LoadFieldNode genLoadFieldNode(Assumptions assumptions, ValueNode originalAlias, ResolvedJavaField field) {
        if (field.getJavaKind() == JavaKind.Object && field.getType() instanceof SharedType) {
            TypeReference trusted = TypeReference.createTrustedWithoutAssumptions((ResolvedJavaType)((SharedType)field.getType()));
            StampPair pair = StampPair.createSingle((Stamp)StampFactory.object((TypeReference)trusted, (boolean)false));
            return LoadFieldNode.createOverrideStamp((StampPair)pair, (ValueNode)originalAlias, (ResolvedJavaField)field);
        }
        return super.genLoadFieldNode(assumptions, originalAlias, field);
    }

    public void lower(LoweringTool tool) {
        tool.getLowerer().lower((Node)this, tool);
    }

    public boolean canDeoptimize() {
        return true;
    }

    public FrameState stateBefore() {
        return this.stateBefore;
    }

    public void setStateBefore(FrameState f) {
        this.updateUsages((Node)this.stateBefore, (Node)f);
        this.stateBefore = f;
    }

    public void virtualize(VirtualizerTool tool) {
        if (SubstrateObjectCloneSnippets.canVirtualize((ObjectClone)this, tool)) {
            super.virtualize(tool);
        }
    }
}

