/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.genscavenge.compacting;

import com.oracle.svm.core.UnmanagedMemoryUtil;
import com.oracle.svm.core.genscavenge.AlignedHeapChunk;
import com.oracle.svm.core.genscavenge.HeapChunk;
import com.oracle.svm.core.genscavenge.compacting.ObjectMoveInfo;
import org.graalvm.word.Pointer;
import org.graalvm.word.UnsignedWord;

public final class CompactingVisitor
implements ObjectMoveInfo.Visitor {
    private AlignedHeapChunk.AlignedHeader chunk;

    public void init(AlignedHeapChunk.AlignedHeader c) {
        this.chunk = c;
        HeapChunk.setTopPointer(c, AlignedHeapChunk.getObjectsStart(c));
    }

    @Override
    public boolean visit(Pointer objSeq, UnsignedWord size, Pointer destAddress, Pointer nextObjSeq) {
        AlignedHeapChunk.AlignedHeader destChunk;
        if (size.equal(0)) {
            assert (objSeq.equal((UnsignedWord)AlignedHeapChunk.getObjectsStart(this.chunk)));
            return true;
        }
        if (destAddress.equal((UnsignedWord)objSeq)) {
            destChunk = this.chunk;
        } else {
            UnmanagedMemoryUtil.copy(objSeq, destAddress, size);
            destChunk = AlignedHeapChunk.getEnclosingChunkFromObjectPointer(destAddress);
        }
        HeapChunk.setTopPointerCarefully(destChunk, destAddress.add(size));
        return true;
    }
}

