/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jipher.internal.spi;

import com.oracle.jipher.internal.common.Util;
import java.security.InvalidKeyException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactorySpi;
import javax.crypto.spec.PBEKeySpec;
import javax.security.auth.Destroyable;

public abstract class PbeKeyFactory
extends SecretKeyFactorySpi {
    private static final Set<String> SUPPORTED_ALGS = new HashSet<String>(Arrays.asList("PBEWithHmacSHA1AndAES_128".toUpperCase(), "PBEWithHmacSHA224AndAES_128".toUpperCase(), "PBEWithHmacSHA256AndAES_128".toUpperCase(), "PBEWithHmacSHA384AndAES_128".toUpperCase(), "PBEWithHmacSHA512AndAES_128".toUpperCase(), "PBEWithHmacSHA1AndAES_256".toUpperCase(), "PBEWithHmacSHA224AndAES_256".toUpperCase(), "PBEWithHmacSHA256AndAES_256".toUpperCase(), "PBEWithHmacSHA384AndAES_256".toUpperCase(), "PBEWithHmacSHA512AndAES_256".toUpperCase(), "PBEWithSHA1AndDESede".toUpperCase()));
    private final String algorithm;

    PbeKeyFactory(String algorithm) {
        this.algorithm = algorithm;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected KeySpec engineGetKeySpec(SecretKey key, Class<?> keySpec) throws InvalidKeySpecException {
        if (keySpec == null || !keySpec.isAssignableFrom(PBEKeySpec.class)) {
            throw new InvalidKeySpecException("Expected KeySpec class to be assignable from PBEKeySpec");
        }
        String keyAlg = key.getAlgorithm().toUpperCase();
        if (!SUPPORTED_ALGS.contains(keyAlg) || !key.getFormat().equalsIgnoreCase("RAW")) {
            throw new InvalidKeySpecException("Invalid key format/algorithm");
        }
        char[] password = PbeKeyFactory.decodePassword(key);
        try {
            PBEKeySpec pBEKeySpec = new PBEKeySpec(password);
            return pBEKeySpec;
        }
        finally {
            Util.clearArray(password);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected SecretKey engineGenerateSecret(KeySpec keySpec) throws InvalidKeySpecException {
        if (!(keySpec instanceof PBEKeySpec)) {
            throw new InvalidKeySpecException("Invalid key spec");
        }
        char[] password = ((PBEKeySpec)keySpec).getPassword();
        try {
            PasswordKey passwordKey = new PasswordKey(this.algorithm, PbeKeyFactory.encodePassword(password));
            return passwordKey;
        }
        finally {
            Util.clearArray(password);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected SecretKey engineTranslateKey(SecretKey key) throws InvalidKeyException {
        String keyAlg = key.getAlgorithm().toUpperCase();
        if (!SUPPORTED_ALGS.contains(keyAlg) || !key.getFormat().equalsIgnoreCase("RAW")) {
            throw new InvalidKeyException("Invalid key format/algorithm");
        }
        char[] password = PbeKeyFactory.decodePassword(key);
        try {
            PasswordKey passwordKey = new PasswordKey(this.algorithm, PbeKeyFactory.encodePassword(password));
            return passwordKey;
        }
        finally {
            Util.clearArray(password);
        }
    }

    private static byte[] encodePassword(char[] password) {
        return Util.utf8Encode(password);
    }

    private static char[] decodePassword(SecretKey key) {
        byte[] encoded = key.getEncoded();
        try {
            if (key instanceof PasswordKey) {
                char[] cArray = Util.utf8Decode(encoded);
                return cArray;
            }
            char[] cArray = Util.asciiDecode(encoded);
            return cArray;
        }
        finally {
            Util.clearArray(encoded);
        }
    }

    static final class PasswordKey
    implements SecretKey,
    Destroyable {
        final String algorithm;
        byte[] encoded;

        PasswordKey(String algorithm, byte[] encoded) {
            this.algorithm = algorithm;
            this.encoded = encoded;
        }

        @Override
        public String getAlgorithm() {
            return this.algorithm;
        }

        @Override
        public String getFormat() {
            return "RAW";
        }

        @Override
        public byte[] getEncoded() {
            if (this.encoded == null) {
                throw new IllegalStateException("password has been cleared");
            }
            return (byte[])this.encoded.clone();
        }

        @Override
        public void destroy() {
            if (this.encoded != null) {
                Arrays.fill(this.encoded, (byte)0);
                this.encoded = null;
            }
        }

        @Override
        public boolean isDestroyed() {
            return this.encoded == null;
        }

        public int hashCode() {
            return this.algorithm.hashCode() + Arrays.hashCode(this.encoded);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof PasswordKey)) {
                return false;
            }
            PasswordKey other = (PasswordKey)obj;
            return this.algorithm.equals(other.algorithm) && Util.equalsTC(this.encoded, other.encoded);
        }
    }

    public static final class PBEWithSHA1AndDESede
    extends PbeKeyFactory {
        public PBEWithSHA1AndDESede() {
            super("PBEWithSHA1AndDESede");
        }
    }

    public static final class PBE
    extends PbeKeyFactory {
        public PBE() {
            super("PBE");
        }
    }

    public static final class PBEWithHmacSHA512AndAES256
    extends PbeKeyFactory {
        public PBEWithHmacSHA512AndAES256() {
            super("PBEWithHmacSHA512AndAES_256");
        }
    }

    public static final class PBEWithHmacSHA384AndAES256
    extends PbeKeyFactory {
        public PBEWithHmacSHA384AndAES256() {
            super("PBEWithHmacSHA384AndAES_256");
        }
    }

    public static final class PBEWithHmacSHA256AndAES256
    extends PbeKeyFactory {
        public PBEWithHmacSHA256AndAES256() {
            super("PBEWithHmacSHA256AndAES_256");
        }
    }

    public static final class PBEWithHmacSHA224AndAES256
    extends PbeKeyFactory {
        public PBEWithHmacSHA224AndAES256() {
            super("PBEWithHmacSHA224AndAES_256");
        }
    }

    public static final class PBEWithHmacSHA1AndAES256
    extends PbeKeyFactory {
        public PBEWithHmacSHA1AndAES256() {
            super("PBEWithHmacSHA1AndAES_256");
        }
    }

    public static final class PBEWithHmacSHA512AndAES128
    extends PbeKeyFactory {
        public PBEWithHmacSHA512AndAES128() {
            super("PBEWithHmacSHA512AndAES_128");
        }
    }

    public static final class PBEWithHmacSHA384AndAES128
    extends PbeKeyFactory {
        public PBEWithHmacSHA384AndAES128() {
            super("PBEWithHmacSHA384AndAES_128");
        }
    }

    public static final class PBEWithHmacSHA256AndAES128
    extends PbeKeyFactory {
        public PBEWithHmacSHA256AndAES128() {
            super("PBEWithHmacSHA256AndAES_128");
        }
    }

    public static final class PBEWithHmacSHA224AndAES128
    extends PbeKeyFactory {
        public PBEWithHmacSHA224AndAES128() {
            super("PBEWithHmacSHA224AndAES_128");
        }
    }

    public static final class PBEWithHmacSHA1AndAES128
    extends PbeKeyFactory {
        public PBEWithHmacSHA1AndAES128() {
            super("PBEWithHmacSHA1AndAES_128");
        }
    }

    public static final class PBES2
    extends PbeKeyFactory {
        public PBES2() {
            super("PBES2");
        }
    }
}

