/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jipher.internal.spi;

import com.oracle.jipher.internal.common.Util;
import com.oracle.jipher.internal.openssl.EvpKdf;
import com.oracle.jipher.internal.openssl.MdAlg;
import com.oracle.jipher.internal.spi.Hmac;
import com.oracle.jipher.internal.spi.PbeKeyFactory;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.SecretKey;
import javax.crypto.interfaces.PBEKey;
import javax.crypto.spec.PBEParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public abstract class PbMac
extends Hmac {
    PbMac(MdAlg evpMd, int macLen) {
        super(evpMd, macLen);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void engineInit(Key key, AlgorithmParameterSpec algorithmParameterSpec) throws InvalidKeyException, InvalidAlgorithmParameterException {
        PBEParameterSpec pbeParamSpec;
        try {
            pbeParamSpec = (PBEParameterSpec)algorithmParameterSpec;
            if (pbeParamSpec == null) {
                throw new InvalidAlgorithmParameterException("PBEParameterSpec required for salt and iteration count");
            }
        }
        catch (ClassCastException ex) {
            throw new InvalidAlgorithmParameterException("PBEParameterSpec type required");
        }
        byte[] salt = pbeParamSpec.getSalt();
        if (salt.length < 8) {
            throw new InvalidAlgorithmParameterException("Salt must be at least 8 bytes long");
        }
        int iter = pbeParamSpec.getIterationCount();
        if (iter < 1) {
            throw new InvalidAlgorithmParameterException("IterationCount must be a positive number");
        }
        if (!(key instanceof SecretKey)) {
            throw new InvalidKeyException("Only SecretKey permitted");
        }
        byte[] pwBytes = PbMac.getKeyEncoding((SecretKey)key);
        byte[] dk = null;
        SecretKeySpec dKey = null;
        try {
            dk = EvpKdf.pkcs12Derive(pwBytes, pwBytes.length, salt, EvpKdf.Pkcs12KdfId.MAC, iter, this.mdAlg, this.macLen);
            dKey = new SecretKeySpec(dk, "Hmac");
            super.engineInit(dKey, null);
        }
        catch (Throwable throwable) {
            Util.clearArray(pwBytes);
            Util.clearArray(dk);
            Util.destroyKey(dKey);
            throw throwable;
        }
        Util.clearArray(pwBytes);
        Util.clearArray(dk);
        Util.destroyKey(dKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] getKeyEncoding(SecretKey key) {
        byte[] pwBytes;
        char[] pwChars;
        block5: {
            byte[] byArray;
            pwChars = null;
            pwBytes = null;
            try {
                if (key instanceof PBEKey) {
                    pwChars = ((PBEKey)key).getPassword();
                } else {
                    pwBytes = key.getEncoded();
                    pwChars = key instanceof PbeKeyFactory.PasswordKey ? Util.utf8Decode(pwBytes) : Util.asciiDecode(pwBytes);
                }
                if (pwChars.length != 1 || pwChars[0] != '\u0000') break block5;
                byArray = new byte[]{};
            }
            catch (Throwable throwable) {
                Util.clearArray(pwChars);
                Util.clearArray(pwBytes);
                throw throwable;
            }
            Util.clearArray(pwChars);
            Util.clearArray(pwBytes);
            return byArray;
        }
        byte[] byArray = Util.utf16BeEncode(pwChars);
        Util.clearArray(pwChars);
        Util.clearArray(pwBytes);
        return byArray;
    }

    public static class HmacPbeSha512
    extends PbMac {
        public HmacPbeSha512() {
            super(MdAlg.SHA512, 64);
        }
    }

    public static class HmacPbeSha384
    extends PbMac {
        public HmacPbeSha384() {
            super(MdAlg.SHA384, 48);
        }
    }

    public static class HmacPbeSha256
    extends PbMac {
        public HmacPbeSha256() {
            super(MdAlg.SHA256, 32);
        }
    }

    public static class HmacPbeSha224
    extends PbMac {
        public HmacPbeSha224() {
            super(MdAlg.SHA224, 28);
        }
    }

    public static class HmacPbeSha1
    extends PbMac {
        public HmacPbeSha1() {
            super(MdAlg.SHA1, 20);
        }
    }
}

