/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jipher.internal.spi;

import com.oracle.jipher.internal.common.Util;
import com.oracle.jipher.internal.openssl.Rand;
import com.oracle.jipher.internal.spi.CipherAlg;
import com.oracle.jipher.internal.spi.CipherMode;
import com.oracle.jipher.internal.spi.CipherPadding;
import com.oracle.jipher.internal.spi.SymmCipher;
import java.nio.ByteBuffer;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.IvParameterSpec;

public abstract class FeedbackCipher
extends SymmCipher {
    int buffered;

    FeedbackCipher(CipherAlg cipherAlg) throws NoSuchAlgorithmException, NoSuchPaddingException {
        super(cipherAlg);
        if (cipherAlg instanceof CipherAlg.FixedModePad) {
            CipherAlg.FixedModePad algModePad = (CipherAlg.FixedModePad)((Object)cipherAlg);
            this.engineSetMode(algModePad.getMode().name());
            this.engineSetPadding(algModePad.getPadding().name());
        }
    }

    @Override
    protected void engineUpdateAAD(ByteBuffer byteBuffer) {
        throw new IllegalStateException("No AAD accepted");
    }

    @Override
    protected void engineUpdateAAD(byte[] bytes, int i, int i1) {
        throw new IllegalStateException("No AAD accepted");
    }

    @Override
    protected int engineUpdate(byte[] input, int inOffset, int inLen, byte[] out, int outOffset) throws ShortBufferException {
        this.checkIfInited();
        this.updateCalled = true;
        int outputSize = this.getUpdateOutputSize(inLen);
        if (outputSize > out.length - outOffset) {
            throw new ShortBufferException("Not enough space in output array");
        }
        int outLen = this.updateInternal(input, inOffset, inLen, out, outOffset, outputSize, this.buffered > 0);
        this.updateBuffered(inLen);
        return outLen;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected int engineDoFinal(byte[] input, int inOffset, int inLen, byte[] out, int outOffset) throws ShortBufferException, IllegalBlockSizeException, BadPaddingException {
        if (inLen == 0 && !this.updateCalled && this.ctx != null && this.padding == CipherPadding.NOPADDING) {
            return 0;
        }
        this.checkIfInited();
        int outputSize = this.engineGetOutputSize(inLen);
        int updateOutputSize = this.getUpdateOutputSize(inLen);
        if (!(this.encrypt || this.mode != CipherMode.ECB && this.mode != CipherMode.CBC || this.padding != CipherPadding.PKCS5PADDING)) {
            int blockSize = this.cipherAlg.getBlockSize();
            int totalInput = Math.addExact(this.buffered, inLen);
            if ((totalInput & blockSize - 1) != 0) {
                this.cleanup();
                throw new IllegalBlockSizeException("Total input data length is not a multiple of the block size");
            }
            if (outputSize > out.length - outOffset && updateOutputSize <= out.length - outOffset) {
                byte[] finalBytes = new byte[blockSize];
                this.ctx.saveState();
                boolean doCleanup = true;
                try {
                    int outLen = this.updateInternal(input, inOffset, inLen, out, outOffset, updateOutputSize, this.buffered > 0);
                    int finalBytesLen = this.ctx.doFinal(finalBytes, 0);
                    if (outLen + finalBytesLen > out.length - outOffset) {
                        doCleanup = false;
                        throw new ShortBufferException("Not enough space in output array");
                    }
                    System.arraycopy(finalBytes, 0, out, outOffset + outLen, finalBytesLen);
                    int n = outLen + finalBytesLen;
                    return n;
                }
                finally {
                    this.ctx.restoreState();
                    Util.clearArray(finalBytes);
                    if (doCleanup) {
                        this.cleanup();
                    }
                }
            }
        }
        if (outputSize > out.length - outOffset) {
            throw new ShortBufferException("Not enough space in output array");
        }
        try {
            int outLen = this.updateInternal(input, inOffset, inLen, out, outOffset, updateOutputSize, this.buffered > 0);
            outLen += this.ctx.doFinal(out, outOffset + outLen);
            int n = outLen;
            return n;
        }
        finally {
            this.cleanup();
        }
    }

    @Override
    AlgorithmParameterSpec getParamSpec(byte[] iv, AlgorithmParameterSpec spec) {
        return iv != null ? new IvParameterSpec(iv) : spec;
    }

    @Override
    byte[] verifyParams(AlgorithmParameterSpec params, boolean encrypt) throws InvalidAlgorithmParameterException {
        if (params == null) {
            return this.validateIv(null, encrypt);
        }
        if (params instanceof IvParameterSpec) {
            return this.validateIv(((IvParameterSpec)params).getIV(), encrypt);
        }
        throw new InvalidAlgorithmParameterException();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private byte[] validateIv(byte[] iv, boolean encrypt) throws InvalidAlgorithmParameterException {
        if (iv == null) {
            if (this.mode == CipherMode.ECB) {
                return null;
            }
            if (!encrypt) throw new InvalidAlgorithmParameterException("IV parameters required for decryption");
            return Rand.generate(this.cipherAlg.getBlockSize());
        }
        if (this.mode == CipherMode.ECB) {
            throw new InvalidAlgorithmParameterException("No IV expected for ECB.");
        }
        if (iv.length == this.cipherAlg.getBlockSize()) return iv;
        throw new InvalidAlgorithmParameterException("Expected IV of length " + this.cipherAlg.getBlockSize());
    }

    @Override
    Class<? extends AlgorithmParameterSpec> getParameterSpecClass() {
        return IvParameterSpec.class;
    }

    @Override
    int getUpdateOutputSize(int inputLen) {
        int outputSize;
        if (this.mode == CipherMode.ECB || this.mode == CipherMode.CBC) {
            int totalInput = Math.addExact(this.buffered, inputLen);
            int blockSize = this.cipherAlg.getBlockSize();
            outputSize = totalInput & -blockSize;
            if (this.padding == CipherPadding.PKCS5PADDING && !this.encrypt && outputSize > 0 && outputSize == totalInput) {
                outputSize -= blockSize;
            }
        } else {
            outputSize = inputLen;
        }
        return outputSize;
    }

    void updateBuffered(int inputLen) {
        if (this.mode == CipherMode.ECB || this.mode == CipherMode.CBC) {
            int processed = Math.addExact(this.buffered, inputLen);
            int blockSize = this.cipherAlg.getBlockSize();
            this.buffered = this.padding == CipherPadding.PKCS5PADDING && !this.encrypt ? (processed > 0 ? (processed - 1 & blockSize - 1) + 1 : 0) : processed & blockSize - 1;
        }
    }

    @Override
    protected int engineGetOutputSize(int inputLen) {
        int outputSize = this.getUpdateOutputSize(inputLen);
        if ((this.mode == CipherMode.ECB || this.mode == CipherMode.CBC) && this.padding == CipherPadding.PKCS5PADDING) {
            int blockSize = this.cipherAlg.getBlockSize();
            if (this.encrypt) {
                outputSize = Math.addExact(outputSize, blockSize);
            } else {
                int totalInput = Math.addExact(this.buffered, inputLen);
                if (outputSize + blockSize == totalInput) {
                    outputSize += blockSize - 1;
                }
            }
        }
        return outputSize;
    }

    @Override
    String getAlgorithmParametersAlg() {
        return this.cipherAlg.getName();
    }

    @Override
    void cleanup() {
        this.buffered = 0;
        if (!this.encrypt && (this.mode == CipherMode.ECB || this.mode == CipherMode.CFB) || this.mode == CipherMode.CBC) {
            if (this.ctx != null) {
                this.ctx.reInit();
            }
            this.updateCalled = false;
        } else {
            super.cleanup();
        }
    }

    public static final class DesEdeCbcPkcs5Pad
    extends FeedbackCipher {
        public DesEdeCbcPkcs5Pad() throws NoSuchAlgorithmException, NoSuchPaddingException {
            super(new CipherAlg.DesEdeFixed(CipherMode.CBC, CipherPadding.PKCS5PADDING));
        }
    }

    public static final class DESEDE
    extends FeedbackCipher {
        public DESEDE() throws NoSuchAlgorithmException, NoSuchPaddingException {
            super(new CipherAlg.DesEde());
        }
    }

    public static final class Aes256OfbNoPad
    extends FeedbackCipher {
        public Aes256OfbNoPad() throws NoSuchAlgorithmException, NoSuchPaddingException {
            super(new CipherAlg.AesFixed(256, CipherMode.OFB, CipherPadding.NOPADDING));
        }
    }

    public static final class Aes256CfbNoPad
    extends FeedbackCipher {
        public Aes256CfbNoPad() throws NoSuchAlgorithmException, NoSuchPaddingException {
            super(new CipherAlg.AesFixed(256, CipherMode.CFB, CipherPadding.NOPADDING));
        }
    }

    public static final class Aes256CbcPkcs5Pad
    extends FeedbackCipher {
        public Aes256CbcPkcs5Pad() throws NoSuchAlgorithmException, NoSuchPaddingException {
            super(new CipherAlg.AesFixed(256, CipherMode.CBC, CipherPadding.PKCS5PADDING));
        }
    }

    public static final class Aes256EcbNoPad
    extends FeedbackCipher {
        public Aes256EcbNoPad() throws NoSuchAlgorithmException, NoSuchPaddingException {
            super(new CipherAlg.AesFixed(256, CipherMode.ECB, CipherPadding.NOPADDING));
        }
    }

    public static final class Aes192OfbNoPad
    extends FeedbackCipher {
        public Aes192OfbNoPad() throws NoSuchAlgorithmException, NoSuchPaddingException {
            super(new CipherAlg.AesFixed(192, CipherMode.OFB, CipherPadding.NOPADDING));
        }
    }

    public static final class Aes192CfbNoPad
    extends FeedbackCipher {
        public Aes192CfbNoPad() throws NoSuchAlgorithmException, NoSuchPaddingException {
            super(new CipherAlg.AesFixed(192, CipherMode.CFB, CipherPadding.NOPADDING));
        }
    }

    public static final class Aes192CbcPkcs5Pad
    extends FeedbackCipher {
        public Aes192CbcPkcs5Pad() throws NoSuchAlgorithmException, NoSuchPaddingException {
            super(new CipherAlg.AesFixed(192, CipherMode.CBC, CipherPadding.PKCS5PADDING));
        }
    }

    public static final class Aes192EcbNoPad
    extends FeedbackCipher {
        public Aes192EcbNoPad() throws NoSuchAlgorithmException, NoSuchPaddingException {
            super(new CipherAlg.AesFixed(192, CipherMode.ECB, CipherPadding.NOPADDING));
        }
    }

    public static final class Aes128OfbNoPad
    extends FeedbackCipher {
        public Aes128OfbNoPad() throws NoSuchAlgorithmException, NoSuchPaddingException {
            super(new CipherAlg.AesFixed(128, CipherMode.OFB, CipherPadding.NOPADDING));
        }
    }

    public static final class Aes128CfbNoPad
    extends FeedbackCipher {
        public Aes128CfbNoPad() throws NoSuchAlgorithmException, NoSuchPaddingException {
            super(new CipherAlg.AesFixed(128, CipherMode.CFB, CipherPadding.NOPADDING));
        }
    }

    public static final class Aes128CbcPkcs5Pad
    extends FeedbackCipher {
        public Aes128CbcPkcs5Pad() throws NoSuchAlgorithmException, NoSuchPaddingException {
            super(new CipherAlg.AesFixed(128, CipherMode.CBC, CipherPadding.PKCS5PADDING));
        }
    }

    public static final class Aes128EcbNoPad
    extends FeedbackCipher {
        public Aes128EcbNoPad() throws NoSuchAlgorithmException, NoSuchPaddingException {
            super(new CipherAlg.AesFixed(128, CipherMode.ECB, CipherPadding.NOPADDING));
        }
    }

    public static final class AES
    extends FeedbackCipher {
        public AES() throws NoSuchAlgorithmException, NoSuchPaddingException {
            super(new CipherAlg.AES());
        }
    }
}

