/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jipher.internal.spi;

import com.oracle.jipher.internal.openssl.MdAlg;
import com.oracle.jipher.internal.spi.AsymKeyFactory;
import com.oracle.jipher.internal.spi.DigestSignature;
import com.oracle.jipher.internal.spi.EcKeyFactory;

public abstract class EcdsaDigestSig
extends DigestSignature {
    EcdsaDigestSig(MdAlg md) {
        super(md);
    }

    @Override
    AsymKeyFactory getKeyFactory() {
        return new EcKeyFactory();
    }

    public static final class Sha512WithEcdsa
    extends EcdsaDigestSig {
        public Sha512WithEcdsa() {
            super(MdAlg.SHA512);
        }
    }

    public static final class Sha384WithEcdsa
    extends EcdsaDigestSig {
        public Sha384WithEcdsa() {
            super(MdAlg.SHA384);
        }
    }

    public static final class Sha256WithEcdsa
    extends EcdsaDigestSig {
        public Sha256WithEcdsa() {
            super(MdAlg.SHA256);
        }
    }

    public static final class Sha224WithEcdsa
    extends EcdsaDigestSig {
        public Sha224WithEcdsa() {
            super(MdAlg.SHA224);
        }
    }

    public static final class Sha1WithEcdsa
    extends EcdsaDigestSig {
        public Sha1WithEcdsa() {
            super(MdAlg.SHA1);
        }
    }
}

