/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jipher.internal.spi;

import com.oracle.jipher.internal.openssl.EcCurve;
import com.oracle.jipher.internal.spi.NamedCurves;
import java.io.IOException;
import java.security.AlgorithmParametersSpi;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.ECGenParameterSpec;
import java.security.spec.ECParameterSpec;
import java.security.spec.InvalidParameterSpecException;

public final class EcParameters
extends AlgorithmParametersSpi {
    private ECParameterSpec spec;

    @Override
    protected <T extends AlgorithmParameterSpec> T engineGetParameterSpec(Class<T> paramSpec) throws InvalidParameterSpecException {
        if (paramSpec != null && paramSpec.isAssignableFrom(ECParameterSpec.class)) {
            return (T)((AlgorithmParameterSpec)paramSpec.cast(this.spec));
        }
        if (paramSpec != null && paramSpec.isAssignableFrom(ECGenParameterSpec.class)) {
            EcCurve curveParams = NamedCurves.lookup(this.spec);
            if (curveParams == null) {
                throw new InvalidParameterSpecException("Could not get ECGenParameterSpec for these parameters.");
            }
            return (T)((AlgorithmParameterSpec)paramSpec.cast(new ECGenParameterSpec(curveParams.oid())));
        }
        throw new InvalidParameterSpecException("Expected ParameterSpec class to be assignable from ECParameterSpec or ECGenParameterSpec");
    }

    @Override
    protected void engineInit(byte[] params) throws IOException {
        this.spec = NamedCurves.decodeParams(params);
    }

    @Override
    protected void engineInit(byte[] params, String format) throws IOException {
        this.spec = NamedCurves.decodeParams(params);
    }

    @Override
    protected void engineInit(AlgorithmParameterSpec paramSpec) throws InvalidParameterSpecException {
        if (paramSpec instanceof ECGenParameterSpec) {
            this.spec = NamedCurves.lookup(((ECGenParameterSpec)paramSpec).getName());
            if (this.spec == null) {
                throw new InvalidParameterSpecException("Unsupported EC curve name");
            }
        } else if (paramSpec instanceof ECParameterSpec) {
            this.spec = (ECParameterSpec)paramSpec;
        } else {
            throw new InvalidParameterSpecException("Invalid parameter spec for EC parameters");
        }
    }

    @Override
    protected String engineToString() {
        return "EC Parameters (" + (Object)((Object)NamedCurves.lookup(this.spec)) + ")";
    }

    @Override
    protected byte[] engineGetEncoded() throws IOException {
        return NamedCurves.getEncoded(this.spec);
    }

    @Override
    protected byte[] engineGetEncoded(String format) throws IOException {
        return NamedCurves.getEncoded(this.spec);
    }
}

