/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.foreign;

import com.oracle.graal.pointsto.infrastructure.GraphProvider;
import com.oracle.graal.pointsto.meta.AnalysisMetaAccess;
import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.graal.pointsto.meta.HostedProviders;
import com.oracle.svm.core.foreign.AbiUtils;
import com.oracle.svm.core.foreign.JavaEntryPointInfo;
import com.oracle.svm.core.graal.nodes.CEntryPointLeaveNode;
import com.oracle.svm.core.graal.nodes.LoweredDeadEndNode;
import com.oracle.svm.hosted.foreign.ForeignGraphKit;
import com.oracle.svm.hosted.foreign.UpcallStub;
import com.oracle.svm.util.ReflectionUtil;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodType;
import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import jdk.graal.compiler.debug.DebugContext;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.java.FrameStateBuilder;
import jdk.graal.compiler.nodes.CallTargetNode;
import jdk.graal.compiler.nodes.InvokeWithExceptionNode;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaMethod;

class HighLevelUpcallStub
extends UpcallStub {
    private static final Method INVOKE = ReflectionUtil.lookupMethod(MethodHandle.class, (String)"invokeWithArguments", (Class[])new Class[]{Object[].class});

    private static MethodType computeType(JavaEntryPointInfo jep, MethodType lowType) {
        if (jep.buffersReturn()) {
            lowType = lowType.insertParameterTypes(0, Long.TYPE);
        }
        return lowType.insertParameterTypes(0, MethodHandle.class);
    }

    HighLevelUpcallStub(JavaEntryPointInfo jep, AbiUtils.Adapter.Result.TypeAdaptation adapted, MetaAccessProvider metaAccess) {
        super(jep, HighLevelUpcallStub.computeType(jep, adapted.callType()), metaAccess, true);
    }

    public StructuredGraph buildGraph(DebugContext debug, AnalysisMethod method, HostedProviders providers, GraphProvider.Purpose purpose) {
        ForeignGraphKit kit = new ForeignGraphKit(debug, providers, (ResolvedJavaMethod)method, purpose);
        AnalysisMetaAccess metaAccess = kit.getMetaAccess();
        FrameStateBuilder frame = kit.getFrameState();
        List<ValueNode> allArguments = new ArrayList<ValueNode>(kit.getInitialArguments());
        ValueNode mh = (ValueNode)allArguments.remove(0);
        allArguments = kit.boxArguments(allArguments, this.jep.handleType());
        ValueNode arguments = kit.packArguments(allArguments);
        frame.clearLocals();
        InvokeWithExceptionNode returnValue = kit.createJavaCallWithException(CallTargetNode.InvokeKind.Virtual, metaAccess.lookupJavaMethod((Executable)INVOKE), new ValueNode[]{mh, arguments});
        kit.exceptionPart();
        kit.append((Node)new CEntryPointLeaveNode(CEntryPointLeaveNode.LeaveAction.ExceptionAbort, (ValueNode)kit.exceptionObject()));
        kit.append((Node)new LoweredDeadEndNode());
        kit.endInvokeWithException();
        ValueNode unboxedReturn = kit.unbox((ValueNode)returnValue, this.jep.cMethodType());
        kit.createReturn(unboxedReturn, this.jep.cMethodType());
        return kit.finalizeGraph();
    }
}

