/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.foreign;

import com.oracle.svm.core.NeverInline;
import com.oracle.svm.core.annotate.Delete;
import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import com.oracle.svm.core.foreign.ForeignFunctionsEnabled;
import com.oracle.svm.core.foreign.Util_java_lang_foreign_SymbolLookup;
import com.oracle.svm.core.jdk.NativeLibraries;
import com.oracle.svm.core.jdk.StackTraceUtils;
import com.oracle.svm.core.snippets.KnownIntrinsics;
import java.lang.foreign.Arena;
import java.lang.foreign.SymbolLookup;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.util.List;
import java.util.function.BiFunction;
import jdk.internal.foreign.Utils;
import jdk.internal.loader.NativeLibrary;
import jdk.internal.loader.RawNativeLibraries;
import jdk.internal.reflect.CallerSensitive;
import org.graalvm.word.Pointer;

@TargetClass(className="java.lang.foreign.SymbolLookup", onlyWith={ForeignFunctionsEnabled.class})
public final class Target_java_lang_foreign_SymbolLookup {
    @Substitute
    @CallerSensitive
    @NeverInline(value="Starting a stack walk in the caller frame")
    static SymbolLookup libraryLookup(String name, Arena arena) {
        Util_java_lang_foreign_SymbolLookup.ensureNativeAccess(StackTraceUtils.getCallerClass((Pointer)KnownIntrinsics.readCallerStackPointer(), (boolean)true), SymbolLookup.class, "libraryLookup");
        if (Utils.containsNullChars(name)) {
            throw new IllegalArgumentException("Cannot open library: " + name);
        }
        return Util_java_lang_foreign_SymbolLookup.libraryLookup(NativeLibraries::loadLibraryPlatformSpecific, arena, List.of(name));
    }

    @Substitute
    @CallerSensitive
    @NeverInline(value="Starting a stack walk in the caller frame")
    static SymbolLookup libraryLookup(Path path, Arena arena) {
        Util_java_lang_foreign_SymbolLookup.ensureNativeAccess(StackTraceUtils.getCallerClass((Pointer)KnownIntrinsics.readCallerStackPointer(), (boolean)true), SymbolLookup.class, "libraryLookup");
        if (path.getFileSystem() != FileSystems.getDefault()) {
            throw new IllegalArgumentException("Path not in default file system: " + String.valueOf(path));
        }
        return Util_java_lang_foreign_SymbolLookup.libraryLookup(NativeLibraries::loadLibraryPlatformSpecific, arena, List.of(path));
    }

    @Delete
    private static native <Z> SymbolLookup libraryLookup(Z var0, BiFunction<RawNativeLibraries, Z, NativeLibrary> var1, Arena var2);
}

