/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.foreign;

import com.oracle.svm.core.config.ConfigurationValues;
import com.oracle.svm.core.util.VMError;
import jdk.internal.foreign.Utils;
import jdk.vm.ci.meta.JavaKind;
import org.graalvm.nativeimage.hosted.FieldValueTransformer;

final class BaseFieldRecomputer
implements FieldValueTransformer {
    BaseFieldRecomputer() {
    }

    public Object transform(Object receiver, Object originalValue) {
        JavaKind kind;
        if (receiver == Utils.BaseAndScale.BYTE) {
            kind = JavaKind.Byte;
        } else if (receiver == Utils.BaseAndScale.CHAR) {
            kind = JavaKind.Char;
        } else if (receiver == Utils.BaseAndScale.SHORT) {
            kind = JavaKind.Short;
        } else if (receiver == Utils.BaseAndScale.INT) {
            kind = JavaKind.Int;
        } else if (receiver == Utils.BaseAndScale.LONG) {
            kind = JavaKind.Long;
        } else if (receiver == Utils.BaseAndScale.FLOAT) {
            kind = JavaKind.Float;
        } else if (receiver == Utils.BaseAndScale.DOUBLE) {
            kind = JavaKind.Double;
        } else {
            throw VMError.shouldNotReachHere((String)("Unexpected BaseAndScale instance: " + String.valueOf(receiver)));
        }
        return ConfigurationValues.getObjectLayout().getArrayBaseOffset(kind);
    }
}

