/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.enterprise.profiling.loaders;

import com.oracle.svm.core.util.VMError;
import com.oracle.svm.enterprise.profiling.collect.e;
import com.oracle.svm.enterprise.profiling.data.l;
import com.oracle.svm.enterprise.profiling.kinds.d;
import com.oracle.svm.enterprise.profiling.metadata.b;
import com.oracle.svm.enterprise.profiling.metadata.codepositions.a;
import com.oracle.svm.enterprise.profiling.metadata.elements.c;
import com.oracle.svm.enterprise.profiling.p;
import com.oracle.svm.enterprise.profiling.profiles.ProfilingBaseProfile;
import com.oracle.svm.util.LogUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PushbackInputStream;
import java.io.Reader;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.zip.GZIPInputStream;
import jdk.graal.compiler.nodes.ProfileData;
import jdk.graal.compiler.util.json.JsonParser;
import jdk.graal.compiler.util.json.JsonParserException;

public abstract class ProfilingLoader<T, M> {
    public abstract boolean shouldIgnoreProfileVersionCheck();

    public abstract e parseProfile(Path var1);

    public List<e> parseProfiles(List<Path> list) {
        return list.stream().map(this::parseProfile).collect(Collectors.toList());
    }

    public ProfilingBaseProfile loadProfile(List<e> list, long l2, ProfileData.ProfileSource profileSource) {
        VMError.guarantee((profileSource.isProfiled() || profileSource.isAdopted() || profileSource.isUnknown() ? 1 : 0) != 0);
        return list.stream().map(e2 -> this.newProfile((e)e2, profileSource)).map(profilingBaseProfile -> profilingBaseProfile.normalize(l2)).reduce(ProfilingBaseProfile::merge).map(profilingBaseProfile -> profilingBaseProfile.normalize(l2)).orElse(null);
    }

    public abstract ProfilingBaseProfile newProfile(e var1, ProfileData.ProfileSource var2);

    public abstract com.oracle.svm.enterprise.profiling.metadata.elements.b<com.oracle.svm.enterprise.profiling.metadata.elements.d> getGlobalTypes();

    public abstract com.oracle.svm.enterprise.profiling.metadata.elements.b<c> getGlobalMethods();

    public abstract Map<Integer, T> loadTypes(Map<Integer, com.oracle.svm.enterprise.profiling.metadata.elements.d> var1);

    public abstract Map<Integer, M> loadMethods(Map<Integer, com.oracle.svm.enterprise.profiling.metadata.elements.d> var1, Map<Integer, c> var2);

    public final void loadNodes(b b2, l l2, List<com.oracle.svm.enterprise.profiling.collect.d> list, byte by, com.oracle.svm.enterprise.profiling.adapters.b<T, M> b3) {
        for (com.oracle.svm.enterprise.profiling.collect.d d2 : list) {
            List<a<?>> list2 = p.a(d2.iC(), this.getCodePositionGenerator(b2, by), b3);
            long[] lArray = d2.iB();
            com.oracle.svm.enterprise.profiling.metadata.cctree.e e2 = b2.m(list2);
            com.oracle.svm.enterprise.profiling.metadata.cctree.d d3 = e2.jd();
            if (e2.je() && d3 instanceof com.oracle.svm.enterprise.profiling.metadata.cctree.c) {
                com.oracle.svm.enterprise.profiling.metadata.cctree.c c2 = (com.oracle.svm.enterprise.profiling.metadata.cctree.c)d3;
                c2.a(l2, lArray);
                continue;
            }
            int n2 = l2.W(lArray.length);
            l2.a(n2, lArray);
            b2.a(list2, by, n2);
        }
    }

    protected abstract BiFunction<M, Integer, a<?>> getCodePositionGenerator(b var1, byte var2);

    protected e parseProfile0(Path path, Consumer<String> consumer) {
        JsonParser jsonParser = null;
        File file = path.toFile();
        long l2 = file.length();
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            InputStream inputStream = ProfilingLoader.handleGzipStream(fileInputStream);
            InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
            jsonParser = new JsonParser((Reader)inputStreamReader);
            Object object = jsonParser.parse();
            return this.createProfileObject(object, path, consumer);
        }
        catch (IOException iOException) {
            consumer.accept(String.format("Cannot load profile %s (reason: %s). Please verify that the file exists and has appropriate access rights.", path, iOException));
        }
        catch (JsonParserException jsonParserException) {
            assert (jsonParser != null);
            consumer.accept(String.format("Malformed JSON in %s (reason: %s). The original file size before parsing is %d, after parsing is %d, and the parsed file size is %d.", new Object[]{path, jsonParserException, l2, file.length(), jsonParser.getSourceLength()}));
        }
        return null;
    }

    private e createProfileObject(Object object, Path path, Consumer<String> consumer) {
        e e2 = new e(object);
        com.oracle.svm.enterprise.profiling.collect.b b2 = e2.iD();
        if (b2.iz()) {
            consumer.accept(String.format("Unable to detect the version number of profile %s.", path));
        }
        this.checkIsCompatibleProfileVersion(b2, path, consumer);
        com.oracle.svm.enterprise.profiling.collect.c c2 = e2.iE();
        String string = "Profile %s is missing a '%s' section.";
        if (c2.iA() == null) {
            consumer.accept(String.format(string, path, "types"));
        }
        if (c2.fc() == null) {
            consumer.accept(String.format(string, path, "methods"));
        }
        com.oracle.svm.enterprise.profiling.collect.a a2 = e2.iF();
        for (d d2 : d.values()) {
            if (a2.d(d2.iL()) != null) continue;
            consumer.accept(String.format(string, path, d2.getName()));
        }
        return e2;
    }

    private void checkIsCompatibleProfileVersion(com.oracle.svm.enterprise.profiling.collect.b b2, Path path, Consumer<String> consumer) {
        if (b2.iy()) {
            String string = String.format("The profile %s, with version %s, is incompatible with the profile version %s, that is supported on GraalVM used for the build. It is possible that given profile is generated with different GraalVM version. Please ensure that you are using a valid and supported profiles.", path, b2.ix(), "0.4.0");
            if (this.shouldIgnoreProfileVersionCheck()) {
                LogUtils.warning((String)string);
            } else {
                consumer.accept(string);
            }
        }
    }

    private static InputStream handleGzipStream(InputStream inputStream) throws IOException {
        PushbackInputStream pushbackInputStream = new PushbackInputStream(inputStream, 2);
        int n2 = pushbackInputStream.read();
        int n3 = pushbackInputStream.read();
        pushbackInputStream.unread(n3);
        pushbackInputStream.unread(n2);
        int n4 = n3 << 8 | n2;
        if (n4 == 35615) {
            return new GZIPInputStream(pushbackInputStream);
        }
        return pushbackInputStream;
    }
}

