/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.enterprise.profiling.framework;

import com.oracle.svm.enterprise.profiling.framework.ProfileDumper;
import com.oracle.svm.enterprise.profiling.framework.collection.CallingContext;
import com.oracle.svm.enterprise.profiling.framework.collection.CodePosition;
import com.oracle.svm.enterprise.profiling.framework.collection.PrefixTree;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class PGOSamplingData
implements ProfileDumper.SampleProvider {
    private final PGOPrefixTree prefixTree = new PGOPrefixTree();

    @Override
    public PrefixTree<Long> samples() {
        return this.prefixTree;
    }

    public void addSample(CallingContext callingContext, long l2) {
        Node node = this.prefixTree.getOrCreate(callingContext);
        node.value += l2;
    }

    private static Node getOrCreateNode(List<PrefixTree.Cursor<Long>> list, List<CodePosition> list2, int n2) {
        CodePosition codePosition = list2.get(n2);
        for (PrefixTree.Cursor<Long> cursor : list) {
            if (!cursor.codePosition().equals(codePosition)) continue;
            return ((Node)cursor).getOrCreate(list2, n2 + 1);
        }
        Node node = new Node(codePosition);
        list.add(node);
        return node.getOrCreate(list2, n2 + 1);
    }

    private static final class PGOPrefixTree
    implements PrefixTree<Long> {
        List<PrefixTree.Cursor<Long>> roots = new ArrayList<PrefixTree.Cursor<Long>>();

        private PGOPrefixTree() {
        }

        @Override
        public List<PrefixTree.Cursor<Long>> roots() {
            return this.roots;
        }

        public Node getOrCreate(CallingContext callingContext) {
            List<CodePosition> list = PGOPrefixTree.reverseContext(callingContext);
            return PGOSamplingData.getOrCreateNode(this.roots, list, 0);
        }

        private static List<CodePosition> reverseContext(CallingContext callingContext) {
            ArrayList<CodePosition> arrayList = new ArrayList<CodePosition>();
            callingContext.traverseFromCallee(arrayList::add);
            Collections.reverse(arrayList);
            return arrayList;
        }
    }

    private static final class Node
    implements PrefixTree.Cursor<Long> {
        private final CodePosition codePosition;
        private final List<PrefixTree.Cursor<Long>> children;
        long value;

        private Node(CodePosition codePosition) {
            this.codePosition = codePosition;
            this.children = new ArrayList<PrefixTree.Cursor<Long>>();
        }

        @Override
        public CodePosition codePosition() {
            return this.codePosition;
        }

        @Override
        public Iterable<PrefixTree.Cursor<Long>> children() {
            return this.children;
        }

        @Override
        public Long value() {
            return this.value;
        }

        public Node getOrCreate(List<CodePosition> list, int n2) {
            if (n2 == list.size()) {
                return this;
            }
            return PGOSamplingData.getOrCreateNode(this.children, list, n2);
        }
    }
}

