/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.enterprise.hosted.substitute;

import com.oracle.svm.core.option.HostedOptionKey;
import com.oracle.svm.core.util.UserError;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.util.ClassUtil;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HexFormat;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import jdk.graal.compiler.util.json.JsonWriter;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.Equivalence;

public interface b
extends AutoCloseable {
    @Override
    public void close();

    public void a(com.oracle.svm.enterprise.hosted.substitute.a var1, Class<?> var2, Class<?> var3);

    public static b f(MetaAccessProvider metaAccessProvider) {
        String string = d.k(c.WriteSubstitutionChecksum);
        if (string != null) {
            return new b();
        }
        String string2 = d.k(c.VerifySubstitutionChecksum);
        if (string2 != null) {
            return new a(metaAccessProvider);
        }
        throw VMError.shouldNotReachHere((String)"isEnabled() should not be true");
    }

    public static boolean ib() {
        return c.WriteSubstitutionChecksum.getValue() != null || c.VerifySubstitutionChecksum.getValue() != null;
    }

    public static class c {
        public static final HostedOptionKey<String> WriteSubstitutionChecksum = new HostedOptionKey(null);
        public static final HostedOptionKey<String> VerifySubstitutionChecksum = new HostedOptionKey(null);
        public static final HostedOptionKey<String> SubstitutionChecksumResult = new HostedOptionKey(null);
    }

    public static abstract class d
    implements b {
        public static final String xQ = "java.vm.version";
        private static final Set<String> xR = Set.of("jdk.graal.compiler", "jdk.graal.compiler.management", "org.graalvm.nativeimage.builder");
        private final EconomicMap<Class<?>, byte[]> xS = EconomicMap.create((Equivalence)Equivalence.IDENTITY);

        static String k(HostedOptionKey<String> hostedOptionKey) {
            String string = (String)hostedOptionKey.getValue();
            if (string != null && !Paths.get(string, new String[0]).toFile().isDirectory()) {
                throw UserError.abort((String)"%s is not pointing to a directory: %s", (Object[])new Object[]{hostedOptionKey.getName(), string});
            }
            return string;
        }

        @Override
        public void a(com.oracle.svm.enterprise.hosted.substitute.a a2, Class<?> clazz, Class<?> clazz2) {
            if (!ModuleLayer.boot().modules().contains(clazz.getModule())) {
                return;
            }
            if (clazz.getClassLoader() != null && clazz.getClassLoader() != ClassLoader.getPlatformClassLoader() || xR.contains(clazz.getModule().getName())) {
                return;
            }
            if (!a2.i(clazz2)) {
                return;
            }
            byte[] byArray = (byte[])this.xS.get(clazz);
            if (byArray == null) {
                byArray = d.n(clazz);
                this.xS.put(clazz, (Object)byArray);
            } else if (!this.ic()) {
                return;
            }
            this.a(clazz, clazz2, byArray);
        }

        protected abstract boolean ic();

        protected abstract void a(Class<?> var1, Class<?> var2, byte[] var3);

        @Override
        public void close() {
        }

        protected static Path l(Class<?> clazz) {
            return Paths.get(clazz.getModule().getName(), clazz.getName() + ".class.sha256");
        }

        protected static Path m(Class<?> clazz) {
            return Paths.get(clazz.getModule().getName(), clazz.getName());
        }

        protected static String ij() {
            return System.getProperty(xQ);
        }

        protected static String b(byte[] byArray) {
            return HexFormat.of().formatHex(byArray);
        }

        protected static byte[] R(String string) {
            return HexFormat.of().parseHex(string);
        }

        static byte[] n(Class<?> clazz) {
            byte[] byArray;
            block8: {
                InputStream inputStream = clazz.getResourceAsStream(d.o(clazz));
                try {
                    VMError.guarantee((inputStream != null ? 1 : 0) != 0, (String)"classfile null for %s", clazz);
                    byArray = MessageDigest.getInstance("SHA-256").digest(d.a(inputStream));
                    if (inputStream == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (inputStream != null) {
                            try {
                                inputStream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException | NoSuchAlgorithmException exception) {
                        throw new RuntimeException(exception);
                    }
                }
                inputStream.close();
            }
            return byArray;
        }

        private static byte[] a(InputStream inputStream) throws IOException {
            int n2;
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            byte[] byArray = new byte[16384];
            while ((n2 = inputStream.read(byArray, 0, byArray.length)) != -1) {
                byteArrayOutputStream.write(byArray, 0, n2);
            }
            return byteArrayOutputStream.toByteArray();
        }

        private static String o(Class<?> clazz) {
            return ClassUtil.getUnqualifiedName(clazz) + ".class";
        }
    }

    public static final class b
    extends d {
        private static void b(Path path, String string) {
            try {
                Path path2 = Paths.get((String)c.WriteSubstitutionChecksum.getValue(), new String[0]).resolve(path);
                Path path3 = path2.getParent();
                assert (path3 != null) : "No parent directory: " + String.valueOf(path2);
                Files.createDirectories(path3, new FileAttribute[0]);
                Files.writeString(path2, (CharSequence)string, new OpenOption[0]);
            }
            catch (IOException iOException) {
                throw UserError.abort((Throwable)iOException, (String)iOException.getMessage(), (Object[])new Object[0]);
            }
        }

        @Override
        protected boolean ic() {
            return false;
        }

        @Override
        protected void a(Class<?> clazz, Class<?> clazz2, byte[] byArray) {
            b.b(b.l(clazz), b.b(byArray));
        }

        @Override
        public void close() {
            super.close();
            b.b(Paths.get("java.vm.version", new String[0]), d.ij());
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static final class com.oracle.svm.enterprise.hosted.substitute.b$a
    extends d {
        private final MetaAccessProvider xJ;
        private final EconomicMap<Path, byte[]> xK = EconomicMap.create();
        private final EconomicMap<Class<?>, a> xL = EconomicMap.create((Equivalence)Equivalence.IDENTITY);
        private final ArrayList<Class<?>> xM = new ArrayList();

        private com.oracle.svm.enterprise.hosted.substitute.b$a(MetaAccessProvider metaAccessProvider) {
            this.xJ = metaAccessProvider;
        }

        @Override
        protected boolean ic() {
            return true;
        }

        @Override
        protected void a(Class<?> clazz, Class<?> clazz2, byte[] byArray) {
            byte[] byArray2 = this.k(clazz);
            if (!Arrays.equals(byArray2, byArray)) {
                a a2 = (a)this.xL.get(clazz);
                if (a2 == null) {
                    a2 = new a(clazz, new ArrayList(), byArray);
                    this.xL.put(clazz, (Object)a2);
                }
                VMError.guarantee((!a2.xO.contains(clazz2) ? 1 : 0) != 0);
                a2.xO.add(clazz2);
            }
            this.xM.add(clazz);
        }

        @Override
        public void close() {
            super.close();
            int n2 = this.xK.size();
            String string = this.ie();
            String string2 = (String)c.SubstitutionChecksumResult.getValue();
            if (string2 != null) {
                this.a(n2, string, string2);
            } else if (!this.xL.isEmpty()) {
                int n3 = this.xL.size();
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append(String.format("Differences from '%s' to '%s'%n", string, com.oracle.svm.enterprise.hosted.substitute.b$a.ij()));
                stringBuilder.append(String.format("Checksum violation (%s/%s):%n", n3, n2));
                this.xL.getValues().forEach(a2 -> stringBuilder.append(a2.xN.getName()).append(System.lineSeparator()));
                throw UserError.abort((String)stringBuilder.toString(), (Object[])new Object[0]);
            }
        }

        private String ie() {
            byte[] byArray = (byte[])this.if().get((Object)Paths.get("java.vm.version", new String[0]));
            return byArray != null ? new String(byArray, StandardCharsets.UTF_8) : "<unknown>";
        }

        private void a(int n2, String string, String string2) {
            LinkedHashMap<String, Object> linkedHashMap = new LinkedHashMap<String, Object>();
            linkedHashMap.put("fileVersion", string);
            linkedHashMap.put("vmVersion", com.oracle.svm.enterprise.hosted.substitute.b$a.ij());
            linkedHashMap.put("numSubstitutions", n2);
            linkedHashMap.put("diff", StreamSupport.stream(this.xL.getValues().spliterator(), false).map(this::a).toList());
            linkedHashMap.put("classes", this.xM.stream().map(d::m).map(Path::toString).toList());
            try (JsonWriter jsonWriter = new JsonWriter(Paths.get(string2, new String[0]), new OpenOption[0]);){
                jsonWriter.print(linkedHashMap);
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        }

        private Map<String, Object> a(a a2) {
            Class<?> clazz = a2.xN;
            return Map.of("originalClass", this.j(clazz), "annotatedClasses", a2.xO.stream().map(this::j).iterator(), "actualCheckSum", com.oracle.svm.enterprise.hosted.substitute.b$a.b(a2.xP));
        }

        private Map<String, Object> j(Class<?> clazz) {
            ResolvedJavaType resolvedJavaType = this.xJ.lookupJavaType(clazz);
            return Map.of("class", clazz.getName(), "module", clazz.getModule().getName(), "sourceFileName", resolvedJavaType.getSourceFileName(), "sourceLineNumber", com.oracle.svm.enterprise.hosted.substitute.b$a.i(resolvedJavaType));
        }

        private static int i(ResolvedJavaType resolvedJavaType) {
            return Stream.concat(Arrays.stream(resolvedJavaType.getDeclaredMethods()), Arrays.stream(resolvedJavaType.getDeclaredConstructors())).mapToInt(resolvedJavaMethod -> resolvedJavaMethod.asStackTraceElement(0).getLineNumber()).filter(n2 -> n2 > 0).min().orElse(-1);
        }

        private byte[] k(Class<?> clazz) {
            return (byte[])this.if().get((Object)com.oracle.svm.enterprise.hosted.substitute.b$a.l(clazz));
        }

        private EconomicMap<Path, byte[]> if() {
            if (this.xK.isEmpty()) {
                try {
                    Path path = Paths.get((String)c.VerifySubstitutionChecksum.getValue(), new String[0]);
                    File[] fileArray = path.toFile().listFiles();
                    assert (fileArray != null) : "Not a directory: " + String.valueOf(path);
                    for (File file : fileArray) {
                        Object[] objectArray;
                        if (file.isDirectory()) {
                            objectArray = file.listFiles();
                            assert (objectArray != null) : "Not a directory: " + String.valueOf(file);
                            for (File file2 : objectArray) {
                                String string = Files.readString(file2.toPath());
                                try {
                                    byte[] byArray = com.oracle.svm.enterprise.hosted.substitute.b$a.R(string);
                                    this.xK.put((Object)path.relativize(file2.toPath()), (Object)byArray);
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    UserError.abort((Throwable)illegalArgumentException, (String)"File content is not a checksum: %s", (Object[])new Object[]{file2});
                                }
                            }
                            continue;
                        }
                        assert (file.isFile());
                        objectArray = Files.readAllBytes(file.toPath());
                        this.xK.put((Object)path.relativize(file.toPath()), (Object)objectArray);
                    }
                }
                catch (IOException iOException) {
                    throw UserError.abort((Throwable)iOException, (String)"Cannot open file", (Object[])new Object[0]);
                }
            }
            return this.xK;
        }

        private static final class a
        extends Record {
            private final Class<?> xN;
            private final ArrayList<Class<?>> xO;
            private final byte[] xP;

            private a(Class<?> clazz, ArrayList<Class<?>> arrayList, byte[] byArray) {
                this.xN = clazz;
                this.xO = arrayList;
                this.xP = byArray;
            }

            @Override
            public final String toString() {
                return ObjectMethods.bootstrap("toString", new MethodHandle[]{a.class, "originalClass;annotatedClasses;actualCheckSum", "xN", "xO", "xP"}, this);
            }

            @Override
            public final int hashCode() {
                return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{a.class, "originalClass;annotatedClasses;actualCheckSum", "xN", "xO", "xP"}, this);
            }

            @Override
            public final boolean equals(Object object) {
                return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{a.class, "originalClass;annotatedClasses;actualCheckSum", "xN", "xO", "xP"}, this, object);
            }

            public Class<?> ig() {
                return this.xN;
            }

            public ArrayList<Class<?>> ih() {
                return this.xO;
            }

            public byte[] ii() {
                return this.xP;
            }
        }
    }
}

