/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.enterprise.hosted.profilingframework.phases;

import com.oracle.svm.enterprise.hosted.profilingframework.instrument.b;
import com.oracle.svm.enterprise.hosted.profilingframework.nodes.c;
import com.oracle.svm.enterprise.hosted.profilingframework.nodes.d;
import com.oracle.svm.enterprise.hosted.profilingframework.nodes.f;
import com.oracle.svm.enterprise.hosted.profilingframework.nodes.h;
import com.oracle.svm.enterprise.hosted.profilingframework.nodes.i;
import com.oracle.svm.enterprise.hosted.profilingframework.nodes.l;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import jdk.graal.compiler.debug.DebugCloseable;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.graph.NodeSourcePosition;
import jdk.graal.compiler.nodes.AbstractBeginNode;
import jdk.graal.compiler.nodes.ControlSplitNode;
import jdk.graal.compiler.nodes.FixedNode;
import jdk.graal.compiler.nodes.FixedWithNextNode;
import jdk.graal.compiler.nodes.FrameState;
import jdk.graal.compiler.nodes.IfNode;
import jdk.graal.compiler.nodes.Invoke;
import jdk.graal.compiler.nodes.StartNode;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.nodes.cfg.HIRBlock;
import jdk.graal.compiler.nodes.extended.BytecodeExceptionNode;
import jdk.graal.compiler.nodes.extended.SwitchNode;
import jdk.graal.compiler.nodes.java.InstanceOfNode;
import jdk.graal.compiler.nodes.java.MethodCallTargetNode;
import jdk.graal.compiler.nodes.java.MonitorEnterNode;
import jdk.graal.compiler.nodes.spi.CoreProviders;
import jdk.graal.compiler.nodes.util.GraphUtil;
import jdk.graal.compiler.phases.BasePhase;
import jdk.graal.compiler.phases.graph.ScheduledNodeIterator;
import jdk.graal.compiler.phases.schedule.SchedulePhase;
import jdk.vm.ci.meta.JavaTypeProfile;
import jdk.vm.ci.meta.ResolvedJavaType;

public abstract class CommonInstrumentationPhase
extends BasePhase<CoreProviders> {
    private static final int[] xC = new int[]{0, 1};
    public static final int xD = 0;
    private static final int xE = -5;

    private static boolean f(ControlSplitNode controlSplitNode) {
        if (controlSplitNode instanceof IfNode) {
            for (Node node : controlSplitNode.successors()) {
                if (!(((AbstractBeginNode)node).next() instanceof BytecodeExceptionNode)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean q(Node node) {
        for (NodeSourcePosition nodeSourcePosition = node.getNodeSourcePosition(); nodeSourcePosition != null; nodeSourcePosition = nodeSourcePosition.getCaller()) {
            if (nodeSourcePosition.getBCI() != -5 && nodeSourcePosition.getBCI() != -6) continue;
            return true;
        }
        return false;
    }

    private static int[] b(IfNode ifNode) {
        int[] nArray = new int[ifNode.successors().count()];
        NodeSourcePosition nodeSourcePosition = ifNode.trueSuccessor().getNodeSourcePosition();
        NodeSourcePosition nodeSourcePosition2 = ifNode.falseSuccessor().getNodeSourcePosition();
        nArray[0] = nodeSourcePosition != null ? nodeSourcePosition.getBCI() : -5;
        nArray[1] = nodeSourcePosition2 != null ? nodeSourcePosition2.getBCI() : -5;
        return nArray;
    }

    protected static void l(StructuredGraph structuredGraph) {
        for (MonitorEnterNode monitorEnterNode : structuredGraph.getNodes(MonitorEnterNode.TYPE)) {
            if (monitorEnterNode.getNodeSourcePosition() == null) {
                assert (false) : "Method call target with no node source position";
                continue;
            }
            CommonInstrumentationPhase.a(structuredGraph, monitorEnterNode);
        }
    }

    private static void a(StructuredGraph structuredGraph, MonitorEnterNode monitorEnterNode) {
        NodeSourcePosition nodeSourcePosition = monitorEnterNode.getNodeSourcePosition();
        try (DebugCloseable debugCloseable = structuredGraph.withNodeSourcePosition(nodeSourcePosition);){
            i i2 = (i)structuredGraph.add((Node)new i(monitorEnterNode.object()));
            structuredGraph.addAfterFixed((FixedWithNextNode)monitorEnterNode, (FixedNode)i2);
        }
    }

    protected static void m(StructuredGraph structuredGraph) {
        for (MethodCallTargetNode methodCallTargetNode : structuredGraph.getNodes(MethodCallTargetNode.TYPE).filter(node -> ((MethodCallTargetNode)node).invokeKind().isIndirect())) {
            if (methodCallTargetNode.getNodeSourcePosition() == null) {
                assert (false) : "Unexpected method call target with no node source position";
                continue;
            }
            if (methodCallTargetNode.invoke() == null) {
                assert (false) : "Unexpected missing invoke node";
                continue;
            }
            CommonInstrumentationPhase.a(structuredGraph, methodCallTargetNode);
        }
    }

    private static void a(StructuredGraph structuredGraph, MethodCallTargetNode methodCallTargetNode) {
        Invoke invoke = methodCallTargetNode.invoke();
        FrameState frameState = GraphUtil.findLastFrameState((FixedNode)((FixedNode)invoke.predecessor()));
        if (frameState == null) {
            return;
        }
        try (DebugCloseable debugCloseable = structuredGraph.withNodeSourcePosition(invoke.asNode().getNodeSourcePosition());){
            l l2 = new l(invoke.getReceiver(), CommonInstrumentationPhase.b(methodCallTargetNode.getTypeProfile()));
            structuredGraph.addBeforeFixed(invoke.asFixedNode(), (FixedWithNextNode)structuredGraph.add((Node)l2));
            l2.setStateAfter(frameState.duplicateWithVirtualState());
        }
    }

    protected static void n(StructuredGraph structuredGraph) {
        SchedulePhase.runWithoutContextOptimizations((StructuredGraph)structuredGraph);
        StructuredGraph.ScheduleResult scheduleResult = structuredGraph.getLastSchedule();
        a a2 = new a(scheduleResult, structuredGraph);
        for (HIRBlock hIRBlock : scheduleResult.getCFG().getBlocks()) {
            a2.processNodes(hIRBlock);
        }
    }

    private static ResolvedJavaType[] b(JavaTypeProfile javaTypeProfile) {
        if (javaTypeProfile == null) {
            return null;
        }
        JavaTypeProfile.ProfiledType[] profiledTypeArray = javaTypeProfile.getTypes();
        ResolvedJavaType[] resolvedJavaTypeArray = new ResolvedJavaType[profiledTypeArray.length];
        for (int i2 = 0; i2 < profiledTypeArray.length; ++i2) {
            resolvedJavaTypeArray[i2] = profiledTypeArray[i2].getType();
        }
        return resolvedJavaTypeArray;
    }

    protected static void o(StructuredGraph structuredGraph) {
        NodeSourcePosition nodeSourcePosition = new NodeSourcePosition(null, structuredGraph.method(), 0);
        StartNode startNode = structuredGraph.start();
        try (DebugCloseable debugCloseable = structuredGraph.withNodeSourcePosition(nodeSourcePosition);){
            startNode = CommonInstrumentationPhase.a(structuredGraph, (FixedWithNextNode)startNode);
            d d2 = (d)structuredGraph.add((Node)new h());
            structuredGraph.addAfterFixed((FixedWithNextNode)startNode, (FixedNode)d2);
        }
    }

    private static FixedWithNextNode a(StructuredGraph structuredGraph, FixedWithNextNode fixedWithNextNode) {
        if (b.singleton().e(structuredGraph.method())) {
            com.oracle.svm.enterprise.hosted.profilingframework.nodes.a a2 = (com.oracle.svm.enterprise.hosted.profilingframework.nodes.a)structuredGraph.add((Node)new com.oracle.svm.enterprise.hosted.profilingframework.nodes.a());
            structuredGraph.addAfterFixed(fixedWithNextNode, (FixedNode)a2);
            a2.setStateAfter(((StartNode)fixedWithNextNode).stateAfter());
            return a2;
        }
        return fixedWithNextNode;
    }

    protected static void p(StructuredGraph structuredGraph) {
        for (Node node : structuredGraph.getNodes()) {
            ControlSplitNode controlSplitNode;
            if (!(node instanceof ControlSplitNode) || CommonInstrumentationPhase.f(controlSplitNode = (ControlSplitNode)node) || CommonInstrumentationPhase.q(node)) continue;
            if (node instanceof SwitchNode) {
                SwitchNode switchNode = (SwitchNode)node;
                CommonInstrumentationPhase.a(structuredGraph, (ControlSplitNode)switchNode, switchNode.getKeySuccessors(), CommonInstrumentationPhase.c(switchNode));
                continue;
            }
            if (!(node instanceof IfNode)) continue;
            IfNode ifNode = (IfNode)node;
            CommonInstrumentationPhase.a(structuredGraph, (ControlSplitNode)ifNode, xC, CommonInstrumentationPhase.b(ifNode));
        }
    }

    private static int[] c(SwitchNode switchNode) {
        List list = switchNode.successors().snapshot();
        int[] nArray = switchNode.getKeySuccessors();
        int[] nArray2 = new int[nArray.length];
        HashSet<Integer> hashSet = new HashSet<Integer>();
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            if (!hashSet.contains(nArray[i2])) {
                NodeSourcePosition nodeSourcePosition = ((Node)list.get(nArray[i2])).getNodeSourcePosition();
                nArray2[i2] = nodeSourcePosition != null ? nodeSourcePosition.getBCI() : -5;
                hashSet.add(nArray[i2]);
                continue;
            }
            nArray2[i2] = -5;
        }
        return nArray2;
    }

    private static void a(StructuredGraph structuredGraph, ControlSplitNode controlSplitNode, int[] nArray, int[] nArray2) {
        if (controlSplitNode.getNodeSourcePosition() == null) {
            assert (false) : "Unexpected control split node with no node source position";
            return;
        }
        for (Node node : controlSplitNode.successors()) {
            if (node.getNodeSourcePosition() == null) continue;
            DebugCloseable debugCloseable = structuredGraph.withNodeSourcePosition(controlSplitNode.getNodeSourcePosition());
            try {
                c c2 = c.a(structuredGraph, nArray, nArray2, node.getNodeSourcePosition().getBCI(), controlSplitNode instanceof IfNode);
                if (c2 == null) continue;
                structuredGraph.addAfterFixed((FixedWithNextNode)node, (FixedNode)c2);
            }
            finally {
                if (debugCloseable == null) continue;
                debugCloseable.close();
            }
        }
    }

    private static final class a
    extends ScheduledNodeIterator {
        private final StructuredGraph xF;
        FixedNode xG;

        private a(StructuredGraph.ScheduleResult scheduleResult, StructuredGraph structuredGraph) {
            super(scheduleResult);
            this.xF = structuredGraph;
        }

        protected void processNode(Node node, HIRBlock hIRBlock, ListIterator<Node> listIterator) {
            FixedNode fixedNode;
            if (node instanceof FixedNode) {
                this.xG = fixedNode = (FixedNode)node;
            }
            if (node instanceof InstanceOfNode) {
                fixedNode = (InstanceOfNode)node;
                this.a(hIRBlock, (InstanceOfNode)fixedNode);
            }
            if (node.equals(hIRBlock.getEndNode())) {
                this.xG = null;
            }
        }

        private void a(HIRBlock hIRBlock, InstanceOfNode instanceOfNode) {
            try (DebugCloseable debugCloseable = this.xF.withNodeSourcePosition(instanceOfNode.getNodeSourcePosition());){
                f f2 = (f)this.xF.add((Node)new f(instanceOfNode.getValue(), CommonInstrumentationPhase.b(instanceOfNode.profile())));
                FrameState frameState = GraphUtil.findLastFrameState((FixedNode)(this.xG == null ? hIRBlock.getBeginNode() : this.xG));
                assert (frameState != null) : "Last frame-state before the current block should not be null: " + String.valueOf(hIRBlock.getBeginNode());
                f2.setStateAfter(frameState.duplicateWithVirtualState());
                if (this.xG == null) {
                    this.xF.addAfterFixed((FixedWithNextNode)hIRBlock.getBeginNode(), (FixedNode)f2);
                } else {
                    this.insert((FixedNode)f2, (FixedWithNextNode)f2);
                }
            }
        }
    }
}

