/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.enterprise.hosted.pgo.profiles;

import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.svm.enterprise.hosted.pgo.profiles.PGOProfilesLookup;
import com.oracle.svm.enterprise.profiling.framework.CommonInstrumentationData;
import com.oracle.svm.enterprise.profiling.framework.PGOData;
import com.oracle.svm.enterprise.profiling.framework.collection.CallingContext;
import com.oracle.svm.enterprise.profiling.framework.collection.CallingContextForest;
import com.oracle.svm.enterprise.profiling.framework.collection.CodePosition;
import com.oracle.svm.enterprise.profiling.metadata.codepositions.ProfilingHostedCodePosition;
import com.oracle.svm.hosted.meta.HostedMethod;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import jdk.vm.ci.meta.JavaType;
import jdk.vm.ci.meta.UnresolvedJavaType;

public class a
implements PGOProfilesLookup {
    private PGOData tY;
    private c tZ;

    public a(PGOData pGOData, c c2) {
        this.tY = pGOData;
        this.tZ = c2;
    }

    @Override
    public Optional<PGOProfilesLookup.ProfiledValue<Long>> getCallCountProfile(HostedMethod hostedMethod) {
        if (this.tY == null) {
            return Optional.empty();
        }
        CallingContextForest.BestFit bestFit = this.tY.metadata().forest().findBestFit(a.u(hostedMethod));
        if (bestFit == null) {
            return Optional.empty();
        }
        e e2 = new e();
        bestFit.cursor().forEachPayloadWithCallers(e2);
        if (e2.rt == 0L) {
            return Optional.empty();
        }
        return Optional.of(new PGOProfilesLookup.ProfiledValue<Long>(this.tY.source(), e2.rt));
    }

    private static CallingContext u(HostedMethod hostedMethod) {
        return CallingContext.withCallee(new CodePosition(hostedMethod.wrapped.getId(), 0), CallingContext.empty());
    }

    @Override
    public Optional<Map<AnalysisType, Long>> getVirtualInvokeProfile(List<ProfilingHostedCodePosition> list) {
        if (this.tY == null) {
            return Optional.empty();
        }
        CallingContext callingContext = a.l(list);
        CallingContextForest.BestFit bestFit = this.tY.metadata().forest().findBestFit(callingContext);
        if (bestFit == null) {
            return Optional.empty();
        }
        g g2 = new g();
        a.a(bestFit, g2);
        return g2.uj.isEmpty() ? Optional.empty() : Optional.of(g2.uj);
    }

    @Override
    public Optional<Map<JavaType, Long>> getInstanceofProfile(List<ProfilingHostedCodePosition> list) {
        if (this.tY == null) {
            return Optional.empty();
        }
        CallingContext callingContext = a.l(list);
        CallingContextForest.BestFit bestFit = this.tY.metadata().forest().findBestFit(callingContext);
        if (bestFit == null) {
            return Optional.empty();
        }
        d d2 = new d();
        a.a(bestFit, d2);
        return d2.ug.isEmpty() ? Optional.empty() : Optional.of(d2.ug);
    }

    private static CallingContext l(List<ProfilingHostedCodePosition> list) {
        ArrayList<CodePosition> arrayList = new ArrayList<CodePosition>();
        for (ProfilingHostedCodePosition profilingHostedCodePosition : list) {
            arrayList.add(new CodePosition(profilingHostedCodePosition.getMethod().getId(), profilingHostedCodePosition.getBCI()));
        }
        return CallingContext.create(arrayList);
    }

    private static void a(CallingContextForest.BestFit bestFit, f f2) {
        bestFit.cursor().forEachPayload(f2);
        if (!f2.isEmpty()) {
            return;
        }
        if (bestFit.fullyMatchedCallingContext()) {
            bestFit.cursor().forEachPayloadWithCallers(f2);
            return;
        }
        for (CallingContextForest.Cursor cursor : bestFit.calleeContext().reversed()) {
            cursor.forEachPayload(f2);
            if (f2.isEmpty()) continue;
            return;
        }
    }

    @Override
    public Optional<PGOProfilesLookup.ProfiledValue<long[]>> getConditionalProfile(List<ProfilingHostedCodePosition> list) {
        if (this.tY == null) {
            return Optional.empty();
        }
        CallingContextForest.BestFit bestFit = this.tY.metadata().forest().findBestFit(a.l(list));
        if (bestFit == null) {
            return Optional.empty();
        }
        b b2 = new b();
        a.a(bestFit, b2);
        return b2.uc == null ? Optional.empty() : Optional.of(new PGOProfilesLookup.ProfiledValue<long[]>(this.tY.source(), b2.uc));
    }

    @Override
    public Optional<Map<AnalysisType, Long>> getMonitorProfiles() {
        if (this.tY == null) {
            return Optional.empty();
        }
        HashMap hashMap = new HashMap();
        this.tY.metadata().forEachMonitorTypeID(n2 -> {
            AnalysisType analysisType = this.tZ.ue.get(n2);
            long l2 = this.tY.commonInstrumentationData().readTotalMonitorCount(n2);
            hashMap.put(analysisType, l2);
        });
        return hashMap.isEmpty() ? Optional.empty() : Optional.of(hashMap);
    }

    @Override
    public Optional<Map<List<ProfilingHostedCodePosition>, Long>> getSampleCounts() {
        if (this.tY == null) {
            return Optional.empty();
        }
        return Optional.of(this.gm());
    }

    private Map<List<ProfilingHostedCodePosition>, Long> gm() {
        HashMap<List<ProfilingHostedCodePosition>, Long> hashMap = new HashMap<List<ProfilingHostedCodePosition>, Long>();
        this.tY.samplingData().samples().topDown((callingContext, l2) -> {
            if (l2 > 0L) {
                List<ProfilingHostedCodePosition> list = this.a((CallingContext)callingContext);
                hashMap.put(list, (Long)l2);
            }
        });
        return hashMap;
    }

    private List<ProfilingHostedCodePosition> a(CallingContext callingContext) {
        ArrayList<ProfilingHostedCodePosition> arrayList = new ArrayList<ProfilingHostedCodePosition>();
        callingContext.traverseFromCallee(codePosition -> arrayList.add(new ProfilingHostedCodePosition(this.tZ.uf.get(codePosition.methodID()), codePosition.bci())));
        return arrayList;
    }

    @Override
    public void clear() {
        this.tY = null;
        this.tZ = null;
    }

    @Override
    public Optional<long[]> getSample(com.oracle.svm.enterprise.profiling.metadata.cctree.c c2) {
        return Optional.empty();
    }

    @Override
    public Optional<Map<List<ProfilingHostedCodePosition>, com.oracle.svm.enterprise.profiling.metadata.cctree.c>> getSamples() {
        return Optional.empty();
    }

    private static long b(long l2, long l3) {
        assert (l2 >= 0L && l3 >= 0L) : "Negative counter value";
        long l4 = Math.max(0L, l2) + Math.max(0L, l3);
        return l4 >= 0L ? l4 : Long.MAX_VALUE;
    }

    public static final class c
    extends Record {
        private final Map<Integer, AnalysisType> ue;
        private final Map<Integer, AnalysisMethod> uf;
        private final Map<Integer, UnresolvedJavaType> unresolvedJavaTypeMap;

        public c() {
            this(new HashMap<Integer, AnalysisType>(), new HashMap<Integer, AnalysisMethod>(), new HashMap<Integer, UnresolvedJavaType>());
        }

        public c(Map<Integer, AnalysisType> map, Map<Integer, AnalysisMethod> map2, Map<Integer, UnresolvedJavaType> map3) {
            this.ue = map;
            this.uf = map2;
            this.unresolvedJavaTypeMap = map3;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{c.class, "globalIDToAnalysisType;globalIDToAnalysisMethod;unresolvedJavaTypeMap", "ue", "uf", "unresolvedJavaTypeMap"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{c.class, "globalIDToAnalysisType;globalIDToAnalysisMethod;unresolvedJavaTypeMap", "ue", "uf", "unresolvedJavaTypeMap"}, this);
        }

        @Override
        public final boolean equals(Object object) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{c.class, "globalIDToAnalysisType;globalIDToAnalysisMethod;unresolvedJavaTypeMap", "ue", "uf", "unresolvedJavaTypeMap"}, this, object);
        }

        public Map<Integer, AnalysisType> go() {
            return this.ue;
        }

        public Map<Integer, AnalysisMethod> gp() {
            return this.uf;
        }

        public Map<Integer, UnresolvedJavaType> gq() {
            return this.unresolvedJavaTypeMap;
        }
    }

    private final class e
    implements CallingContextForest.PayloadConsumer {
        long rt;

        private e() {
        }

        @Override
        public void accept(CallingContextForest.Payload payload) {
            if (payload instanceof CommonInstrumentationData.MethodEntryPayload) {
                CommonInstrumentationData.MethodEntryPayload methodEntryPayload = (CommonInstrumentationData.MethodEntryPayload)payload;
                this.rt += methodEntryPayload.readTotalCounterValue(a.this.tY.commonInstrumentationData().storage());
            }
        }
    }

    private final class g
    extends f {
        Map<AnalysisType, Long> uj;

        private g() {
            super(a.this);
            this.uj = new HashMap<AnalysisType, Long>();
        }

        @Override
        public void accept(CallingContextForest.Payload payload) {
            if (payload instanceof CommonInstrumentationData.VirtualCallPayload) {
                CommonInstrumentationData.VirtualCallPayload virtualCallPayload = (CommonInstrumentationData.VirtualCallPayload)payload;
                for (int i2 = 0; i2 < virtualCallPayload.length(); ++i2) {
                    int n2 = virtualCallPayload.typeID(a.this.tY.commonInstrumentationData().storage(), i2);
                    long l2 = virtualCallPayload.readTotalCounterValue(a.this.tY.commonInstrumentationData().storage(), i2);
                    AnalysisType analysisType = a.this.tZ.ue.get(n2);
                    if (analysisType == null || l2 <= 0L) {
                        assert (l2 == 0L) : "Negative value in virtual call counter: " + l2;
                        continue;
                    }
                    this.uj.merge(analysisType, l2, a::b);
                }
            }
        }

        @Override
        boolean isEmpty() {
            return this.uj.isEmpty();
        }
    }

    private abstract class f
    implements CallingContextForest.PayloadConsumer {
        private f(a a2) {
        }

        abstract boolean isEmpty();
    }

    private final class d
    extends f {
        Map<JavaType, Long> ug;

        private d() {
            super(a.this);
            this.ug = new HashMap<JavaType, Long>();
        }

        @Override
        public void accept(CallingContextForest.Payload payload) {
            if (payload instanceof CommonInstrumentationData.InstanceOfPayload) {
                CommonInstrumentationData.InstanceOfPayload instanceOfPayload = (CommonInstrumentationData.InstanceOfPayload)payload;
                for (int i2 = 0; i2 < instanceOfPayload.length(); ++i2) {
                    int n2 = instanceOfPayload.typeID(a.this.tY.commonInstrumentationData().storage(), i2);
                    long l2 = instanceOfPayload.readTotalCounterValue(a.this.tY.commonInstrumentationData().storage(), i2);
                    assert (l2 >= 0L) : "Negative value in virtual call counter: " + l2;
                    AnalysisType analysisType = a.this.tZ.ue.get(n2);
                    if (analysisType == null) {
                        UnresolvedJavaType unresolvedJavaType = a.this.tZ.unresolvedJavaTypeMap.get(n2);
                        if (unresolvedJavaType == null) continue;
                        this.ug.merge((JavaType)unresolvedJavaType, l2, a::b);
                        continue;
                    }
                    this.ug.merge((JavaType)analysisType, l2, a::b);
                }
            }
        }

        @Override
        boolean isEmpty() {
            return this.ug.isEmpty();
        }
    }

    private final class b
    extends f {
        long[] uc;

        private b() {
            super(a.this);
        }

        @Override
        public void accept(CallingContextForest.Payload payload) {
            if (payload instanceof CommonInstrumentationData.ConditionalPayload) {
                int n2;
                CommonInstrumentationData.ConditionalPayload conditionalPayload = (CommonInstrumentationData.ConditionalPayload)payload;
                if (this.uc == null) {
                    this.uc = new long[conditionalPayload.length() * 3];
                    for (n2 = 0; n2 < conditionalPayload.length(); ++n2) {
                        this.uc[3 * n2] = conditionalPayload.bciAt(n2);
                        this.uc[3 * n2 + 1] = conditionalPayload.successorAt(n2);
                    }
                }
                if (3 * conditionalPayload.length() != this.uc.length) {
                    return;
                }
                for (n2 = 0; n2 < conditionalPayload.length(); ++n2) {
                    long l2 = conditionalPayload.readTotalCounterValue(a.this.tY.commonInstrumentationData().storage(), n2);
                    if (l2 <= 0L) {
                        assert (l2 == 0L) : "Negative value in conditional counter: " + l2;
                        continue;
                    }
                    this.uc[3 * n2 + 2] = a.b(this.uc[3 * n2 + 2], l2);
                }
            }
        }

        @Override
        boolean isEmpty() {
            return this.uc == null;
        }
    }

    public static final class a
    implements PGOProfilesLookup {
        private final PGOProfilesLookup ua;
        private final PGOProfilesLookup ub;

        private static void a(String string, Object object, Object object2, Object object3) {
            if (!Objects.equals(object2, object3)) {
                System.out.printf("[PGO] %s profile diff! legacy: %s, replacement: %s, context: %s.%n", string, object2, object3, object);
            }
        }

        public a(PGOProfilesLookup pGOProfilesLookup, a a2) {
            this.ua = pGOProfilesLookup;
            this.ub = a2;
        }

        @Override
        public Optional<PGOProfilesLookup.ProfiledValue<Long>> getCallCountProfile(HostedMethod hostedMethod) {
            Optional<PGOProfilesLookup.ProfiledValue<Long>> optional = this.ub.getCallCountProfile(hostedMethod);
            a.a("call-count", hostedMethod.format("%H.%n"), this.ua.getCallCountProfile(hostedMethod), optional);
            return optional;
        }

        @Override
        public Optional<Map<AnalysisType, Long>> getVirtualInvokeProfile(List<ProfilingHostedCodePosition> list) {
            Optional<Map<AnalysisType, Long>> optional = this.ub.getVirtualInvokeProfile(list);
            a.a("virtual-call", list, this.ua.getVirtualInvokeProfile(list), optional);
            return optional;
        }

        @Override
        public Optional<PGOProfilesLookup.ProfiledValue<long[]>> getConditionalProfile(List<ProfilingHostedCodePosition> list) {
            Optional<PGOProfilesLookup.ProfiledValue<long[]>> optional = this.ub.getConditionalProfile(list);
            a.a("conditional", list, a.a(this.ua.getConditionalProfile(list)), a.a(optional));
            return optional;
        }

        private static Object a(Optional<PGOProfilesLookup.ProfiledValue<long[]>> optional) {
            if (optional.isPresent()) {
                PGOProfilesLookup.ProfiledValue<long[]> profiledValue = optional.get();
                return "[" + String.valueOf(profiledValue.source()) + " " + Arrays.toString(profiledValue.value()) + "]";
            }
            return optional.toString();
        }

        @Override
        public Optional<Map<AnalysisType, Long>> getMonitorProfiles() {
            Optional<Map<AnalysisType, Long>> optional = this.ub.getMonitorProfiles();
            a.a("monitor", "", this.ua.getMonitorProfiles(), optional);
            return optional;
        }

        @Override
        public Optional<long[]> getSample(com.oracle.svm.enterprise.profiling.metadata.cctree.c c2) {
            return Optional.empty();
        }

        @Override
        public Optional<Map<List<ProfilingHostedCodePosition>, com.oracle.svm.enterprise.profiling.metadata.cctree.c>> getSamples() {
            return Optional.empty();
        }

        @Override
        public Optional<Map<List<ProfilingHostedCodePosition>, Long>> getSampleCounts() {
            return this.ub.getSampleCounts();
        }
    }
}

