/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.enterprise.hosted.pgo.profiles;

import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.svm.enterprise.profiling.metadata.cctree.c;
import com.oracle.svm.enterprise.profiling.metadata.codepositions.ProfilingHostedCodePosition;
import com.oracle.svm.hosted.meta.HostedMethod;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import jdk.graal.compiler.nodes.ProfileData;
import jdk.vm.ci.meta.JavaType;

public interface PGOProfilesLookup {
    public Optional<ProfiledValue<Long>> getCallCountProfile(HostedMethod var1);

    default public boolean isProfiled(HostedMethod hostedMethod) {
        return this.getCallCountProfile(hostedMethod).map(profiledValue -> profiledValue.source().isProfiled() && (Long)profiledValue.value() > 0L).orElse(false);
    }

    public Optional<Map<AnalysisType, Long>> getVirtualInvokeProfile(List<ProfilingHostedCodePosition> var1);

    public Optional<ProfiledValue<long[]>> getConditionalProfile(List<ProfilingHostedCodePosition> var1);

    public Optional<Map<AnalysisType, Long>> getMonitorProfiles();

    @Deprecated(forRemoval=true)
    public Optional<long[]> getSample(c var1);

    @Deprecated(forRemoval=true)
    public Optional<Map<List<ProfilingHostedCodePosition>, c>> getSamples();

    default public Optional<Map<List<ProfilingHostedCodePosition>, Long>> getSampleCounts() {
        return Optional.empty();
    }

    default public void clear() {
    }

    default public Optional<Map<JavaType, Long>> getInstanceofProfile(List<ProfilingHostedCodePosition> list) {
        return Optional.empty();
    }

    public record ProfiledValue<T>(ProfileData.ProfileSource source, T value) {
    }
}

