/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.enterprise.hosted.ml.phases;

import com.oracle.graal.compiler.enterprise.ml.features.c;
import com.oracle.graal.compiler.enterprise.ml.features.provider.b;
import com.oracle.graal.compiler.enterprise.ml.phases.ExtractGraphMLFeaturesBasePhase;
import com.oracle.svm.enterprise.hosted.ml.features.provider.a;
import com.oracle.svm.enterprise.hosted.ml.phases.InferControlSplitProfilesPhase;
import java.util.Optional;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.graph.iterators.FilteredNodeIterable;
import jdk.graal.compiler.nodes.AbstractBeginNode;
import jdk.graal.compiler.nodes.ControlSinkNode;
import jdk.graal.compiler.nodes.IfNode;
import jdk.graal.compiler.nodes.LoopExitNode;
import jdk.graal.compiler.nodes.ProfileData;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.nodes.spi.CoreProviders;
import jdk.graal.compiler.phases.BasePhase;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.collections.EconomicMap;

public abstract class GuardControlSplitProfileInferencePhase
extends BasePhase<CoreProviders> {
    protected final com.oracle.graal.compiler.enterprise.ml.features.provider.c<Node, c> tw;
    protected final double tx;
    protected final double ty;
    protected final double tz;

    public GuardControlSplitProfileInferencePhase(com.oracle.graal.compiler.enterprise.ml.features.provider.c<Node, c> c2, double d2, double d3, double d4) {
        this.tw = c2;
        this.tx = d2;
        this.ty = d3;
        this.tz = d4;
    }

    protected void run(StructuredGraph structuredGraph, CoreProviders coreProviders) {
        FilteredNodeIterable<Node> filteredNodeIterable = InferControlSplitProfilesPhase.c(structuredGraph);
        b b2 = this.tw.g(ExtractGraphMLFeaturesBasePhase.b((StructuredGraph)structuredGraph));
        for (Node node : filteredNodeIterable) {
            IfNode ifNode;
            Optional optional;
            if (!(node instanceof IfNode) || !(optional = b2.a((Object)(ifNode = (IfNode)node))).isPresent()) continue;
            assert (!ifNode.getProfileData().getProfileSource().isUnknown()) : "To guard the inferred profiles generated by machine learning, it is necessary first to infer them.";
            this.b(structuredGraph.method(), ifNode);
            this.a(structuredGraph.method(), ifNode, (c)optional.get(), (b<Node, c>)b2);
        }
    }

    protected void b(ResolvedJavaMethod resolvedJavaMethod, IfNode ifNode) {
        AbstractBeginNode abstractBeginNode = ifNode.getSuccessor(true);
        AbstractBeginNode abstractBeginNode2 = ifNode.getSuccessor(false);
        ProfileData.ProfileSource profileSource = ifNode.getProfileData().getProfileSource();
        if (abstractBeginNode2 instanceof LoopExitNode && profileSource.isInferred() && ifNode.getTrueSuccessorProbability() < this.tx) {
            GuardControlSplitProfileInferencePhase.a(resolvedJavaMethod, ifNode, abstractBeginNode, this.tx);
        }
        if (abstractBeginNode instanceof LoopExitNode && profileSource.isInferred() && ifNode.getTrueSuccessorProbability() > 1.0 - this.tx) {
            GuardControlSplitProfileInferencePhase.a(resolvedJavaMethod, ifNode, abstractBeginNode, 1.0 - this.tx);
        }
    }

    protected abstract void a(ResolvedJavaMethod var1, IfNode var2, c var3, b<Node, c> var4);

    protected static void a(ResolvedJavaMethod resolvedJavaMethod, IfNode ifNode, AbstractBeginNode abstractBeginNode, double d2) {
        if (a.fG()) {
            com.oracle.svm.enterprise.hosted.ml.logging.a.a(resolvedJavaMethod, ifNode, d2);
        }
        ifNode.setProbability(abstractBeginNode, ProfileData.BranchProbabilityData.create((double)d2, (ProfileData.ProfileSource)ProfileData.ProfileSource.INFERRED));
    }

    protected static boolean m(EconomicMap<Class<? extends Node>, Integer> economicMap) {
        for (Class clazz : economicMap.getKeys()) {
            if (!ControlSinkNode.class.isAssignableFrom(clazz)) continue;
            return true;
        }
        return false;
    }

    protected static boolean a(com.oracle.svm.enterprise.hosted.ml.features.c c2) {
        return GuardControlSplitProfileInferencePhase.m(c2.fz());
    }
}

