/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.enterprise.hosted;

import com.oracle.svm.core.BuildArtifacts;
import com.oracle.svm.core.SubstrateControlFlowIntegrity;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.feature.AutomaticallyRegisteredFeature;
import com.oracle.svm.enterprise.hosted.pgo.features.PGOFeature;
import com.oracle.svm.enterprise.hosted.profiling.features.ProfilingFeature;
import com.oracle.svm.hosted.ByteFormattingUtil;
import com.oracle.svm.hosted.Log4ShellFeature;
import com.oracle.svm.hosted.ProgressReporter;
import com.oracle.svm.hosted.ProgressReporterFeature;
import com.oracle.svm.hosted.ProgressReporterJsonHelper;
import java.io.ObjectInputStream;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.hosted.Feature;

@AutomaticallyRegisteredFeature
public class h
extends ProgressReporterFeature {
    private static boolean qs;
    private static final String qt = " - ";

    public static boolean r() {
        return qs;
    }

    public static void d(boolean bl2) {
        qs = bl2;
    }

    public void afterAnalysis(Feature.AfterAnalysisAccess afterAnalysisAccess) {
        super.afterAnalysis(afterAnalysisAccess);
        h.d(afterAnalysisAccess.isReachable(ObjectInputStream.class));
    }

    protected void warnAboutVectorAPI() {
        if (!((Boolean)SubstrateOptions.VectorAPISupport.getValue()).booleanValue()) {
            super.warnAboutVectorAPI();
        }
    }

    protected void appendGraalSuffix(ProgressReporter.DirectPrinter directPrinter) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (com.oracle.svm.enterprise.hosted.profiling.features.jfr.b.hg()) {
            arrayList.add("sampling");
        }
        if (((Boolean)ProfilingFeature.Options.ProfilingEnabled.getValue()).booleanValue()) {
            arrayList.add("instrument");
        }
        if (PGOFeature.isPGOEnabled()) {
            arrayList.add("user-provided");
        }
        if (com.oracle.svm.enterprise.hosted.ml.features.provider.a.fF()) {
            arrayList.add("ML-inferred");
        }
        if (!arrayList.isEmpty()) {
            this.reporter.recordJsonMetric((ProgressReporterJsonHelper.JsonMetric)ProgressReporterJsonHelper.GeneralInfo.GRAAL_COMPILER_PGO, arrayList);
        }
        String string = arrayList.isEmpty() ? "off" : String.join((CharSequence)"+", arrayList);
        ((ProgressReporter.DirectPrinter)directPrinter.a(", ").doclink("PGO", "#recommendation-pgo")).a(": ").a(string);
    }

    private ProgressReporter.DirectPrinter dX() {
        return this.reporter.l();
    }

    public void afterBreakdowns() {
        this.dY();
        this.ea();
    }

    private void dY() {
        ProgressReporter.CenteredTextPrinter centeredTextPrinter = (ProgressReporter.CenteredTextPrinter)this.reporter.centered().dim();
        if (ImageSingletons.contains(a.class)) {
            a a2 = (a)ImageSingletons.lookup(a.class);
            Path path = a2.C().getFirst();
            ((ProgressReporter.CenteredTextPrinter)((ProgressReporter.CenteredTextPrinter)centeredTextPrinter.a("For more details, open '")).link(path, true)).a("'.");
        } else {
            centeredTextPrinter.a("Use '--emit build-report' to create a report with more details.");
        }
        centeredTextPrinter.reset();
        centeredTextPrinter.flushln();
    }

    private void ea() {
        Object object;
        this.dX().printLineSeparator();
        ((ProgressReporter.DirectPrinter)((ProgressReporter.DirectPrinter)this.dX().yellowBold()).a("Security report:").reset()).println();
        ((ProgressReporter.DirectPrinter)this.dX().a(" - Binary").a(qs ? " includes " : " does not include ").doclink("Java deserialization", "#glossary-deserialization")).a(".").println();
        this.eb();
        if (SubstrateControlFlowIntegrity.enabled()) {
            object = SubstrateControlFlowIntegrity.singleton().getCFIMode();
            if (object == SubstrateControlFlowIntegrity.CFIOptions.HW) {
                ((ProgressReporter.DirectPrinter)this.dX().a(qt).doclink("Backwards-edge control-flow integrity (CFI)", "#glossary-backwards-edge-cfi")).a(" enforced within the binary using pointer authentication codes (PAC).").println();
            } else if (SubstrateControlFlowIntegrity.useSoftwareCFI()) {
                ((ProgressReporter.DirectPrinter)this.dX().a(qt).doclink("Control-flow integrity (CFI) enforced in software", "#glossary-sw-cfi")).a(" with target checks for indirect branches and function returns.").println();
            }
        }
        if (ImageSingletons.contains(Log4ShellFeature.class) && (object = ((Log4ShellFeature)ImageSingletons.lookup(Log4ShellFeature.class)).getUserWarning()) != null) {
            ((ProgressReporter.DirectPrinter)((ProgressReporter.DirectPrinter)((ProgressReporter.DirectPrinter)this.dX().red()).a(" - %s", new Object[]{object})).reset()).println();
        }
    }

    private void eb() {
        if (ImageSingletons.contains(b.class)) {
            int n2;
            b b2 = (b)ImageSingletons.lookup(b.class);
            ProgressReporter.DirectPrinter directPrinter = ((ProgressReporter.DirectPrinter)((ProgressReporter.DirectPrinter)this.dX().a(qt).a("%s", new Object[]{b2.eg()})).doclink(" SBOM", "#glossary-sbom")).a(" with " + b2.ef() + " component(s)");
            if (b2.ek()) {
                directPrinter.a(" and class-level info");
            }
            directPrinter.a(" is");
            boolean bl2 = b2.eh() != null;
            boolean bl3 = b2.ei() != null;
            boolean bl4 = b2.ej();
            int n3 = n2 = (bl2 ? 1 : 0) + (bl3 ? 1 : 0) + (bl4 ? 1 : 0);
            if (bl2) {
                --n3;
                directPrinter.a(" embedded in binary (%s)", new Object[]{ByteFormattingUtil.bytesToHuman((long)b2.eh().intValue())});
            }
            if (bl3) {
                directPrinter.a("%s saved to class path (%s)", new Object[]{h.d(n2, --n3), b2.ei()});
            }
            if (bl4) {
                directPrinter.a("%s exported as JSON (see build artifacts)", new Object[]{h.d(n2, --n3)});
            }
            directPrinter.a(".");
            List<String> list = b2.n();
            if (!list.isEmpty()) {
                directPrinter.a(" %s type(s) could not be associated to a component.", new Object[]{list.size()});
            }
            directPrinter.a(" See build report for more SBOM details.");
            directPrinter.println();
        } else {
            ((ProgressReporter.DirectPrinter)this.dX().a(" - Use '--enable-sbom' to ").doclink("assemble a Software Bill of Materials (SBOM)", "#glossary-sbom")).a(".").println();
        }
    }

    private static String d(int n2, int n3) {
        if (n2 == 1) {
            return "";
        }
        String string = n2 > 2 ? ", and" : " and";
        return n3 == 0 ? string : ",";
    }

    public void createAdditionalArtifactsOnSuccess(BuildArtifacts buildArtifacts) {
        if (ImageSingletons.contains(a.class)) {
            ((a)ImageSingletons.lookup(a.class)).a(buildArtifacts);
        }
    }

    protected List<ProgressReporterFeature.UserRecommendation> getRecommendations() {
        ArrayList<ProgressReporterFeature.UserRecommendation> arrayList = new ArrayList<ProgressReporterFeature.UserRecommendation>();
        arrayList.add(new ProgressReporterFeature.UserRecommendation("G1GC", "Use the G1 GC ('--gc=G1') for improved latency and throughput.", h::ec));
        arrayList.add(new ProgressReporterFeature.UserRecommendation("PGO", "Use Profile-Guided Optimizations ('--pgo') for improved throughput.", () -> !PGOFeature.isPGOEnabled()));
        arrayList.addAll(super.getRecommendations());
        arrayList.add(new ProgressReporterFeature.UserRecommendation("QBM", "Use the quick build mode ('-Ob') to speed up builds during development.", () -> !SubstrateOptions.useEconomyCompilerConfig()));
        return arrayList;
    }

    private static boolean ec() {
        return !SubstrateOptions.SupportedGCs.hasBeenSet() && Platform.includedIn(Platform.LINUX_AMD64.class);
    }

    public static interface a {
        public List<Path> C();

        public void a(BuildArtifacts var1);
    }

    public static interface b {
        public int ef();

        public String eg();

        default public Integer eh() {
            return null;
        }

        default public String ei() {
            return null;
        }

        public boolean ej();

        public boolean ek();

        public List<String> n();
    }
}

