/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.enterprise.gc.g1;

import com.oracle.svm.core.jvmstat.PerfDataHolder;
import com.oracle.svm.core.jvmstat.PerfLongConstant;
import com.oracle.svm.core.jvmstat.PerfLongCounter;
import com.oracle.svm.core.jvmstat.PerfLongVariable;
import com.oracle.svm.core.jvmstat.PerfManager;
import com.oracle.svm.core.jvmstat.PerfStringConstant;
import com.oracle.svm.core.jvmstat.PerfStringVariable;
import com.oracle.svm.core.jvmstat.PerfUnit;
import com.oracle.svm.enterprise.core.annotate.a;
import com.oracle.svm.enterprise.gc.g1.b;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

public class G1PerfData
implements PerfDataHolder {
    @a
    private final G1TLABPerfData tlab;
    @a
    private final G1GCPolicyPerfData gcPolicy;
    @a
    private final G1GCCausesPerfData gcCauses;
    @a
    private final G1CollectorPerfData[] collectors;
    @a
    private final G1GenerationPerfData[] generations;
    @a
    private final G1AgeTablePerfData ageTable;
    @a
    private final G1CpuTimePerfData cpuTime;

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public G1PerfData() {
        PerfManager perfManager = (PerfManager)ImageSingletons.lookup(PerfManager.class);
        perfManager.register((PerfDataHolder)this);
        this.tlab = new G1TLABPerfData();
        this.gcPolicy = new G1GCPolicyPerfData();
        this.gcCauses = new G1GCCausesPerfData();
        this.collectors = new G1CollectorPerfData[]{new G1CollectorPerfData(0), new G1CollectorPerfData(1), new G1CollectorPerfData(2)};
        G1SpacePerfData[] g1SpacePerfDataArray = new G1SpacePerfData[]{new G1SpacePerfData(0, 0), new G1SpacePerfData(0, 1), new G1SpacePerfData(0, 2)};
        G1SpacePerfData[] g1SpacePerfDataArray2 = new G1SpacePerfData[]{new G1SpacePerfData(1, 3)};
        this.generations = new G1GenerationPerfData[]{new G1GenerationPerfData(0, g1SpacePerfDataArray), new G1GenerationPerfData(1, g1SpacePerfDataArray2)};
        this.ageTable = new G1AgeTablePerfData(1 << b.cY());
        this.cpuTime = new G1CpuTimePerfData();
    }

    public void allocate() {
        this.tlab.allocate();
        this.gcPolicy.allocate();
        this.gcCauses.allocate();
        this.collectors[0].B("G1 young collection pauses");
        this.collectors[1].B("G1 full collection pauses");
        this.collectors[2].B("G1 concurrent cycle pauses");
        assert (this.collectors.length == 3) : this.collectors.length;
        this.generations[0].B("young");
        this.generations[0].spaces[0].B("eden");
        this.generations[0].spaces[1].B("s0");
        this.generations[0].spaces[2].B("s1");
        assert (this.generations[0].spaces.length == 3) : this.generations[0].spaces.length;
        this.generations[1].B("old");
        this.generations[1].spaces[0].B("space");
        assert (this.generations[1].spaces.length == 1) : this.generations[1].spaces.length;
        assert (this.generations.length == 2) : this.generations.length;
        this.ageTable.allocate();
        this.cpuTime.allocate();
    }

    public void update() {
    }

    public static class G1TLABPerfData {
        @a
        private final PerfLongVariable allocThreads;
        @a
        private final PerfLongVariable fills;
        @a
        private final PerfLongVariable maxFills;
        @a
        private final PerfLongVariable alloc;
        @a
        private final PerfLongVariable gcWaste;
        @a
        private final PerfLongVariable maxGcWaste;
        @a
        private final PerfLongVariable refillWaste;
        @a
        private final PerfLongVariable maxRefillWaste;
        @a
        private final PerfLongVariable slowAlloc;
        @a
        private final PerfLongVariable maxSlowAlloc;

        @Platforms(value={Platform.HOSTED_ONLY.class})
        G1TLABPerfData() {
            PerfManager perfManager = (PerfManager)ImageSingletons.lookup(PerfManager.class);
            this.allocThreads = perfManager.createLongVariable("sun.gc.tlab.allocThreads", PerfUnit.NONE);
            this.fills = perfManager.createLongVariable("sun.gc.tlab.fills", PerfUnit.NONE);
            this.maxFills = perfManager.createLongVariable("sun.gc.tlab.maxFills", PerfUnit.NONE);
            this.alloc = perfManager.createLongVariable("sun.gc.tlab.alloc", PerfUnit.BYTES);
            this.gcWaste = perfManager.createLongVariable("sun.gc.tlab.gcWaste", PerfUnit.BYTES);
            this.maxGcWaste = perfManager.createLongVariable("sun.gc.tlab.maxGcWaste", PerfUnit.BYTES);
            this.refillWaste = perfManager.createLongVariable("sun.gc.tlab.refillWaste", PerfUnit.BYTES);
            this.maxRefillWaste = perfManager.createLongVariable("sun.gc.tlab.maxRefillWaste", PerfUnit.BYTES);
            this.slowAlloc = perfManager.createLongVariable("sun.gc.tlab.slowAlloc", PerfUnit.NONE);
            this.maxSlowAlloc = perfManager.createLongVariable("sun.gc.tlab.maxSlowAlloc", PerfUnit.NONE);
        }

        public void allocate() {
            this.allocThreads.allocate();
            this.fills.allocate();
            this.maxFills.allocate();
            this.alloc.allocate();
            this.gcWaste.allocate();
            this.maxGcWaste.allocate();
            this.refillWaste.allocate();
            this.maxRefillWaste.allocate();
            this.slowAlloc.allocate();
            this.maxSlowAlloc.allocate();
        }
    }

    public static class G1GCPolicyPerfData {
        private final PerfStringConstant ny;
        private final PerfLongConstant nz;
        private final PerfLongConstant nA;
        @a
        private final PerfLongVariable desiredSurvivorSize;
        @a
        private final PerfLongVariable gcTimeLimitExceeded;
        @a
        private final PerfLongVariable maxTenuringThreshold;
        @a
        private final PerfLongVariable tenuringThreshold;

        @Platforms(value={Platform.HOSTED_ONLY.class})
        G1GCPolicyPerfData() {
            PerfManager perfManager = (PerfManager)ImageSingletons.lookup(PerfManager.class);
            this.ny = perfManager.createStringConstant("sun.gc.policy.name");
            this.nz = perfManager.createLongConstant("sun.gc.policy.collectors", PerfUnit.NONE);
            this.nA = perfManager.createLongConstant("sun.gc.policy.generations", PerfUnit.NONE);
            this.desiredSurvivorSize = perfManager.createLongVariable("sun.gc.policy.desiredSurvivorSize", PerfUnit.BYTES);
            this.gcTimeLimitExceeded = perfManager.createLongVariable("sun.gc.policy.gcTimeLimitExceeded", PerfUnit.EVENTS);
            this.maxTenuringThreshold = perfManager.createLongVariable("sun.gc.policy.maxTenuringThreshold", PerfUnit.NONE);
            this.tenuringThreshold = perfManager.createLongVariable("sun.gc.policy.tenuringThreshold", PerfUnit.NONE);
        }

        public void allocate() {
            this.ny.allocate("GarbageFirst");
            this.nz.allocate(1L);
            this.nA.allocate(2L);
            this.desiredSurvivorSize.allocate();
            this.gcTimeLimitExceeded.allocate();
            this.maxTenuringThreshold.allocate();
            this.tenuringThreshold.allocate();
        }
    }

    public static class G1GCCausesPerfData {
        @a
        private final PerfStringVariable cause;
        @a
        private final PerfStringVariable lastCause;

        @Platforms(value={Platform.HOSTED_ONLY.class})
        G1GCCausesPerfData() {
            PerfManager perfManager = (PerfManager)ImageSingletons.lookup(PerfManager.class);
            this.cause = perfManager.createStringVariable("sun.gc.cause", 80);
            this.lastCause = perfManager.createStringVariable("sun.gc.lastCause", 80);
        }

        public void allocate() {
            this.cause.allocate();
            this.lastCause.allocate();
        }
    }

    public static class G1CollectorPerfData {
        private final PerfStringConstant nx;
        @a
        private final PerfLongCounter invocations;
        @a
        private final PerfLongVariable lastEntryTime;
        @a
        private final PerfLongVariable lastExitTime;
        @a
        private final PerfLongCounter time;

        @Platforms(value={Platform.HOSTED_ONLY.class})
        G1CollectorPerfData(int n2) {
            PerfManager perfManager = (PerfManager)ImageSingletons.lookup(PerfManager.class);
            this.nx = perfManager.createStringConstant("sun.gc.collector." + n2 + ".name");
            this.invocations = perfManager.createLongCounter("sun.gc.collector." + n2 + ".invocations", PerfUnit.EVENTS);
            this.lastEntryTime = perfManager.createLongVariable("sun.gc.collector." + n2 + ".lastEntryTime", PerfUnit.TICKS);
            this.lastExitTime = perfManager.createLongVariable("sun.gc.collector." + n2 + ".lastExitTime", PerfUnit.TICKS);
            this.time = perfManager.createLongCounter("sun.gc.collector." + n2 + ".time", PerfUnit.TICKS);
        }

        public void B(String string) {
            this.nx.allocate(string);
            this.invocations.allocate();
            this.lastEntryTime.allocate();
            this.lastExitTime.allocate();
            this.time.allocate();
        }
    }

    public static class G1SpacePerfData {
        private final PerfStringConstant nD;
        @a
        private final PerfLongVariable capacity;
        @a
        private final PerfLongVariable initCapacity;
        @a
        private final PerfLongVariable maxCapacity;
        @a
        private final PerfLongVariable used;

        @Platforms(value={Platform.HOSTED_ONLY.class})
        G1SpacePerfData(int n2, int n3) {
            PerfManager perfManager = (PerfManager)ImageSingletons.lookup(PerfManager.class);
            this.nD = perfManager.createStringConstant("sun.gc.generation." + n2 + ".space." + n3 + ".name");
            this.capacity = perfManager.createLongVariable("sun.gc.generation." + n2 + ".space." + n3 + ".capacity", PerfUnit.BYTES);
            this.initCapacity = perfManager.createLongVariable("sun.gc.generation." + n2 + ".space." + n3 + ".initCapacity", PerfUnit.BYTES);
            this.maxCapacity = perfManager.createLongVariable("sun.gc.generation." + n2 + ".space." + n3 + ".maxCapacity", PerfUnit.BYTES);
            this.used = perfManager.createLongVariable("sun.gc.generation." + n2 + ".space." + n3 + ".used", PerfUnit.BYTES);
        }

        public void B(String string) {
            this.nD.allocate(string);
            this.capacity.allocate();
            this.initCapacity.allocate();
            this.maxCapacity.allocate();
            this.used.allocate();
        }
    }

    public static class G1GenerationPerfData {
        private final PerfStringConstant nB;
        private final PerfLongConstant nC;
        @a
        private final PerfLongVariable capacity;
        @a
        private final PerfLongVariable maxCapacity;
        @a
        private final PerfLongVariable minCapacity;
        @a
        private final G1SpacePerfData[] spaces;

        @Platforms(value={Platform.HOSTED_ONLY.class})
        G1GenerationPerfData(int n2, G1SpacePerfData[] g1SpacePerfDataArray) {
            PerfManager perfManager = (PerfManager)ImageSingletons.lookup(PerfManager.class);
            this.nB = perfManager.createStringConstant("sun.gc.generation." + n2 + ".name");
            this.nC = perfManager.createLongConstant("sun.gc.generation." + n2 + ".spaces", PerfUnit.NONE);
            this.capacity = perfManager.createLongVariable("sun.gc.generation." + n2 + ".capacity", PerfUnit.BYTES);
            this.maxCapacity = perfManager.createLongVariable("sun.gc.generation." + n2 + ".maxCapacity", PerfUnit.BYTES);
            this.minCapacity = perfManager.createLongVariable("sun.gc.generation." + n2 + ".minCapacity", PerfUnit.BYTES);
            this.spaces = g1SpacePerfDataArray;
        }

        public void B(String string) {
            this.nB.allocate(string);
            this.nC.allocate((long)this.spaces.length);
            this.capacity.allocate();
            this.maxCapacity.allocate();
            this.minCapacity.allocate();
        }
    }

    public static class G1AgeTablePerfData {
        private final PerfLongConstant nw;
        @a
        private final PerfLongVariable[] table;

        @Platforms(value={Platform.HOSTED_ONLY.class})
        G1AgeTablePerfData(int n2) {
            PerfManager perfManager = (PerfManager)ImageSingletons.lookup(PerfManager.class);
            this.nw = perfManager.createLongConstant("sun.gc.generation.0.agetable.size", PerfUnit.NONE);
            this.table = new PerfLongVariable[n2];
            for (int i2 = 0; i2 < n2; ++i2) {
                this.table[i2] = perfManager.createLongVariable("sun.gc.generation.0.agetable.bytes." + String.format("%02d", i2), PerfUnit.BYTES);
            }
        }

        public void allocate() {
            this.nw.allocate((long)this.table.length);
            for (PerfLongVariable perfLongVariable : this.table) {
                perfLongVariable.allocate();
            }
        }
    }

    public static class G1CpuTimePerfData {
        @a
        private final PerfLongCounter gcTotal;
        @a
        private final PerfLongCounter gcParallelWorkers;
        @a
        private final PerfLongCounter gcConcMark;
        @a
        private final PerfLongCounter gcConcRefine;
        @a
        private final PerfLongCounter gcService;

        @Platforms(value={Platform.HOSTED_ONLY.class})
        public G1CpuTimePerfData() {
            PerfManager perfManager = (PerfManager)ImageSingletons.lookup(PerfManager.class);
            this.gcTotal = perfManager.createLongCounter("sun.threads.total_gc_cpu_time", PerfUnit.TICKS);
            this.gcParallelWorkers = perfManager.createLongCounter("sun.threads.cpu_time.gc_parallel_workers", PerfUnit.TICKS);
            this.gcConcMark = perfManager.createLongCounter("sun.threads.cpu_time.gc_conc_mark", PerfUnit.TICKS);
            this.gcConcRefine = perfManager.createLongCounter("sun.threads.cpu_time.gc_conc_refine", PerfUnit.TICKS);
            this.gcService = perfManager.createLongCounter("sun.threads.cpu_time.gc_service", PerfUnit.TICKS);
        }

        public void allocate() {
            this.gcTotal.allocate();
            this.gcParallelWorkers.allocate();
            this.gcConcMark.allocate();
            this.gcConcRefine.allocate();
            this.gcService.allocate();
        }
    }
}

