/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.enterprise.core.stringformat;

import com.oracle.svm.core.nodes.SubstrateMethodCallTargetNode;
import com.oracle.svm.core.option.HostedOptionKey;
import com.oracle.svm.core.util.HostedStringDeduplication;
import com.oracle.svm.enterprise.core.stringformat.e;
import com.oracle.svm.util.ReflectionUtil;
import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.Deque;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jdk.graal.compiler.debug.GraalError;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.graph.NodeInputList;
import jdk.graal.compiler.nodes.CallTargetNode;
import jdk.graal.compiler.nodes.ConstantNode;
import jdk.graal.compiler.nodes.FixedWithNextNode;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.java.MethodCallTargetNode;
import jdk.graal.compiler.nodes.spi.CoreProviders;
import jdk.graal.compiler.nodes.virtual.AllocatedObjectNode;
import jdk.graal.compiler.nodes.virtual.CommitAllocationNode;
import jdk.graal.compiler.nodes.virtual.VirtualArrayNode;
import jdk.graal.compiler.nodes.virtual.VirtualObjectNode;
import jdk.graal.compiler.phases.BasePhase;
import jdk.graal.compiler.phases.util.Providers;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

@Platforms(value={Platform.HOSTED_ONLY.class})
public final class StringFormatPhase
extends BasePhase<Providers> {
    private static final Method mi = ReflectionUtil.lookupMethod(String.class, (String)"format", (Class[])new Class[]{String.class, Object[].class});
    private static final Method mj = ReflectionUtil.lookupMethod(String.class, (String)"format", (Class[])new Class[]{Locale.class, String.class, Object[].class});
    private static final Method mk = ReflectionUtil.lookupMethod(String.class, (String)"formatted", (Class[])new Class[]{Object[].class});
    private static final Method ml = ReflectionUtil.lookupMethod(com.oracle.svm.enterprise.core.stringformat.a.class, (String)"format", (Class[])new Class[]{String.class, Object[].class});
    private static final Method mm = ReflectionUtil.lookupMethod(com.oracle.svm.enterprise.core.stringformat.a.class, (String)"format", (Class[])new Class[]{Locale.class, String.class, Object[].class});
    private static final Pattern mn = Pattern.compile("%(\\d+\\$)?([0#\\<]*)?([1-9]\\d*)?([dxXcs])");
    private static final int mo = 100;

    protected void a(StructuredGraph structuredGraph, Providers providers) {
        ResolvedJavaMethod resolvedJavaMethod = providers.getMetaAccess().lookupJavaMethod((Executable)mi);
        ResolvedJavaMethod resolvedJavaMethod2 = providers.getMetaAccess().lookupJavaMethod((Executable)mj);
        ResolvedJavaMethod resolvedJavaMethod3 = providers.getMetaAccess().lookupJavaMethod((Executable)mk);
        for (MethodCallTargetNode methodCallTargetNode : structuredGraph.getNodes(MethodCallTargetNode.TYPE)) {
            NodeInputList nodeInputList = methodCallTargetNode.arguments();
            if (resolvedJavaMethod.equals((Object)methodCallTargetNode.targetMethod())) {
                assert (nodeInputList.size() == 2);
                StringFormatPhase.a(structuredGraph, methodCallTargetNode, null, (ValueNode)nodeInputList.get(0), (ValueNode)nodeInputList.get(1), providers);
                continue;
            }
            if (resolvedJavaMethod2.equals((Object)methodCallTargetNode.targetMethod())) {
                assert (nodeInputList.size() == 3);
                StringFormatPhase.a(structuredGraph, methodCallTargetNode, (ValueNode)nodeInputList.get(0), (ValueNode)nodeInputList.get(1), (ValueNode)nodeInputList.get(2), providers);
                continue;
            }
            if (!resolvedJavaMethod3.equals((Object)methodCallTargetNode.targetMethod())) continue;
            assert (nodeInputList.size() == 2);
            StringFormatPhase.a(structuredGraph, methodCallTargetNode, null, (ValueNode)nodeInputList.get(0), (ValueNode)nodeInputList.get(1), providers);
        }
    }

    private static void a(StructuredGraph structuredGraph, MethodCallTargetNode methodCallTargetNode, ValueNode valueNode, ValueNode valueNode2, ValueNode valueNode3, Providers providers) {
        if (!valueNode2.isJavaConstant()) {
            structuredGraph.getDebug().log("Format string is not a constant: %s", (Object)valueNode2);
            return;
        }
        Object object = providers.getSnippetReflection().asObject(Object.class, valueNode2.asJavaConstant());
        if (!(object instanceof String)) {
            structuredGraph.getDebug().log("Format string is not a constant string: %s", object);
            return;
        }
        String string = (String)object;
        if (!(valueNode3 instanceof AllocatedObjectNode)) {
            structuredGraph.getDebug().log("Format arguments are not an escape-analyzed array: %s", (Object)valueNode3);
            return;
        }
        if (methodCallTargetNode.invoke().predecessor() != ((AllocatedObjectNode)valueNode3).getCommit()) {
            structuredGraph.getDebug().log("Format arguments are not materialized immediately before the invoke: %s", (Object)valueNode3);
            return;
        }
        List<ValueNode> list = StringFormatPhase.a((AllocatedObjectNode)valueNode3);
        Deque<e> deque = StringFormatPhase.a(string, list);
        if (deque == null) {
            structuredGraph.getDebug().log("Format string is too complicated for intrinsification: %s", (Object)string);
            return;
        }
        StringFormatPhase.a(structuredGraph, methodCallTargetNode, valueNode, deque, (CoreProviders)providers);
    }

    private static Deque<e> a(String string, List<ValueNode> list) {
        ArrayDeque<e> arrayDeque = new ArrayDeque<e>();
        int n2 = 0;
        int n3 = string.length();
        int n4 = -1;
        int n5 = 0;
        Matcher matcher = mn.matcher(string);
        while (n2 < n3) {
            String string2;
            int n6;
            int n7;
            String string3;
            int n8 = string.indexOf(37, n2);
            if (n8 < 0) {
                StringFormatPhase.a(arrayDeque, string.substring(n2, n3));
                break;
            }
            if (arrayDeque.size() > 100) {
                return null;
            }
            if (n2 != n8) {
                StringFormatPhase.a(arrayDeque, string.substring(n2, n8));
            }
            if ((string3 = StringFormatPhase.b(string, n8)) != null) {
                StringFormatPhase.a(arrayDeque, string3);
                n2 = n8 + 2;
                continue;
            }
            if (!matcher.find(n8) || matcher.start() != n8) {
                return null;
            }
            boolean bl2 = false;
            if (matcher.start(1) >= 0) {
                bl2 = true;
                try {
                    n7 = Integer.parseInt(string.substring(matcher.start(1), matcher.end(1) - 1));
                    n4 = n7 - 1;
                }
                catch (NumberFormatException numberFormatException) {
                    return null;
                }
            }
            n7 = 0;
            boolean bl3 = false;
            if (matcher.start(2) >= 0) {
                String string4 = string.substring(matcher.start(2), matcher.end(2));
                for (n6 = 0; n6 < string4.length(); ++n6) {
                    if (string4.charAt(n6) == '#' && n7 == 0) {
                        n7 = 1;
                        continue;
                    }
                    if (string4.charAt(n6) == '<' && !bl2) {
                        bl2 = true;
                        continue;
                    }
                    if (string4.charAt(n6) == '0' && !bl3) {
                        bl3 = true;
                        continue;
                    }
                    return null;
                }
            }
            boolean bl4 = false;
            n6 = -1;
            if (matcher.start(3) >= 0) {
                string2 = string.substring(matcher.start(3), matcher.end(3));
                assert (string2.charAt(0) != '0');
                if (string2.length() > 1) {
                    return null;
                }
                try {
                    n6 = Integer.parseInt(string2);
                    assert (n6 > 0);
                    bl4 = true;
                }
                catch (NumberFormatException numberFormatException) {
                    return null;
                }
            }
            string2 = string.substring(matcher.start(4), matcher.end(4));
            assert (string2.length() == 1);
            char c2 = string2.charAt(0);
            assert ("dxXcs".indexOf(c2) >= 0);
            if (n7 != 0) {
                if (c2 == 'x') {
                    StringFormatPhase.a(arrayDeque, "0x");
                } else if (c2 == 'X') {
                    StringFormatPhase.a(arrayDeque, "0X");
                } else {
                    return null;
                }
            }
            if (bl3 || bl4) {
                if (c2 != 'd' && c2 != 'x' && c2 != 'X') {
                    return null;
                }
                if (!bl3 || !bl4) {
                    return null;
                }
            }
            if (!bl2) {
                n4 = n5++;
            }
            if (n4 < 0 || n4 >= list.size()) {
                return null;
            }
            arrayDeque.addLast(new e(c2, list.get(n4), n6));
            n2 = matcher.end();
        }
        return arrayDeque;
    }

    private static void a(StructuredGraph structuredGraph, MethodCallTargetNode methodCallTargetNode, ValueNode valueNode, Deque<e> deque, CoreProviders coreProviders) {
        ValueNode[] valueNodeArray;
        JavaConstant javaConstant;
        e e22;
        VirtualObjectNode virtualObjectNode = (VirtualObjectNode)structuredGraph.add((Node)new VirtualArrayNode(coreProviders.getMetaAccess().lookupJavaType(Object.class), deque.size()));
        AllocatedObjectNode allocatedObjectNode = (AllocatedObjectNode)structuredGraph.unique((Node)new AllocatedObjectNode(virtualObjectNode));
        CommitAllocationNode commitAllocationNode = (CommitAllocationNode)structuredGraph.add((Node)new CommitAllocationNode());
        commitAllocationNode.getVirtualObjects().add(virtualObjectNode);
        allocatedObjectNode.setCommit(commitAllocationNode);
        commitAllocationNode.addLocks(Collections.emptyList());
        commitAllocationNode.getEnsureVirtual().add(false);
        HostedStringDeduplication hostedStringDeduplication = HostedStringDeduplication.singleton();
        StringBuilder stringBuilder = new StringBuilder();
        for (e e22 : deque) {
            if (e22.mq != null) {
                javaConstant = coreProviders.getConstantReflection().forString(hostedStringDeduplication.deduplicate(e22.mq, false));
                commitAllocationNode.getValues().add(ConstantNode.forConstant((JavaConstant)javaConstant, (MetaAccessProvider)coreProviders.getMetaAccess(), (StructuredGraph)structuredGraph));
            } else {
                commitAllocationNode.getValues().add(e22.ms);
            }
            stringBuilder.append(e22.mr);
            if (e22.mt < 0) continue;
            assert (String.valueOf(e22.mt).length() == 1);
            stringBuilder.append(e22.mt);
        }
        structuredGraph.addBeforeFixed(methodCallTargetNode.invoke().asFixedNode(), (FixedWithNextNode)commitAllocationNode);
        assert (commitAllocationNode.verify());
        JavaConstant javaConstant2 = coreProviders.getConstantReflection().forString(hostedStringDeduplication.deduplicate(stringBuilder.toString(), false));
        e22 = ConstantNode.forConstant((JavaConstant)javaConstant2, (MetaAccessProvider)coreProviders.getMetaAccess(), (StructuredGraph)structuredGraph);
        javaConstant = coreProviders.getMetaAccess().lookupJavaMethod((Executable)(valueNode == null ? ml : mm));
        if (valueNode == null) {
            ValueNode[] valueNodeArray2 = new ValueNode[2];
            valueNodeArray2[0] = e22;
            valueNodeArray = valueNodeArray2;
            valueNodeArray2[1] = allocatedObjectNode;
        } else {
            ValueNode[] valueNodeArray3 = new ValueNode[3];
            valueNodeArray3[0] = valueNode;
            valueNodeArray3[1] = e22;
            valueNodeArray = valueNodeArray3;
            valueNodeArray3[2] = allocatedObjectNode;
        }
        ValueNode[] valueNodeArray4 = valueNodeArray;
        MethodCallTargetNode methodCallTargetNode2 = (MethodCallTargetNode)structuredGraph.add((Node)new SubstrateMethodCallTargetNode(CallTargetNode.InvokeKind.Static, (ResolvedJavaMethod)javaConstant, valueNodeArray4, methodCallTargetNode.returnStamp()));
        methodCallTargetNode.replaceAndDelete((Node)methodCallTargetNode2);
        structuredGraph.getDebug().log("Intrinsified format string to %s", (Object)stringBuilder);
    }

    private static void a(Deque<e> deque, String string) {
        if (deque.size() > 0) {
            e e2 = deque.getLast();
            if (e2.mq != null) {
                deque.removeLast();
                deque.addLast(new e(e2.mq + string));
                return;
            }
        }
        deque.addLast(new e(string));
    }

    private static String b(String string, int n2) {
        if (n2 + 1 < string.length()) {
            switch (string.charAt(n2 + 1)) {
                case '%': {
                    return "%";
                }
                case 'n': {
                    return System.lineSeparator();
                }
            }
        }
        return null;
    }

    private static List<ValueNode> a(AllocatedObjectNode allocatedObjectNode) {
        CommitAllocationNode commitAllocationNode = allocatedObjectNode.getCommit();
        int n2 = 0;
        for (VirtualObjectNode virtualObjectNode : commitAllocationNode.getVirtualObjects()) {
            if (virtualObjectNode == allocatedObjectNode.getVirtualObject()) {
                assert (virtualObjectNode instanceof VirtualArrayNode) : virtualObjectNode;
                return commitAllocationNode.getValues().subList(n2, n2 + virtualObjectNode.entryCount());
            }
            n2 += virtualObjectNode.entryCount();
        }
        throw GraalError.shouldNotReachHere((String)"Did not find virtual object");
    }

    protected /* synthetic */ void run(StructuredGraph structuredGraph, Object object) {
        this.a(structuredGraph, (Providers)object);
    }

    public static final class a {
        public static final HostedOptionKey<Boolean> IntrinsifyStringFormat = new HostedOptionKey((Object)true);
    }
}

