/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.enterprise.core.amd64;

import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.c.struct.OffsetOf;
import com.oracle.svm.core.config.ConfigurationValues;
import com.oracle.svm.core.deopt.DeoptimizationSlotPacking;
import com.oracle.svm.core.graal.amd64.SubstrateAMD64Backend;
import com.oracle.svm.core.graal.amd64.SubstrateAMD64RegisterConfig;
import com.oracle.svm.core.graal.meta.SubstrateRegisterConfig;
import com.oracle.svm.core.meta.SharedMethod;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.enterprise.core.x;
import jdk.graal.compiler.api.replacements.Fold;
import jdk.graal.compiler.asm.Label;
import jdk.graal.compiler.asm.amd64.AMD64Address;
import jdk.graal.compiler.asm.amd64.AMD64Assembler;
import jdk.graal.compiler.asm.amd64.AMD64MacroAssembler;
import jdk.graal.compiler.core.common.NumUtil;
import jdk.graal.compiler.lir.asm.CompilationResultBuilder;
import jdk.vm.ci.amd64.AMD64;
import jdk.vm.ci.code.CallingConvention;
import jdk.vm.ci.code.Register;
import jdk.vm.ci.code.RegisterArray;
import jdk.vm.ci.code.RegisterValue;
import jdk.vm.ci.code.StackSlot;
import jdk.vm.ci.code.TargetDescription;
import jdk.vm.ci.meta.AllocatableValue;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.c.struct.RawField;
import org.graalvm.nativeimage.c.struct.RawStructure;
import org.graalvm.nativeimage.c.struct.SizeOf;
import org.graalvm.word.Pointer;
import org.graalvm.word.PointerBase;
import org.graalvm.word.WordFactory;

public class AMD64InterpreterStubs {
    public static final Register cV = AMD64.rax;

    private static SubstrateAMD64RegisterConfig aJ() {
        return new SubstrateAMD64RegisterConfig(SubstrateRegisterConfig.ConfigKind.NORMAL, null, (TargetDescription)ConfigurationValues.getTarget(), ((Boolean)SubstrateOptions.PreserveFramePointer.getValue()).booleanValue());
    }

    public static int aC() {
        return NumUtil.roundUp((int)SizeOf.get(InterpreterDataAMD64.class), (int)16);
    }

    public static int aD() {
        int n2 = 8;
        int n3 = n2 + n2;
        return AMD64InterpreterStubs.aC() + n3;
    }

    public static int aE() {
        int n2 = 8;
        return 4 * n2;
    }

    @Fold
    public static int offsetAbiSpReg() {
        return OffsetOf.get(InterpreterDataAMD64.class, (String)"AbiSpReg");
    }

    @Fold
    public static int offsetAbiGp0() {
        return OffsetOf.get(InterpreterDataAMD64.class, (String)"AbiGp0");
    }

    @Fold
    public static int offsetAbiGp1() {
        return OffsetOf.get(InterpreterDataAMD64.class, (String)"AbiGp1");
    }

    @Fold
    public static int offsetAbiGp2() {
        return OffsetOf.get(InterpreterDataAMD64.class, (String)"AbiGp2");
    }

    @Fold
    public static int offsetAbiGp3() {
        return OffsetOf.get(InterpreterDataAMD64.class, (String)"AbiGp3");
    }

    @Fold
    public static int offsetAbiGp4() {
        return OffsetOf.get(InterpreterDataAMD64.class, (String)"AbiGp4");
    }

    @Fold
    public static int offsetAbiGp5() {
        return OffsetOf.get(InterpreterDataAMD64.class, (String)"AbiGp5");
    }

    @Fold
    public static int offsetAbiFpArg0() {
        return OffsetOf.get(InterpreterDataAMD64.class, (String)"AbiFpArg0");
    }

    @Fold
    public static int offsetAbiFpArg1() {
        return OffsetOf.get(InterpreterDataAMD64.class, (String)"AbiFpArg1");
    }

    @Fold
    public static int offsetAbiFpArg2() {
        return OffsetOf.get(InterpreterDataAMD64.class, (String)"AbiFpArg2");
    }

    @Fold
    public static int offsetAbiFpArg3() {
        return OffsetOf.get(InterpreterDataAMD64.class, (String)"AbiFpArg3");
    }

    @Fold
    public static int offsetAbiFpArg4() {
        return OffsetOf.get(InterpreterDataAMD64.class, (String)"AbiFpArg4");
    }

    @Fold
    public static int offsetAbiFpArg5() {
        return OffsetOf.get(InterpreterDataAMD64.class, (String)"AbiFpArg5");
    }

    @Fold
    public static int offsetAbiFpArg6() {
        return OffsetOf.get(InterpreterDataAMD64.class, (String)"AbiFpArg6");
    }

    @Fold
    public static int offsetAbiFpArg7() {
        return OffsetOf.get(InterpreterDataAMD64.class, (String)"AbiFpArg7");
    }

    @Fold
    public static int offsetAbiGpRet() {
        return OffsetOf.get(InterpreterDataAMD64.class, (String)"AbiGpRet");
    }

    @Fold
    public static int offsetAbiFpRet() {
        return OffsetOf.get(InterpreterDataAMD64.class, (String)"AbiFpRet");
    }

    @RawStructure
    public static interface InterpreterDataAMD64
    extends PointerBase {
        @RawField
        public long getStackSize();

        @RawField
        public void setStackSize(long var1);

        @RawField
        public long getAbiSpReg();

        @RawField
        public void setAbiSpReg(long var1);

        @RawField
        public void setAbiGpRet(long var1);

        @RawField
        public long getAbiGpRet();

        @RawField
        public void setAbiFpRet(long var1);

        @RawField
        public long getAbiFpRet();

        @RawField
        public long getAbiGp0();

        @RawField
        public void setAbiGp0(long var1);

        @RawField
        public long getAbiGp1();

        @RawField
        public void setAbiGp1(long var1);

        @RawField
        public long getAbiGp2();

        @RawField
        public void setAbiGp2(long var1);

        @RawField
        public long getAbiGp3();

        @RawField
        public void setAbiGp3(long var1);

        @RawField
        public long getAbiGp4();

        @RawField
        public void setAbiGp4(long var1);

        @RawField
        public long getAbiGp5();

        @RawField
        public void setAbiGp5(long var1);

        @RawField
        public long getAbiFpArg0();

        @RawField
        public void setAbiFpArg0(long var1);

        @RawField
        public long getAbiFpArg1();

        @RawField
        public void setAbiFpArg1(long var1);

        @RawField
        public long getAbiFpArg2();

        @RawField
        public void setAbiFpArg2(long var1);

        @RawField
        public long getAbiFpArg3();

        @RawField
        public void setAbiFpArg3(long var1);

        @RawField
        public long getAbiFpArg4();

        @RawField
        public void setAbiFpArg4(long var1);

        @RawField
        public long getAbiFpArg5();

        @RawField
        public void setAbiFpArg5(long var1);

        @RawField
        public long getAbiFpArg6();

        @RawField
        public void setAbiFpArg6(long var1);

        @RawField
        public long getAbiFpArg7();

        @RawField
        public void setAbiFpArg7(long var1);
    }

    public static class a
    implements x {
        @Override
        public void a(Pointer pointer, int n2, Pointer pointer2) {
            VMError.guarantee((boolean)pointer2.isNonNull());
            InterpreterDataAMD64 interpreterDataAMD64 = (InterpreterDataAMD64)pointer;
            interpreterDataAMD64.setAbiSpReg(pointer2.rawValue());
            interpreterDataAMD64.setStackSize(n2);
            assert (n2 % 16 == 0);
            pointer2.writeLong(0, DeoptimizationSlotPacking.encodeVariableFrameSizeIntoDeoptSlot((long)n2));
        }

        @Override
        public long a(AllocatableValue allocatableValue, Pointer pointer, int n2) {
            InterpreterDataAMD64 interpreterDataAMD64 = (InterpreterDataAMD64)pointer;
            return switch (n2) {
                case 0 -> interpreterDataAMD64.getAbiGp0();
                case 1 -> interpreterDataAMD64.getAbiGp1();
                case 2 -> interpreterDataAMD64.getAbiGp2();
                case 3 -> interpreterDataAMD64.getAbiGp3();
                case 4 -> interpreterDataAMD64.getAbiGp4();
                case 5 -> interpreterDataAMD64.getAbiGp5();
                default -> {
                    StackSlot var5_5 = (StackSlot)allocatableValue;
                    Pointer var6_6 = (Pointer)WordFactory.pointer((long)interpreterDataAMD64.getAbiSpReg());
                    int var7_7 = ConfigurationValues.getTarget().wordSize;
                    int var8_8 = var5_5.getOffset(0) + var7_7;
                    yield var6_6.readLong(var8_8);
                }
            };
        }

        @Override
        public long a(AllocatableValue allocatableValue, Pointer pointer, int n2, long l2) {
            InterpreterDataAMD64 interpreterDataAMD64 = (InterpreterDataAMD64)pointer;
            if (n2 >= 0 && n2 <= 5) {
                VMError.guarantee((boolean)(allocatableValue instanceof RegisterValue));
                switch (n2) {
                    case 0: {
                        interpreterDataAMD64.setAbiGp0(l2);
                        break;
                    }
                    case 1: {
                        interpreterDataAMD64.setAbiGp1(l2);
                        break;
                    }
                    case 2: {
                        interpreterDataAMD64.setAbiGp2(l2);
                        break;
                    }
                    case 3: {
                        interpreterDataAMD64.setAbiGp3(l2);
                        break;
                    }
                    case 4: {
                        interpreterDataAMD64.setAbiGp4(l2);
                        break;
                    }
                    case 5: {
                        interpreterDataAMD64.setAbiGp5(l2);
                    }
                }
                return 0L;
            }
            StackSlot stackSlot = (StackSlot)allocatableValue;
            Pointer pointer2 = (Pointer)WordFactory.pointer((long)interpreterDataAMD64.getAbiSpReg());
            int n3 = stackSlot.getOffset(0);
            VMError.guarantee((boolean)pointer2.isNonNull());
            VMError.guarantee(((long)n3 < interpreterDataAMD64.getStackSize() ? 1 : 0) != 0);
            pointer2.writeLong(n3, l2);
            VMError.guarantee((n2 - 6 < 64 ? 1 : 0) != 0, (String)"more than 64 stack args are not supported");
            return 1L << n2 - 6;
        }

        private static int aK() {
            return Platform.includedIn(Platform.WINDOWS.class) ? 3 : 7;
        }

        @Override
        public long b(AllocatableValue allocatableValue, Pointer pointer, int n2) {
            InterpreterDataAMD64 interpreterDataAMD64 = (InterpreterDataAMD64)pointer;
            if (n2 >= 0 && n2 <= a.aK()) {
                VMError.guarantee((boolean)(allocatableValue instanceof RegisterValue));
                switch (n2) {
                    case 0: {
                        return interpreterDataAMD64.getAbiFpArg0();
                    }
                    case 1: {
                        return interpreterDataAMD64.getAbiFpArg1();
                    }
                    case 2: {
                        return interpreterDataAMD64.getAbiFpArg2();
                    }
                    case 3: {
                        return interpreterDataAMD64.getAbiFpArg3();
                    }
                    case 4: {
                        return interpreterDataAMD64.getAbiFpArg4();
                    }
                    case 5: {
                        return interpreterDataAMD64.getAbiFpArg5();
                    }
                    case 6: {
                        return interpreterDataAMD64.getAbiFpArg6();
                    }
                    case 7: {
                        return interpreterDataAMD64.getAbiFpArg7();
                    }
                }
            }
            StackSlot stackSlot = (StackSlot)allocatableValue;
            Pointer pointer2 = (Pointer)WordFactory.pointer((long)interpreterDataAMD64.getAbiSpReg());
            int n3 = ConfigurationValues.getTarget().wordSize;
            int n4 = stackSlot.getOffset(0) + n3;
            return pointer2.readLong(n4);
        }

        @Override
        public void b(AllocatableValue allocatableValue, Pointer pointer, int n2, long l2) {
            InterpreterDataAMD64 interpreterDataAMD64 = (InterpreterDataAMD64)pointer;
            if (n2 >= 0 && n2 <= a.aK()) {
                VMError.guarantee((boolean)(allocatableValue instanceof RegisterValue));
                switch (n2) {
                    case 0: {
                        interpreterDataAMD64.setAbiFpArg0(l2);
                        break;
                    }
                    case 1: {
                        interpreterDataAMD64.setAbiFpArg1(l2);
                        break;
                    }
                    case 2: {
                        interpreterDataAMD64.setAbiFpArg2(l2);
                        break;
                    }
                    case 3: {
                        interpreterDataAMD64.setAbiFpArg3(l2);
                        break;
                    }
                    case 4: {
                        interpreterDataAMD64.setAbiFpArg4(l2);
                        break;
                    }
                    case 5: {
                        interpreterDataAMD64.setAbiFpArg5(l2);
                        break;
                    }
                    case 6: {
                        interpreterDataAMD64.setAbiFpArg6(l2);
                        break;
                    }
                    case 7: {
                        interpreterDataAMD64.setAbiFpArg7(l2);
                    }
                }
            } else {
                StackSlot stackSlot = (StackSlot)allocatableValue;
                Pointer pointer2 = (Pointer)WordFactory.pointer((long)interpreterDataAMD64.getAbiSpReg());
                int n3 = stackSlot.getOffset(0);
                VMError.guarantee((boolean)pointer2.isNonNull());
                VMError.guarantee(((long)n3 < interpreterDataAMD64.getStackSize() ? 1 : 0) != 0);
                pointer2.writeLong(n3, l2);
            }
        }

        @Override
        public long a(Pointer pointer) {
            return ((InterpreterDataAMD64)pointer).getAbiGpRet();
        }

        @Override
        public void a(Pointer pointer, long l2) {
            ((InterpreterDataAMD64)pointer).setAbiGpRet(l2);
        }

        @Override
        public long b(Pointer pointer) {
            return ((InterpreterDataAMD64)pointer).getAbiFpRet();
        }

        @Override
        public void b(Pointer pointer, long l2) {
            ((InterpreterDataAMD64)pointer).setAbiFpRet(l2);
        }

        @Override
        @Fold
        public int allocateStubDataSize() {
            return AMD64InterpreterStubs.aC();
        }
    }

    public static class c
    extends SubstrateAMD64Backend.SubstrateAMD64FrameContext {
        public c(SharedMethod sharedMethod, CallingConvention callingConvention) {
            super(sharedMethod, callingConvention);
        }

        public void enter(CompilationResultBuilder compilationResultBuilder) {
            super.enter(compilationResultBuilder);
            AMD64MacroAssembler aMD64MacroAssembler = (AMD64MacroAssembler)compilationResultBuilder.asm;
            RegisterArray registerArray = AMD64InterpreterStubs.aJ().getJavaGeneralParameterRegs();
            aMD64MacroAssembler.movq(new AMD64Address(AMD64.rsp, 0), registerArray.get(1));
            aMD64MacroAssembler.movq(new AMD64Address(AMD64.rsp, 8), registerArray.get(2));
            aMD64MacroAssembler.movq(new AMD64Address(AMD64.rsp, 16), registerArray.get(3));
            aMD64MacroAssembler.subq(AMD64.rsp, registerArray.get(2));
        }

        public void leave(CompilationResultBuilder compilationResultBuilder) {
            AMD64MacroAssembler aMD64MacroAssembler = (AMD64MacroAssembler)compilationResultBuilder.asm;
            RegisterArray registerArray = AMD64InterpreterStubs.aJ().getJavaGeneralParameterRegs();
            RegisterArray registerArray2 = AMD64InterpreterStubs.aJ().getFloatingPointParameterRegs();
            Register register = AMD64.r10;
            aMD64MacroAssembler.movq(register, AMD64.rax);
            aMD64MacroAssembler.movq(AMD64.rax, registerArray.get(1));
            Register register2 = AMD64.r11;
            aMD64MacroAssembler.movq(register2, registerArray.get(2));
            Label label = new Label();
            aMD64MacroAssembler.testq(register2, register2);
            aMD64MacroAssembler.jccb(AMD64Assembler.ConditionFlag.Zero, label);
            Register register3 = AMD64.r12;
            Register register4 = AMD64.r13;
            aMD64MacroAssembler.movq(register4, new AMD64Address(AMD64.rax, AMD64InterpreterStubs.offsetAbiSpReg()));
            aMD64MacroAssembler.movq(register3, AMD64.rsp);
            int n2 = 8;
            Label label2 = new Label();
            aMD64MacroAssembler.bind(label2);
            aMD64MacroAssembler.movq(registerArray.get(4), new AMD64Address(register4, 0));
            aMD64MacroAssembler.movq(new AMD64Address(register3, 0), registerArray.get(4));
            aMD64MacroAssembler.addq(register4, n2);
            aMD64MacroAssembler.addq(register3, n2);
            aMD64MacroAssembler.subl(register2, n2);
            aMD64MacroAssembler.testq(register2, register2);
            aMD64MacroAssembler.jccb(AMD64Assembler.ConditionFlag.NotZero, label2);
            aMD64MacroAssembler.bind(label);
            aMD64MacroAssembler.movq(registerArray2.get(0), new AMD64Address(AMD64.rax, AMD64InterpreterStubs.offsetAbiFpArg0()));
            aMD64MacroAssembler.movq(registerArray2.get(1), new AMD64Address(AMD64.rax, AMD64InterpreterStubs.offsetAbiFpArg1()));
            aMD64MacroAssembler.movq(registerArray2.get(2), new AMD64Address(AMD64.rax, AMD64InterpreterStubs.offsetAbiFpArg2()));
            aMD64MacroAssembler.movq(registerArray2.get(3), new AMD64Address(AMD64.rax, AMD64InterpreterStubs.offsetAbiFpArg3()));
            if (Platform.includedIn(Platform.LINUX.class) || Platform.includedIn(Platform.DARWIN.class)) {
                aMD64MacroAssembler.movq(registerArray2.get(4), new AMD64Address(AMD64.rax, AMD64InterpreterStubs.offsetAbiFpArg4()));
                aMD64MacroAssembler.movq(registerArray2.get(5), new AMD64Address(AMD64.rax, AMD64InterpreterStubs.offsetAbiFpArg5()));
                aMD64MacroAssembler.movq(registerArray2.get(6), new AMD64Address(AMD64.rax, AMD64InterpreterStubs.offsetAbiFpArg6()));
                aMD64MacroAssembler.movq(registerArray2.get(7), new AMD64Address(AMD64.rax, AMD64InterpreterStubs.offsetAbiFpArg7()));
            }
            aMD64MacroAssembler.movq(registerArray.get(0), new AMD64Address(AMD64.rax, AMD64InterpreterStubs.offsetAbiGp0()));
            aMD64MacroAssembler.movq(registerArray.get(1), new AMD64Address(AMD64.rax, AMD64InterpreterStubs.offsetAbiGp1()));
            aMD64MacroAssembler.movq(registerArray.get(2), new AMD64Address(AMD64.rax, AMD64InterpreterStubs.offsetAbiGp2()));
            aMD64MacroAssembler.movq(registerArray.get(3), new AMD64Address(AMD64.rax, AMD64InterpreterStubs.offsetAbiGp3()));
            aMD64MacroAssembler.movq(registerArray.get(4), new AMD64Address(AMD64.rax, AMD64InterpreterStubs.offsetAbiGp4()));
            aMD64MacroAssembler.movq(registerArray.get(5), new AMD64Address(AMD64.rax, AMD64InterpreterStubs.offsetAbiGp5()));
            aMD64MacroAssembler.call(register);
            Register register5 = AMD64.r10;
            aMD64MacroAssembler.movq(register5, AMD64.rax);
            aMD64MacroAssembler.movq(AMD64.r12, new AMD64Address(AMD64.rsp, 0));
            assert (compilationResultBuilder.target.stackAlignment == 16);
            aMD64MacroAssembler.shrq(AMD64.r12, 52);
            aMD64MacroAssembler.addq(AMD64.rsp, AMD64.r12);
            aMD64MacroAssembler.movq(AMD64.rax, new AMD64Address(AMD64.rsp, 0));
            aMD64MacroAssembler.movq(new AMD64Address(AMD64.rax, AMD64InterpreterStubs.offsetAbiGpRet()), register5);
            aMD64MacroAssembler.movq(new AMD64Address(AMD64.rax, AMD64InterpreterStubs.offsetAbiFpRet()), AMD64.xmm0);
            super.leave(compilationResultBuilder);
        }
    }

    public static class b
    extends SubstrateAMD64Backend.SubstrateAMD64FrameContext {
        public b(SharedMethod sharedMethod, CallingConvention callingConvention) {
            super(sharedMethod, callingConvention);
        }

        private static AMD64Address m(int n2) {
            int n3 = 16;
            return new AMD64Address(AMD64.rsp, n3 + n2);
        }

        public void enter(CompilationResultBuilder compilationResultBuilder) {
            AMD64MacroAssembler aMD64MacroAssembler = (AMD64MacroAssembler)compilationResultBuilder.asm;
            Register register = cV;
            Register register2 = AMD64.r11;
            aMD64MacroAssembler.movq(register2, AMD64.rsp);
            super.enter(compilationResultBuilder);
            aMD64MacroAssembler.movq(b.m(AMD64InterpreterStubs.offsetAbiSpReg()), register2);
            RegisterArray registerArray = AMD64InterpreterStubs.aJ().getJavaGeneralParameterRegs();
            VMError.guarantee((registerArray.size() == 6 ? 1 : 0) != 0);
            aMD64MacroAssembler.movq(b.m(AMD64InterpreterStubs.offsetAbiGp0()), registerArray.get(0));
            aMD64MacroAssembler.movq(b.m(AMD64InterpreterStubs.offsetAbiGp1()), registerArray.get(1));
            aMD64MacroAssembler.movq(b.m(AMD64InterpreterStubs.offsetAbiGp2()), registerArray.get(2));
            aMD64MacroAssembler.movq(b.m(AMD64InterpreterStubs.offsetAbiGp3()), registerArray.get(3));
            aMD64MacroAssembler.movq(b.m(AMD64InterpreterStubs.offsetAbiGp4()), registerArray.get(4));
            aMD64MacroAssembler.movq(b.m(AMD64InterpreterStubs.offsetAbiGp5()), registerArray.get(5));
            RegisterArray registerArray2 = AMD64InterpreterStubs.aJ().getFloatingPointParameterRegs();
            aMD64MacroAssembler.movq(b.m(AMD64InterpreterStubs.offsetAbiFpArg0()), registerArray2.get(0));
            aMD64MacroAssembler.movq(b.m(AMD64InterpreterStubs.offsetAbiFpArg1()), registerArray2.get(1));
            aMD64MacroAssembler.movq(b.m(AMD64InterpreterStubs.offsetAbiFpArg2()), registerArray2.get(2));
            aMD64MacroAssembler.movq(b.m(AMD64InterpreterStubs.offsetAbiFpArg3()), registerArray2.get(3));
            if (Platform.includedIn(Platform.LINUX.class) || Platform.includedIn(Platform.DARWIN.class)) {
                VMError.guarantee((registerArray2.size() == 8 ? 1 : 0) != 0);
                aMD64MacroAssembler.movq(b.m(AMD64InterpreterStubs.offsetAbiFpArg4()), registerArray2.get(4));
                aMD64MacroAssembler.movq(b.m(AMD64InterpreterStubs.offsetAbiFpArg5()), registerArray2.get(5));
                aMD64MacroAssembler.movq(b.m(AMD64InterpreterStubs.offsetAbiFpArg6()), registerArray2.get(6));
                aMD64MacroAssembler.movq(b.m(AMD64InterpreterStubs.offsetAbiFpArg7()), registerArray2.get(7));
            } else {
                assert (Platform.includedIn(Platform.WINDOWS.class));
                VMError.guarantee((registerArray2.size() == 4 ? 1 : 0) != 0);
            }
            aMD64MacroAssembler.movq(registerArray.get(1), AMD64.rsp);
            aMD64MacroAssembler.addq(registerArray.get(1), 16);
            aMD64MacroAssembler.movq(registerArray.get(0), register);
        }

        public void leave(CompilationResultBuilder compilationResultBuilder) {
            AMD64MacroAssembler aMD64MacroAssembler = (AMD64MacroAssembler)compilationResultBuilder.asm;
            aMD64MacroAssembler.movq(AMD64.xmm0, new AMD64Address(AMD64.rax, AMD64InterpreterStubs.offsetAbiFpRet()));
            aMD64MacroAssembler.movq(AMD64.rax, new AMD64Address(AMD64.rax, AMD64InterpreterStubs.offsetAbiGpRet()));
            super.leave(compilationResultBuilder);
        }
    }
}

