/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.enterprise.core;

import com.oracle.svm.core.IsolateArgumentAccess;
import com.oracle.svm.core.IsolateArgumentParser;
import com.oracle.svm.core.IsolateArguments;
import com.oracle.svm.core.NeverInline;
import com.oracle.svm.core.SubstrateGCOptions;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.VMInspectionOptions;
import com.oracle.svm.core.genscavenge.HeapParameters;
import com.oracle.svm.core.graal.snippets.CEntryPointSnippets;
import com.oracle.svm.core.graal.stackvalue.UnsafeStackValue;
import com.oracle.svm.core.heap.Heap;
import com.oracle.svm.core.heap.OutOfMemoryUtil;
import com.oracle.svm.core.heap.ReferenceAccess;
import com.oracle.svm.core.heap.RestrictHeapAccess;
import com.oracle.svm.core.locks.VMMutex;
import com.oracle.svm.core.log.Log;
import com.oracle.svm.core.memory.NullableNativeMemory;
import com.oracle.svm.core.nmt.NativeMemoryTracking;
import com.oracle.svm.core.nmt.NmtCategory;
import com.oracle.svm.core.option.RuntimeOptionKey;
import com.oracle.svm.core.os.ChunkBasedCommittedMemoryProvider;
import com.oracle.svm.core.os.ImageHeapProvider;
import com.oracle.svm.core.os.VirtualMemoryProvider;
import com.oracle.svm.core.snippets.KnownIntrinsics;
import com.oracle.svm.core.thread.VMOperation;
import com.oracle.svm.core.util.PointerUtils;
import com.oracle.svm.core.util.UnsignedUtils;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.enterprise.core.auximage.AuxiliaryImageLoader;
import com.oracle.svm.enterprise.core.auximage.AuxiliaryImageProvider;
import com.oracle.svm.enterprise.core.bc;
import com.oracle.svm.enterprise.core.g;
import jdk.graal.compiler.api.replacements.Fold;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.StackValue;
import org.graalvm.nativeimage.c.struct.RawField;
import org.graalvm.nativeimage.c.struct.RawStructure;
import org.graalvm.nativeimage.c.struct.SizeOf;
import org.graalvm.nativeimage.c.type.CCharPointer;
import org.graalvm.nativeimage.c.type.WordPointer;
import org.graalvm.word.ComparableWord;
import org.graalvm.word.Pointer;
import org.graalvm.word.PointerBase;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordBase;
import org.graalvm.word.WordFactory;

public class EnterpriseAddressRangeCommittedMemoryProvider
extends ChunkBasedCommittedMemoryProvider {
    private static final long bH = 0x800000000L;
    private static final int bI = 0;
    private static final int bJ = 1;
    private static final int bK = 2;
    private static final OutOfMemoryError bL = new OutOfMemoryError("Could not allocate node for free list, OS may be out of memory.");
    private static final OutOfMemoryError bM = new OutOfMemoryError("Could not allocate an aligned heap chunk because the heap address space is exhausted. Consider re-building the image with compressed references disabled ('-H:-UseCompressedReferences').");
    private static final OutOfMemoryError bN = new OutOfMemoryError("Could not allocate an unaligned heap chunk because the heap address space is exhausted. Consider re-building the image with compressed references disabled ('-H:-UseCompressedReferences').");
    private static final OutOfMemoryError bO = new OutOfMemoryError("Could not commit the memory for an aligned heap chunk, OS may be out of memory.");
    private static final OutOfMemoryError bP = new OutOfMemoryError("Could not commit the memory for an unaligned heap chunk, OS may be out of memory.");
    private final VMMutex bQ = new VMMutex("freeList");
    private FreeListNode bR;
    private long bS;
    private FreeListNode bT;
    private long bU;
    private UnsignedWord bV;
    private Pointer bW;
    private UnsignedWord bX;

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public EnterpriseAddressRangeCommittedMemoryProvider() {
        assert (((Boolean)SubstrateOptions.SpawnIsolates.getValue()).booleanValue());
    }

    @Uninterruptible(reason="Still being initialized.")
    public int initialize(WordPointer wordPointer, IsolateArguments isolateArguments) {
        CCharPointer cCharPointer;
        WordPointer wordPointer2;
        int n2;
        UnsignedWord unsignedWord;
        UnsignedWord unsignedWord2 = ReferenceAccess.singleton().getAddressSpaceSize();
        UnsignedWord unsignedWord3 = WordFactory.unsigned((long)IsolateArgumentAccess.readLong((IsolateArguments)isolateArguments, (int)IsolateArgumentParser.getOptionIndex((RuntimeOptionKey)SubstrateGCOptions.ReservedAddressSpaceSize)));
        if (unsignedWord3.equal(0)) {
            unsignedWord = WordFactory.unsigned((long)IsolateArgumentAccess.readLong((IsolateArguments)isolateArguments, (int)IsolateArgumentParser.getOptionIndex((RuntimeOptionKey)SubstrateGCOptions.MaxHeapSize))).multiply(2);
            unsignedWord3 = UnsignedUtils.clamp((UnsignedWord)unsignedWord, (UnsignedWord)WordFactory.unsigned((long)0x800000000L), (UnsignedWord)unsignedWord2);
        }
        if ((n2 = this.a(unsignedWord3, unsignedWord = WordFactory.unsigned((int)Heap.getHeap().getPreferredAddressSpaceAlignment()), isolateArguments, wordPointer2 = (WordPointer)StackValue.get(WordPointer.class))) != 0) {
            return n2;
        }
        Pointer pointer = (Pointer)wordPointer2.read();
        WordPointer wordPointer3 = (WordPointer)StackValue.get(WordPointer.class);
        int n3 = ImageHeapProvider.get().initialize(pointer, unsignedWord3, wordPointer, wordPointer3);
        if (n3 != 0) {
            this.a(pointer, unsignedWord3);
            return n3;
        }
        CEntryPointSnippets.setHeapBase((PointerBase)((PointerBase)wordPointer.read()));
        Pointer pointer2 = (Pointer)wordPointer3.read();
        Pointer pointer3 = PointerUtils.roundUp((PointerBase)((PointerBase)wordPointer3.read()), (UnsignedWord)this.getGranularity());
        UnsignedWord unsignedWord4 = unsignedWord3.subtract((UnsignedWord)pointer3.subtract((UnsignedWord)pointer));
        UnsignedWord unsignedWord5 = WordFactory.unsigned((long)IsolateArgumentAccess.readLong((IsolateArguments)isolateArguments, (int)IsolateArgumentParser.getOptionIndex(bc.AuxiliaryImageBytes)));
        if (unsignedWord5.equal((UnsignedWord)WordFactory.zero())) {
            unsignedWord5 = bc.getReservedAuxiliaryImageBytes();
        }
        if (unsignedWord5.aboveThan(0)) {
            if (unsignedWord5.aboveThan(unsignedWord4)) {
                this.a(pointer, unsignedWord3);
                return 17;
            }
            unsignedWord4 = unsignedWord5;
        }
        if ((cCharPointer = IsolateArgumentAccess.readCCharPointer((IsolateArguments)isolateArguments, (int)IsolateArgumentParser.getOptionIndex(bc.AuxiliaryImagePath))).isNonNull()) {
            WordPointer wordPointer4 = (WordPointer)StackValue.get(WordPointer.class);
            WordPointer wordPointer5 = (WordPointer)StackValue.get(WordPointer.class);
            n3 = AuxiliaryImageProvider.get().loadAuxiliaryImage(pointer3, unsignedWord4, cCharPointer, wordPointer4, wordPointer5);
            if (n3 != 0) {
                this.a(pointer, unsignedWord3);
                return n3;
            }
            pointer2 = (Pointer)wordPointer5.read();
        }
        if (unsignedWord5.aboveThan(0)) {
            AuxiliaryImageLoader.setAuxImageReservedSpace(pointer3, unsignedWord5);
            pointer2 = pointer3.add(unsignedWord5);
        }
        if ((n3 = EnterpriseAddressRangeCommittedMemoryProvider.a(pointer, unsignedWord3, pointer2 = PointerUtils.roundUp((PointerBase)pointer2, (UnsignedWord)this.getGranularity()))) != 0) {
            this.a(pointer, unsignedWord3);
        }
        return n3;
    }

    @NeverInline(value="Ensure a newly looked up value of EnterpriseAddressRangeCommittedMemoryProvider is used now that the image heap is initialized")
    @Uninterruptible(reason="Called from uninterruptible code.")
    private static int a(Pointer pointer, UnsignedWord unsignedWord, Pointer pointer2) {
        Object object;
        if (VMInspectionOptions.hasNativeMemoryTrackingSupport()) {
            object = ImageHeapProvider.get().getImageHeapAddressSpaceSize();
            UnsignedWord unsignedWord2 = unsignedWord.subtract((UnsignedWord)object);
            NativeMemoryTracking.singleton().trackReserve(unsignedWord2, NmtCategory.JavaHeap);
        }
        object = (EnterpriseAddressRangeCommittedMemoryProvider)ChunkBasedCommittedMemoryProvider.get();
        return ((EnterpriseAddressRangeCommittedMemoryProvider)((Object)object)).b(pointer, unsignedWord, pointer2);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private int b(Pointer pointer, UnsignedWord unsignedWord, Pointer pointer2) {
        this.bV = unsignedWord;
        this.bW = pointer2;
        this.bX = pointer.add(unsignedWord).subtract((UnsignedWord)pointer2);
        FreeListNode freeListNode = this.c(pointer2, this.bX);
        if (freeListNode.isNull()) {
            return 3;
        }
        this.bT = freeListNode;
        this.bU = 1L;
        this.bR = freeListNode;
        this.bS = 1L;
        return 0;
    }

    @Uninterruptible(reason="Still being initialized.")
    protected int a(UnsignedWord unsignedWord, UnsignedWord unsignedWord2, IsolateArguments isolateArguments, WordPointer wordPointer) {
        Pointer pointer = ImageSingletons.contains(g.class) ? g.singleton().a(unsignedWord, unsignedWord2) : VirtualMemoryProvider.get().reserve(unsignedWord, unsignedWord2, false);
        if (pointer.isNull()) {
            return 801;
        }
        wordPointer.write((WordBase)pointer);
        return 0;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    protected void a(Pointer pointer, UnsignedWord unsignedWord) {
        VirtualMemoryProvider.get().free((PointerBase)pointer, unsignedWord);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private FreeListNode b(Pointer pointer, UnsignedWord unsignedWord) {
        FreeListNode freeListNode = this.c(pointer, unsignedWord);
        if (freeListNode.isNull()) {
            throw bL;
        }
        return freeListNode;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private FreeListNode c(Pointer pointer, UnsignedWord unsignedWord) {
        FreeListNode freeListNode = (FreeListNode)NullableNativeMemory.calloc((UnsignedWord)SizeOf.unsigned(FreeListNode.class), (NmtCategory)NmtCategory.GC);
        if (freeListNode.isNonNull()) {
            this.a(freeListNode, pointer, unsignedWord);
        }
        return freeListNode;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static void a(FreeListNode freeListNode) {
        NullableNativeMemory.free((PointerBase)freeListNode);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static boolean a(UnsignedWord unsignedWord) {
        return unsignedWord.aboveOrEqual(EnterpriseAddressRangeCommittedMemoryProvider.minAllocationSize());
    }

    @Fold
    static UnsignedWord minAllocationSize() {
        return UnsignedUtils.min((UnsignedWord)HeapParameters.getAlignedHeapChunkSize(), (UnsignedWord)HeapParameters.getMinUnalignedChunkSize());
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private void a(FreeListNode freeListNode, Pointer pointer, UnsignedWord unsignedWord) {
        assert (UnsignedUtils.isAMultiple((UnsignedWord)pointer, (UnsignedWord)this.getGranularity()));
        assert (UnsignedUtils.isAMultiple((UnsignedWord)unsignedWord, (UnsignedWord)this.getGranularity()));
        assert (pointer.aboveOrEqual((UnsignedWord)this.bW));
        assert (unsignedWord.belowOrEqual(this.bX));
        assert (pointer.add(unsignedWord).belowOrEqual((UnsignedWord)this.bW.add(this.bX)));
        freeListNode.setStart(pointer);
        freeListNode.setSize(unsignedWord);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static Pointer b(FreeListNode freeListNode) {
        return freeListNode.getStart().add(freeListNode.getSize());
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private void a(FreeListNode freeListNode, Pointer pointer, Pointer pointer2) {
        assert (freeListNode.getCommittedStart().isNull() == freeListNode.getCommittedEnd().isNull());
        assert (pointer.isNull() == pointer2.isNull());
        if (pointer.isNull()) {
            return;
        }
        assert (pointer.aboveOrEqual((UnsignedWord)this.bW));
        assert (pointer.belowThan((UnsignedWord)pointer2));
        assert (PointerUtils.isAMultiple((PointerBase)pointer, (UnsignedWord)this.getGranularity()));
        assert (PointerUtils.isAMultiple((PointerBase)pointer2, (UnsignedWord)this.getGranularity()));
        assert (pointer2.subtract((UnsignedWord)pointer).belowOrEqual(this.bX));
        Pointer pointer3 = EnterpriseAddressRangeCommittedMemoryProvider.b(freeListNode);
        if (pointer.aboveOrEqual((UnsignedWord)pointer3) || pointer2.belowOrEqual((UnsignedWord)freeListNode.getStart())) {
            return;
        }
        Pointer pointer4 = (Pointer)PointerUtils.max((PointerBase)pointer, (PointerBase)freeListNode.getStart());
        Pointer pointer5 = (Pointer)PointerUtils.min((PointerBase)pointer2, (PointerBase)pointer3);
        if (freeListNode.getCommittedStart().isNull() || pointer4.belowThan((UnsignedWord)freeListNode.getCommittedStart())) {
            freeListNode.setCommittedStart(pointer4);
        }
        if (freeListNode.getCommittedEnd().isNull() || pointer5.aboveThan((UnsignedWord)freeListNode.getCommittedEnd())) {
            freeListNode.setCommittedEnd(pointer5);
        }
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private void c(FreeListNode freeListNode) {
        Pointer pointer = freeListNode.getCommittedStart();
        Pointer pointer2 = freeListNode.getCommittedEnd();
        if (pointer.isNonNull()) {
            freeListNode.setCommittedStart((Pointer)WordFactory.nullPointer());
            freeListNode.setCommittedEnd((Pointer)WordFactory.nullPointer());
            this.a(freeListNode, pointer, pointer2);
        }
    }

    @Uninterruptible(reason="Tear-down in progress.")
    public int tearDown() {
        FreeListNode freeListNode = this.bT;
        while (freeListNode.isNonNull()) {
            FreeListNode freeListNode2 = freeListNode.getUnusedNext();
            EnterpriseAddressRangeCommittedMemoryProvider.a(freeListNode);
            freeListNode = freeListNode2;
        }
        return this.a((PointerBase)KnownIntrinsics.heapBase());
    }

    @Uninterruptible(reason="Tear-down in progress.")
    protected int a(PointerBase pointerBase) {
        if (VirtualMemoryProvider.get().free(pointerBase, this.bV) != 0) {
            return 19;
        }
        return 0;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public Pointer allocateAlignedChunk(UnsignedWord unsignedWord, UnsignedWord unsignedWord2) {
        WordPointer wordPointer = (WordPointer)UnsafeStackValue.get(WordPointer.class);
        int n2 = this.a(unsignedWord, unsignedWord2, wordPointer);
        if (n2 == 0) {
            if (VMInspectionOptions.hasNativeMemoryTrackingSupport()) {
                NativeMemoryTracking.singleton().trackCommit(unsignedWord, NmtCategory.JavaHeap);
            }
            return (Pointer)wordPointer.read();
        }
        if (n2 == 1) {
            throw OutOfMemoryUtil.reportOutOfMemoryError((OutOfMemoryError)bM);
        }
        if (n2 == 2) {
            throw OutOfMemoryUtil.reportOutOfMemoryError((OutOfMemoryError)bO);
        }
        throw VMError.shouldNotReachHereAtRuntime();
    }

    public Pointer allocateUnalignedChunk(UnsignedWord unsignedWord) {
        WordPointer wordPointer = (WordPointer)UnsafeStackValue.get(WordPointer.class);
        int n2 = this.a(unsignedWord, EnterpriseAddressRangeCommittedMemoryProvider.getAlignmentForUnalignedChunks(), wordPointer);
        if (n2 == 0) {
            if (VMInspectionOptions.hasNativeMemoryTrackingSupport()) {
                NativeMemoryTracking.singleton().trackCommit(unsignedWord, NmtCategory.JavaHeap);
            }
            return (Pointer)wordPointer.read();
        }
        if (n2 == 1) {
            throw OutOfMemoryUtil.reportOutOfMemoryError((OutOfMemoryError)bN);
        }
        if (n2 == 2) {
            throw OutOfMemoryUtil.reportOutOfMemoryError((OutOfMemoryError)bP);
        }
        throw VMError.shouldNotReachHereAtRuntime();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Uninterruptible(reason="Entering a safepoint in this code can deadlock garbage collection.")
    private int a(UnsignedWord unsignedWord, UnsignedWord unsignedWord2, WordPointer wordPointer) {
        assert (unsignedWord.aboveThan(0));
        assert (unsignedWord2.aboveThan(0));
        this.bQ.lockNoTransitionUnspecifiedOwner();
        try {
            Pointer pointer;
            UnsignedWord unsignedWord3;
            FreeListNode freeListNode = (FreeListNode)WordFactory.nullPointer();
            FreeListNode freeListNode2 = (FreeListNode)WordFactory.nullPointer();
            UnsignedWord unsignedWord4 = UnsignedUtils.MAX_VALUE;
            FreeListNode freeListNode3 = (FreeListNode)WordFactory.nullPointer();
            FreeListNode freeListNode4 = this.bR;
            while (freeListNode4.isNonNull()) {
                unsignedWord3 = freeListNode4.getSize();
                if (unsignedWord3.aboveOrEqual(unsignedWord) && unsignedWord3.belowThan(unsignedWord4)) {
                    pointer = PointerUtils.roundUp((PointerBase)freeListNode4.getStart(), (UnsignedWord)unsignedWord2).subtract((UnsignedWord)freeListNode4.getStart());
                    if (unsignedWord3.subtract(unsignedWord).aboveOrEqual((UnsignedWord)pointer)) {
                        freeListNode2 = freeListNode3;
                        freeListNode = freeListNode4;
                        unsignedWord4 = unsignedWord3;
                        if (unsignedWord3.equal(unsignedWord)) break;
                    }
                }
                freeListNode3 = freeListNode4;
                freeListNode4 = freeListNode4.getAllocNext();
            }
            if (freeListNode.isNull()) {
                wordPointer.write((WordBase)WordFactory.nullPointer());
                int n2 = 1;
                return n2;
            }
            freeListNode3 = this.getGranularity();
            freeListNode4 = freeListNode.getStart();
            assert (PointerUtils.isAMultiple((PointerBase)freeListNode4, (UnsignedWord)freeListNode3));
            assert (UnsignedUtils.isAMultiple((UnsignedWord)unsignedWord4, (UnsignedWord)freeListNode3));
            unsignedWord3 = PointerUtils.roundUp((PointerBase)freeListNode4, (UnsignedWord)unsignedWord2);
            pointer = PointerUtils.roundDown((PointerBase)unsignedWord3, (UnsignedWord)freeListNode3);
            Pointer pointer2 = PointerUtils.roundUp((PointerBase)unsignedWord3.add(unsignedWord), (UnsignedWord)freeListNode3);
            Pointer pointer3 = pointer2.subtract((UnsignedWord)pointer);
            assert (pointer.aboveOrEqual((UnsignedWord)freeListNode4) && pointer2.belowOrEqual((UnsignedWord)freeListNode4.add(unsignedWord4)));
            int n3 = 3;
            Pointer pointer4 = VirtualMemoryProvider.get().commit((PointerBase)pointer, (UnsignedWord)pointer3, 3);
            if (pointer4.isNull()) {
                wordPointer.write((WordBase)WordFactory.nullPointer());
                int n4 = 2;
                return n4;
            }
            VMError.guarantee((boolean)pointer4.equal((UnsignedWord)pointer), (String)"Must not be mapped anywhere else.");
            Pointer pointer5 = pointer.subtract((UnsignedWord)freeListNode4);
            Pointer pointer6 = freeListNode4.add(unsignedWord4).subtract((UnsignedWord)pointer2);
            boolean bl2 = false;
            if (pointer5.aboveThan(0) && pointer6.aboveThan(0)) {
                if (EnterpriseAddressRangeCommittedMemoryProvider.a((UnsignedWord)pointer5)) {
                    this.b(freeListNode, pointer2, (UnsignedWord)pointer6);
                    this.d(freeListNode, freeListNode.getStart(), (UnsignedWord)pointer5);
                } else {
                    this.a(freeListNode, (UnsignedWord)pointer5);
                    this.d(freeListNode, pointer2, (UnsignedWord)pointer6);
                }
            } else if (pointer6.aboveThan(0)) {
                this.d(freeListNode, pointer2, (UnsignedWord)pointer6);
            } else if (pointer5.aboveThan(0)) {
                this.d(freeListNode, freeListNode.getStart(), (UnsignedWord)pointer5);
            } else {
                bl2 = true;
            }
            if (bl2 || !EnterpriseAddressRangeCommittedMemoryProvider.a(freeListNode.getSize())) {
                this.c(freeListNode, freeListNode2);
            }
            if (bl2) {
                this.d(freeListNode);
                EnterpriseAddressRangeCommittedMemoryProvider.a(freeListNode);
                freeListNode = (FreeListNode)WordFactory.nullPointer();
            }
            wordPointer.write((WordBase)unsignedWord3);
            int n5 = 0;
            return n5;
        }
        finally {
            this.bQ.unlockNoTransitionUnspecifiedOwner();
        }
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private void a(FreeListNode freeListNode, UnsignedWord unsignedWord) {
        FreeListNode freeListNode2 = this.b(freeListNode.getStart(), unsignedWord);
        this.a(freeListNode2, freeListNode.getCommittedStart(), freeListNode.getCommittedEnd());
        this.a(freeListNode2, freeListNode.getUnusedPrevious());
        assert (!EnterpriseAddressRangeCommittedMemoryProvider.a(unsignedWord));
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private void b(FreeListNode freeListNode, Pointer pointer, UnsignedWord unsignedWord) {
        FreeListNode freeListNode2 = this.b(pointer, unsignedWord);
        this.a(freeListNode2, freeListNode.getCommittedStart(), freeListNode.getCommittedEnd());
        this.a(freeListNode2, freeListNode);
        if (EnterpriseAddressRangeCommittedMemoryProvider.a(unsignedWord)) {
            this.b(freeListNode2, freeListNode);
        }
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private void a(FreeListNode freeListNode, FreeListNode freeListNode2) {
        FreeListNode freeListNode3;
        assert (freeListNode.isNonNull());
        assert (freeListNode.getUnusedNext().isNull());
        assert (freeListNode.getUnusedPrevious().isNull());
        if (freeListNode2.isNull()) {
            freeListNode3 = this.bT;
            this.bT = freeListNode;
        } else {
            freeListNode3 = freeListNode2.getUnusedNext();
            freeListNode2.setUnusedNext(freeListNode);
            freeListNode.setUnusedPrevious(freeListNode2);
        }
        if (freeListNode3.isNonNull()) {
            freeListNode3.setUnusedPrevious(freeListNode);
            freeListNode.setUnusedNext(freeListNode3);
        }
        ++this.bU;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private void d(FreeListNode freeListNode) {
        assert (freeListNode.isNonNull());
        FreeListNode freeListNode2 = freeListNode.getUnusedNext();
        FreeListNode freeListNode3 = freeListNode.getUnusedPrevious();
        if (freeListNode2.isNonNull()) {
            freeListNode2.setUnusedPrevious(freeListNode3);
        }
        if (freeListNode == this.bT) {
            this.bT = freeListNode2;
        } else {
            freeListNode3.setUnusedNext(freeListNode2);
        }
        --this.bU;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private void b(FreeListNode freeListNode, FreeListNode freeListNode2) {
        assert (freeListNode.isNonNull());
        assert (freeListNode.getAllocNext().isNull());
        if (freeListNode2.isNull()) {
            freeListNode.setAllocNext(this.bR);
            this.bR = freeListNode;
        } else {
            freeListNode.setAllocNext(freeListNode2.getAllocNext());
            freeListNode2.setAllocNext(freeListNode);
        }
        ++this.bS;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private void c(FreeListNode freeListNode, FreeListNode freeListNode2) {
        assert (freeListNode.isNonNull());
        if (freeListNode == this.bR) {
            assert (freeListNode2.isNull());
            this.bR = freeListNode.getAllocNext();
        } else {
            freeListNode2.setAllocNext(freeListNode.getAllocNext());
        }
        freeListNode.setAllocNext((FreeListNode)WordFactory.nullPointer());
        --this.bS;
    }

    public boolean areUnalignedChunksZeroed() {
        return true;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public void freeAlignedChunk(PointerBase pointerBase, UnsignedWord unsignedWord, UnsignedWord unsignedWord2) {
        if (VMInspectionOptions.hasNativeMemoryTrackingSupport()) {
            NativeMemoryTracking.singleton().trackUncommit(unsignedWord, NmtCategory.JavaHeap);
        }
        this.d((Pointer)pointerBase, unsignedWord);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public void freeUnalignedChunk(PointerBase pointerBase, UnsignedWord unsignedWord) {
        if (VMInspectionOptions.hasNativeMemoryTrackingSupport()) {
            NativeMemoryTracking.singleton().trackUncommit(unsignedWord, NmtCategory.JavaHeap);
        }
        this.d((Pointer)pointerBase, unsignedWord);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Uninterruptible(reason="Entering a safepoint in this code can deadlock garbage collection.")
    private void d(Pointer pointer, UnsignedWord unsignedWord) {
        assert (pointer.isNonNull());
        assert (unsignedWord.aboveThan(0));
        this.bQ.lockNoTransition();
        try {
            FreeListNode freeListNode;
            boolean bl2;
            FreeListNode freeListNode2;
            UnsignedWord unsignedWord2 = this.getGranularity();
            Pointer pointer2 = PointerUtils.roundDown((PointerBase)pointer, (UnsignedWord)unsignedWord2);
            FreeListNode freeListNode3 = (FreeListNode)WordFactory.nullPointer();
            FreeListNode freeListNode4 = this.bR;
            while (freeListNode4.isNonNull() && freeListNode4.getStart().belowThan((UnsignedWord)pointer2)) {
                freeListNode3 = freeListNode4;
                freeListNode4 = freeListNode4.getAllocNext();
            }
            FreeListNode freeListNode5 = freeListNode3;
            FreeListNode freeListNode6 = freeListNode2 = freeListNode5.isNull() ? this.bT : freeListNode5.getUnusedNext();
            while (freeListNode2.isNonNull() && freeListNode2.getStart().belowThan((UnsignedWord)pointer2)) {
                freeListNode5 = freeListNode2;
                freeListNode2 = freeListNode2.getUnusedNext();
            }
            Pointer pointer3 = PointerUtils.roundUp((PointerBase)pointer.add(unsignedWord), (UnsignedWord)unsignedWord2);
            Pointer pointer4 = pointer3.subtract((UnsignedWord)pointer2);
            assert (pointer4.aboveOrEqual(unsignedWord));
            assert (freeListNode5.isNull() || pointer2.aboveOrEqual((UnsignedWord)EnterpriseAddressRangeCommittedMemoryProvider.b(freeListNode5)));
            assert (freeListNode2.isNull() || pointer3.belowOrEqual((UnsignedWord)freeListNode2.getStart()));
            boolean bl3 = freeListNode5.isNonNull() && EnterpriseAddressRangeCommittedMemoryProvider.b(freeListNode5).equal((UnsignedWord)pointer2);
            boolean bl4 = bl2 = freeListNode2.isNonNull() && pointer3.equal((UnsignedWord)freeListNode2.getStart());
            if (bl3) {
                this.c(freeListNode5, pointer2, (UnsignedWord)pointer4);
                freeListNode = freeListNode5;
                if (bl2) {
                    this.c(freeListNode, freeListNode2.getStart(), freeListNode2.getSize());
                    this.a(freeListNode, freeListNode2.getCommittedStart(), freeListNode2.getCommittedEnd());
                    if (freeListNode4 == freeListNode2) {
                        freeListNode4 = freeListNode4.getAllocNext();
                        this.c(freeListNode2, freeListNode3);
                    }
                    this.d(freeListNode2);
                    EnterpriseAddressRangeCommittedMemoryProvider.a(freeListNode2);
                    freeListNode2 = (FreeListNode)WordFactory.nullPointer();
                }
            } else if (bl2) {
                this.c(freeListNode2, pointer2, (UnsignedWord)pointer4);
                freeListNode = freeListNode2;
            } else {
                FreeListNode freeListNode7 = this.b(pointer2, (UnsignedWord)pointer4);
                this.a(freeListNode7, freeListNode5);
                freeListNode = freeListNode7;
            }
            this.a(freeListNode, pointer2, pointer2.add((UnsignedWord)pointer4));
            if (EnterpriseAddressRangeCommittedMemoryProvider.a(freeListNode.getSize()) && freeListNode != freeListNode3 && freeListNode != freeListNode4) {
                this.b(freeListNode, freeListNode3);
            }
        }
        finally {
            this.bQ.unlock();
        }
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private void c(FreeListNode freeListNode, Pointer pointer, UnsignedWord unsignedWord) {
        assert (EnterpriseAddressRangeCommittedMemoryProvider.b(freeListNode).equal((UnsignedWord)pointer) || pointer.add(unsignedWord).equal((UnsignedWord)freeListNode.getStart())) : "must be adjacent";
        assert (UnsignedUtils.isAMultiple((UnsignedWord)unsignedWord, (UnsignedWord)this.getGranularity()));
        assert (unsignedWord.belowOrEqual(this.bV));
        Pointer pointer2 = (Pointer)PointerUtils.min((PointerBase)freeListNode.getStart(), (PointerBase)pointer);
        UnsignedWord unsignedWord2 = freeListNode.getSize().add(unsignedWord);
        this.a(freeListNode, pointer2, unsignedWord2);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private void d(FreeListNode freeListNode, Pointer pointer, UnsignedWord unsignedWord) {
        assert (unsignedWord.belowOrEqual(this.bV));
        assert (freeListNode.getStart().equal((UnsignedWord)pointer) && unsignedWord.belowThan(freeListNode.getSize()) || freeListNode.getStart().belowThan((UnsignedWord)pointer) && EnterpriseAddressRangeCommittedMemoryProvider.b(freeListNode).equal((UnsignedWord)pointer.add(unsignedWord)));
        this.a(freeListNode, pointer, unsignedWord);
        this.c(freeListNode);
    }

    @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, reason="Called by the GC.")
    public void beforeGarbageCollection() {
        assert (VMOperation.isGCInProgress()) : "must only be called by the GC";
        assert (!this.bQ.hasOwner()) : "Must not be locked -- is mutator code holding the lock?";
        if (((Boolean)SubstrateGCOptions.VerifyHeap.getValue()).booleanValue()) {
            this.aq();
        }
    }

    @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, reason="Called by the GC.")
    public void afterGarbageCollection() {
        assert (VMOperation.isGCInProgress()) : "must only be called by the GC";
    }

    @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, reason="Called by the GC.")
    public void uncommitUnusedMemory() {
        assert (VMOperation.isGCInProgress()) : "must only be called by the GC";
        assert (!this.bQ.hasOwner()) : "Must not be locked";
        this.ap();
    }

    private void ap() {
        FreeListNode freeListNode = this.bT;
        while (freeListNode.isNonNull()) {
            Pointer pointer = freeListNode.getCommittedStart();
            if (pointer.isNonNull()) {
                assert (pointer.aboveOrEqual((UnsignedWord)freeListNode.getStart()) && freeListNode.getCommittedEnd().belowOrEqual((UnsignedWord)EnterpriseAddressRangeCommittedMemoryProvider.b(freeListNode)));
                Pointer pointer2 = freeListNode.getCommittedEnd().subtract((UnsignedWord)pointer);
                if (VirtualMemoryProvider.get().uncommit((PointerBase)pointer, (UnsignedWord)pointer2) != 0) {
                    Log.log().string("Uncommitting ").unsigned((WordBase)pointer2).string(" bytes of unused memory at ").hex((WordBase)pointer).string(" failed. nodeStart=").zhex((WordBase)freeListNode.getStart()).string(", nodeEnd=").zhex((WordBase)EnterpriseAddressRangeCommittedMemoryProvider.b(freeListNode)).newline();
                    VMError.shouldNotReachHere((String)"Uncommitting memory failed.");
                }
                freeListNode.setCommittedStart((Pointer)WordFactory.nullPointer());
                freeListNode.setCommittedEnd((Pointer)WordFactory.nullPointer());
            }
            freeListNode = freeListNode.getUnusedNext();
        }
        if (((Boolean)SubstrateGCOptions.VerifyHeap.getValue()).booleanValue()) {
            this.aq();
        }
    }

    private void aq() {
        FreeListNode freeListNode;
        int n2 = 0;
        FreeListNode freeListNode2 = (FreeListNode)WordFactory.nullPointer();
        FreeListNode freeListNode3 = this.bT;
        while (freeListNode3.isNonNull()) {
            VMError.guarantee((boolean)freeListNode3.getUnusedPrevious().equal((ComparableWord)freeListNode2), (String)"Unused list previous-next node linkage must be consistent");
            VMError.guarantee((freeListNode2.isNull() || freeListNode3.getStart().aboveThan((UnsignedWord)EnterpriseAddressRangeCommittedMemoryProvider.b(freeListNode2)) ? 1 : 0) != 0, (String)"Unused blocks must not be adjacent or overlapping");
            VMError.guarantee((this.e(freeListNode3) == EnterpriseAddressRangeCommittedMemoryProvider.a(freeListNode3.getSize()) ? 1 : 0) != 0, (String)"Allocatable blocks must be in the alloc list");
            ++n2;
            freeListNode2 = freeListNode3;
            freeListNode3 = freeListNode3.getUnusedNext();
        }
        VMError.guarantee(((long)n2 == this.bU ? 1 : 0) != 0, (String)"Number of unused list nodes must match recorded count");
        int n3 = 0;
        if (freeListNode2.isNonNull()) {
            FreeListNode freeListNode4 = freeListNode2;
            ++n3;
            freeListNode = freeListNode4.getUnusedPrevious();
            while (freeListNode.isNonNull()) {
                VMError.guarantee((boolean)freeListNode.getUnusedNext().equal((ComparableWord)freeListNode4), (String)"Unused list previous-next node linkage must be consistent");
                VMError.guarantee((boolean)freeListNode4.getStart().aboveThan((UnsignedWord)EnterpriseAddressRangeCommittedMemoryProvider.b(freeListNode)), (String)"Unused blocks must not be adjacent or overlapping");
                ++n3;
                freeListNode4 = freeListNode;
                freeListNode = freeListNode.getUnusedPrevious();
            }
            VMError.guarantee((freeListNode4 == this.bT ? 1 : 0) != 0, (String)"Unused list reverse iteration must terminate at list head");
        }
        VMError.guarantee((n2 == n3 ? 1 : 0) != 0, (String)"Number of unused list nodes must be the same for forward and reverse iteration");
        int n4 = 0;
        freeListNode = (FreeListNode)WordFactory.nullPointer();
        FreeListNode freeListNode5 = this.bR;
        while (freeListNode5.isNonNull()) {
            VMError.guarantee((freeListNode.isNull() || freeListNode5.getStart().aboveThan((UnsignedWord)EnterpriseAddressRangeCommittedMemoryProvider.b(freeListNode)) ? 1 : 0) != 0, (String)"Allocatable blocks must not be adjacent or overlapping");
            VMError.guarantee((boolean)EnterpriseAddressRangeCommittedMemoryProvider.a(freeListNode5.getSize()), (String)"Allocatable blocks must satisfy minimum allocatable size");
            ++n4;
            freeListNode = freeListNode5;
            freeListNode5 = freeListNode5.getAllocNext();
        }
        VMError.guarantee((this.bR.isNull() || this.bT.equal((ComparableWord)this.bR) || EnterpriseAddressRangeCommittedMemoryProvider.b(this.bT).belowOrEqual((UnsignedWord)this.bR.getStart()) ? 1 : 0) != 0, (String)"First unused block must start before first allocatable block, or be allocatable itself");
        VMError.guarantee((n4 <= n2 ? 1 : 0) != 0, (String)"Allocation list must not be longer than unused list");
        VMError.guarantee(((long)n4 == this.bS ? 1 : 0) != 0, (String)"Number of allocation list nodes must match recorded count");
    }

    private boolean e(FreeListNode freeListNode) {
        FreeListNode freeListNode2 = this.bR;
        while (freeListNode2.isNonNull() && freeListNode2.getStart().belowOrEqual((UnsignedWord)freeListNode.getStart())) {
            if (freeListNode2.equal((ComparableWord)freeListNode)) {
                return true;
            }
            freeListNode2 = freeListNode2.getAllocNext();
        }
        return false;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    protected UnsignedWord ar() {
        return this.bV;
    }

    @RawStructure
    private static interface FreeListNode
    extends PointerBase {
        @RawField
        public Pointer getStart();

        @RawField
        public void setStart(Pointer var1);

        @RawField
        public UnsignedWord getSize();

        @RawField
        public void setSize(UnsignedWord var1);

        @RawField
        public Pointer getCommittedStart();

        @RawField
        public void setCommittedStart(Pointer var1);

        @RawField
        public Pointer getCommittedEnd();

        @RawField
        public void setCommittedEnd(Pointer var1);

        @RawField
        public FreeListNode getAllocNext();

        @RawField
        public void setAllocNext(FreeListNode var1);

        @RawField
        public FreeListNode getUnusedPrevious();

        @RawField
        public void setUnusedPrevious(FreeListNode var1);

        @RawField
        public FreeListNode getUnusedNext();

        @RawField
        public void setUnusedNext(FreeListNode var1);
    }

    public static final class a {
        public static void a(EnterpriseAddressRangeCommittedMemoryProvider enterpriseAddressRangeCommittedMemoryProvider, Pointer pointer, UnsignedWord unsignedWord, Pointer pointer2) {
            enterpriseAddressRangeCommittedMemoryProvider.b(pointer, unsignedWord, pointer2);
        }

        public static void a(EnterpriseAddressRangeCommittedMemoryProvider enterpriseAddressRangeCommittedMemoryProvider) {
            VMError.guarantee((enterpriseAddressRangeCommittedMemoryProvider.bU == 1L ? 1 : 0) != 0, (String)"more than one unused node");
            VMError.guarantee((enterpriseAddressRangeCommittedMemoryProvider.bS == 1L ? 1 : 0) != 0, (String)"more than one alloc node");
            VMError.guarantee((enterpriseAddressRangeCommittedMemoryProvider.bR == enterpriseAddressRangeCommittedMemoryProvider.bT ? 1 : 0) != 0, (String)"different nodes");
            VMError.guarantee((boolean)enterpriseAddressRangeCommittedMemoryProvider.bT.getStart().equal((UnsignedWord)enterpriseAddressRangeCommittedMemoryProvider.bW), (String)"begin is incorrect");
            VMError.guarantee((boolean)enterpriseAddressRangeCommittedMemoryProvider.bT.getSize().equal(enterpriseAddressRangeCommittedMemoryProvider.bX), (String)"size is incorrect");
            VMError.guarantee((boolean)enterpriseAddressRangeCommittedMemoryProvider.bT.getCommittedStart().isNull(), (String)"committed start is incorrect");
            VMError.guarantee((boolean)enterpriseAddressRangeCommittedMemoryProvider.bT.getCommittedEnd().isNull(), (String)"committed end is incorrect");
        }

        public static void b(EnterpriseAddressRangeCommittedMemoryProvider enterpriseAddressRangeCommittedMemoryProvider) {
            VMError.guarantee((enterpriseAddressRangeCommittedMemoryProvider.bU == 0L ? 1 : 0) != 0, (String)"there must not be any nodes left");
            VMError.guarantee((enterpriseAddressRangeCommittedMemoryProvider.bS == 0L ? 1 : 0) != 0, (String)"there must not be any nodes left");
            VMError.guarantee((boolean)enterpriseAddressRangeCommittedMemoryProvider.bR.isNull(), (String)"must be null");
            VMError.guarantee((boolean)enterpriseAddressRangeCommittedMemoryProvider.bT.isNull(), (String)"must be null");
        }

        public static Pointer a(EnterpriseAddressRangeCommittedMemoryProvider enterpriseAddressRangeCommittedMemoryProvider, UnsignedWord unsignedWord, UnsignedWord unsignedWord2) {
            WordPointer wordPointer = (WordPointer)UnsafeStackValue.get(WordPointer.class);
            enterpriseAddressRangeCommittedMemoryProvider.a(unsignedWord, unsignedWord2, wordPointer);
            return (Pointer)wordPointer.read();
        }

        public static void a(EnterpriseAddressRangeCommittedMemoryProvider enterpriseAddressRangeCommittedMemoryProvider, Pointer pointer, UnsignedWord unsignedWord) {
            enterpriseAddressRangeCommittedMemoryProvider.d(pointer, unsignedWord);
        }

        public static void c(EnterpriseAddressRangeCommittedMemoryProvider enterpriseAddressRangeCommittedMemoryProvider) {
            enterpriseAddressRangeCommittedMemoryProvider.ap();
        }
    }
}

