/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.aotjs.wasm.gc;

import com.oracle.svm.aotjs.platform.e;
import com.oracle.svm.core.AlwaysInline;
import com.oracle.svm.core.FrameAccess;
import com.oracle.svm.core.JavaMemoryUtil;
import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.UnmanagedMemoryUtil;
import com.oracle.svm.core.genscavenge.graal.nodes.FormatArrayNode;
import com.oracle.svm.core.genscavenge.graal.nodes.FormatObjectNode;
import com.oracle.svm.core.heap.ObjectVisitor;
import com.oracle.svm.core.heap.RestrictHeapAccess;
import com.oracle.svm.core.hub.DynamicHub;
import com.oracle.svm.core.hub.LayoutEncoding;
import com.oracle.svm.core.log.Log;
import com.oracle.svm.core.option.HostedOptionKey;
import com.oracle.svm.core.snippets.SubstrateForeignCallTarget;
import com.oracle.svm.core.util.UnsignedUtils;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.aotjs.wasm.gc.ae;
import com.oracle.svm.hosted.aotjs.wasm.gc.af;
import com.oracle.svm.hosted.aotjs.wasm.gc.aj;
import com.oracle.svm.hosted.aotjs.wasm.gc.ap;
import com.oracle.svm.hosted.aotjs.wasm.nodes.n;
import jdk.graal.compiler.api.replacements.Fold;
import jdk.graal.compiler.nodes.extended.BranchProbabilityNode;
import jdk.graal.compiler.options.OptionKey;
import jdk.graal.compiler.options.OptionValues;
import jdk.graal.compiler.replacements.AllocationSnippets;
import jdk.graal.compiler.word.Word;
import org.graalvm.collections.UnmodifiableEconomicMap;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.StackValue;
import org.graalvm.nativeimage.c.struct.RawField;
import org.graalvm.nativeimage.c.struct.RawStructure;
import org.graalvm.word.Pointer;
import org.graalvm.word.PointerBase;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordBase;
import org.graalvm.word.WordFactory;

public final class ac {
    private static final OutOfMemoryError AH = new OutOfMemoryError("Could not allocate memory");
    private static final UnsignedWord AI = WordFactory.unsigned((int)7);
    private static final UnsignedWord AJ = WordFactory.unsigned((int)1);
    private static final UnsignedWord AK = WordFactory.unsigned((int)2);
    private static final UnsignedWord AL = AI.not();
    private static final UnsignedWord AM = WordFactory.unsigned((int)8);
    private static final UnsignedWord AN = ac.h(AM);
    private static final UnsignedWord AO = ac.j(b.AR);

    @Fold
    public static boolean shouldVerify() {
        return (Boolean)c.AS.getValue();
    }

    @Fold
    public static byte getFillByte() {
        assert (((Boolean)c.AT.getValue()).booleanValue());
        return (byte)(ac.shouldVerify() ? 205 : 0);
    }

    @com.oracle.svm.hosted.aotjs.wasm.annotation.a(dM="malloc", dN="Allocate unmanaged memory")
    @Platforms(value={e.class})
    public static Pointer d(UnsignedWord unsignedWord) {
        return ac.m(unsignedWord);
    }

    @com.oracle.svm.hosted.aotjs.wasm.annotation.a(dM="free", dN="Free memory allocated with malloc")
    @Platforms(value={e.class})
    public static void c(Pointer pointer) {
        ac.i(pointer);
    }

    @Uninterruptible(reason="Runs while module is constructed", callerMustBe=true)
    @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, reason="Allocator not yet initialized")
    static void dj() {
        Pointer pointer;
        Pointer pointer2 = com.oracle.svm.hosted.aotjs.wasm.gc.c.hp();
        VMError.guarantee((pointer2 == (pointer = com.oracle.svm.hosted.aotjs.wasm.gc.c.hq()) ? 1 : 0) != 0, (String)"Allocator must start out completely empty");
        if (ac.e(com.oracle.svm.hosted.aotjs.wasm.gc.c.pageSize()).isNull()) {
            n.trap();
        }
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, reason="Allocator may be in inconsistent state")
    static Pointer e(UnsignedWord unsignedWord) {
        Pointer pointer = com.oracle.svm.hosted.aotjs.wasm.gc.c.hq();
        Pointer pointer2 = com.oracle.svm.hosted.aotjs.wasm.gc.c.b((Pointer)com.oracle.svm.hosted.aotjs.wasm.gc.c.a((UnsignedWord)pointer.add(unsignedWord)));
        if (pointer2.isNull()) {
            return (Pointer)WordFactory.nullPointer();
        }
        Pointer pointer3 = pointer2.subtract((UnsignedWord)pointer);
        d.AV += pointer3.rawValue();
        ac.b(pointer, (UnsignedWord)pointer3);
        b.n(pointer);
        return pointer;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static void f(UnsignedWord unsignedWord) {
        if (ac.shouldVerify()) {
            ac.g(unsignedWord);
        }
    }

    @Uninterruptible(reason="Executes interruptible code if the validation fails.", callerMustBe=true, calleeMustBe=false)
    private static void g(UnsignedWord unsignedWord) {
        UnsignedWord unsignedWord2 = unsignedWord.and(AL);
        boolean bl = unsignedWord.and(AJ).notEqual(0);
        VMError.guarantee((boolean)ac.i(unsignedWord2), (String)"Size is not aligned");
        VMError.guarantee((boolean)ac.i(ac.j(unsignedWord2)), (String)"Inner size is not aligned");
        if (unsignedWord2.aboveThan((UnsignedWord)com.oracle.svm.hosted.aotjs.wasm.gc.c.hq().subtract((UnsignedWord)com.oracle.svm.hosted.aotjs.wasm.gc.c.hp()))) {
            Log.log().string("Block size is larger than allocator region: ").hex((WordBase)unsignedWord2).newline();
            throw VMError.shouldNotReachHereAtRuntime();
        }
        if (unsignedWord2.belowThan(b.AR)) {
            Log.log().string("Block size is too small: ").hex((WordBase)unsignedWord2).string(bl ? " (allocated)" : " (free)").string(". Must be at least ").unsigned((WordBase)b.AR).string("B").newline();
            throw VMError.shouldNotReachHereAtRuntime();
        }
        if (!bl) {
            VMError.guarantee((boolean)unsignedWord.and(AK).equal(0), (String)"Free block is marked as object");
        }
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static void hw() {
        if (!ac.shouldVerify()) {
            return;
        }
        b.hD();
        Pointer pointer = com.oracle.svm.hosted.aotjs.wasm.gc.c.hp();
        long l2 = 0L;
        long l3 = 0L;
        while (pointer.belowThan((UnsignedWord)com.oracle.svm.hosted.aotjs.wasm.gc.c.hq())) {
            VMError.guarantee((boolean)ac.i((UnsignedWord)pointer), (String)"Block is not aligned");
            a a2 = (a)StackValue.get(a.class);
            ac.b(pointer, a2);
            if (a2.getAllocated()) {
                if (a2.getIsObject()) {
                    l2 += a2.getSize().rawValue();
                }
            } else {
                l3 += a2.getSize().rawValue();
            }
            if (!a2.getAllocated() && ((Boolean)c.AT.getValue()).booleanValue()) {
                UnsignedWord unsignedWord = b.AQ;
                while (unsignedWord.belowThan(ac.a(a2))) {
                    VMError.guarantee((ac.e(pointer).readByte((WordBase)unsignedWord) == ac.getFillByte() ? 1 : 0) != 0, (String)"Free block does not only contain fill bytes");
                    unsignedWord = unsignedWord.add(1);
                }
            }
            pointer = ac.a(pointer, a2);
        }
        VMError.guarantee((boolean)pointer.equal((UnsignedWord)com.oracle.svm.hosted.aotjs.wasm.gc.c.hq()), (String)"Last block does not point to allocator top");
        VMError.guarantee((l2 == d.AU ? 1 : 0) != 0, (String)"objectSize has wrong value in Statistics");
        VMError.guarantee((l3 == d.AV ? 1 : 0) != 0, (String)"freeSize has wrong value in Statistics");
    }

    @Uninterruptible(reason="Executes interruptible code.", calleeMustBe=false)
    @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, reason="Allocator state must not change")
    static void hx() {
        Log.log().string("Allocator state").newline();
        Log.log().string("Free size: ").unsigned(ac.hz()).newline();
        Log.log().string("Object size: ").unsigned(ac.hy()).newline();
        Pointer pointer = com.oracle.svm.hosted.aotjs.wasm.gc.c.hp();
        while (pointer.belowThan((UnsignedWord)com.oracle.svm.hosted.aotjs.wasm.gc.c.hq())) {
            a a2 = (a)StackValue.get(a.class);
            ac.b(pointer, a2);
            Log.log().hex((WordBase)pointer).string(" [").string(a2.getAllocated() ? "alloc" : " free").string("]");
            if (a2.getIsObject()) {
                int n2;
                Object object = ac.e(pointer).toObjectNonNull();
                if (ap.G(object)) {
                    n2 = 87;
                } else if (ap.I(object)) {
                    n2 = 71;
                } else if (ap.K(object)) {
                    n2 = 66;
                } else {
                    throw VMError.shouldNotReachHereUnexpectedInput((Object)object);
                }
                Log.log().string(" [").character((char)n2).string("] ").object(object);
            }
            Log.log().string(", size: ").hex((WordBase)a2.getSize()).newline();
            pointer = ac.a(pointer, a2);
        }
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static long hy() {
        return d.AU;
    }

    public static long hz() {
        return d.AV;
    }

    public static long hA() {
        return ac.hy() + ac.hz();
    }

    public static int hB() {
        return (int)(ac.hy() * 100L / ac.hA());
    }

    @Uninterruptible(reason="Reads allocator state")
    public static boolean d(Pointer pointer) {
        if (pointer.belowThan((UnsignedWord)com.oracle.svm.hosted.aotjs.wasm.gc.c.hp()) || pointer.aboveOrEqual((UnsignedWord)com.oracle.svm.hosted.aotjs.wasm.gc.c.hq())) {
            return false;
        }
        Pointer pointer2 = ac.f(pointer);
        a a2 = (a)StackValue.get(a.class);
        ac.b(pointer2, a2);
        return a2.getAllocated() && a2.getIsObject();
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static <T extends UnsignedWord> T h(T t2) {
        UnsignedWord unsignedWord = UnsignedUtils.roundUp(t2, (UnsignedWord)AM);
        return (T)unsignedWord;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static boolean i(UnsignedWord unsignedWord) {
        return UnsignedUtils.isAMultiple((UnsignedWord)unsignedWord, (UnsignedWord)AM);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static Pointer a(Pointer pointer, a a2) {
        return ac.a(pointer, a2.getSize());
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static Pointer a(Pointer pointer, UnsignedWord unsignedWord) {
        return pointer.add(unsignedWord);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static Pointer e(Pointer pointer) {
        return pointer.add(AN);
    }

    @Uninterruptible(reason="Exposes allocator state", callerMustBe=true)
    private static Pointer f(Pointer pointer) {
        return pointer.subtract(AN);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static UnsignedWord a(a a2) {
        return a2.getSize().subtract(AN);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static UnsignedWord j(UnsignedWord unsignedWord) {
        return unsignedWord.subtract(AN);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    @AlwaysInline(value="Allocator Performance")
    private static void b(Pointer pointer, a a2) {
        UnsignedWord unsignedWord = (UnsignedWord)pointer.readWord(0);
        ac.f(unsignedWord);
        a2.setSize(unsignedWord.and(AL));
        a2.setAllocated(unsignedWord.and(AJ).notEqual(0));
        a2.setIsObject(unsignedWord.and(AK).notEqual(0));
    }

    @Uninterruptible(reason="Holds uninitialized memory.", callerMustBe=true)
    @AlwaysInline(value="Allocator performance")
    private static void b(Pointer pointer, UnsignedWord unsignedWord) {
        ac.a(pointer, unsignedWord, false, false);
    }

    @Uninterruptible(reason="Holds uninitialized memory", callerMustBe=true)
    @AlwaysInline(value="Allocator performance")
    private static void c(Pointer pointer, a a2) {
        ac.a(pointer, a2.getSize(), a2.getAllocated(), a2.getIsObject());
    }

    @Uninterruptible(reason="Holds uninitialized memory", callerMustBe=true)
    @AlwaysInline(value="Allocator performance")
    private static void a(Pointer pointer, UnsignedWord unsignedWord, boolean bl, boolean bl2) {
        VMError.guarantee((boolean)ac.i((UnsignedWord)pointer));
        UnsignedWord unsignedWord2 = unsignedWord;
        if (bl) {
            unsignedWord2 = unsignedWord2.or(AJ);
        }
        if (bl2) {
            assert (bl);
            unsignedWord2 = unsignedWord2.or(AK);
        }
        ac.f(unsignedWord2);
        pointer.writeWord(0, (WordBase)unsignedWord2);
        if (!bl && ((Boolean)c.AT.getValue()).booleanValue()) {
            JavaMemoryUtil.fill((Pointer)ac.e(pointer).add(b.AQ), (UnsignedWord)ac.j(unsignedWord).subtract(b.AQ), (byte)ac.getFillByte());
        }
    }

    @Uninterruptible(reason="Modifies allocator state.", callerMustBe=true)
    private static void g(Pointer pointer) {
        ac.hw();
        a a2 = (a)StackValue.get(a.class);
        ac.b(pointer, a2);
        VMError.guarantee((boolean)a2.getAllocated(), (String)"Double free");
        d.b(a2);
        ac.b(pointer, a2.getSize());
        b.n(pointer);
        ac.hw();
    }

    @Uninterruptible(reason="Holds uninitialized memory.", callerMustBe=true)
    private static void h(Pointer pointer) {
        ac.hw();
        a a2 = (a)StackValue.get(a.class);
        ac.b(pointer, a2);
        assert (a2.getAllocated());
        if (!a2.getIsObject()) {
            a2.setIsObject(true);
            ac.c(pointer, a2);
            d.AU += a2.getSize().rawValue();
            ac.hw();
        }
    }

    @Uninterruptible(reason="Modifies allocator state.", callerMustBe=true)
    private static void c(Pointer pointer, UnsignedWord unsignedWord) {
        a a2 = (a)StackValue.get(a.class);
        ac.b(pointer, a2);
        ac.a(pointer, a2, unsignedWord);
    }

    @Uninterruptible(reason="Modifies allocator state.", callerMustBe=true)
    private static void a(Pointer pointer, a a2, UnsignedWord unsignedWord) {
        UnsignedWord unsignedWord2 = ac.h(unsignedWord);
        ac.hw();
        if (ac.shouldVerify()) {
            VMError.guarantee((!a2.getAllocated() ? 1 : 0) != 0, (String)"Trying to allocate in non-free block");
            VMError.guarantee((boolean)ac.a(a2).aboveOrEqual(unsignedWord2), (String)"Trying to allocate in too small block");
            VMError.guarantee((boolean)unsignedWord.aboveOrEqual(AO), (String)"Trying to allocate too small block");
        }
        UnsignedWord unsignedWord3 = ac.a(a2).subtract(unsignedWord2);
        if (ac.shouldVerify()) {
            VMError.guarantee((boolean)ac.i(unsignedWord3), (String)"Remaining space after block is not aligned");
        }
        boolean bl = unsignedWord3.aboveOrEqual(b.AR);
        UnsignedWord unsignedWord4 = a2.getSize().subtract(bl ? unsignedWord3 : (UnsignedWord)WordFactory.zero());
        a2.setSize(unsignedWord4);
        a2.setAllocated(true);
        b.m(pointer);
        ac.c(pointer, a2);
        d.AV -= unsignedWord4.rawValue();
        if (bl) {
            Pointer pointer2 = ac.a(pointer, a2);
            ac.b(pointer2, unsignedWord3);
            b.n(pointer2);
        }
        ac.hw();
    }

    @Uninterruptible(reason="Modifies allocator state", calleeMustBe=false)
    private static Pointer k(UnsignedWord unsignedWord) {
        Pointer pointer = ac.e(unsignedWord.add(AN));
        if (pointer.isNull()) {
            return (Pointer)WordFactory.nullPointer();
        }
        ac.c(pointer, unsignedWord);
        return ac.e(pointer);
    }

    @Uninterruptible(reason="Modifies allocator state", mayBeInlined=true)
    @AlwaysInline(value="Allocator Performance")
    private static Pointer l(UnsignedWord unsignedWord) {
        assert (unsignedWord.notEqual(0));
        Pointer pointer = b.AP;
        while (pointer.isNonNull()) {
            a a2 = (a)StackValue.get(a.class);
            ac.b(pointer, a2);
            assert (!a2.getAllocated());
            if (ac.a(a2).aboveOrEqual(unsignedWord)) {
                ac.a(pointer, a2, unsignedWord);
                return ac.e(pointer);
            }
            pointer = b.k(pointer);
        }
        return (Pointer)WordFactory.nullPointer();
    }

    @Uninterruptible(reason="Modifies allocator state")
    @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, reason="Must not allocate in the implementation of allocation.")
    public static Pointer m(UnsignedWord unsignedWord) {
        if (BranchProbabilityNode.probability((double)1.0000000000287557E-6, (boolean)unsignedWord.equal(0))) {
            return (Pointer)WordFactory.nullPointer();
        }
        UnsignedWord unsignedWord2 = UnsignedUtils.max((UnsignedWord)AO, (UnsignedWord)unsignedWord);
        ac.hw();
        Pointer pointer = ac.l(unsignedWord2);
        if (pointer.isNonNull()) {
            return pointer;
        }
        aj.getGC().collect(ae.AX);
        pointer = ac.l(unsignedWord2);
        if (pointer.isNonNull()) {
            return pointer;
        }
        return ac.k(unsignedWord2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Uninterruptible(reason="Modifies allocator state")
    public static Pointer d(Pointer pointer, UnsignedWord unsignedWord) {
        try {
            if (pointer.isNull()) {
                Pointer pointer2 = ac.m(unsignedWord);
                return pointer2;
            }
            if (unsignedWord.equal(0)) {
                Pointer pointer3 = (Pointer)WordFactory.nullPointer();
                return pointer3;
            }
            Pointer pointer4 = ac.f(pointer);
            a a2 = (a)StackValue.get(a.class);
            ac.b(pointer4, a2);
            UnsignedWord unsignedWord2 = ac.a(a2);
            Pointer pointer5 = ac.d(unsignedWord);
            UnsignedWord unsignedWord3 = UnsignedUtils.min((UnsignedWord)unsignedWord2, (UnsignedWord)unsignedWord);
            UnmanagedMemoryUtil.copy((Pointer)pointer, (Pointer)pointer5, (UnsignedWord)unsignedWord3);
            Pointer pointer6 = pointer5;
            return pointer6;
        }
        finally {
            ac.i(pointer);
        }
    }

    @Uninterruptible(reason="Modifies allocator state")
    public static void i(Pointer pointer) {
        if (pointer.isNull()) {
            return;
        }
        ac.j(pointer);
        Pointer pointer2 = ac.f(pointer);
        a a2 = (a)StackValue.get(a.class);
        ac.b(pointer2, a2);
        ac.d(pointer2, a2);
    }

    @Uninterruptible(reason="Modifies allocator state")
    public static void j(Pointer pointer) {
        if (pointer.isNull()) {
            return;
        }
        ac.g(ac.f(pointer));
    }

    @Uninterruptible(reason="Modifies allocator state")
    public static void hC() {
        Pointer pointer = com.oracle.svm.hosted.aotjs.wasm.gc.c.hp();
        Pointer pointer2 = com.oracle.svm.hosted.aotjs.wasm.gc.c.hq();
        while (pointer.belowThan((UnsignedWord)com.oracle.svm.hosted.aotjs.wasm.gc.c.hq())) {
            a a2 = (a)StackValue.get(a.class);
            ac.b(pointer, a2);
            if (!a2.getAllocated()) {
                ac.d(pointer, a2);
                pointer2 = (Pointer)UnsignedUtils.min((UnsignedWord)pointer2, (UnsignedWord)pointer);
            }
            pointer = ac.a(pointer, a2);
        }
        ac.hw();
    }

    @Uninterruptible(reason="Modifies allocator state")
    public static void d(Pointer pointer, a a2) {
        assert (!a2.getAllocated());
        UnsignedWord unsignedWord = a2.getSize();
        Pointer pointer2 = ac.a(pointer, a2);
        while (pointer2.belowThan((UnsignedWord)com.oracle.svm.hosted.aotjs.wasm.gc.c.hq())) {
            a a3 = (a)StackValue.get(a.class);
            ac.b(pointer2, a3);
            if (a3.getAllocated()) break;
            b.m(pointer2);
            unsignedWord = unsignedWord.add(a3.getSize());
            pointer2 = ac.a(pointer2, a3);
        }
        if (unsignedWord.aboveThan(a2.getSize())) {
            a2.setSize(unsignedWord);
            ac.c(pointer, a2);
        }
    }

    public static boolean walkObjects(ObjectVisitor visitor) {
        Pointer pointer = com.oracle.svm.hosted.aotjs.wasm.gc.c.hp();
        while (pointer.belowThan((UnsignedWord)com.oracle.svm.hosted.aotjs.wasm.gc.c.hq())) {
            a a2 = (a)StackValue.get(a.class);
            ac.b(pointer, a2);
            if (a2.getIsObject() && !visitor.visitObject(ac.e(pointer).toObjectNonNull())) {
                return false;
            }
            pointer = ac.a(pointer, a2);
        }
        return true;
    }

    @SubstrateForeignCallTarget(stubCallingConvention=false)
    private static Object newInstance(Word objectHeader) {
        DynamicHub dynamicHub = ap.getObjectHeaderImpl().dynamicHubFromObjectHeader(objectHeader);
        return ac.a(dynamicHub);
    }

    @SubstrateForeignCallTarget(stubCallingConvention=false)
    private static Object newArray(Word objectHeader, int length) {
        return ac.a(objectHeader, length);
    }

    private static Object a(Word word, int n2) {
        if (n2 < 0) {
            throw new NegativeArraySizeException();
        }
        return ac.b(word, n2);
    }

    @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, reason="Must not allocate in the implementation of allocation.")
    private static Object b(Word word, int n2) {
        DynamicHub dynamicHub = ap.getObjectHeaderImpl().dynamicHubFromObjectHeader(word);
        af.a("WasmAllocation.newArrayLikeObject0", DynamicHub.toClass((DynamicHub)dynamicHub).getName());
        aj.getGC().hM();
        return ac.a(dynamicHub, n2);
    }

    @Uninterruptible(reason="Holds uninitialized memory")
    private static Object a(DynamicHub dynamicHub, int n2) {
        UnsignedWord unsignedWord = LayoutEncoding.getArrayAllocationSize((int)dynamicHub.getLayoutEncoding(), (int)n2);
        Pointer pointer = ac.n(unsignedWord);
        return ac.a(pointer, dynamicHub, n2, false, AllocationSnippets.FillContent.WITH_ZEROES);
    }

    @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, reason="Must not allocate in the implementation of allocation.")
    private static Object a(DynamicHub dynamicHub) {
        af.a("WasmAllocation.newInstanceWithoutAllocating", DynamicHub.toClass((DynamicHub)dynamicHub).getName());
        aj.getGC().hM();
        return ac.b(dynamicHub);
    }

    @Uninterruptible(reason="Holds uninitialized memory")
    private static Object b(DynamicHub dynamicHub) {
        UnsignedWord unsignedWord = LayoutEncoding.getPureInstanceAllocationSize((int)dynamicHub.getLayoutEncoding());
        Pointer pointer = ac.n(unsignedWord);
        return FormatObjectNode.formatObject((Pointer)pointer, (Class)DynamicHub.toClass((DynamicHub)dynamicHub), (boolean)false, (AllocationSnippets.FillContent)AllocationSnippets.FillContent.WITH_ZEROES, (boolean)true);
    }

    @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, reason="Must not allocate in the implementation of allocation.")
    @Uninterruptible(reason="Holds uninitialized memory")
    private static Pointer n(UnsignedWord unsignedWord) {
        Pointer pointer = ac.m(unsignedWord);
        if (pointer.isNull()) {
            throw AH;
        }
        ac.h(ac.f(pointer));
        return pointer;
    }

    @Uninterruptible(reason="Holds uninitialized memory")
    private static Object a(Pointer pointer, DynamicHub dynamicHub, int n2, boolean bl, AllocationSnippets.FillContent fillContent) {
        Class clazz = DynamicHub.toClass((DynamicHub)dynamicHub);
        return FormatArrayNode.formatArray((Pointer)pointer, (Class)clazz, (int)n2, (boolean)false, (boolean)bl, (AllocationSnippets.FillContent)fillContent, (boolean)true);
    }

    public static class c {
        public static final HostedOptionKey<Boolean> AS = new HostedOptionKey((Object)false);
        public static final HostedOptionKey<Boolean> AT = new HostedOptionKey<Boolean>(Boolean.valueOf(false)){

            public Boolean b(UnmodifiableEconomicMap<OptionKey<?>, Object> unmodifiableEconomicMap) {
                if (!unmodifiableEconomicMap.containsKey((Object)this)) {
                    return (Boolean)AS.getValueOrDefault(unmodifiableEconomicMap);
                }
                return (Boolean)super.getValueOrDefault(unmodifiableEconomicMap);
            }

            public Boolean h(OptionValues optionValues) {
                return this.b(optionValues.getMap());
            }

            public /* synthetic */ Object getValueOrDefault(UnmodifiableEconomicMap unmodifiableEconomicMap) {
                return this.b(unmodifiableEconomicMap);
            }

            public /* synthetic */ Object getValue(OptionValues optionValues) {
                return this.h(optionValues);
            }
        };
    }

    static class d {
        static long AU = 0L;
        static long AV = 0L;

        d() {
        }

        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        static void b(a a2) {
            assert (a2.getAllocated());
            long l2 = a2.getSize().rawValue();
            if (a2.getIsObject()) {
                AU -= l2;
            }
            AV += l2;
        }
    }

    private static class b {
        private static Pointer AP = (Pointer)WordFactory.nullPointer();
        private static final UnsignedWord AQ = WordFactory.unsigned((int)(2 * FrameAccess.wordSize()));
        private static final UnsignedWord AR = AN.add(AQ);

        private b() {
        }

        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        static Pointer k(Pointer pointer) {
            return (Pointer)ac.e(pointer).readWord(0);
        }

        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        static Pointer l(Pointer pointer) {
            return (Pointer)ac.e(pointer).readWord(FrameAccess.wordSize());
        }

        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        static void a(Pointer pointer, Pointer pointer2) {
            ac.e(pointer).writeWord(0, (WordBase)pointer2);
        }

        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        static void b(Pointer pointer, Pointer pointer2) {
            ac.e(pointer).writeWord(FrameAccess.wordSize(), (WordBase)pointer2);
        }

        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        @AlwaysInline(value="Allocator Performance")
        static void m(Pointer pointer) {
            Pointer pointer2 = b.l(pointer);
            Pointer pointer3 = b.k(pointer);
            if (pointer2.isNull()) {
                AP = pointer3;
            } else {
                b.a(pointer2, pointer3);
            }
            if (pointer3.isNonNull()) {
                b.b(pointer3, pointer2);
            }
        }

        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        @AlwaysInline(value="Allocator Performance")
        static void n(Pointer pointer) {
            Pointer pointer2 = AP;
            b.a(pointer, pointer2);
            b.b(pointer, (Pointer)WordFactory.nullPointer());
            if (pointer2.isNonNull()) {
                b.b(pointer2, pointer);
            }
            AP = pointer;
        }

        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        static void hD() {
            if (!ac.shouldVerify()) {
                return;
            }
            Pointer pointer = AP;
            while (pointer.isNonNull()) {
                Pointer pointer2 = b.l(pointer);
                Pointer pointer3 = b.k(pointer);
                a a2 = (a)StackValue.get(a.class);
                ac.b(pointer, a2);
                VMError.guarantee((!a2.getAllocated() ? 1 : 0) != 0, (String)"Found allocated block in free list");
                if (pointer2.isNull()) {
                    VMError.guarantee((boolean)AP.equal((UnsignedWord)pointer), (String)"Block with null prev pointer is not the first block");
                } else {
                    VMError.guarantee((boolean)b.k(pointer2).equal((UnsignedWord)pointer), (String)"Broken double link to previous block");
                }
                if (pointer3.isNonNull()) {
                    VMError.guarantee((boolean)b.l(pointer3).equal((UnsignedWord)pointer), (String)"Broken double link to next block");
                }
                pointer = b.k(pointer);
            }
        }
    }

    @RawStructure
    private static interface a
    extends PointerBase {
        @RawField
        public UnsignedWord getSize();

        @RawField
        public void setSize(UnsignedWord var1);

        @RawField
        public boolean getAllocated();

        @RawField
        public void setAllocated(boolean var1);

        @RawField
        public boolean getIsObject();

        @RawField
        public void setIsObject(boolean var1);
    }
}

